/*
 * Decompiled with CFR 0.152.
 */
package com.sun.smartcard;

import com.sun.smartcard.AIDSpec;
import com.sun.smartcard.Card;
import com.sun.smartcard.CardInsertedThread;
import com.sun.smartcard.CardListener;
import com.sun.smartcard.CardRemovedThread;
import com.sun.smartcard.CardSpec;
import com.sun.smartcard.OCFClientSocket;
import com.sun.smartcard.OCFDecoder;
import com.sun.smartcard.OCFEncoder;
import com.sun.smartcard.ReaderSpec;
import com.sun.smartcard.SmartcardException;
import com.sun.smartcard.SmartcardInvalidCardHandleException;
import com.sun.smartcard.SmartcardInvalidClientHandleException;
import com.sun.smartcard.SmartcardInvalidVersionException;
import com.sun.smartcard.SmartcardNoCardException;
import com.sun.smartcard.SmartcardParameterErrorException;
import com.sun.smartcard.SmartcardServerException;
import com.sun.smartcard.SmartcardTimeoutException;
import com.sun.smartcard.SmartcardUnknownObjectException;
import com.sun.smartcard.SmartcardUnknownResultsException;
import com.sun.smartcard.TimeoutSpec;
import com.sun.smartcard.util.GetEnv;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Smartcard {
    private boolean suspended = false;
    private boolean terminated = false;
    private String clientName;
    private String xDisplay;
    private String filterKey;
    private float clientVersion;
    public static final String VERSION1 = "1.0";
    private OCFClientSocket server;
    private long clientHandle;
    private boolean threadsRunning = false;
    protected Hashtable cardListeners = new Hashtable();
    private static boolean debug = false;
    public static String OCF_CLIENT_RAW_PROPERTY_PREFIX = "[raw].";

    public Smartcard() throws SmartcardException {
        this("");
    }

    public Smartcard(String string) throws SmartcardException {
        this(string, "1");
    }

    public Smartcard(String string, String string2) throws SmartcardException {
        this.clientName = string == null ? new String("default") : new String(string);
        if (string2 == null || string2.equals("null")) {
            string2 = "1";
        }
        if (string2 == "0") {
            throw new SmartcardInvalidVersionException();
        }
        try {
            this.clientVersion = Float.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SmartcardInvalidVersionException();
        }
        this.xDisplay = GetEnv.getEnv("DISPLAY");
        try {
            this.xDisplay = this.getParsedDisplay(this.xDisplay);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.loadLibrary("smartcard");
            this.xDisplay = this.getParsedDisplay(this.xDisplay);
        }
        this.filterKey = GetEnv.getEnv("SCF_FILTER_KEY");
        if (this.filterKey == null) {
            this.filterKey = this.xDisplay != null ? this.xDisplay : ":0";
        }
        debug = Boolean.getBoolean("OCF_DEBUG");
        this.server = new OCFClientSocket();
        this.register();
    }

    private native String getParsedDisplay(String var1);

    private void register() throws SmartcardUnknownObjectException, SmartcardException, SmartcardServerException {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.clientName);
        vector.add(new Float(this.clientVersion));
        vector.add(this.xDisplay != null ? this.xDisplay : "NULL");
        vector.add(this.filterKey);
        Long l = (Long)this.getObject("register", vector);
        this.clientHandle = l;
    }

    public static boolean debugOn() {
        return debug;
    }

    public String getClientName() {
        return new String(this.clientName);
    }

    public float getClientVersion() {
        return this.clientVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCardListener(CardListener cardListener) throws SmartcardException {
        this.cardListeners.put(cardListener, cardListener);
        Hashtable hashtable = this.cardListeners;
        synchronized (hashtable) {
            if (!this.threadsRunning) {
                CardInsertedThread cardInsertedThread = new CardInsertedThread(this);
                cardInsertedThread.start();
                CardRemovedThread cardRemovedThread = new CardRemovedThread(this);
                cardRemovedThread.start();
                this.threadsRunning = true;
            }
        }
    }

    public void removeCardListener(CardListener cardListener) throws SmartcardException {
        this.cardListeners.remove(cardListener);
    }

    public Card waitForCardInserted(CardSpec cardSpec, ReaderSpec readerSpec, AIDSpec aIDSpec, TimeoutSpec timeoutSpec) throws SmartcardException {
        Vector<Object> vector = new Vector<Object>();
        vector.add(new Long(this.clientHandle));
        vector.add(cardSpec.getCardName());
        vector.add(readerSpec.getReaderName());
        vector.add(aIDSpec.getAID());
        vector.add(new Integer(timeoutSpec.getFlags()));
        vector.add(new Integer(timeoutSpec.getTimeout()));
        Vector vector2 = timeoutSpec.getTimeout() == 0 && (timeoutSpec.getFlags() & 1) == 0 ? this.getSyncResponse("waitForCardInserted", vector) : this.getResponse("waitForCardInserted", vector);
        if (vector2 == null || vector2.size() == 0) {
            throw new SmartcardUnknownResultsException();
        }
        long l = (Long)vector2.elementAt(0);
        return new Card(this, l);
    }

    Card waitForAnyCardInserted() throws SmartcardException, InterruptedException {
        return this.waitForAnyCardEvent("waitForAnyCardInserted");
    }

    public void waitForCardRemoved(Card card) throws SmartcardException {
        Vector<Long> vector = new Vector<Long>();
        vector.add(new Long(this.clientHandle));
        vector.add(new Long(card.getCardHandle()));
        this.getSyncResponse("waitForCardRemoved", vector);
    }

    Card waitForAnyCardRemoved() throws SmartcardException, InterruptedException {
        return this.waitForAnyCardEvent("waitForAnyCardRemoved");
    }

    public boolean cardPresent(CardSpec cardSpec, ReaderSpec readerSpec) throws SmartcardException {
        Vector<Object> vector = new Vector<Object>();
        vector.add(new Long(this.clientHandle));
        vector.add(cardSpec.getCardName());
        vector.add(readerSpec.getReaderName());
        try {
            this.getResponse("isCardPresent", vector);
        }
        catch (SmartcardNoCardException smartcardNoCardException) {
            return false;
        }
        return true;
    }

    public Enumeration cardServices(String string) throws SmartcardException {
        Vector<String> vector = new Vector<String>();
        vector.add(string);
        Enumeration enumeration = this.getElements("listCardServices", vector);
        if (enumeration == null) {
            throw new SmartcardUnknownResultsException();
        }
        return enumeration;
    }

    public Enumeration cardsConfigured() throws SmartcardException {
        return this.getElements("listCardsConfigured", null);
    }

    public Enumeration readersConfigured() throws SmartcardException {
        Vector<Long> vector = new Vector<Long>();
        vector.add(new Long(this.clientHandle));
        return this.getElements("listReadersConfigured", vector);
    }

    public Enumeration properties() throws SmartcardException {
        return this.getElements("listProperties", null);
    }

    public void setProperty(String string, String string2) throws SmartcardException {
        Vector<String> vector = new Vector<String>();
        vector.add(string);
        vector.add(string2);
        this.getResponse("setProperty", vector);
    }

    public String getProperty(String string) throws SmartcardException {
        Vector<String> vector = new Vector<String>();
        vector.add(string);
        return (String)this.getObject("getProperty", vector);
    }

    public void deleteProperty(String string) throws SmartcardException {
        if (string == null) {
            throw new SmartcardParameterErrorException();
        }
        Vector<String> vector = new Vector<String>();
        vector.add(string);
        this.getResponse("deleteProperty", vector);
    }

    public String getTerminalInfo(String string, String string2) throws SmartcardException {
        Vector<Object> vector = new Vector<Object>();
        vector.add(new Long(this.clientHandle));
        vector.add(string);
        vector.add(string2);
        return (String)this.getObject("getTerminalInfo", vector);
    }

    public Enumeration clientProperties() throws SmartcardException {
        Vector<Long> vector = new Vector<Long>();
        vector.add(new Long(this.clientHandle));
        return this.getElements("listClientProperties", vector);
    }

    public void setClientProperty(String string, String string2) throws SmartcardException {
        Vector<Object> vector = new Vector<Object>();
        vector.add(new Long(this.clientHandle));
        vector.add(string);
        vector.add(string2);
        this.getResponse("setClientProperty", vector);
    }

    public String getClientProperty(String string, String string2) throws SmartcardException {
        String string3;
        block2: {
            try {
                string3 = this.getClientProperty(OCF_CLIENT_RAW_PROPERTY_PREFIX + string);
            }
            catch (SmartcardException smartcardException) {
                string3 = string2;
                if (string3 != null) break block2;
                throw new SmartcardException("Property : " + string + " not defined");
            }
        }
        return string3;
    }

    public String getClientProperty(String string) throws SmartcardException {
        Vector<Object> vector = new Vector<Object>();
        vector.add(new Long(this.clientHandle));
        vector.add(string);
        return (String)this.getObject("getClientProperty", vector);
    }

    public void deleteClientProperty(String string) throws SmartcardException {
        Vector<Object> vector = new Vector<Object>();
        vector.add(new Long(this.clientHandle));
        vector.add(string);
        this.getResponse("deleteClientProperty", vector);
    }

    public Enumeration listClients() throws SmartcardException {
        return this.getElements("listClients", null);
    }

    protected long getClientHandle() {
        return this.clientHandle;
    }

    private void deregister() {
        Vector<Long> vector = new Vector<Long>();
        vector.add(new Long(this.clientHandle));
        try {
            this.getResponse("deregister", vector);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        Smartcard smartcard = this;
        synchronized (smartcard) {
            this.terminated = true;
        }
        this.deregister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        Smartcard smartcard = this;
        synchronized (smartcard) {
            this.suspended = true;
        }
        this.deregister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() throws SmartcardException {
        this.register();
        Smartcard smartcard = this;
        synchronized (smartcard) {
            this.suspended = false;
            this.notifyAll();
        }
    }

    private Card waitForAnyCardEvent(String string) throws SmartcardException, InterruptedException {
        Vector<Long> vector = new Vector<Long>();
        vector.add(new Long(this.clientHandle));
        Vector vector2 = this.getSyncResponse(string, vector);
        if (vector2 == null) {
            return null;
        }
        if (vector2.size() == 0) {
            throw new SmartcardUnknownResultsException();
        }
        long l = (Long)vector2.elementAt(0);
        return new Card(this, l);
    }

    private Enumeration getElements(String string, Vector vector) throws SmartcardException {
        Vector vector2 = (Vector)this.getObject(string, vector);
        return vector2 == null ? null : vector2.elements();
    }

    private Object getObject(String string, Vector vector) throws SmartcardException {
        Vector vector2 = this.getResponse(string, vector);
        if (vector2 == null || vector2.size() == 0) {
            return null;
        }
        return vector2.elementAt(0);
    }

    Vector getResponse(String string, Vector vector) throws SmartcardException {
        String string2 = null;
        if (vector != null) {
            string2 = OCFEncoder.encode(vector);
        }
        String string3 = this.server.serverResponse("OCF", "OCFService", string, string2);
        return OCFDecoder.decode(string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Vector getSyncResponse(String string, Vector vector) throws SmartcardException {
        String string2 = OCFEncoder.encode(vector);
        while (true) {
            try {
                Object object;
                do {
                    if (this.terminated) {
                        throw new SmartcardInvalidClientHandleException();
                    }
                    if (this.suspended) {
                        object = this;
                        synchronized (object) {
                            while (this.suspended) {
                                System.out.println("Thread suspended...");
                                this.wait();
                            }
                            System.out.println("Thread resumed");
                        }
                        vector.setElementAt(new Long(this.clientHandle), 0);
                        string2 = OCFEncoder.encode(vector);
                    }
                    object = this.server.serverResponse("OCF", "OCFService", string, string2);
                    if (!this.terminated) continue;
                    throw new SmartcardInvalidClientHandleException();
                } while (this.suspended);
                return OCFDecoder.decode((String)object);
            }
            catch (SmartcardTimeoutException smartcardTimeoutException) {
                System.out.println(string + " timeout occured");
                continue;
            }
            catch (SmartcardInvalidCardHandleException smartcardInvalidCardHandleException) {
                throw smartcardInvalidCardHandleException;
            }
            catch (SmartcardInvalidClientHandleException smartcardInvalidClientHandleException) {
                throw smartcardInvalidClientHandleException;
            }
            catch (SmartcardException smartcardException) {
                smartcardException.printStackTrace();
                throw smartcardException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static void main(String[] stringArray) {
        try {
            String string;
            Smartcard smartcard = new Smartcard("client1", VERSION1);
            Enumeration enumeration = smartcard.cardsConfigured();
            while (enumeration != null && enumeration.hasMoreElements()) {
                System.out.println("Card: " + (String)enumeration.nextElement());
            }
            Enumeration enumeration2 = smartcard.readersConfigured();
            while (enumeration2 != null && enumeration2.hasMoreElements()) {
                System.out.println("Reader: " + (String)enumeration2.nextElement());
            }
            Enumeration enumeration3 = null;
            try {
                enumeration3 = smartcard.properties();
                while (enumeration3 != null && enumeration3.hasMoreElements()) {
                    string = (String)enumeration3.nextElement();
                    System.out.println("Server Property: " + string + " Value: " + smartcard.getProperty(string));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            enumeration3 = smartcard.clientProperties();
            while (enumeration3 != null && enumeration3.hasMoreElements()) {
                string = (String)enumeration3.nextElement();
                System.out.println("Client Property: " + string + " Value: " + smartcard.getClientProperty(string));
            }
            smartcard.cardPresent(new CardSpec(), new ReaderSpec());
            Card card = smartcard.waitForCardInserted(new CardSpec(), new ReaderSpec(), new AIDSpec(), new TimeoutSpec());
            System.out.println("Name of Card inserted: " + card.getCardType());
            System.out.println("Name of Reader : " + card.getReaderName());
            System.out.println("SlotID : " + card.getSlotID());
            smartcard.cardPresent(new CardSpec(), new ReaderSpec());
            Enumeration enumeration4 = smartcard.cardServices("CyberFlex");
            while (enumeration4 != null && enumeration4.hasMoreElements()) {
                System.out.println("CardService: " + (String)enumeration4.nextElement());
            }
            enumeration3 = card.properties();
            while (enumeration3 != null && enumeration3.hasMoreElements()) {
                System.out.println("Card Property: " + (String)enumeration3.nextElement());
            }
            Card card2 = smartcard.waitForAnyCardRemoved();
            System.out.println("Card removed: " + card2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Smartcard)) {
            return false;
        }
        Smartcard smartcard = (Smartcard)object;
        return smartcard.clientHandle == this.clientHandle;
    }
}

