/*
 * Decompiled with CFR 0.152.
 */
package com.sun.smartcard;

import com.sun.smartcard.Smartcard;
import com.sun.smartcard.SmartcardServerException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class OCFClientSocket {
    protected static final int port = 8080;
    protected static final String hostFile = "/etc/smartcard/server_spec";
    protected static final String BEGIN_INDEX = "<body>";
    protected static final String END_INDEX = "</body>";
    protected InetAddress destinationAddress = null;
    private static boolean libraryLoaded = false;

    protected OCFClientSocket() throws SmartcardServerException {
        try {
            this.destinationAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            throw new SmartcardServerException(unknownHostException.toString());
        }
    }

    protected String serverResponse(String string, String string2, String string3, String string4) throws SmartcardServerException {
        String string5 = null;
        Object var6_6 = null;
        String string6 = new String("GET /" + string + "/" + string2 + "/" + string3 + (string4 == null ? "?" : "?" + string4) + " HTTP/1.0\n\n");
        if (Smartcard.debugOn()) {
            System.out.println("\nURL: [" + string6 + "]");
        }
        try {
            string5 = this.httpOverRPC(string6);
        }
        catch (SmartcardServerException smartcardServerException) {
            throw new SmartcardServerException(smartcardServerException.toString());
        }
        int n = string5.indexOf(BEGIN_INDEX) + BEGIN_INDEX.length();
        int n2 = string5.indexOf(END_INDEX);
        String string7 = string5.substring(n, n2);
        if (Smartcard.debugOn()) {
            System.out.println("Server Response:\n" + string7);
        }
        return string7;
    }

    private void closeSocket(Socket socket) throws SmartcardServerException {
        try {
            socket.close();
        }
        catch (IOException iOException) {
            throw new SmartcardServerException(iOException.toString());
        }
    }

    private String httpOverSocket(String string) throws SmartcardServerException {
        Socket socket = null;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            socket = new Socket(this.destinationAddress, 8080);
            inputStream = socket.getInputStream();
            outputStream = socket.getOutputStream();
        }
        catch (IOException iOException) {
            throw new SmartcardServerException(iOException.toString());
        }
        try {
            outputStream.write(string.getBytes());
        }
        catch (IOException iOException) {
            this.closeSocket(socket);
            throw new SmartcardServerException(iOException.toString());
        }
        String string2 = null;
        byte[] byArray = new byte[512];
        int n = 0;
        while (n < 512) {
            byArray[n] = 0;
            ++n;
        }
        try {
            int n2;
            while ((n2 = inputStream.read(byArray)) > 0) {
                string2 = string2 == null ? new String(byArray, 0, n2) : string2.concat(new String(byArray, 0, n2));
                n = 0;
                while (n < 512) {
                    byArray[n] = 0;
                    ++n;
                }
            }
        }
        catch (IOException iOException) {
            this.closeSocket(socket);
            throw new SmartcardServerException(iOException.toString());
        }
        this.closeSocket(socket);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSmartcardLibrary() throws SmartcardServerException {
        if (libraryLoaded) {
            return;
        }
        OCFClientSocket oCFClientSocket = this;
        synchronized (oCFClientSocket) {
            if (libraryLoaded) {
                return;
            }
            try {
                System.loadLibrary("smartcard");
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                try {
                    System.load("/usr/lib/libsmartcard.so.1");
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                    throw new SmartcardServerException(unsatisfiedLinkError2.toString());
                }
            }
            libraryLoaded = true;
        }
    }

    public native String httpOverRPC(String var1, String var2) throws SmartcardServerException;

    private String httpOverRPC(String string) throws SmartcardServerException {
        this.loadSmartcardLibrary();
        return this.httpOverRPC(this.destinationAddress.getHostName(), string);
    }
}

