/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.apps.cimworkshop;

import com.sun.wbem.apps.common.ActionString;
import com.sun.wbem.apps.common.AdminDialog;
import com.sun.wbem.apps.common.ColumnLayout;
import com.sun.wbem.apps.common.ContextHelpListener;
import com.sun.wbem.apps.common.GenInfoPanel;
import com.sun.wbem.apps.common.I18N;
import com.sun.wbem.apps.common.LAYOUT_ALIGNMENT;
import com.sun.wbem.apps.common.Util;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class QueryInputDialog
extends AdminDialog
implements DocumentListener {
    private JButton execBtn;
    private JButton cancelBtn;
    private GenInfoPanel infoPanel = super.getInfoPanel();
    String queryString = null;
    JTextArea textArea;

    public QueryInputDialog(Frame frame) {
        super(frame, I18N.loadString("TTL_QUERY_STRING"), false);
        this.cancelBtn = this.getCancelBtn();
        this.cancelBtn.addActionListener(new OKCancelButtonListener());
        this.execBtn = this.getOKBtn();
        this.execBtn.setText(I18N.loadString("LBL_EXECUTE"));
        this.execBtn.addActionListener(new OKCancelButtonListener());
        JPanel jPanel = this.getRightPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(25, 15, 15, 15));
        jPanel.setLayout(new ColumnLayout(LAYOUT_ALIGNMENT.EXPAND));
        ActionString actionString = new ActionString("LBL_QUERY_STRING");
        JLabel jLabel = new JLabel(actionString.getString() + ":");
        jLabel.setDisplayedMnemonic(actionString.getMnemonic());
        this.textArea = new JTextArea(4, 25);
        this.textArea.setWrapStyleWord(true);
        jLabel.setLabelFor(this.textArea);
        this.textArea.getDocument().addDocumentListener(this);
        this.textArea.addFocusListener(new ContextHelpListener(this.getInfoPanel(), "cimworkshop", "QueryString_010.htm"));
        this.setDefaultFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "QueryString_000.htm"), true);
        this.execBtn.addFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "QueryString_000.htm"));
        this.cancelBtn.addFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "QueryString_000.htm"));
        jPanel.add(jLabel);
        jPanel.add(new JScrollPane(this.textArea));
        this.pack();
        this.setLocation(Util.getCenterPoint(frame, this));
        this.setVisible(true);
    }

    public void okClicked() {
        this.queryString = this.textArea.getText();
        this.dispose();
    }

    public void cancelClicked() {
        this.queryString = null;
        this.dispose();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.setOKEnabled();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.setOKEnabled();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.setOKEnabled();
    }

    private void setOKEnabled() {
        this.execBtn.setEnabled(this.textArea.getText().trim().length() != 0);
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void windowOpened(WindowEvent windowEvent) {
        super.windowOpened(windowEvent);
        this.textArea.requestFocus();
    }

    class OKCancelButtonListener
    implements ActionListener {
        OKCancelButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == QueryInputDialog.this.cancelBtn) {
                QueryInputDialog.this.cancelClicked();
            } else if (actionEvent.getSource() == QueryInputDialog.this.execBtn) {
                QueryInputDialog.this.okClicked();
            }
        }
    }
}

