/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.upgrade;

import com.sun.wbem.cimom.ReadersWriter;
import com.sun.wbem.repository.PSRlogImpl;
import com.sun.wbem.upgrade.DagTraversor;
import com.sun.wbem.util.I18N;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.client.CIMClient;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;

public class RepositoryUpgrader {
    private CIMOMHandle cimClient;
    private String repositoryDir;
    private DataOutputStream succStream;
    private DataOutputStream dupStream;
    private DataOutputStream errorStream;
    private DataOutputStream cycleStream;

    private void processClasses(Enumeration enumeration, PSRlogImpl pSRlogImpl, CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, ReadersWriter readersWriter) throws Exception {
        Object object;
        Object object2;
        String string = cIMObjectPath.getNameSpace();
        HashMap<String, CIMClass> hashMap = new HashMap<String, CIMClass>();
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = null;
        while (enumeration.hasMoreElements()) {
            object2 = (CIMClass)enumeration.nextElement();
            object = object2.getName().toLowerCase();
            hashMap.put((String)object, (CIMClass)object2);
            arrayList.add(0, (String)object);
            stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
        }
        object2 = new DagCB(hashMap, pSRlogImpl, cIMOMHandle, cIMObjectPath, readersWriter);
        object = new DagTraversor(stringArray, new String[]{"s", "a"}, (DagTraversor.Callback)object2);
        ((DagTraversor)object).start();
        Iterator iterator = object2.addedClassList.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            System.out.println(I18N.loadStringFormat("ADDING_INSTANCE", string2));
            Enumeration enumeration2 = pSRlogImpl.enumerateInstances(string, string2, false, false).elements();
            while (enumeration2.hasMoreElements()) {
                boolean bl = true;
                CIMInstance cIMInstance = (CIMInstance)enumeration2.nextElement();
                try {
                    cIMOMHandle.createInstance(cIMObjectPath, cIMInstance);
                }
                catch (CIMException cIMException) {
                    bl = false;
                    System.out.println((Object)cIMException);
                    if (cIMException.getID().equals("CIM_ERR_ALREADY_EXISTS")) {
                        this.dupStream.writeBytes(string + "\n");
                        this.dupStream.writeBytes(cIMInstance + "\n");
                    } else {
                        this.errorStream.writeBytes(string + "\n");
                        this.errorStream.writeBytes(cIMInstance + "\n");
                        this.errorStream.writeBytes((Object)((Object)cIMException) + "\n");
                    }
                }
                catch (Exception exception) {
                    System.out.println(exception);
                    bl = false;
                    this.errorStream.writeBytes(string + "\n");
                    this.errorStream.writeBytes(cIMInstance + "\n");
                    this.errorStream.writeBytes(exception + "\n");
                }
                if (!bl) continue;
                this.succStream.writeBytes(string + "\n");
                this.succStream.writeBytes(cIMInstance + "\n");
            }
        }
    }

    private DataOutputStream getStream(String string) throws Exception {
        File file = new File(string);
        file.createNewFile();
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(string));
        return dataOutputStream;
    }

    public RepositoryUpgrader(CIMOMHandle cIMOMHandle, String string) throws Exception {
        this.cimClient = cIMOMHandle;
        this.repositoryDir = string;
        this.succStream = this.getStream(string + File.separator + "succ");
        this.dupStream = this.getStream(string + File.separator + "dup");
        this.errorStream = this.getStream(string + File.separator + "err");
        this.cycleStream = this.getStream(string + File.separator + "cycle");
    }

    public void run() throws Exception {
        ReadersWriter readersWriter = new ReadersWriter();
        PSRlogImpl pSRlogImpl = new PSRlogImpl("localhost", readersWriter, this.repositoryDir);
        Vector vector = pSRlogImpl.enumerateNameSpace("", true);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            System.out.println(I18N.loadStringFormat("ADDING_NS", string));
            CIMObjectPath cIMObjectPath = new CIMObjectPath();
            cIMObjectPath.setNameSpace(string);
            string = cIMObjectPath.getNameSpace();
            boolean bl = true;
            try {
                this.cimClient.createNameSpace(new CIMNameSpace("", string));
            }
            catch (CIMException cIMException) {
                bl = false;
                if (cIMException.getID().equals("CIM_ERR_ALREADY_EXISTS")) {
                    this.dupStream.writeBytes(string + "\n");
                } else {
                    this.errorStream.writeBytes(string + "\n");
                    this.errorStream.writeBytes((Object)((Object)cIMException) + "\n");
                }
            }
            catch (Exception exception) {
                bl = false;
                this.errorStream.writeBytes(string + "\n");
                this.errorStream.writeBytes(exception + "\n");
            }
            if (bl) {
                this.succStream.writeBytes(string + "\n");
            }
            Enumeration enumeration2 = pSRlogImpl.enumerateQualifierTypes(cIMObjectPath).elements();
            while (enumeration2.hasMoreElements()) {
                CIMQualifierType cIMQualifierType = (CIMQualifierType)enumeration2.nextElement();
                CIMObjectPath cIMObjectPath2 = new CIMObjectPath();
                cIMObjectPath2.setNameSpace(cIMObjectPath.getNameSpace());
                cIMObjectPath2.setObjectName(cIMQualifierType.getName());
                bl = true;
                try {
                    this.cimClient.createQualifierType(cIMObjectPath, cIMQualifierType);
                }
                catch (CIMException cIMException) {
                    bl = false;
                    if (cIMException.getID().equals("CIM_ERR_ALREADY_EXISTS")) {
                        this.dupStream.writeBytes(cIMObjectPath2 + "\n");
                    } else {
                        this.errorStream.writeBytes(cIMObjectPath2 + "\n");
                        this.errorStream.writeBytes((Object)((Object)cIMException) + "\n");
                    }
                }
                catch (Exception exception) {
                    bl = false;
                    this.errorStream.writeBytes(cIMObjectPath2 + "\n");
                    this.errorStream.writeBytes(exception + "\n");
                }
                if (!bl) continue;
                this.succStream.writeBytes(cIMObjectPath2 + "\n");
            }
            enumeration2 = pSRlogImpl.enumerateClasses(cIMObjectPath, true, true).elements();
            this.processClasses(enumeration2, pSRlogImpl, this.cimClient, cIMObjectPath, readersWriter);
        }
    }

    private static String getInput(String string) throws IOException {
        System.out.print(string);
        byte[] byArray = new byte[20];
        System.in.read(byArray, 0, 20);
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] == 10) {
                byArray[n] = 0;
                break;
            }
            ++n;
        }
        return new String(byArray);
    }

    public static void main(String[] stringArray) throws Exception {
        I18N.setResourceName("com.sun.wbem.cimom.CIMOM");
        String string = RepositoryUpgrader.getInput(I18N.loadString("PASSWORD"));
        UserPrincipal userPrincipal = new UserPrincipal(stringArray[0]);
        PasswordCredential passwordCredential = new PasswordCredential(string);
        CIMClient cIMClient = null;
        Exception exception = null;
        int n = 0;
        while (n < 10) {
            try {
                cIMClient = new CIMClient(new CIMNameSpace("", ""), (Principal)userPrincipal, (Object)passwordCredential);
                break;
            }
            catch (Exception exception2) {
                exception = exception2;
            }
        }
        if (n == 10) {
            throw exception;
        }
        RepositoryUpgrader repositoryUpgrader = new RepositoryUpgrader((CIMOMHandle)cIMClient, stringArray[1]);
        repositoryUpgrader.run();
    }

    private class DagCB
    implements DagTraversor.Callback {
        HashMap cMap = null;
        CIMObjectPath op;
        String ns;
        PSRlogImpl ps;
        CIMOMHandle cimClient;
        List addedClassList;
        ReadersWriter rw;

        public void noCycles(String string) {
            System.out.println(I18N.loadStringFormat("ADDING_CLASS", string));
            CIMClass cIMClass = (CIMClass)this.cMap.get(string);
            boolean bl = true;
            try {
                this.cimClient.createClass(this.op, cIMClass);
                this.addedClassList.add(0, string);
            }
            catch (CIMException cIMException) {
                System.out.println((Object)cIMException);
                bl = false;
                if (cIMException.getID().equals("CIM_ERR_ALREADY_EXISTS")) {
                    this.addedClassList.add(0, string);
                    try {
                        RepositoryUpgrader.this.dupStream.writeBytes(this.ns + "\n");
                        RepositoryUpgrader.this.dupStream.writeBytes(cIMClass + "\n");
                    }
                    catch (Exception exception) {
                        System.out.println(exception);
                    }
                } else {
                    try {
                        RepositoryUpgrader.this.errorStream.writeBytes(this.ns + "\n");
                        RepositoryUpgrader.this.errorStream.writeBytes(cIMClass + "\n");
                        RepositoryUpgrader.this.errorStream.writeBytes((Object)((Object)cIMException) + "\n");
                    }
                    catch (Exception exception) {
                        System.out.println(exception);
                    }
                }
            }
            catch (Exception exception) {
                System.out.println(exception);
                bl = false;
                try {
                    RepositoryUpgrader.this.errorStream.writeBytes(this.ns + "\n");
                    RepositoryUpgrader.this.errorStream.writeBytes(cIMClass + "\n");
                    RepositoryUpgrader.this.errorStream.writeBytes(exception + "\n");
                }
                catch (Exception exception2) {
                    System.out.println(exception2);
                }
            }
            if (bl) {
                try {
                    RepositoryUpgrader.this.succStream.writeBytes(this.ns + "\n");
                    RepositoryUpgrader.this.succStream.writeBytes(cIMClass + "\n");
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            }
        }

        public String[] dependNodes(String string, String string2) {
            String[] stringArray;
            CIMClass cIMClass = (CIMClass)this.cMap.get(string);
            if (string2.equals("s")) {
                String string3 = cIMClass.getSuperClass();
                if (string3 == null || string3.length() == 0) {
                    return null;
                }
                String[] stringArray2 = new String[]{string3.toLowerCase()};
                return stringArray2;
            }
            if (!cIMClass.isAssociation()) {
                return null;
            }
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            Enumeration enumeration = cIMClass.getProperties().elements();
            while (enumeration.hasMoreElements()) {
                CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
                if (!cIMProperty.isReference()) continue;
                stringArray = cIMProperty.getType().getRefClassName().toLowerCase();
                arrayList.add(stringArray);
            }
            int n = arrayList.size();
            if (n == 0) {
                return null;
            }
            stringArray = new String[n];
            arrayList.toArray(stringArray);
            return stringArray;
        }

        public void cycleDetected(String[] stringArray) {
            try {
                RepositoryUpgrader.this.cycleStream.writeBytes(this.ns + "\n");
                int n = 0;
                while (n < stringArray.length) {
                    RepositoryUpgrader.this.cycleStream.writeBytes(stringArray[n] + " ");
                    ++n;
                }
                RepositoryUpgrader.this.cycleStream.writeBytes("\n");
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }

        DagCB(HashMap hashMap, PSRlogImpl pSRlogImpl, CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, ReadersWriter readersWriter) {
            this.cMap = hashMap;
            this.ps = pSRlogImpl;
            this.cimClient = cIMOMHandle;
            this.op = cIMObjectPath;
            this.ns = cIMObjectPath.getNameSpace();
            this.addedClassList = new ArrayList();
            this.rw = readersWriter;
        }
    }
}

