/*
 * Copyright (c) 1998-2000 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef	_SYS_SYSEVENT_H
#define	_SYS_SYSEVENT_H

#pragma ident	"@(#)sysevent.h	1.2	00/10/10 SMI"

#include <sys/nvpair.h>

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * Event allocation/enqueuing sleep/nosleep flags
 */
#define	SE_SLEEP		0
#define	SE_NOSLEEP		1

/* Framework error codes */
#define	SE_EINVAL		1	/* Invalid argument */
#define	SE_ENOMEM		2	/* Unable to allocate memory */
#define	SE_EQSIZE		3	/* Maximum event q size exceeded */
#define	SE_EFAULT		4	/* Copy fault */
#define	SE_NOTFOUND		5	/* Attribute not found */
#define	SE_NO_TRANSPORT		6	/* sysevent transport down */

/* Internal data types */

#define	SE_DATA_TYPE_BYTE	DATA_TYPE_BYTE
#define	SE_DATA_TYPE_INT16	DATA_TYPE_INT16
#define	SE_DATA_TYPE_UINT16	DATA_TYPE_UINT16
#define	SE_DATA_TYPE_INT32	DATA_TYPE_INT32
#define	SE_DATA_TYPE_UINT32	DATA_TYPE_UINT32
#define	SE_DATA_TYPE_INT64	DATA_TYPE_INT64
#define	SE_DATA_TYPE_UINT64	DATA_TYPE_UINT64
#define	SE_DATA_TYPE_STRING	DATA_TYPE_STRING
#define	SE_DATA_TYPE_BYTES	DATA_TYPE_BYTE_ARRAY
#define	SE_DATA_TYPE_TIME	DATA_TYPE_HRTIME

#define	SE_KERN_PID	0

#define	SUNW_VENDOR	"SUNW"
#define	SE_USR_PUB	"usr:"
#define	SE_KERN_PUB	"kern:"
#define	SUNW_KERN_PUB	SUNW_VENDOR":"SE_KERN_PUB

/*
 * Event header and attribute value limits
 */
#define	MAX_ATTR_NAME	1024
#define	MAX_STRING_SZ	1024
#define	MAX_BYTE_ARRAY	1024

#define	MAX_CLASS_LEN		64
#define	MAX_SUBCLASS_LEN	64
#define	MAX_PUB_LEN		128

/* Opaque sysevent_t data type */
typedef void *sysevent_t;

/* sysevent attribute list */
typedef nvlist_t sysevent_attr_list_t;

/* sysevent attribute name-value pair */
typedef nvpair_t sysevent_attr_t;

/* Unique event identifier */
typedef struct sysevent_id {
	uint64_t eid_seq;
	hrtime_t eid_ts;
} sysevent_id_t;

/* Event attribute value structures */
typedef struct sysevent_bytes {
	int32_t	size;
	uchar_t	*data;
} sysevent_bytes_t;

typedef struct sysevent_value {
	int32_t		value_type;		/* data type */
	union {
		uchar_t		sv_byte;
		int16_t		sv_int16;
		uint16_t	sv_uint16;
		int32_t		sv_int32;
		uint32_t	sv_uint32;
		int64_t		sv_int64;
		uint64_t	sv_uint64;
		hrtime_t	sv_time;
		char		*sv_string;
		sysevent_bytes_t	sv_bytes;
	} value;
} sysevent_value_t;

#ifdef	_KERNEL

/*
 * kernel log_event interfaces.
 */
void log_event_init(void);
void log_sysevent_flushq(int cmd, uint_t flag);
int log_sysevent_filename(char *file);
int log_sysevent(sysevent_t *ev, int flag, sysevent_id_t *eid);
int log_usr_sysevent(sysevent_t *ev, int ev_size, sysevent_id_t *eid);
int log_sysevent_copyout_data(sysevent_id_t *eid, size_t ubuflen, caddr_t ubuf);
int log_sysevent_free_data(sysevent_id_t *eid);

sysevent_t *sysevent_alloc(char *class, char *subclass, char *pub, int flag);
void sysevent_free(sysevent_t *ev);
int sysevent_add_attr(sysevent_attr_list_t **ev_attr_list, char *name,
	sysevent_value_t *se_value, int flag);
void sysevent_free_attr(sysevent_attr_list_t *ev_attr_list);
int sysevent_attach_attributes(sysevent_t *ev,
	sysevent_attr_list_t *ev_attr_list);
void sysevent_detach_attributes(sysevent_t *ev);
void sysevent_unattach_attributes(sysevent_t *ev);

#endif	/* _KERNEL */

#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_SYSEVENT_H */
