/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.client;

import com.sun.dhcpmgr.client.DataManager;
import com.sun.dhcpmgr.client.ResourceStrings;
import com.sun.dhcpmgr.data.Option;
import com.sun.dhcpmgr.data.OptionContext;
import com.sun.dhcpmgr.data.StandardOptions;
import com.sun.dhcpmgr.ui.AutosizingTable;
import com.sun.dhcpmgr.ui.ButtonPanel;
import com.sun.dhcpmgr.ui.ButtonPanelListener;
import com.sun.dhcpmgr.ui.TableSorter;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class SelectOptionDialog
extends JComponent
implements ButtonPanelListener {
    private JComboBox category;
    private AutosizingTable optionTable;
    private ButtonPanel buttonPanel;
    private OptionTableModel optionTableModel;
    private TableSorter sortedModel;
    static final String SELECTED_OPTION = "selected_option";
    static String value = null;
    static JDialog dialog;
    private OptionContext[] categories = new OptionContext[]{Option.ctxts[Option.STANDARD], Option.ctxts[Option.EXTEND], Option.ctxts[Option.VENDOR], Option.ctxts[Option.SITE]};
    static /* synthetic */ Class class$java$lang$String;

    public void buttonPressed(int n) {
        switch (n) {
            case 0: {
                this.firePropertyChange(SELECTED_OPTION, null, (String)this.optionTableModel.getValueAt(this.sortedModel.mapRowAt(this.optionTable.getSelectedRow()), 0));
                break;
            }
            case 1: {
                this.firePropertyChange(SELECTED_OPTION, null, null);
                break;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void createDialog() {
        dialog = new JDialog(null, ResourceStrings.getString("select_option_title"), true);
        dialog.getContentPane().setLayout(new BoxLayout(dialog.getContentPane(), 1));
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(new JLabel(ResourceStrings.getString("category_label")));
        this.category = new JComboBox<OptionContext>(this.categories);
        this.category.setEditable(false);
        jPanel.add(this.category);
        dialog.getContentPane().add(jPanel);
        this.optionTableModel = new OptionTableModel();
        this.sortedModel = new TableSorter(this.optionTableModel);
        this.sortedModel.sortByColumn(0);
        this.optionTable = new AutosizingTable(this.sortedModel);
        this.optionTable.getTableHeader().setReorderingAllowed(false);
        this.optionTable.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.optionTable);
        jPanel = new JPanel();
        jPanel.add(jScrollPane);
        dialog.getContentPane().add(jPanel);
        dialog.getContentPane().add(new JSeparator());
        this.buttonPanel = new ButtonPanel(false, false);
        this.buttonPanel.addButtonPanelListener(this);
        dialog.getContentPane().add(this.buttonPanel);
        this.category.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SelectOptionDialog.this.updateTable();
            }
        });
        this.optionTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (SelectOptionDialog.this.optionTable.getSelectedRow() == -1) {
                    SelectOptionDialog.this.buttonPanel.setOkEnabled(false);
                } else {
                    SelectOptionDialog.this.buttonPanel.setOkEnabled(true);
                }
            }
        });
        this.updateTable();
    }

    public static String showDialog(Component component) {
        SelectOptionDialog selectOptionDialog = new SelectOptionDialog();
        selectOptionDialog.createDialog();
        selectOptionDialog.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ((Component)dialog).setVisible(false);
                dialog.dispose();
                value = (String)propertyChangeEvent.getNewValue();
            }
        });
        dialog.setLocationRelativeTo(component);
        dialog.pack();
        dialog.show();
        return value;
    }

    private void updateTable() {
        this.optionTableModel.setCategory(this.categories[this.category.getSelectedIndex()]);
        this.optionTable.clearSelection();
    }

    class OptionTableModel
    extends AbstractTableModel {
        private Option[] data = new Option[0];
        private ResourceBundle bundle = ResourceBundle.getBundle("com.sun.dhcpmgr.client.OptionDescriptions", Locale.getDefault());

        public Class getColumnClass(int n) {
            return class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = SelectOptionDialog.class$("java.lang.String"));
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return ResourceStrings.getString("option_column");
            }
            return ResourceStrings.getString("description_column");
        }

        public int getRowCount() {
            return this.data.length;
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.data[n].getKey();
            }
            try {
                return this.bundle.getString(this.data[n].getKey());
            }
            catch (Exception exception) {
                return null;
            }
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void setCategory(OptionContext optionContext) {
            byte by = optionContext.getCode();
            if (by == Option.ctxts[Option.STANDARD].getCode()) {
                this.data = StandardOptions.getAllOptions();
            } else if (by == Option.ctxts[Option.EXTEND].getCode() || by == Option.ctxts[Option.SITE].getCode() || by == Option.ctxts[Option.VENDOR].getCode()) {
                try {
                    Option[] optionArray = DataManager.get().getOptions(false);
                    Vector<Option> vector = new Vector<Option>();
                    int n = 0;
                    while (n < optionArray.length) {
                        if (optionArray[n].getContext() == by) {
                            vector.addElement(optionArray[n]);
                        }
                        ++n;
                    }
                    this.data = new Option[vector.size()];
                    vector.copyInto(this.data);
                }
                catch (Exception exception) {
                    this.data = new Option[0];
                }
            }
            SelectOptionDialog.this.sortedModel.reallocateIndexes();
            this.fireTableDataChanged();
        }
    }
}

