/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.client;

import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMSecurityException;
import com.sun.wbem.security.WorkMod51;

public class CIMOMLibrary {
    public static final String CIMOM_LIBRARY = "cimom";
    private static boolean library_loaded = false;

    static {
        try {
            System.loadLibrary(CIMOM_LIBRARY);
            library_loaded = true;
        }
        catch (SecurityException securityException) {
            System.err.println(securityException);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(unsatisfiedLinkError);
        }
    }

    public static synchronized void auditLogin(String string, String string2, long l) throws CIMException {
        if (string == null || string2 == null) {
            return;
        }
        if (library_loaded) {
            CIMOMLibrary.setupAuditLogin(string, string2);
            if (l != -1L && l != -2L) {
                CIMOMLibrary.auditLoginSuccess(string, string2, l);
            } else {
                CIMOMLibrary.auditLoginFailure(string, string2, (int)l);
            }
        } else {
            throw new CIMException("Error loading library - cannot audit login");
        }
    }

    private static native void auditLoginFailure(String var0, String var1, int var2);

    private static native void auditLoginSuccess(String var0, String var1, long var2);

    public static boolean canUserAssumeRole(String string, String string2) throws CIMException {
        boolean bl = false;
        if (!library_loaded) {
            System.out.println("Cannot find passwd access library");
            throw new CIMSecurityException("CIM_ERR_FAILED");
        }
        bl = CIMOMLibrary.canUserBeRole(string, string2);
        return bl;
    }

    private static native boolean canUserBeRole(String var0, String var1);

    private static native void doSyslog(String var0, String var1, int var2);

    public static String getEncryptedPassword(String string) throws CIMException {
        String string2 = null;
        if (library_loaded) {
            string2 = CIMOMLibrary.getPassword(string);
            if (string2 == null) {
                return null;
            }
            if (string2.trim().length() == 0) {
                string2 = "";
            }
        } else {
            System.out.println("Cannot find passwd access library");
            throw new CIMSecurityException("NO_SUCH_PRINCIPAL", (Object)string);
        }
        byte[] byArray = string2.getBytes();
        byte[] byArray2 = new byte[]{byArray[0], byArray[1]};
        byte[] byArray3 = new WorkMod51().mod51Format(new byte[20], byArray2);
        String string3 = new String(byArray3);
        if (string3.equals(string2)) {
            return "";
        }
        return string2;
    }

    private static native String getPassword(String var0);

    private static native void setupAuditLogin(String var0, String var1);

    public static void writeToSyslog(String string, String string2, int n) throws CIMException {
        if (!library_loaded) {
            throw new CIMException("Cannot log");
        }
        CIMOMLibrary.doSyslog(string, string2, n);
    }
}

