/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.compiler.mib2mof;

import com.sun.wbem.compiler.mib2mof.ASTMib;
import com.sun.wbem.compiler.mib2mof.ASTNamedType;
import com.sun.wbem.compiler.mib2mof.ASTObjectTypeDefinition;
import com.sun.wbem.compiler.mib2mof.BeanGenerator;
import com.sun.wbem.compiler.mib2mof.Def;
import com.sun.wbem.compiler.mib2mof.MessageHandler;
import com.sun.wbem.compiler.mib2mof.MetaEntryGenerator;
import com.sun.wbem.compiler.mib2mof.MibNode;
import com.sun.wbem.compiler.mib2mof.ResourceManager;
import com.sun.wbem.compiler.mib2mof.SyntaxMapper;
import com.sun.wbem.compiler.mib2mof.Trace;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class MetaBeanGenerator
extends BeanGenerator
implements Serializable {
    protected StringBuffer getNext_impl = new StringBuffer();
    protected StringBuffer get_impl = new StringBuffer();
    protected StringBuffer set_impl = new StringBuffer();
    protected StringBuffer check_impl = new StringBuffer();
    protected StringBuffer init_impl = new StringBuffer();
    protected StringBuffer var_def = new StringBuffer();
    protected StringBuffer moi_impl = new StringBuffer();
    protected StringBuffer constructor = new StringBuffer();
    protected StringBuffer accessors = new StringBuffer();
    protected static String MBEAN_NAME = "node";
    protected int counter = 0;
    protected int varCount = 0;

    public MetaBeanGenerator(ResourceManager resourceManager, String string, String string2, String string3, MibNode mibNode, ASTMib aSTMib) throws IOException {
        super(resourceManager, string, string2, string3, mibNode, aSTMib);
        this.oid = this.node.getComputedOid();
        this.varName = this.node.getSymbolName();
        if (this.varName == null) {
            this.varName = this.getClassName(this.node.getComputedOid());
        }
        this.symboleName = MetaBeanGenerator.buildMetaName(string2, this.varName);
        Trace.info(MessageHandler.getMessage("generate.info.meta", this.varName));
        this.out = this.openFile(String.valueOf(this.symboleName) + Def.JAVA);
        this.writeHeader();
        this.writeClassDeclaration();
        this.buildVarList();
        this.buildConstructorHeader();
        this.buildSetInstance();
        this.buildGetterHeader();
        this.buildSetterHeader();
        this.buildCheckerHeader();
        this.buildGetNextHeader();
    }

    protected void buildCheckerHeader() throws IOException {
        this.check_impl.append(String.valueOf(Def.TAB) + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.checker") + "\n" + Def.TAB + " */\n");
        this.check_impl.append(String.valueOf(Def.TAB) + Def.PUBLIC + Def.VOID + Def.CHECK + "(" + Def.SNMP_VALUE + " x, long[] oid, int pos)\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.check_impl.append("\n" + Def.TAB2 + "boolean moi = true" + Def.SEMICOLON + Def.TAB2 + "int length = oid.length" + Def.SEMICOLON + Def.TAB2 + "if ( pos >= length)" + "\n" + Def.TAB3 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_NOACCESS + ")" + Def.SEMICOLON + Def.TAB2 + "if ((pos + 2) == length)" + Def.LBRACE + Def.TAB3 + "moi = (oid[length - 1] == 0) ? true : false;\n" + Def.TAB2 + Def.RBRACE + Def.TAB2 + "switch((int) oid[pos])" + Def.LBRACE);
    }

    protected void buildConstructorHeader() throws IOException {
        this.constructor.append(String.valueOf(Def.TAB) + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.constr", this.varName) + "\n" + Def.TAB + " */\n");
        this.constructor.append(String.valueOf(Def.TAB) + Def.PUBLIC + this.symboleName + "(SnmpMib myMib)" + Def.LBRACE);
    }

    protected void buildGetNextHeader() throws IOException {
        this.getNext_impl.append(String.valueOf(Def.TAB) + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.getNext") + "\n" + Def.TAB + " */\n" + Def.TAB + Def.PUBLIC + Def.SNMP_VARBIND + " " + Def.GET_NEXT + "(long[] oid, int pos)\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.getNext_impl.append("\n" + Def.TAB2 + "if (oid.length <= pos)" + Def.LBRACE + Def.TAB3 + "oid = new long[1]" + Def.SEMICOLON + Def.TAB3 + "pos = 0" + Def.SEMICOLON + Def.TAB3 + "oid[0] = (long) -1" + Def.SEMICOLON + Def.TAB3 + Def.RETURN + Def.GET_NEXT + "(oid, pos)" + Def.SEMICOLON + Def.TAB2 + Def.RBRACE);
        this.getNext_impl.append(String.valueOf(Def.TAB2) + "int next = (int) oid[pos]" + Def.SEMICOLON + Def.TAB2 + Def.SNMP_VARBIND + " result = null" + Def.SEMICOLON + Def.TAB2 + "try" + Def.LBRACE + Def.TAB3 + "switch(next)" + Def.LBRACE);
    }

    protected void buildGetterHeader() throws IOException {
        this.get_impl.append(String.valueOf(Def.TAB) + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.getter") + "\n" + Def.TAB + " */\n" + Def.TAB + Def.PUBLIC + Def.SNMP_VALUE + " " + Def.GET + "(long[] oid, int pos)\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.get_impl.append("\n" + Def.TAB2 + "boolean moi = false" + Def.SEMICOLON + Def.TAB2 + "int length = oid.length" + Def.SEMICOLON + Def.TAB2 + "if (pos >= length)" + "\n" + Def.TAB3 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_NOACCESS + ")" + Def.SEMICOLON + Def.TAB2 + "if ((pos + 2) == length)" + Def.LBRACE + Def.TAB3 + "moi = (oid[length - 1] == 0) ? true : false;\n" + Def.TAB2 + Def.RBRACE + Def.TAB2 + "switch((int)oid[pos])" + Def.LBRACE);
    }

    public static String buildMetaName(String string, String string2) {
        return String.valueOf(string) + string2 + Def.METAPREFIX;
    }

    protected void buildSetInstance() throws IOException {
        this.moi_impl.append(String.valueOf(Def.TAB) + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.setMoi") + "\n" + Def.TAB + " */\n" + Def.TAB + Def.PROTECTED + Def.VOID + Def.SET_MOI + "(" + this.prefix + this.varName + Def.MBEANSUFFIX + " var)" + Def.LBRACE + Def.TAB2 + MBEAN_NAME + " = var" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
    }

    protected void buildSetterHeader() throws IOException {
        this.set_impl.append(String.valueOf(Def.TAB) + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.setter") + "\n" + Def.TAB + " */\n");
        this.set_impl.append(String.valueOf(Def.TAB) + Def.PUBLIC + Def.SNMP_VALUE + " " + Def.SET + "(" + Def.SNMP_VALUE + " x, long[] oid, int pos)\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.set_impl.append("\n" + Def.TAB2 + "boolean moi = true" + Def.SEMICOLON + Def.TAB2 + "int length = oid.length" + Def.SEMICOLON + Def.TAB2 + "if ( pos >= length)" + "\n" + Def.TAB3 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_NOACCESS + ")" + Def.SEMICOLON + Def.TAB2 + "if (pos == (length -2))" + Def.LBRACE + Def.TAB3 + "moi = (oid[length - 1] == 0) ? true : false;\n" + Def.TAB2 + Def.RBRACE + Def.TAB2 + "switch((int)oid[pos])" + Def.LBRACE);
    }

    protected void buildVarList() throws IOException {
        this.var_def.append(String.valueOf(Def.TAB) + Def.PRIVATE + this.prefix + this.varName + Def.MBEANSUFFIX + " node" + Def.SEMICOLON);
    }

    protected void closeCheckerMeth() throws IOException {
        this.check_impl.append(String.valueOf(Def.TAB3) + "default:\n");
        this.defaultCheckerMeth();
        this.check_impl.append(String.valueOf(Def.TAB2) + Def.RBRACE + Def.TAB + Def.RBRACE + "\n");
    }

    protected void closeConstructor() throws IOException {
        this.constructor.append(String.valueOf(Def.TAB2) + Def.SNMP_VARLIST + " = new int[" + String.valueOf(this.counter) + "]" + Def.SEMICOLON + this.init_impl.toString());
        this.constructor.append(String.valueOf(Def.TAB2) + Def.SNMP_NODE + "." + Def.SNMP_SORT + "(" + Def.SNMP_VARLIST + ")" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
    }

    protected void closeGetNext() throws IOException {
        this.getNext_impl.append(String.valueOf(Def.TAB4) + "default:\n");
        this.defaultGetNext();
        this.getNext_impl.append(String.valueOf(Def.TAB3) + Def.RBRACE + Def.TAB2 + Def.RBRACE + Def.TAB2 + "catch(" + Def.EXCP_SNMP + " e)" + Def.LBRACE + Def.TAB3 + "long[] newOid = new long[1]" + Def.SEMICOLON + Def.TAB3 + "newOid[0] = " + Def.METH_NEXTID + "(" + Def.SNMP_VARLIST + ", oid[pos])" + Def.SEMICOLON + Def.TAB3 + Def.RETURN + Def.GET_NEXT + "(newOid, 0)" + Def.SEMICOLON + Def.TAB2 + Def.RBRACE + Def.TAB + Def.RBRACE + "\n");
    }

    protected void closeGetterMeth() throws IOException {
        this.get_impl.append(String.valueOf(Def.TAB3) + "default:\n");
        this.defaultGetterMeth();
        this.get_impl.append(String.valueOf(Def.TAB2) + Def.RBRACE);
        this.endGetterMeth();
        this.get_impl.append(String.valueOf(Def.TAB) + Def.RBRACE + "\n");
    }

    protected void closeSetterMeth() throws IOException {
        this.set_impl.append(String.valueOf(Def.TAB3) + "default:\n");
        this.defaultSetterMeth();
        this.set_impl.append(String.valueOf(Def.TAB2) + Def.RBRACE);
        this.endSetterMeth();
        this.set_impl.append(String.valueOf(Def.TAB) + Def.RBRACE + "\n");
    }

    protected void defaultCheckerMeth() throws IOException {
        this.check_impl.append(String.valueOf(Def.TAB4) + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_NOSUCHNAME + ")" + Def.SEMICOLON);
    }

    protected void defaultGetNext() throws IOException {
        this.getNext_impl.append(String.valueOf(Def.TAB5) + "long[] index = new long[2]" + Def.SEMICOLON + Def.TAB5 + "if ( (pos+1) == oid.length) " + Def.LBRACE + Def.TAB6 + "index[0] = next" + Def.SEMICOLON + Def.TAB5 + Def.N_RBRACE + " else " + Def.LBRACE + Def.TAB6 + "index[0] = " + Def.METH_NEXTID + "(" + Def.SNMP_VARLIST + ", oid[pos])" + Def.SEMICOLON + Def.TAB5 + Def.RBRACE + Def.TAB5 + "index[1] = 0" + Def.SEMICOLON + Def.TAB5 + Def.SNMP_VALUE + " val = " + Def.GET + "(index,0)" + Def.SEMICOLON + Def.TAB5 + Def.RETURN + Def.NEW + Def.SNMP_VARBIND + "(" + Def.NEW + Def.SNMP_OID + "(index), val)" + Def.SEMICOLON);
    }

    protected void defaultGetterMeth() throws IOException {
        this.get_impl.append(String.valueOf(Def.TAB4) + "break" + Def.SEMICOLON);
    }

    protected void defaultSetterMeth() throws IOException {
        this.set_impl.append(String.valueOf(Def.TAB4) + "break" + Def.SEMICOLON);
    }

    protected void endGetterMeth() throws IOException {
        this.get_impl.append(String.valueOf(Def.TAB2) + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_NOSUCHNAME + ")" + Def.SEMICOLON);
    }

    public void endOfGroup() throws IOException {
        this.closeGetterMeth();
        this.closeSetterMeth();
        this.closeCheckerMeth();
        this.closeGetNext();
        this.closeConstructor();
        this.write(this.constructor.toString());
        this.write(this.get_impl.toString());
        this.write(this.getNext_impl.toString());
        this.write(this.set_impl.toString());
        this.write(this.check_impl.toString());
        this.write(this.moi_impl.toString());
        this.write(this.var_def.toString());
        this.write(Def.RBRACE);
        this.closeIO();
    }

    protected void endSetterMeth() throws IOException {
        this.set_impl.append(String.valueOf(Def.TAB2) + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_NOSUCHNAME + ")" + Def.SEMICOLON);
    }

    protected String getParentClass() {
        return Def.SNMP_NODE;
    }

    protected String getParentClassPkg() {
        return Def.PKG_SNMP_MIB_NODE;
    }

    protected void handleCheck(String string, String string2, String string3, String string4, int n) throws IOException {
        this.check_impl.append(String.valueOf(Def.TAB3) + "case " + string + ":\n" + Def.TAB4);
        this.check_impl.append("if (moi == false)\n" + Def.TAB5 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_NOSUCHNAME + ")" + Def.SEMICOLON + Def.TAB4);
        if (n == 67) {
            this.check_impl.append(String.valueOf(Def.THROW_NEW) + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_READONLY + ")" + Def.SEMICOLON + "\n");
            return;
        }
        if (n == 47 || n == 7) {
            this.check_impl.append(String.valueOf(Def.THROW_NEW) + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_NOACCESS + ")" + Def.SEMICOLON + "\n");
            return;
        }
        String string5 = SyntaxMapper.getTypeName(string3);
        String string6 = SyntaxMapper.getCastMethod(string3);
        this.check_impl.append("if (x instanceof " + string5 + ")" + Def.LBRACE + Def.TAB5);
        if (string4 == null) {
            this.check_impl.append(String.valueOf(MBEAN_NAME) + "." + Def.CHECK + string2 + "(((" + string5 + ")x)." + string6 + "())" + Def.SEMICOLON + Def.TAB4 + "} else {\n" + Def.TAB5 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_BADVALUE + ")" + Def.SEMICOLON + Def.TAB4 + Def.RBRACE + Def.TAB4 + "break" + Def.SEMICOLON + "\n");
        } else {
            this.check_impl.append("try " + Def.LBRACE + Def.TAB6 + MBEAN_NAME + "." + Def.CHECK + string2 + "( new " + string4 + "(((" + string5 + ")x)." + string6 + "()))" + Def.SEMICOLON + Def.TAB5 + Def.N_RBRACE + " catch(" + Def.EXCP_ARGUMENT + " e) " + Def.LBRACE + Def.TAB6 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_BADVALUE + ")" + Def.SEMICOLON + Def.TAB5 + Def.RBRACE + Def.TAB4 + "} else {\n" + Def.TAB5 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_BADVALUE + ")" + Def.SEMICOLON + Def.TAB4 + Def.RBRACE + Def.TAB4 + "break" + Def.SEMICOLON + "\n");
        }
    }

    protected void handleGet(String string, String string2, String string3, int n) throws IOException {
        this.get_impl.append(String.valueOf(Def.TAB3) + "case " + string + ":\n" + Def.TAB4);
        this.get_impl.append("if (moi == true)\n" + Def.TAB5);
        if (n == 85 || n == 47 || n == 7) {
            this.get_impl.append(String.valueOf(Def.THROW_NEW) + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_READONLY + ")" + Def.SEMICOLON);
            this.get_impl.append(String.valueOf(Def.TAB4) + "break" + Def.SEMICOLON + "\n");
            return;
        }
        String string4 = SyntaxMapper.getTypeName(string3);
        this.get_impl.append("return new " + string4 + "(" + MBEAN_NAME + "." + Def.GET + string2 + "())" + Def.SEMICOLON + Def.TAB4 + "break" + Def.SEMICOLON + "\n");
    }

    protected void handleInit(String string, String string2, int n) throws IOException {
        if (n == 67 || n == 66 || n == 68) {
            this.init_impl.append(String.valueOf(Def.TAB2) + Def.SNMP_VARLIST + "[" + String.valueOf(this.counter) + "] = " + string + Def.SEMICOLON);
            ++this.counter;
        }
    }

    protected void handleMinMax(String string) {
    }

    protected void handleNestedGroups(MibNode mibNode) throws IOException {
    }

    public void handleNode(MibNode mibNode) throws IOException {
        String string = mibNode.getSymbolName();
        String string2 = mibNode.getNodeId();
        if (mibNode.isGroup() || mibNode.hasNestedGroups()) {
            this.handleNestedGroups(mibNode);
            return;
        }
        if (mibNode.isTable()) {
            Trace.info(MessageHandler.getMessage("generate.info.var", mibNode.getSymbolName()));
            this.handleTable(mibNode);
            this.handleInit(string2, string, 67);
            return;
        }
        ASTObjectTypeDefinition aSTObjectTypeDefinition = mibNode.getObjectType();
        int n = aSTObjectTypeDefinition.getDefinition().getAccess();
        ASTNamedType aSTNamedType = aSTObjectTypeDefinition.getSyntax();
        String string3 = aSTNamedType.getSnmpSyntax();
        mibNode.setSnmpSyntax(string3);
        this.handleMinMax(string2);
        this.handleGet(string2, string, string3, n);
        if (mibNode.isEnumeratedType()) {
            this.handleCheck(string2, string, string3, mibNode.getEnumeratedType(), n);
            this.handleSet(string2, string, string3, mibNode.getEnumeratedType(), n);
        } else {
            this.handleSet(string2, string, string3, null, n);
            this.handleCheck(string2, string, string3, null, n);
        }
        this.handleInit(string2, string, n);
        ++this.varCount;
    }

    protected void handleSet(String string, String string2, String string3, String string4, int n) throws IOException {
        this.set_impl.append(String.valueOf(Def.TAB3) + "case " + string + ":\n" + Def.TAB4);
        this.set_impl.append("if (moi == false)\n" + Def.TAB5 + "break" + Def.SEMICOLON + Def.TAB4);
        if (n == 67) {
            this.set_impl.append(String.valueOf(Def.THROW_NEW) + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_READONLY + ")" + Def.SEMICOLON + "\n");
            return;
        }
        if (n == 47 || n == 7) {
            this.set_impl.append(String.valueOf(Def.THROW_NEW) + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_NOACCESS + ")" + Def.SEMICOLON + "\n");
            return;
        }
        String string5 = SyntaxMapper.getTypeName(string3);
        String string6 = SyntaxMapper.getCastMethod(string3);
        this.set_impl.append("if (x instanceof " + string5 + ")" + Def.LBRACE + Def.TAB5);
        if (string4 == null) {
            this.set_impl.append(String.valueOf(MBEAN_NAME) + "." + Def.SET + string2 + "(((" + string5 + ")x)." + string6 + "())" + Def.SEMICOLON + Def.TAB5 + "return new " + string5 + "(" + MBEAN_NAME + "." + Def.GET + string2 + "())" + Def.SEMICOLON + Def.TAB4 + "} else {\n" + Def.TAB5 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_BADVALUE + ")" + Def.SEMICOLON + Def.TAB4 + Def.RBRACE + "\n");
        } else {
            this.set_impl.append("try " + Def.LBRACE + Def.TAB6 + MBEAN_NAME + "." + Def.SET + string2 + "( new " + string4 + "(((" + string5 + ")x)." + string6 + "()))" + Def.SEMICOLON + Def.TAB5 + Def.N_RBRACE + " catch(" + Def.EXCP_ARGUMENT + " e) " + Def.LBRACE + Def.TAB6 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_BADVALUE + ")" + Def.SEMICOLON + Def.TAB5 + Def.RBRACE + Def.TAB5 + "return new " + string5 + "(" + MBEAN_NAME + "." + Def.GET + string2 + "())" + Def.SEMICOLON + Def.TAB4 + "} else {\n" + Def.TAB5 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_BADVALUE + ")" + Def.SEMICOLON + Def.TAB4 + Def.RBRACE + "\n");
        }
    }

    protected void handleTable(MibNode mibNode) throws IOException {
        String string = mibNode.getSymbolName();
        String string2 = mibNode.getNodeId();
        this.get_impl.append(String.valueOf(Def.TAB3) + "case " + string2 + ":" + Def.LBRACE + Def.TAB4);
        this.get_impl.append(String.valueOf(Def.SNMP_TABLE) + " table = node." + Def.ACCESS + string + "()" + Def.SEMICOLON + Def.TAB4 + "return table.get(oid, pos+1)" + Def.SEMICOLON + Def.TAB4 + Def.RBRACE + "\n");
        this.getNext_impl.append(String.valueOf(Def.TAB4) + "case " + string2 + ":" + Def.LBRACE + Def.TAB5 + Def.SNMP_TABLE + " table = node." + Def.ACCESS + string + "()" + Def.SEMICOLON + Def.TAB5 + "result = table." + Def.GET_NEXT + "(oid, pos+1)" + Def.SEMICOLON + Def.TAB5 + "result." + Def.METH_INSERTINOID + "(" + string2 + ")" + Def.SEMICOLON + Def.TAB5 + Def.RETURN + "result" + Def.SEMICOLON + Def.TAB5 + Def.RBRACE + "\n");
        this.set_impl.append(String.valueOf(Def.TAB3) + "case " + string2 + ":" + Def.LBRACE + Def.TAB4);
        this.set_impl.append(String.valueOf(Def.SNMP_TABLE) + " table = node." + Def.ACCESS + string + "()" + Def.SEMICOLON + Def.TAB4 + "return table.set(x, oid, pos+1)" + Def.SEMICOLON + Def.TAB4 + Def.RBRACE + "\n");
        this.check_impl.append(String.valueOf(Def.TAB3) + "case " + string2 + ":" + Def.LBRACE + Def.TAB4);
        this.check_impl.append(String.valueOf(Def.SNMP_TABLE) + " table = node." + Def.ACCESS + string + "()" + Def.SEMICOLON + Def.TAB4 + "table.check(x, oid, pos+1)" + Def.SEMICOLON + Def.TAB4 + Def.RETURN + Def.SEMICOLON + Def.TAB4 + Def.RBRACE + "\n");
        Hashtable hashtable = mibNode.getChildren();
        if (hashtable.size() != 1) {
            Trace.info("=======>ERROR: Invalid definition for entry " + string);
            throw new IOException("Invalid definition for entry " + string);
        }
        Enumeration enumeration = hashtable.elements();
        MibNode mibNode2 = (MibNode)enumeration.nextElement();
        MetaEntryGenerator metaEntryGenerator = new MetaEntryGenerator(this.manager, this.packageName, this.prefix, this.targetDir, mibNode2, this.mib);
        Enumeration enumeration2 = mibNode2.getChildren().elements();
        while (enumeration2.hasMoreElements()) {
            MibNode mibNode3 = (MibNode)enumeration2.nextElement();
            metaEntryGenerator.handleNode(mibNode3);
        }
        metaEntryGenerator.endOfGroup();
    }

    protected void writeClassDeclaration() throws IOException {
        this.write("/**\n * " + MessageHandler.getMessage("generate.meta.comment.desc", this.varName) + "\n" + " * " + MessageHandler.getMessage("generate.mbean.comment.oid", this.oid) + "\n" + " */\n");
        this.write(String.valueOf(Def.PUBLIC) + Def.CLASS + this.symboleName + Def.EXTEND + this.getParentClass());
        this.write(String.valueOf(Def.IMPLEMENT) + Def.SERIALIZABLE + Def.LBRACE + "\n");
    }

    protected void writeHeader() throws IOException {
        this.writePkg();
        this.write("// java imports\n//\n");
        this.write(String.valueOf(Def.IMPORT) + Def.PKG_SERIALIZABLE + Def.SEMICOLON);
        this.write("\n// jmx imports\n//\n");
        this.write(String.valueOf(Def.IMPORT) + Def.PKG_SNMP_COUNTER + Def.SEMICOLON);
        this.write(String.valueOf(Def.IMPORT) + Def.PKG_SNMP_COUNTER64 + Def.SEMICOLON);
        this.write(String.valueOf(Def.IMPORT) + Def.PKG_SNMP_GAUGE + Def.SEMICOLON);
        this.write(String.valueOf(Def.IMPORT) + Def.PKG_SNMP_INT + Def.SEMICOLON);
        this.write(String.valueOf(Def.IMPORT) + Def.PKG_SNMP_UINT + Def.SEMICOLON);
        this.write(String.valueOf(Def.IMPORT) + Def.PKG_SNMP_IP_ADDR + Def.SEMICOLON);
        this.write(String.valueOf(Def.IMPORT) + Def.PKG_SNMP_TIME_TICKS + Def.SEMICOLON);
        this.write(String.valueOf(Def.IMPORT) + Def.PKG_SNMP_OPAQUE + Def.SEMICOLON);
        this.write(String.valueOf(Def.IMPORT) + Def.PKG_SNMP_STRING + Def.SEMICOLON);
        this.write(String.valueOf(Def.IMPORT) + Def.PKG_SNMP_STRING_FIXED + Def.SEMICOLON);
        this.write(String.valueOf(Def.IMPORT) + Def.PKG_SNMP_OID + Def.SEMICOLON);
        this.write(String.valueOf(Def.IMPORT) + Def.PKG_SNMP_NULL + Def.SEMICOLON);
        this.write(String.valueOf(Def.IMPORT) + Def.PKG_SNMP_VALUE + Def.SEMICOLON);
        this.write(String.valueOf(Def.IMPORT) + Def.PKG_SNMP_VARBIND + Def.SEMICOLON);
        this.write(String.valueOf(Def.IMPORT) + Def.PKG_SNMP_STATUS_EXCEPTION + Def.SEMICOLON);
        this.write("\n// jdmk imports\n//\n");
        this.writeJdmkImports();
        this.write("\n");
    }

    protected void writeJdmkImports() throws IOException {
        this.write(String.valueOf(Def.IMPORT) + Def.PKG_SNMP_MIB + Def.SEMICOLON);
        this.write(String.valueOf(Def.IMPORT) + this.getParentClassPkg() + Def.SEMICOLON);
        this.write(String.valueOf(Def.IMPORT) + Def.PKG_SNMP_MIB_TABLE + Def.SEMICOLON);
    }
}

