/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.compiler.mib2mof;

import com.sun.wbem.compiler.mib2mof.ASTMib;
import com.sun.wbem.compiler.mib2mof.ASTNamedType;
import com.sun.wbem.compiler.mib2mof.ASTObjectTypeDefinition;
import com.sun.wbem.compiler.mib2mof.ASTValue;
import com.sun.wbem.compiler.mib2mof.BeanGenerator;
import com.sun.wbem.compiler.mib2mof.Def;
import com.sun.wbem.compiler.mib2mof.EnumGenerator;
import com.sun.wbem.compiler.mib2mof.MessageHandler;
import com.sun.wbem.compiler.mib2mof.MibNode;
import com.sun.wbem.compiler.mib2mof.ResourceManager;
import com.sun.wbem.compiler.mib2mof.SyntaxMapper;
import com.sun.wbem.compiler.mib2mof.TableBeanGenerator;
import com.sun.wbem.compiler.mib2mof.Trace;
import java.io.IOException;
import java.io.Serializable;

public class MbeanGenerator
extends BeanGenerator
implements Serializable {
    protected StringBuffer var_list = new StringBuffer();
    protected StringBuffer accessors = new StringBuffer();
    protected StringBuffer constructor1 = new StringBuffer();
    protected StringBuffer constructor2 = new StringBuffer();

    public MbeanGenerator(ResourceManager resourceManager, String string, String string2, String string3, MibNode mibNode, ASTMib aSTMib) throws IOException {
        super(resourceManager, string, string2, string3, mibNode, aSTMib);
        this.oid = this.node.getComputedOid();
        this.varName = this.node.getSymbolName();
        if (this.varName == null) {
            this.varName = this.getClassName(this.node.getComputedOid());
        }
        this.symboleName = String.valueOf(string2) + this.varName;
        Trace.info(MessageHandler.getMessage("generate.info.var", this.varName));
        this.out = this.openFile(String.valueOf(this.symboleName) + Def.JAVA);
        this.writeHeader();
        this.writeClassDeclaration();
        this.buildConstructorHeader();
    }

    protected void addAccessors(MibNode mibNode, String string, String string2) throws IOException {
        ASTObjectTypeDefinition aSTObjectTypeDefinition = mibNode.getObjectType();
        String string3 = aSTObjectTypeDefinition.getDefinition().getDescription();
        this.accessors.append(String.valueOf(Def.TAB) + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.getter", string2) + "\n" + Def.TAB + " */\n");
        this.accessors.append(String.valueOf(Def.TAB) + Def.PUBLIC + string + Def.GET + string2 + "() " + BeanGenerator.accessThrows);
        this.accessors.append(String.valueOf(Def.TAB2) + Def.RETURN + string2 + Def.SEMICOLON);
        this.accessors.append(String.valueOf(Def.TAB) + Def.RBRACE + "\n");
        int n = aSTObjectTypeDefinition.getDefinition().getAccess();
        if (n == 68 || n == 85 || n == 66) {
            this.accessors.append(String.valueOf(Def.TAB) + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.setter", string2) + "\n" + Def.TAB + " */\n");
            this.accessors.append(String.valueOf(Def.TAB) + Def.PUBLIC + Def.VOID + Def.SET + string2 + "(" + string + "x) " + BeanGenerator.accessThrows);
            this.accessors.append(String.valueOf(Def.TAB2) + string2 + " = x" + Def.SEMICOLON);
            this.accessors.append(String.valueOf(Def.TAB) + Def.RBRACE + "\n");
            this.accessors.append(String.valueOf(Def.TAB) + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.checker", string2) + "\n" + Def.TAB + " */\n");
            this.accessors.append(String.valueOf(Def.TAB) + Def.PUBLIC + Def.VOID + Def.CHECK + string2 + "(" + string + "x) " + BeanGenerator.accessThrows);
            this.accessors.append(String.valueOf(Def.TAB2) + "//\n" + Def.TAB2 + "// " + MessageHandler.getMessage("generate.mbean.comment.checker.policy") + "\n" + Def.TAB2 + "//\n");
            this.accessors.append(String.valueOf(Def.TAB) + Def.RBRACE + "\n");
        }
    }

    protected void addCacheVar(MibNode mibNode, String string, long l, String string2, String string3) throws IOException {
        this.var_list.append(String.valueOf(Def.TAB) + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.varUse", string3) + "\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.varOid", mibNode.getOid()) + "\n" + Def.TAB);
        if (l != -1L) {
            this.var_list.append(" * " + MessageHandler.getMessage("generate.mbean.comment.varFix", String.valueOf(l)) + "\n" + Def.TAB);
        }
        if (this.mib.isDescriptionOn()) {
            ASTObjectTypeDefinition aSTObjectTypeDefinition = mibNode.getObjectType();
            String string4 = aSTObjectTypeDefinition.getDefinition().getDescription();
            this.var_list.append(this.formatDescription(string4));
        }
        this.var_list.append(" */\n");
        if (string2 == null) {
            string2 = "";
        }
        this.var_list.append(String.valueOf(Def.TAB) + Def.PROTECTED + string + string3 + string2 + Def.SEMICOLON + "\n");
    }

    protected void buildConstructorHeader() throws IOException {
        this.constructor1.append("\n" + Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.constr", this.symboleName) + "\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.noRegistration") + "\n" + Def.TAB + " */\n");
        this.constructor1.append(String.valueOf(Def.TAB) + Def.PUBLIC + this.symboleName + "(SnmpMib myMib)" + Def.LBRACE);
        this.constructor2.append("\n" + Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.constr", this.symboleName) + "\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.registration") + "\n" + Def.TAB + " */\n");
        this.constructor2.append(String.valueOf(Def.TAB) + Def.PUBLIC + this.symboleName + "(SnmpMib myMib, MBeanServer server)" + Def.LBRACE);
    }

    protected void closeConstructor() throws IOException {
        this.constructor1.append(String.valueOf(Def.TAB) + Def.RBRACE + "\n");
        this.constructor2.append(String.valueOf(Def.TAB) + Def.RBRACE + "\n");
    }

    public void endOfGroup() throws IOException {
        this.closeConstructor();
        this.write(this.var_list.toString());
        this.write(this.constructor1.toString());
        this.write(this.constructor2.toString());
        this.write(this.accessors.toString());
        this.write(Def.RBRACE);
        this.closeIO();
    }

    public String getSnmpClassName() {
        return this.symboleName;
    }

    protected void handleNestedGroups(MibNode mibNode) throws IOException {
    }

    public void handleNode(MibNode mibNode) throws IOException {
        if (mibNode.isGroup() || mibNode.hasNestedGroups()) {
            this.handleNestedGroups(mibNode);
            return;
        }
        if (mibNode.isTable()) {
            this.handleTable(mibNode);
            return;
        }
        String string = mibNode.getSymbolName();
        ASTObjectTypeDefinition aSTObjectTypeDefinition = mibNode.getObjectType();
        if (aSTObjectTypeDefinition == null) {
            return;
        }
        ASTNamedType aSTNamedType = aSTObjectTypeDefinition.getSyntax();
        String string2 = "";
        ASTValue aSTValue = aSTObjectTypeDefinition.getDefValue();
        String string3 = new String();
        if (aSTNamedType.isEnumeratedType()) {
            EnumGenerator enumGenerator = new EnumGenerator(this.manager, this.packageName, this.prefix, this.targetDir, string, aSTNamedType.getEnumeratedDef(), this.mib);
            string2 = enumGenerator.getTypeName();
            if (aSTValue != null) {
                string3 = aSTValue.getDefValInitializer(string2, aSTNamedType, string);
            }
            if (aSTValue == null || string3.equals("")) {
                string3 = " = new " + string2.trim() + "()";
            }
            mibNode.setEnumerated(true);
            mibNode.setEnumeratedType(string2);
        } else {
            string2 = aSTNamedType.getMbeanSyntax();
            if (aSTValue != null) {
                string3 = aSTValue.getDefValInitializer(string2, aSTNamedType, string);
            }
            if (aSTValue == null || string3.equals("")) {
                string3 = SyntaxMapper.getInitializer(aSTNamedType.getSnmpSyntax());
            }
        }
        long l = aSTNamedType.getFixedLength();
        mibNode.setFixedLength(l);
        this.addCacheVar(mibNode, string2, l, string3, string);
        this.addAccessors(mibNode, string2, string);
    }

    protected void handleTable(MibNode mibNode) throws IOException {
        TableBeanGenerator tableBeanGenerator = new TableBeanGenerator(this.manager, this.packageName, this.prefix, this.targetDir, mibNode, this.mib);
        String string = tableBeanGenerator.getEntryName();
        String string2 = tableBeanGenerator.getTableClassName();
        String string3 = tableBeanGenerator.getSymbolName();
        this.addCacheVar(mibNode, string2, -1L, null, string3);
        this.constructor1.append(String.valueOf(Def.TAB2) + string3 + " = " + Def.NEW + string2 + "(myMib)" + Def.SEMICOLON);
        this.constructor2.append(String.valueOf(Def.TAB2) + string3 + " = " + Def.NEW + string2 + "(myMib, server)" + Def.SEMICOLON);
        this.accessors.append(String.valueOf(Def.TAB) + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.table.access", string3) + "\n" + Def.TAB + " */\n");
        this.accessors.append(String.valueOf(Def.TAB) + Def.PUBLIC + string2 + Def.ACCESS + string3 + "() " + BeanGenerator.accessThrows);
        this.accessors.append(String.valueOf(Def.TAB2) + Def.RETURN + string3 + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
        this.accessors.append(String.valueOf(Def.TAB) + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.table.entry", string3) + "\n" + Def.TAB + " */\n");
        this.accessors.append(String.valueOf(Def.TAB) + Def.PUBLIC + string + Def.MBEANSUFFIX + "[] " + Def.GET + string3 + "() " + BeanGenerator.accessThrows);
        this.accessors.append(String.valueOf(Def.TAB2) + Def.RETURN + string3 + ".getEntries()" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
    }

    protected void writeClassDeclaration() throws IOException {
        this.write("/**\n * " + MessageHandler.getMessage("generate.mbean.comment.desc", this.varName) + "\n" + " * " + MessageHandler.getMessage("generate.mbean.comment.oid", this.oid) + "\n" + " */\n");
        this.write(String.valueOf(Def.PUBLIC) + Def.CLASS + this.symboleName + Def.IMPLEMENT + this.symboleName + Def.MBEANSUFFIX + ", " + Def.SERIALIZABLE + Def.LBRACE + "\n");
    }

    protected void writeHeader() throws IOException {
        this.writePkg();
        this.write("// java imports\n//\n");
        this.write(String.valueOf(Def.IMPORT) + Def.PKG_SERIALIZABLE + Def.SEMICOLON);
        this.write("\n// jmx imports\n//\n");
        this.write(String.valueOf(Def.IMPORT) + Def.PKG_MBEAN_SERVER + Def.SEMICOLON);
        this.write(String.valueOf(Def.IMPORT) + Def.PKG_SNMP_STRING + Def.SEMICOLON);
        this.write(String.valueOf(Def.IMPORT) + Def.PKG_SNMP_STATUS_EXCEPTION + Def.SEMICOLON);
        this.write("\n// jdmk imports\n//\n");
        this.write(String.valueOf(Def.IMPORT) + Def.PKG_SNMP_MIB + Def.SEMICOLON);
        this.write("\n");
    }
}

