/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.logviewer.client;

import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.DateWidget;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.TimeWidget;
import com.sun.admin.logviewer.client.LogContextHelpListener;
import com.sun.admin.logviewer.client.VLogViewer;
import com.sun.admin.logviewer.common.LogFilter;
import com.sun.admin.logviewer.common.LogViewerException;
import com.sun.management.viper.console.VConsoleActionListener;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VFilter;
import com.sun.management.viper.console.gui.VOptionPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class LogVFilterPanel
extends JPanel
implements VFilter,
PropertyChangeListener,
VConsoleActionListener {
    public static final int HELP_CACHE_SIZE = 17;
    VLogViewer theApp;
    ResourceBundle bundle;
    JLabel label;
    JRadioButton startRBtn;
    JRadioButton startFromRBtn;
    DateWidget startingFromDW;
    TimeWidget startingFromTW;
    JCheckBox infoChk;
    JCheckBox warnChk;
    JCheckBox errorChk;
    JCheckBox appChk;
    JCheckBox sysChk;
    JCheckBox secChk;
    JRadioButton endRBtn;
    JRadioButton endingAtRBtn;
    DateWidget endingAtDW;
    TimeWidget endingAtTW;
    JTextField userField;
    JTextField computerField;
    GridBagConstraints gbc = new GridBagConstraints();
    protected Action filterControl = null;
    protected VOptionPane optionPane = null;
    protected VConsoleProperties properties = null;
    protected Vector listeners = new Vector();
    private JFrame frame = null;
    private boolean bListenersAdded = false;
    private boolean bIsFilterEnabled;

    public LogVFilterPanel(VLogViewer vLogViewer) {
        this.theApp = vLogViewer;
        this.bundle = vLogViewer.getResourceBundle();
        this.frame = vLogViewer.getFrame();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        String string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"view_from");
        jPanel3.setBorder(BorderFactory.createTitledBorder(string));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        ButtonGroup buttonGroup = new ButtonGroup();
        this.startRBtn = new JRadioButton(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"start_log"));
        buttonGroup.add(this.startRBtn);
        this.startRBtn.setSelected(true);
        this.startRBtn.setActionCommand("start");
        RadioListener radioListener = new RadioListener();
        this.startRBtn.addActionListener(radioListener);
        Constraints.constrain((Container)jPanel4, (Component)this.startRBtn, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)6, (int)6, (int)0, (int)6);
        this.startFromRBtn = new JRadioButton(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"logs_begin"));
        buttonGroup.add(this.startFromRBtn);
        this.startFromRBtn.setActionCommand("start from");
        this.startFromRBtn.addActionListener(radioListener);
        Constraints.constrain((Container)jPanel4, (Component)this.startFromRBtn, (int)0, (int)1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)6, (int)0, (int)6);
        Constraints.constrain((Container)jPanel3, (Component)jPanel4, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)6, (int)6, (int)6, (int)6);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridBagLayout());
        this.startingFromDW = new DateWidget(this.frame);
        this.startingFromDW.setEnabled(false);
        Constraints.constrain((Container)jPanel5, (Component)this.startingFromDW, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)0, (int)6, (int)6, (int)6);
        this.startingFromTW = new TimeWidget(this.frame);
        this.startingFromTW.setEnabled(false);
        this.startingFromTW.setMinimumSize(this.startingFromTW.getPreferredSize());
        Constraints.constrain((Container)jPanel5, (Component)this.startingFromTW, (int)0, (int)1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)0, (int)6, (int)6, (int)6);
        Constraints.constrain((Container)jPanel3, (Component)jPanel5, (int)0, (int)1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)6, (int)6, (int)6, (int)6);
        Constraints.constrain((Container)jPanel2, (Component)jPanel3, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)6, (int)6, (int)6, (int)6);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridBagLayout());
        string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"view_through");
        jPanel6.setBorder(BorderFactory.createTitledBorder(string));
        jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        buttonGroup = new ButtonGroup();
        this.endRBtn = new JRadioButton(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"end_log"));
        buttonGroup.add(this.endRBtn);
        this.endRBtn.setSelected(true);
        this.endRBtn.setActionCommand("end");
        this.endRBtn.addActionListener(radioListener);
        Constraints.constrain((Container)jPanel4, (Component)this.endRBtn, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)6, (int)6, (int)0, (int)6);
        this.endingAtRBtn = new JRadioButton(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"log_end"));
        buttonGroup.add(this.endingAtRBtn);
        this.endingAtRBtn.setActionCommand("ending at");
        this.endingAtRBtn.addActionListener(radioListener);
        Constraints.constrain((Container)jPanel4, (Component)this.endingAtRBtn, (int)0, (int)1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)6, (int)0, (int)6);
        Constraints.constrain((Container)jPanel6, (Component)jPanel4, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)6, (int)6, (int)6, (int)6);
        jPanel5 = new JPanel();
        jPanel5.setLayout(new GridBagLayout());
        this.endingAtDW = new DateWidget(this.frame);
        this.endingAtDW.setEnabled(false);
        Constraints.constrain((Container)jPanel5, (Component)this.endingAtDW, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)0, (int)6, (int)6, (int)6);
        this.endingAtTW = new TimeWidget(this.frame);
        this.endingAtTW.setEnabled(false);
        this.endingAtTW.setMinimumSize(this.endingAtTW.getPreferredSize());
        Constraints.constrain((Container)jPanel5, (Component)this.endingAtTW, (int)0, (int)1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)0, (int)6, (int)6, (int)6);
        Constraints.constrain((Container)jPanel6, (Component)jPanel5, (int)0, (int)1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)6, (int)6, (int)6, (int)6);
        Constraints.constrain((Container)jPanel2, (Component)jPanel6, (int)1, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)6, (int)6, (int)6, (int)6);
        Constraints.constrain((Container)jPanel, (Component)jPanel2, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridBagLayout());
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridBagLayout());
        string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"Prop_lbl");
        jPanel8.setBorder(BorderFactory.createTitledBorder(string));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridBagLayout());
        FlowArea flowArea = new FlowArea(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"Prop_title"));
        Constraints.constrain((Container)jPanel9, (Component)flowArea, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)6, (int)6, (int)6, (int)6);
        Constraints.constrain((Container)jPanel8, (Component)jPanel9, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new GridBagLayout());
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new GridBagLayout());
        string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"type_title");
        jPanel11.setBorder(BorderFactory.createTitledBorder(string));
        this.infoChk = new JCheckBox(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"info"), true);
        Constraints.constrain((Container)jPanel11, (Component)this.infoChk, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)6, (int)6, (int)6, (int)6);
        this.warnChk = new JCheckBox(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"warn"), true);
        Constraints.constrain((Container)jPanel11, (Component)this.warnChk, (int)0, (int)1, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)0, (int)6, (int)6, (int)6);
        this.errorChk = new JCheckBox(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"error"), true);
        Constraints.constrain((Container)jPanel11, (Component)this.errorChk, (int)0, (int)2, (int)1, (int)1, (int)0, (int)18, (double)1.0, (double)1.0, (int)0, (int)6, (int)6, (int)6);
        Constraints.constrain((Container)jPanel10, (Component)jPanel11, (int)0, (int)0, (int)1, (int)1, (int)1, (int)17, (double)1.0, (double)1.0, (int)0, (int)6, (int)6, (int)6);
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new GridBagLayout());
        string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"misc");
        jPanel12.setBorder(BorderFactory.createTitledBorder(string));
        this.label = new JLabel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"user_lbl"));
        Constraints.constrain((Container)jPanel12, (Component)this.label, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)6, (int)6, (int)6, (int)6);
        this.userField = new JTextField(15);
        Constraints.constrain((Container)jPanel12, (Component)this.userField, (int)0, (int)1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)6, (int)6, (int)6);
        this.label = new JLabel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"computer_lbl"));
        Constraints.constrain((Container)jPanel12, (Component)this.label, (int)0, (int)2, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)0, (int)6, (int)6, (int)6);
        this.computerField = new JTextField(15);
        Constraints.constrain((Container)jPanel12, (Component)this.computerField, (int)0, (int)3, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)6, (int)6, (int)6);
        Constraints.constrain((Container)jPanel10, (Component)jPanel12, (int)1, (int)0, (int)1, (int)1, (int)1, (int)17, (double)1.0, (double)1.0, (int)0, (int)0, (int)6, (int)6);
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new GridBagLayout());
        string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"cat_lbl1");
        jPanel13.setBorder(BorderFactory.createTitledBorder(string));
        this.appChk = new JCheckBox(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"application"), true);
        Constraints.constrain((Container)jPanel13, (Component)this.appChk, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)6, (int)6, (int)6, (int)6);
        this.sysChk = new JCheckBox(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"system"), true);
        Constraints.constrain((Container)jPanel13, (Component)this.sysChk, (int)0, (int)1, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)0, (int)6, (int)6, (int)6);
        this.secChk = new JCheckBox(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"security"), true);
        Constraints.constrain((Container)jPanel13, (Component)this.secChk, (int)0, (int)2, (int)1, (int)1, (int)0, (int)18, (double)1.0, (double)1.0, (int)0, (int)6, (int)6, (int)6);
        Constraints.constrain((Container)jPanel10, (Component)jPanel13, (int)0, (int)1, (int)2, (int)1, (int)1, (int)17, (double)1.0, (double)1.0, (int)0, (int)6, (int)6, (int)6);
        Constraints.constrain((Container)jPanel8, (Component)jPanel10, (int)0, (int)1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        Constraints.constrain((Container)jPanel7, (Component)jPanel8, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)6, (int)6, (int)6);
        Constraints.constrain((Container)jPanel, (Component)jPanel7, (int)0, (int)1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        JPanel jPanel14 = new JPanel();
        Constraints.constrain((Container)jPanel, (Component)jPanel14, (int)0, (int)2, (int)1, (int)1, (int)1, (int)17, (double)1.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
        this.setLayout(new GridBagLayout());
        Constraints.constrain((Container)this, (Component)jPanel, (int)0, (int)0, (int)1, (int)1, (int)1, (int)17, (double)1.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
    }

    public void addConsoleActionListener(VConsoleActionListener vConsoleActionListener) {
        this.listeners.addElement(vConsoleActionListener);
    }

    public Vector applyFilter(VScopeNode vScopeNode) {
        return null;
    }

    private boolean areDatesOK() {
        boolean bl = true;
        String string = this.startingFromDW.getDateString();
        String string2 = this.endingAtDW.getDateString();
        if (this.startFromRBtn.isSelected() && this.endingAtRBtn.isSelected() && !string.equals("") && !string2.equals("")) {
            int n = this.startingFromDW.getYearInt();
            int n2 = this.startingFromDW.getMonthInt();
            int n3 = this.startingFromDW.getDayInt();
            int n4 = this.endingAtDW.getYearInt();
            int n5 = this.endingAtDW.getMonthInt();
            int n6 = this.endingAtDW.getDayInt();
            if (n > n4 || n2 > n5 || n3 > n6) {
                bl = false;
            }
        }
        return bl;
    }

    public void clearFilter() {
        this.resetDefaults();
    }

    public void consoleAction(VConsoleEvent vConsoleEvent) {
    }

    public int getAppCat() {
        if (this.appChk.isSelected()) {
            return 0;
        }
        return -1;
    }

    public String getComputer() {
        if (!this.computerField.getText().equals("")) {
            return this.computerField.getText();
        }
        return null;
    }

    public String getEndDate() {
        if (!this.endingAtDW.getTraditionalDate().equals("")) {
            return this.endingAtDW.getTraditionalDate();
        }
        return null;
    }

    public String getEndTime() {
        if (!this.endingAtTW.getTimeString().equals("")) {
            return this.endingAtTW.getTimeString();
        }
        return null;
    }

    public int getErrorSev() {
        if (this.errorChk.isSelected()) {
            return 2;
        }
        return -1;
    }

    public boolean getFilterEnabled() {
        return false;
    }

    public boolean getFindMode() {
        return false;
    }

    public int getInfoSev() {
        if (this.infoChk.isSelected()) {
            return 0;
        }
        return -1;
    }

    public boolean getIsFilterEnabled() {
        return this.bIsFilterEnabled;
    }

    public int getSecCat() {
        if (this.secChk.isSelected()) {
            return 1;
        }
        return -1;
    }

    public String getStartDate() {
        if (!this.startingFromDW.getTraditionalDate().equals("")) {
            return this.startingFromDW.getTraditionalDate();
        }
        return null;
    }

    public String getStartTime() {
        if (!this.startingFromTW.getTimeString().equals("")) {
            return this.startingFromTW.getTimeString();
        }
        return null;
    }

    public int getSysCat() {
        if (this.sysChk.isSelected()) {
            return 2;
        }
        return -1;
    }

    public String getUser() {
        if (!this.userField.getText().equals("")) {
            return this.userField.getText();
        }
        return null;
    }

    public int getWarnSev() {
        if (this.warnChk.isSelected()) {
            return 1;
        }
        return -1;
    }

    public boolean isLogBeginDateOK() {
        if (this.startFromRBtn.isSelected()) {
            return this.startingFromDW.isValidDate();
        }
        return true;
    }

    public boolean isLogBeginTimeOK() {
        if (this.startFromRBtn.isSelected()) {
            return this.startingFromTW.isValidTime();
        }
        return true;
    }

    public boolean isLogEndDateOK() {
        if (this.endingAtRBtn.isSelected()) {
            return this.endingAtDW.isValidDate();
        }
        return true;
    }

    public boolean isLogEndTimeOK() {
        if (this.endingAtRBtn.isSelected()) {
            return this.endingAtTW.isValidTime();
        }
        return true;
    }

    protected void notifyListeners(VConsoleEvent vConsoleEvent) {
        if (this.listeners.size() > 0) {
            int n = 0;
            while (n < this.listeners.size()) {
                ((VConsoleActionListener)this.listeners.elementAt(n)).consoleAction(vConsoleEvent);
                ++n;
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public void resetDefaults() {
        this.startRBtn.setSelected(true);
        this.startingFromDW.setDateString("");
        this.startingFromTW.setTimeString("");
        this.endRBtn.setSelected(true);
        this.endingAtDW.setDateString("");
        this.endingAtTW.setTimeString("");
        this.infoChk.setSelected(true);
        this.warnChk.setSelected(true);
        this.errorChk.setSelected(true);
        this.userField.setText("");
        this.computerField.setText("");
        this.appChk.setSelected(true);
        this.sysChk.setSelected(true);
        this.secChk.setSelected(true);
        this.repaint();
    }

    public void setFilterAction(Action action) {
        this.filterControl = action;
    }

    public void setFilterEnabled(boolean bl) {
        this.bIsFilterEnabled = bl;
        if (bl) {
            if (this.areDatesOK()) {
                this.updateSettings();
                this.properties.setProperty("vconsole.filteredstate", "true");
                this.theApp.getTree().getCurrentContent().refresh();
            } else {
                LogViewerException logViewerException = new LogViewerException("EXM_LV_GUI_BAD_DATES");
                this.theApp.reportErrorException((Exception)((Object)logViewerException));
            }
        } else {
            this.resetDefaults();
            this.theApp.setFilter(new LogFilter());
            this.properties.setProperty("vconsole.filteredstate", "false");
            this.theApp.getTree().getCurrentContent().refresh();
        }
    }

    public void setFindMode(boolean bl) {
    }

    public void setOptionPane(VOptionPane vOptionPane) {
        this.optionPane = vOptionPane;
        if (this.optionPane != null) {
            this.optionPane.getContentPane().setLayout(new BorderLayout());
            this.optionPane.getContentPane().add((Component)this, "Center");
            this.optionPane.setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"filter_title"));
            this.optionPane.repaint();
            GenInfoPanel genInfoPanel = new GenInfoPanel(this.optionPane);
            Vector vector = new Vector(17);
            LogContextHelpListener logContextHelpListener = new LogContextHelpListener(this.theApp, vector, genInfoPanel, "lm_ctx_dlg_filter_overview");
            if (!this.bListenersAdded) {
                GenInfoPanel genInfoPanel2 = new GenInfoPanel(this.optionPane);
                LogContextHelpListener logContextHelpListener2 = new LogContextHelpListener(this.theApp, vector, genInfoPanel2, "lm_ctx_dlg_filter_from_start");
                this.theApp.addHelpListener(logContextHelpListener2, this.startRBtn);
                this.theApp.addHelpListener(logContextHelpListener2, this.startFromRBtn);
                logContextHelpListener2 = new LogContextHelpListener(this.theApp, vector, genInfoPanel2, "lm_ctx_dlg_filter_from_beginlog_date");
                this.theApp.addHelpListener(logContextHelpListener2, (Component)this.startingFromDW);
                logContextHelpListener2 = new LogContextHelpListener(this.theApp, vector, genInfoPanel2, "lm_ctx_dlg_filter_beginlog_time");
                this.theApp.addHelpListener(logContextHelpListener2, (Component)this.startingFromTW);
                logContextHelpListener2 = new LogContextHelpListener(this.theApp, vector, genInfoPanel2, "lm_ctx_dlg_filter_through_end");
                this.theApp.addHelpListener(logContextHelpListener2, this.endRBtn);
                this.theApp.addHelpListener(logContextHelpListener2, this.endingAtRBtn);
                logContextHelpListener2 = new LogContextHelpListener(this.theApp, vector, genInfoPanel2, "lm_ctx_dlg_filter_through_endlog_date");
                this.theApp.addHelpListener(logContextHelpListener2, (Component)this.endingAtDW);
                logContextHelpListener2 = new LogContextHelpListener(this.theApp, vector, genInfoPanel2, "lm_ctx_dlg_filter_through_endlog_time");
                this.theApp.addHelpListener(logContextHelpListener2, (Component)this.endingAtTW);
                logContextHelpListener2 = new LogContextHelpListener(this.theApp, vector, genInfoPanel2, "lm_ctx_dlg_filter_show_security");
                this.theApp.addHelpListener(logContextHelpListener2, this.infoChk);
                this.theApp.addHelpListener(logContextHelpListener2, this.warnChk);
                this.theApp.addHelpListener(logContextHelpListener2, this.errorChk);
                logContextHelpListener2 = new LogContextHelpListener(this.theApp, vector, genInfoPanel2, "lm_ctx_dlg_filter_show_misc_user");
                this.theApp.addHelpListener(logContextHelpListener2, this.userField);
                logContextHelpListener2 = new LogContextHelpListener(this.theApp, vector, genInfoPanel2, "lm_ctx_dlg_filter_show_misc_comp");
                this.theApp.addHelpListener(logContextHelpListener2, this.computerField);
                logContextHelpListener2 = new LogContextHelpListener(this.theApp, vector, genInfoPanel2, "lm_ctx_dlg_filter_show_category");
                this.theApp.addHelpListener(logContextHelpListener2, this.appChk);
                this.theApp.addHelpListener(logContextHelpListener2, this.sysChk);
                this.theApp.addHelpListener(logContextHelpListener2, this.secChk);
                this.bListenersAdded = true;
            }
            genInfoPanel.setFocusListener((FocusListener)((Object)logContextHelpListener), true);
        }
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        this.properties = vConsoleProperties;
        if (vConsoleProperties != null) {
            vConsoleProperties.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public void updateSettings() {
        LogFilter logFilter = new LogFilter();
        logFilter.setFileName(this.theApp.getFileName());
        if (this.startFromRBtn.isSelected()) {
            if (this.isLogBeginDateOK() && this.isLogBeginTimeOK()) {
                logFilter.setStartDate(this.getStartDate(), this.getStartTime());
            }
        } else {
            logFilter.setStartDate(null, null);
        }
        if (this.endingAtRBtn.isSelected()) {
            if (this.isLogEndDateOK() && this.isLogEndTimeOK()) {
                logFilter.setEndDate(this.getEndDate(), this.getEndTime());
            }
        } else {
            logFilter.setEndDate(null, null);
        }
        logFilter.setSeverity(this.getInfoSev(), this.getWarnSev(), this.getErrorSev());
        logFilter.setUser(this.getUser());
        logFilter.setClientHostName(this.getComputer());
        logFilter.setCategory(this.getAppCat(), this.getSysCat(), this.getSecCat());
        this.theApp.setFilter(logFilter);
    }

    protected class RadioListener
    implements ActionListener {
        protected RadioListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("end")) {
                LogVFilterPanel.this.endingAtDW.setEnabled(false);
                LogVFilterPanel.this.endingAtTW.setEnabled(false);
            } else if (string.equals("ending at")) {
                LogVFilterPanel.this.endingAtDW.setEnabled(true);
                LogVFilterPanel.this.endingAtTW.setEnabled(true);
            } else if (string.equals("start")) {
                LogVFilterPanel.this.startingFromDW.setEnabled(false);
                LogVFilterPanel.this.startingFromTW.setEnabled(false);
            } else if (string.equals("start from")) {
                LogVFilterPanel.this.startingFromDW.setEnabled(true);
                LogVFilterPanel.this.startingFromTW.setEnabled(true);
            }
        }
    }
}

