/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.common;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class CommonTools {
    public static final String TRACE_STDOUT_NAME = "stdout";
    public static final String TRACE_STDERR_NAME = "stderr";
    public static final int TRACE_OFF = 0;
    public static final String PREFERENCES_GLOBAL = "global";
    private static final String WIN_BAT_SUFFIX = ".bat";
    private static final int TRACE_NONE = 0;
    private static final int TRACE_STDOUT = 1;
    private static final int TRACE_STDERR = 2;
    private static final int TRACE_FILE = 3;
    private static final int TRACE_RETRY = 5;
    private static boolean trace_init = false;
    private static int trace_level = 0;
    private static int trace_out = 3;
    private static FileWriter trace_fw;
    private static BufferedWriter trace_bw;
    private static PrintWriter trace_pw;
    private static Hashtable preferences;

    static {
        preferences = new Hashtable();
    }

    public static Vector CMN_ArrayToVector(Object[] objectArray) {
        Vector<Object> vector = new Vector<Object>();
        int n = 0;
        while (n < objectArray.length) {
            vector.addElement(objectArray[n]);
            ++n;
        }
        return vector;
    }

    public static String CMN_CallingClassMethod() {
        String string = null;
        try {
            InputStream inputStream = CommonTools.getStackStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            bufferedReader.readLine();
            bufferedReader.readLine();
            bufferedReader.readLine();
            bufferedReader.readLine();
            bufferedReader.readLine();
            bufferedReader.readLine();
            String string2 = bufferedReader.readLine();
            string = CommonTools.getCaller(string2);
            bufferedReader.close();
        }
        catch (Exception exception) {
            string = "??:??";
        }
        return string;
    }

    public static String CMN_CheckScriptName(String string) {
        String string2 = string;
        String string3 = System.getProperty("os.name");
        if (string3 != null && string3.regionMatches(true, 0, "Win", 0, 3) && !string.endsWith(WIN_BAT_SUFFIX)) {
            string2 = string.concat(WIN_BAT_SUFFIX);
        }
        return string2;
    }

    public static File CMN_CreateTempFile(String string) throws IOException {
        String string2 = CommonTools.CMN_GetTempDir();
        File file = new File(string2);
        if (!(file.exists() && file.isDirectory() && file.canWrite())) {
            file = new File(string);
            string2 = file.getParent();
        }
        File file2 = CommonTools.CMN_CreateTempFile(string2, string);
        return file2;
    }

    public static File CMN_CreateTempFile(String string, String string2) throws IOException {
        String string3;
        File file;
        int n = 0;
        while ((file = new File(string, string3 = String.valueOf(string2) + "." + n)).exists()) {
            ++n;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.close();
        return file;
    }

    private static Vector CMN_ExecWithStdErr(String string, String[] stringArray, String[] stringArray2) throws Exception {
        Object[] objectArray;
        Vector<Object[]> vector = new Vector<Object[]>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Process process = null;
        try {
            if (stringArray2 == null) {
                objectArray = Runtime.getRuntime();
                process = string == null ? objectArray.exec(stringArray) : objectArray.exec(string);
            } else {
                objectArray = Runtime.getRuntime();
                process = string == null ? objectArray.exec(stringArray, stringArray2) : objectArray.exec(string, stringArray2);
            }
            objectArray = process.getInputStream();
            InputStream inputStream = process.getErrorStream();
            StringBuffer stringBuffer = new StringBuffer("");
            StringBuffer stringBuffer2 = new StringBuffer("");
            boolean bl = false;
            while (!bl) {
                try {
                    char c;
                    while (objectArray.available() > 0) {
                        c = (char)objectArray.read();
                        if (c == '\n') {
                            stringBuffer.append(c);
                            vector2.addElement(stringBuffer.toString());
                            stringBuffer.setLength(0);
                            continue;
                        }
                        stringBuffer.append(c);
                    }
                    while (inputStream.available() > 0) {
                        c = (char)inputStream.read();
                        if (c == '\n') {
                            vector3.addElement(stringBuffer2.toString());
                            stringBuffer2.setLength(0);
                            continue;
                        }
                        stringBuffer2.append(c);
                    }
                    c = process.exitValue();
                    bl = true;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    Thread.currentThread();
                    Thread.sleep(50L);
                }
            }
        }
        catch (Exception exception) {
            if (process != null) {
                process.destroy();
            }
            vector = null;
            throw exception;
        }
        objectArray = new String[vector2.size()];
        if (vector2.size() != 0) {
            vector2.copyInto(objectArray);
            vector.addElement(objectArray);
        } else {
            vector.addElement(objectArray);
        }
        objectArray = new String[vector3.size()];
        if (vector3.size() != 0) {
            vector3.copyInto(objectArray);
            vector.addElement(objectArray);
        } else {
            vector.addElement(objectArray);
        }
        return vector;
    }

    public static Vector CMN_ExecWithStdErrNoCRLF(String[] stringArray) {
        Object[] objectArray;
        Vector<Object[]> vector = new Vector<Object[]>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Process process = null;
        try {
            objectArray = Runtime.getRuntime();
            process = objectArray.exec(stringArray);
            InputStream inputStream = process.getInputStream();
            InputStream inputStream2 = process.getErrorStream();
            StringBuffer stringBuffer = new StringBuffer("");
            StringBuffer stringBuffer2 = new StringBuffer("");
            boolean bl = false;
            while (!bl) {
                try {
                    char c;
                    while (inputStream.available() > 0) {
                        c = (char)inputStream.read();
                        if (c == '\n') {
                            stringBuffer.append(c);
                            vector2.addElement(stringBuffer.toString());
                            stringBuffer.setLength(0);
                            continue;
                        }
                        stringBuffer.append(c);
                    }
                    while (inputStream2.available() > 0) {
                        c = (char)inputStream2.read();
                        stringBuffer2.append(c);
                    }
                    if (stringBuffer2.length() > 0) {
                        vector3.addElement(stringBuffer2.toString());
                        stringBuffer2.setLength(0);
                    }
                    c = process.exitValue();
                    bl = true;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    Thread.currentThread();
                    Thread.sleep(50L);
                }
            }
        }
        catch (Exception exception) {
            if (process != null) {
                process.destroy();
            }
            vector = null;
            CommonTools.CMN_HandleOutput("Exception in CMN_exec with :" + stringArray);
        }
        objectArray = new String[vector2.size()];
        if (vector2.size() != 0) {
            vector2.copyInto(objectArray);
            vector.addElement(objectArray);
        } else {
            vector.addElement(objectArray);
        }
        objectArray = new String[vector3.size()];
        if (vector3.size() != 0) {
            vector3.copyInto(objectArray);
            vector.addElement(objectArray);
        } else {
            vector.addElement(objectArray);
        }
        return vector;
    }

    public static String CMN_GetTempDir() {
        Properties properties = System.getProperties();
        String string = properties.getProperty("java.io.tmpdir");
        if (string == null) {
            String string2 = properties.getProperty("os.name");
            string = string2.regionMatches(true, 0, "Win", 0, 3) ? "C:\\TEMP" : "/tmp";
        }
        return string;
    }

    public static void CMN_HandleOutput(String string) {
        if (trace_level > 2) {
            CommonTools.writeTrace(string);
        }
    }

    public static void CMN_Trace1(String string) {
        if (trace_level > 0) {
            CommonTools.writeTrace(string);
        }
    }

    public static void CMN_Trace2(String string) {
        if (trace_level > 1) {
            CommonTools.writeTrace(string);
        }
    }

    public static void CMN_Trace3(String string) {
        if (trace_level > 2) {
            CommonTools.writeTrace(string);
        }
    }

    public static void CMN_TraceOpen(int n, String string) {
        String string2 = null;
        String string3 = null;
        if (trace_init) {
            return;
        }
        trace_level = n;
        if (string != null && string.trim().length() != 0) {
            if (string.equals(TRACE_STDOUT_NAME)) {
                trace_out = 1;
            } else if (string.equals(TRACE_STDERR_NAME)) {
                trace_out = 2;
            } else {
                trace_out = 3;
                string2 = string.trim();
            }
        } else {
            trace_level = 0;
        }
        if (trace_out == 3 && trace_level > 0) {
            string2 = String.valueOf(CommonTools.CMN_GetTempDir()) + File.separator + string2;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMdd_HHmm");
            string3 = simpleDateFormat.format(new Date());
            String string4 = string2 = String.valueOf(string2) + string3;
            int n2 = 1;
            while (n2 < 5) {
                try {
                    File file = new File(string4);
                    if (!file.exists()) break;
                    string4 = String.valueOf(string2) + "_" + n2;
                }
                catch (Exception exception) {}
                ++n2;
            }
            if (n2 < 5) {
                try {
                    trace_fw = new FileWriter(string4);
                    trace_bw = new BufferedWriter(trace_fw);
                    trace_pw = new PrintWriter((Writer)trace_bw, true);
                }
                catch (Exception exception) {
                    trace_level = 0;
                }
            } else {
                trace_level = 0;
            }
        }
        trace_init = true;
    }

    public static void CMN_TraceStack(int n, Exception exception) {
        block7: {
            if (trace_level < n) break block7;
            try {
                if (trace_out == 3) {
                    trace_pw.println(exception.getMessage());
                    exception.printStackTrace(trace_pw);
                } else if (trace_out == 1) {
                    System.out.println(exception.getMessage());
                    exception.printStackTrace(trace_pw);
                } else if (trace_out == 2) {
                    System.out.println(exception.getMessage());
                    exception.printStackTrace(trace_pw);
                }
            }
            catch (Exception exception2) {}
        }
    }

    public static Object[] CMN_VectorToArray(Vector vector) {
        int n = vector.size();
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = vector.elementAt(n2);
            ++n2;
        }
        return objectArray;
    }

    public static void CMN_WriteArray(File file, String[] stringArray) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        int n = 0;
        while (n < stringArray.length) {
            byte[] byArray = stringArray[n].getBytes();
            fileOutputStream.write(byArray);
            ++n;
        }
        fileOutputStream.close();
    }

    public static String[] CMN_exec(String string) {
        String[] stringArray = null;
        Vector vector = new Vector();
        try {
            vector = CommonTools.CMN_ExecWithStdErr(string, null, null);
            String[] stringArray2 = (String[])vector.elementAt(0);
            stringArray = new String[stringArray2.length];
            int n = 0;
            while (n < stringArray2.length) {
                stringArray[n] = stringArray2[n];
                ++n;
            }
        }
        catch (Exception exception) {
            CommonTools.CMN_HandleOutput("Exception in CMN_exec with :" + string);
        }
        return stringArray;
    }

    public static Vector CMN_exec(String string, boolean bl) {
        Object var3_2 = null;
        Vector vector = new Vector();
        try {
            vector = CommonTools.CMN_ExecWithStdErr(string, null, null);
        }
        catch (Exception exception) {
            CommonTools.CMN_HandleOutput("Exception in CMN_exec with :" + string);
        }
        if (!bl) {
            vector.removeElementAt(1);
        }
        return vector;
    }

    public static String[] CMN_exec(String string, String[] stringArray) {
        String[] stringArray2 = null;
        Vector vector = new Vector();
        try {
            vector = CommonTools.CMN_ExecWithStdErr(string, null, stringArray);
            String[] stringArray3 = (String[])vector.elementAt(0);
            stringArray2 = new String[stringArray3.length];
            int n = 0;
            while (n < stringArray3.length) {
                stringArray2[n] = stringArray3[n];
                ++n;
            }
        }
        catch (Exception exception) {
            CommonTools.CMN_HandleOutput("Exception in CMN_exec with :" + string);
        }
        return stringArray2;
    }

    public static String[] CMN_exec(String[] stringArray) {
        String[] stringArray2 = null;
        Vector vector = new Vector();
        try {
            vector = CommonTools.CMN_ExecWithStdErr(null, stringArray, null);
            String[] stringArray3 = (String[])vector.elementAt(0);
            stringArray2 = new String[stringArray3.length];
            int n = 0;
            while (n < stringArray3.length) {
                stringArray2[n] = stringArray3[n];
                ++n;
            }
        }
        catch (Exception exception) {
            CommonTools.CMN_HandleOutput("Exception in CMN_exec with :" + stringArray);
        }
        return stringArray2;
    }

    public static Vector CMN_exec(String[] stringArray, boolean bl) {
        Object var3_2 = null;
        Vector vector = new Vector();
        try {
            vector = CommonTools.CMN_ExecWithStdErr(null, stringArray, null);
        }
        catch (Exception exception) {
            CommonTools.CMN_HandleOutput("Exception in CMN_exec with :" + stringArray);
        }
        if (!bl) {
            vector.removeElementAt(1);
        }
        return vector;
    }

    public static Vector CMN_exec(String[] stringArray, boolean bl, String[] stringArray2) {
        Object var4_3 = null;
        Vector vector = new Vector();
        try {
            vector = CommonTools.CMN_ExecWithStdErr(null, stringArray, stringArray2);
        }
        catch (Exception exception) {
            CommonTools.CMN_HandleOutput("Exception in CMN_exec with :" + stringArray);
        }
        if (!bl) {
            vector.removeElementAt(1);
        }
        return vector;
    }

    public static Object CMN_getPreference(String string, Object object, Object object2) {
        if (!preferences.containsKey(string)) {
            return object2;
        }
        Hashtable hashtable = (Hashtable)preferences.get(string);
        if (!hashtable.containsKey(object)) {
            return object2;
        }
        return hashtable.get(object);
    }

    public static synchronized String CMN_parseLinesForData(String[] stringArray, String string) {
        String string2 = "";
        String string3 = "";
        int n = 0;
        n = 0;
        while (n < stringArray.length) {
            string2 = stringArray[n];
            if (string2 != null && string2.indexOf(string) != -1) {
                int n2 = string2.indexOf(string) + string.length();
                string3 = string2.substring(n2);
                string3 = string3.trim();
                break;
            }
            ++n;
        }
        return string3;
    }

    public static void CMN_setPreference(String string, Object object, Object object2) {
        if (!preferences.containsKey(string)) {
            preferences.put(string, new Hashtable());
        }
        Hashtable hashtable = (Hashtable)preferences.get(string);
        hashtable.put(object, object2);
    }

    private static String getCaller(String string) {
        String string2 = string;
        int n = string.indexOf(40);
        if (n > 0) {
            string2 = string.substring(0, n);
        }
        if ((n = string2.indexOf("at")) > 0) {
            string2 = string2.substring(n + 3);
        }
        if ((n = string2.lastIndexOf(46)) > 0) {
            String string3 = string2.substring(n + 1);
            String string4 = (n = (string2 = string2.substring(0, n)).lastIndexOf(46)) > 0 ? string2.substring(n + 1) : string2;
            string2 = String.valueOf(string4) + ":" + string3;
        }
        return string2;
    }

    private static InputStream getStackStream() {
        ByteArrayInputStream byteArrayInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
            new Exception().printStackTrace(printWriter);
            printWriter.close();
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            byteArrayInputStream = null;
        }
        return byteArrayInputStream;
    }

    private static synchronized void writeTrace(String string) {
        try {
            if (trace_out == 3) {
                trace_pw.println(string);
            } else if (trace_out == 1) {
                System.out.println(string);
            } else if (trace_out == 2) {
                System.err.println(string);
            }
        }
        catch (Exception exception) {}
    }
}

