/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.diskmgr.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.JIntSpinBox;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.SelectableLabel;
import com.sun.admin.diskmgr.client.DiskGraphic;
import com.sun.admin.diskmgr.client.DiskMgrContextHelpListener;
import com.sun.admin.diskmgr.client.SliceFsStep;
import com.sun.admin.diskmgr.client.SliceWizard;
import com.sun.admin.diskmgr.client.VDiskMgr;
import com.sun.admin.diskmgr.common.DiskData;
import com.sun.admin.diskmgr.common.SliceData;
import com.sun.management.viper.console.gui.VOptionPane;
import com.sun.management.viper.console.gui.wizard.VWizardCard;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SliceCustomStep
extends VWizardCard {
    public static final String NAME = "SliceCustomStep";
    public static final int HELP_CACHE_SIZE = 7;
    GenInfoPanel infoPanel;
    Vector helpCache;
    DiskMgrContextHelpListener helpListener;
    DiskData diskData;
    SliceData sliceData;
    SliceData previousSliceData;
    ResourceBundle bundle;
    SliceWizard wizard;
    VDiskMgr theApp;
    SliceCustomStep nextCustomStep = null;
    SliceFsStep fsStep = null;
    String name;
    ActionString actionString;
    JLabel partLabel = new JLabel();
    SelectableLabel partField;
    JLabel sizeLabel = new JLabel();
    JIntSpinBox sizeSpin;
    JComboBox sizeCombo = null;
    Object[] aSizeValues;
    JLabel useLabel = new JLabel();
    JComboBox useCombo;
    JButton previewButton = new JButton();
    JButton resetButton = new JButton();
    DiskGraphic diskGraphic;
    int numSlices;
    int numToCreate;
    boolean backup;
    Vector slices;
    int sliceNum;

    public SliceCustomStep(VDiskMgr vDiskMgr, SliceWizard sliceWizard, int n) {
        this.theApp = vDiskMgr;
        this.wizard = sliceWizard;
        this.diskData = sliceWizard.getDiskData();
        this.sliceNum = n;
        this.backup = sliceWizard.hasBackup();
        this.numSlices = sliceWizard.getNumSlices();
        this.slices = sliceWizard.getSlices();
        if (this.sliceNum == 0) {
            sliceWizard.resetSliceData();
            this.slices = sliceWizard.getSlices();
            this.sliceData = (SliceData)this.slices.elementAt(this.sliceNum);
        } else if (this.sliceNum == 2 && this.backup) {
            this.sliceNum = 3;
        }
        this.numToCreate = this.numSlices - 1;
        if (this.backup) {
            ++this.numToCreate;
        }
        this.slices = sliceWizard.getSlices();
        this.sliceData = (SliceData)this.slices.elementAt(this.sliceNum);
        this.previousSliceData = this.getPreviousSliceData();
        this.name = NAME.concat(Integer.toString(this.sliceNum));
        this.bundle = vDiskMgr.getResourceBundle();
        String string = "disk_wiz_custom_next_size";
        if (this.sliceNum == 0) {
            string = "disk_wiz_custom_size";
        }
        this.infoPanel = new GenInfoPanel((VOptionPane)sliceWizard);
        this.helpCache = new Vector(7);
        this.helpListener = new DiskMgrContextHelpListener(vDiskMgr, this.helpCache, this.infoPanel, string);
        this.infoPanel.setFocusListener((FocusListener)((Object)this.helpListener), true);
        this.setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"SliceWizCustomStep"));
        this.constructStep();
    }

    protected JComboBox buildCombo() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("unassigned");
        jComboBox.addItem("boot");
        jComboBox.addItem("root");
        jComboBox.addItem("swap");
        jComboBox.addItem("usr");
        if (!this.diskData.hasBackup()) {
            jComboBox.addItem("backup");
        }
        jComboBox.addItem("stand");
        jComboBox.addItem("var");
        jComboBox.addItem("home");
        jComboBox.addItem("altsctr");
        jComboBox.addItem("cache");
        return jComboBox;
    }

    private int computeCeiling() {
        int n = (int)this.diskData.computeDiskPercentFree();
        if (this.sizeCombo.getSelectedItem() == this.aSizeValues[1]) {
            n = (int)this.diskData.cylinderToMB(this.diskData.computeDiskFree());
        }
        return n += this.sizeSpin.getIntValue();
    }

    private int computeEndCylinder() {
        if (this.useCombo.getSelectedItem().equals("backup")) {
            return this.diskData.getSolarisCylinders() - 1;
        }
        int n = this.sizeSpin.getIntValue();
        if (n == 0) {
            return 0;
        }
        int n2 = this.computeStartCylinder();
        int n3 = 0;
        if (this.sizeCombo.getSelectedItem() == this.aSizeValues[0]) {
            double d = (double)n / 100.0;
            int n4 = (int)(d * (double)this.diskData.getSolarisCylinders());
            n3 = n2 + n4;
            if (n3 > this.diskData.getSolarisCylinders() - 1) {
                return this.diskData.getSolarisCylinders() - 1;
            }
            return n3;
        }
        n3 = n2 + this.diskData.spaceToCylinders(n);
        if (n3 > this.diskData.getSolarisCylinders() - 1) {
            return this.diskData.getSolarisCylinders() - 1;
        }
        return n3;
    }

    private int computeFloor() {
        return 1;
    }

    private int computeStartCylinder() {
        if (this.previousSliceData == null || this.sizeSpin.getIntValue() == 0 || this.previousSliceData.getTag() == 5 || this.useCombo.getSelectedItem().equals("backup")) {
            return 0;
        }
        return this.previousSliceData.getEndCylinder() + 1;
    }

    private void constructStep() {
        ((Container)((Object)this)).removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.initLabel(this.partLabel, "SliceWizCustomPart");
        Constraints.constrain((Container)jPanel, (Component)this.partLabel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)12, (int)6, (int)6, (int)3);
        this.partField = new SelectableLabel(Integer.toString(this.sliceNum), 3);
        this.partLabel.setLabelFor((Component)this.partField);
        this.helpListener = new DiskMgrContextHelpListener(this.theApp, this.helpCache, this.infoPanel, "disk_wiz_custom_part");
        this.theApp.addHelpListener(this.helpListener, (Component)this.partField);
        Constraints.constrain((Container)jPanel, (Component)this.partField, (int)1, (int)0, (int)2, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)12, (int)3, (int)6, (int)3);
        this.initLabel(this.sizeLabel, "SliceWizCustomSize");
        Constraints.constrain((Container)jPanel, (Component)this.sizeLabel, (int)0, (int)1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)3, (int)6, (int)6, (int)3);
        this.sizeSpin = new JIntSpinBox(4, 1, this.diskData.getSolarisCylinders() - 1);
        SpinBoxDocListener spinBoxDocListener = new SpinBoxDocListener();
        this.sizeSpin.getTextField().getDocument().addDocumentListener(spinBoxDocListener);
        this.helpListener = new DiskMgrContextHelpListener(this.theApp, this.helpCache, this.infoPanel, "disk_wiz_custom_number_size");
        this.theApp.addHelpListener(this.helpListener, (Component)this.sizeSpin);
        this.sizeLabel.setLabelFor(this.sizeSpin.getTextField());
        Constraints.constrain((Container)jPanel, (Component)this.sizeSpin, (int)1, (int)1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)3, (int)3, (int)6, (int)3);
        this.aSizeValues = new Object[2];
        this.aSizeValues[0] = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"Percent");
        this.aSizeValues[1] = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"MB");
        this.sizeCombo = new JComboBox<Object>(this.aSizeValues);
        this.sizeCombo.addItemListener(new SizeComboListener());
        this.selectSizeValue();
        this.sizeSpin.setFloor(this.computeFloor());
        this.sizeSpin.setCeiling(this.computeCeiling());
        this.helpListener = new DiskMgrContextHelpListener(this.theApp, this.helpCache, this.infoPanel, "disk_wiz_custom_units");
        this.theApp.addHelpListener(this.helpListener, this.sizeCombo);
        Constraints.constrain((Container)jPanel, (Component)this.sizeCombo, (int)2, (int)1, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)3, (int)3, (int)6, (int)3);
        this.initLabel(this.useLabel, "SliceWizCustomUse");
        Constraints.constrain((Container)jPanel, (Component)this.useLabel, (int)0, (int)2, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)3, (int)6, (int)6, (int)3);
        this.useCombo = this.buildCombo();
        this.useCombo.addItemListener(new UseComboListener());
        this.helpListener = new DiskMgrContextHelpListener(this.theApp, this.helpCache, this.infoPanel, "disk_wiz_custom_use");
        this.theApp.addHelpListener(this.helpListener, this.useCombo);
        this.useLabel.setLabelFor(this.useCombo);
        Constraints.constrain((Container)jPanel, (Component)this.useCombo, (int)1, (int)2, (int)2, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)3, (int)3, (int)6, (int)3);
        Constraints.constrain((Container)((Object)this), (Component)jPanel, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        this.initButton(this.previewButton, "GraphicPreview");
        this.helpListener = new DiskMgrContextHelpListener(this.theApp, this.helpCache, this.infoPanel, "disk_wiz_custom_preview");
        this.theApp.addHelpListener(this.helpListener, this.previewButton);
        ButtonListener buttonListener = new ButtonListener();
        this.previewButton.addActionListener(buttonListener);
        Constraints.constrain((Container)jPanel2, (Component)this.previewButton, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)6, (int)3, (int)6, (int)3);
        this.initButton(this.resetButton, "GraphicReset");
        this.helpListener = new DiskMgrContextHelpListener(this.theApp, this.helpCache, this.infoPanel, "disk_wiz_custom_revert");
        this.theApp.addHelpListener(this.helpListener, this.resetButton);
        this.resetButton.addActionListener(buttonListener);
        Constraints.constrain((Container)jPanel2, (Component)this.resetButton, (int)1, (int)0, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)6, (int)3, (int)6, (int)3);
        Constraints.constrain((Container)((Object)this), (Component)jPanel2, (int)0, (int)1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        this.diskGraphic = new DiskGraphic(this.theApp, this.diskData, this.sliceData, false);
        Constraints.constrain((Container)((Object)this), (Component)this.diskGraphic, (int)0, (int)2, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        JPanel jPanel3 = new JPanel();
        Constraints.constrain((Container)((Object)this), (Component)jPanel3, (int)0, (int)3, (int)1, (int)1, (int)1, (int)17, (double)1.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
    }

    private void doPreview() {
        this.diskData.sortSlicesByStartCyl();
        this.diskGraphic.preview(this.computeStartCylinder(), this.computeEndCylinder());
        this.previewButton.setEnabled(false);
        this.resetButton.setEnabled(true);
        this.diskData.sortSlicesByPartition();
    }

    private void doReset() {
        this.diskGraphic.reset();
        this.sizeSpin.setIntValue(0);
        this.previewButton.setEnabled(false);
        this.resetButton.setEnabled(false);
    }

    public String getName() {
        return this.name;
    }

    private SliceData getPreviousSliceData() {
        if (this.sliceNum == 0) {
            return null;
        }
        int n = this.sliceNum - 1;
        while (n >= 0) {
            SliceData sliceData = (SliceData)this.slices.elementAt(n);
            if (sliceData.getTag() != 5 && sliceData.computeSize() > 0.0f) {
                return sliceData;
            }
            --n;
        }
        return (SliceData)this.slices.elementAt(this.sliceNum - 1);
    }

    private void initButton(JButton jButton, String string) {
        this.actionString = new ActionString(this.bundle, string);
        jButton.setText(this.actionString.getString());
        jButton.setMnemonic(this.actionString.getMnemonic());
        jButton.setEnabled(false);
    }

    private void initLabel(JLabel jLabel, String string) {
        this.actionString = new ActionString(this.bundle, string);
        jLabel.setText(this.actionString.getString());
        jLabel.setDisplayedMnemonic(this.actionString.getMnemonic());
    }

    public boolean isSubStep() {
        return true;
    }

    public void reset() {
    }

    private void selectSizeValue() {
        if (this.wizard.isSizePercent()) {
            this.sizeCombo.setSelectedIndex(0);
        } else {
            this.sizeCombo.setSelectedIndex(1);
        }
    }

    private void setNextStep() {
        boolean bl;
        if (this.backup && this.numToCreate <= 2) {
            bl = this.sliceNum < this.numToCreate - 1;
        } else {
            boolean bl2 = bl = this.sliceNum < this.numToCreate;
        }
        if (bl) {
            if (this.nextCustomStep == null) {
                this.nextCustomStep = new SliceCustomStep(this.theApp, this.wizard, this.sliceNum + 1);
                this.wizard.addCard(this.nextCustomStep.getName(), this.nextCustomStep);
                this.getManager().setNext(this.getManager().getCurrent(), this.nextCustomStep.getName());
            }
        } else {
            if (this.fsStep == null) {
                this.fsStep = new SliceFsStep(this.theApp, this.wizard);
                this.wizard.addCard("SliceFsStep", this.fsStep);
            }
            this.getManager().setNext(this.getManager().getCurrent(), "SliceFsStep");
        }
    }

    private void setPreviousStep() {
        String string = this.sliceNum == 0 ? "SliceNumCustomStep" : (this.sliceNum == 3 && this.backup ? NAME.concat(Integer.toString(1)) : NAME.concat(Integer.toString(this.sliceNum - 1)));
        this.getManager().setPrevious(this.getManager().getCurrent(), string);
    }

    public void start() {
        super.start();
        this.slices = this.wizard.getSlices();
        this.previousSliceData = this.getPreviousSliceData();
        if (this.numSlices != this.wizard.getNumSlices() || this.backup != this.wizard.hasBackup()) {
            if (this.sliceNum == 0) {
                this.wizard.resetSliceData();
            }
            this.slices = this.wizard.getSlices();
            this.sliceData = (SliceData)this.slices.elementAt(this.sliceNum);
            this.numSlices = this.wizard.getNumSlices();
            this.backup = this.wizard.hasBackup();
            this.numToCreate = this.numSlices - 1;
            if (this.backup) {
                ++this.numToCreate;
            }
            this.constructStep();
        }
        this.diskGraphic.layoutGraphic(this.wizard.getDiskData());
        ((Container)((Object)this)).validate();
        ((Component)((Object)this)).repaint();
        this.sizeSpin.setFloor(this.computeFloor());
        this.sizeSpin.setCeiling(this.computeCeiling());
        this.setProperty("vwp.canmovebackward", "vwp.true");
        this.setProperty("vwp.canmoveforward", "vwp.true");
    }

    public boolean stop(boolean bl) {
        if (bl) {
            this.sliceData.setStartCylinder(this.computeStartCylinder());
            this.sliceData.setEndCylinder(this.computeEndCylinder());
            short s = (short)this.useCombo.getSelectedIndex();
            if (this.diskData.hasBackup() && s >= 5) {
                s = (short)(s + 1);
            }
            this.sliceData.setTag(s);
            this.setNextStep();
        } else {
            this.sliceData.setStartCylinder(0);
            this.sliceData.setEndCylinder(0);
            this.sliceData.setTag((short)0);
            this.sizeSpin.getTextField().setText("");
            this.useCombo.setSelectedIndex(0);
        }
        this.setPreviousStep();
        return true;
    }

    private void updateButtons() {
        this.previewButton.setEnabled(this.sizeSpin.getIntValue() > 0);
        this.resetButton.setEnabled(this.sizeSpin.getIntValue() == 0);
    }

    private class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == SliceCustomStep.this.previewButton) {
                SliceCustomStep.this.doPreview();
            } else {
                SliceCustomStep.this.doReset();
            }
        }
    }

    private class SizeComboListener
    implements ItemListener {
        SizeComboListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            SliceCustomStep.this.wizard.setSizeAsPercent(SliceCustomStep.this.sizeCombo.getSelectedIndex() == 0);
            SliceCustomStep.this.sizeSpin.setFloor(SliceCustomStep.this.computeFloor());
            SliceCustomStep.this.sizeSpin.setCeiling(SliceCustomStep.this.computeCeiling());
        }
    }

    private class UseComboListener
    implements ItemListener {
        UseComboListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            boolean bl = SliceCustomStep.this.useCombo.getSelectedItem().equals("backup");
            SliceCustomStep.this.sizeSpin.setEnabled(bl ^ true);
            SliceCustomStep.this.sizeCombo.setEnabled(bl ^ true);
        }
    }

    private class SpinBoxDocListener
    implements DocumentListener {
        SpinBoxDocListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            SliceCustomStep.this.updateButtons();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            SliceCustomStep.this.updateButtons();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            SliceCustomStep.this.updateButtons();
        }
    }
}

