/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.diskmgr.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.JIntSpinBox;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.SelectableLabel;
import com.sun.admin.diskmgr.client.DiskMgrContextHelpListener;
import com.sun.admin.diskmgr.client.FdiskReviewStep;
import com.sun.admin.diskmgr.client.FdiskWizard;
import com.sun.admin.diskmgr.client.VDiskMgr;
import com.sun.admin.diskmgr.common.DiskData;
import com.sun.admin.diskmgr.common.FdiskData;
import com.sun.management.viper.console.gui.VOptionPane;
import com.sun.management.viper.console.gui.wizard.VWizardCard;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FdiskCustomStep
extends VWizardCard {
    public static final String NAME = "FdiskCustomStep";
    public static final int HELP_CACHE_SIZE = 5;
    GenInfoPanel infoPanel;
    Vector helpCache;
    DiskMgrContextHelpListener helpListener;
    DiskData diskData;
    FdiskData fdiskData;
    FdiskData previousFdiskData;
    ResourceBundle bundle;
    FdiskWizard wizard;
    VDiskMgr theApp;
    FdiskCustomStep nextCustomStep = null;
    FdiskReviewStep reviewStep = null;
    String name;
    ActionString actionString;
    JLabel partLabel = new JLabel();
    SelectableLabel partField;
    JLabel sizeLabel = new JLabel();
    JIntSpinBox sizeSpin;
    JComboBox sizeCombo = null;
    Object[] aSizeValues;
    JLabel useLabel = new JLabel();
    JComboBox useCombo;
    int numPartitions;
    Vector partitions;
    int partitionNum;

    public FdiskCustomStep(VDiskMgr vDiskMgr, FdiskWizard fdiskWizard, int n) {
        this.theApp = vDiskMgr;
        this.bundle = vDiskMgr.getResourceBundle();
        this.wizard = fdiskWizard;
        this.diskData = fdiskWizard.getDiskData();
        this.partitionNum = n;
        this.numPartitions = fdiskWizard.getNumPartitions();
        if (this.partitionNum == 0) {
            this.resetFdiskData();
        }
        this.partitions = this.diskData.getVPartitions();
        this.fdiskData = (FdiskData)this.partitions.elementAt(this.partitionNum);
        this.previousFdiskData = this.getPreviousFdiskData();
        this.name = NAME.concat(Integer.toString(this.partitionNum));
        this.infoPanel = new GenInfoPanel((VOptionPane)fdiskWizard);
        this.helpCache = new Vector(5);
        this.helpListener = new DiskMgrContextHelpListener(vDiskMgr, this.helpCache, this.infoPanel, "fdisk_wiz_first");
        this.infoPanel.setFocusListener((FocusListener)((Object)this.helpListener), true);
        this.setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"FdiskWizCustomStep"));
        this.constructStep();
    }

    protected JComboBox buildCombo() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("Solaris");
        jComboBox.addItem("Unix");
        jComboBox.addItem("Linux");
        jComboBox.addItem("BSD");
        jComboBox.addItem("PC/IX");
        jComboBox.addItem("Other");
        jComboBox.addItem("EXT-DOS");
        jComboBox.addItem("Huge DOS");
        return jComboBox;
    }

    private int computeCeiling() {
        int n = (int)this.diskData.computeFdiskPercentFree();
        if (this.sizeCombo.getSelectedItem() == this.aSizeValues[1]) {
            n = (int)this.diskData.cylinderToMB(this.diskData.computeFdiskFree());
        }
        return n += this.sizeSpin.getIntValue();
    }

    private int computeEndCylinder() {
        int n = this.sizeSpin.getIntValue();
        if (n == 0) {
            return 0;
        }
        int n2 = this.computeStartCylinder();
        int n3 = 0;
        if (this.sizeCombo.getSelectedItem() == this.aSizeValues[0]) {
            double d = (double)n / 100.0;
            int n4 = (int)(d * (double)this.diskData.getTotalCylinders());
            n3 = n2 + n4;
            if (n3 > this.diskData.getTotalCylinders() - 1) {
                return this.diskData.getTotalCylinders() - 1;
            }
            return n3;
        }
        n3 = n2 + this.diskData.spaceToCylinders(n);
        if (n3 > this.diskData.getTotalCylinders() - 1) {
            return this.diskData.getTotalCylinders() - 1;
        }
        return n3;
    }

    private int computeFloor() {
        return 1;
    }

    private int computeStartCylinder() {
        int n = this.sizeSpin.getIntValue();
        if (n == 0) {
            return 0;
        }
        if (this.previousFdiskData == null) {
            return 1;
        }
        return this.previousFdiskData.getEndCylinder() + 1;
    }

    private void constructStep() {
        ((Container)((Object)this)).removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.initLabel(this.partLabel, "FdiskWizCustomPart");
        Constraints.constrain((Container)jPanel, (Component)this.partLabel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)12, (int)6, (int)6, (int)3);
        this.partField = new SelectableLabel(Integer.toString(this.partitionNum), 3);
        this.partLabel.setLabelFor((Component)this.partField);
        this.helpListener = new DiskMgrContextHelpListener(this.theApp, this.helpCache, this.infoPanel, "fdisk_wiz_first_part");
        this.theApp.addHelpListener(this.helpListener, (Component)this.partField);
        Constraints.constrain((Container)jPanel, (Component)this.partField, (int)1, (int)0, (int)2, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)12, (int)3, (int)6, (int)3);
        this.initLabel(this.sizeLabel, "FdiskWizCustomSize");
        Constraints.constrain((Container)jPanel, (Component)this.sizeLabel, (int)0, (int)1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)3, (int)6, (int)6, (int)3);
        this.sizeSpin = new JIntSpinBox(4, 1, 100);
        this.helpListener = new DiskMgrContextHelpListener(this.theApp, this.helpCache, this.infoPanel, "fdisk_wiz_first_number");
        this.theApp.addHelpListener(this.helpListener, (Component)this.sizeSpin);
        this.sizeLabel.setLabelFor(this.sizeSpin.getTextField());
        Constraints.constrain((Container)jPanel, (Component)this.sizeSpin, (int)1, (int)1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)3, (int)3, (int)6, (int)3);
        this.aSizeValues = new Object[2];
        this.aSizeValues[0] = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"Percent");
        this.aSizeValues[1] = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"MB");
        this.sizeCombo = new JComboBox<Object>(this.aSizeValues);
        this.sizeCombo.addItemListener(new ComboListener());
        this.selectSizeValue();
        this.sizeSpin.setFloor(this.computeFloor());
        this.sizeSpin.setCeiling(this.computeCeiling());
        this.helpListener = new DiskMgrContextHelpListener(this.theApp, this.helpCache, this.infoPanel, "fdisk_wiz_first_units");
        this.theApp.addHelpListener(this.helpListener, this.sizeCombo);
        Constraints.constrain((Container)jPanel, (Component)this.sizeCombo, (int)2, (int)1, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)3, (int)3, (int)6, (int)3);
        this.initLabel(this.useLabel, "FdiskWizCustomUse");
        Constraints.constrain((Container)jPanel, (Component)this.useLabel, (int)0, (int)2, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)3, (int)6, (int)6, (int)3);
        this.useCombo = this.buildCombo();
        this.helpListener = new DiskMgrContextHelpListener(this.theApp, this.helpCache, this.infoPanel, "fdisk_wiz_first_use");
        this.theApp.addHelpListener(this.helpListener, this.useCombo);
        this.useLabel.setLabelFor(this.useCombo);
        Constraints.constrain((Container)jPanel, (Component)this.useCombo, (int)1, (int)2, (int)2, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)3, (int)3, (int)6, (int)3);
        Constraints.constrain((Container)((Object)this), (Component)jPanel, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        JPanel jPanel2 = new JPanel();
        Constraints.constrain((Container)((Object)this), (Component)jPanel2, (int)0, (int)1, (int)1, (int)1, (int)1, (int)17, (double)1.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
    }

    public String getName() {
        return this.name;
    }

    private FdiskData getPreviousFdiskData() {
        if (this.partitionNum == 0) {
            return null;
        }
        int n = this.partitionNum - 1;
        while (n >= 0) {
            FdiskData fdiskData = (FdiskData)this.partitions.elementAt(n);
            if (fdiskData.computeSize() > 0.0f) {
                return fdiskData;
            }
            --n;
        }
        return (FdiskData)this.partitions.elementAt(this.partitionNum - 1);
    }

    private void initLabel(JLabel jLabel, String string) {
        this.actionString = new ActionString(this.bundle, string);
        jLabel.setText(this.actionString.getString());
        jLabel.setDisplayedMnemonic(this.actionString.getMnemonic());
    }

    public boolean isSubStep() {
        return true;
    }

    public void reset() {
    }

    private void resetFdiskData() {
        Vector<FdiskData> vector = new Vector<FdiskData>();
        int n = 0;
        while (n < this.numPartitions) {
            FdiskData fdiskData = new FdiskData(this.diskData, (short)n);
            vector.addElement(fdiskData);
            ++n;
        }
        this.diskData.setVPartitions(vector);
    }

    private void selectSizeValue() {
        if (this.wizard.isSizePercent()) {
            this.sizeCombo.setSelectedIndex(0);
        } else {
            this.sizeCombo.setSelectedIndex(1);
        }
    }

    private void setNextStep() {
        if (this.partitionNum < this.numPartitions - 1) {
            if (this.nextCustomStep == null) {
                this.nextCustomStep = new FdiskCustomStep(this.theApp, this.wizard, this.partitionNum + 1);
                this.wizard.addCard(this.nextCustomStep.getName(), this.nextCustomStep);
                this.getManager().setNext(this.getManager().getCurrent(), this.nextCustomStep.getName());
            }
        } else {
            if (this.reviewStep == null) {
                this.reviewStep = new FdiskReviewStep(this.theApp, this.wizard);
                this.wizard.addCard("FdiskReviewStep", this.reviewStep);
            }
            this.getManager().setNext(this.getManager().getCurrent(), "FdiskReviewStep");
        }
    }

    private void setPreviousStep() {
        String string = NAME.concat(Integer.toString(this.partitionNum - 1));
        if (this.partitionNum == 0) {
            string = "FdiskGenStep";
        }
        this.getManager().setPrevious(this.getManager().getCurrent(), string);
    }

    public void start() {
        super.start();
        this.previousFdiskData = this.getPreviousFdiskData();
        if (this.numPartitions != this.wizard.getNumPartitions()) {
            this.numPartitions = this.wizard.getNumPartitions();
            if (this.partitionNum == 0) {
                this.resetFdiskData();
            }
            this.partitions = this.diskData.getVPartitions();
            this.fdiskData = (FdiskData)this.partitions.elementAt(this.partitionNum);
            this.constructStep();
        }
        this.sizeSpin.setFloor(this.computeFloor());
        this.sizeSpin.setCeiling(this.computeCeiling());
        this.setProperty("vwp.canmovebackward", "vwp.true");
        this.setProperty("vwp.canmoveforward", "vwp.true");
    }

    public boolean stop(boolean bl) {
        if (bl) {
            this.fdiskData.setStartCylinder(this.computeStartCylinder());
            this.fdiskData.setEndCylinder(this.computeEndCylinder());
            this.fdiskData.setUsedFor((String)this.useCombo.getSelectedItem());
            this.setNextStep();
        } else {
            this.fdiskData.setStartCylinder(0);
            this.fdiskData.setEndCylinder(0);
            this.sizeSpin.getTextField().setText("");
            this.useCombo.setSelectedIndex(0);
        }
        this.setPreviousStep();
        return true;
    }

    private class ComboListener
    implements ItemListener {
        ComboListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            FdiskCustomStep.this.wizard.setSizeAsPercent(FdiskCustomStep.this.sizeCombo.getSelectedIndex() == 0);
            FdiskCustomStep.this.sizeSpin.setFloor(FdiskCustomStep.this.computeFloor());
            FdiskCustomStep.this.sizeSpin.setCeiling(FdiskCustomStep.this.computeCeiling());
        }
    }
}

