/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.prodreg;

import com.sun.wbem.prodreg.KeyValuePair;
import com.sun.wbem.prodreg.RegistryInstance;
import com.sun.wbem.prodreg.RegistryQuery;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public class RegistryComponent {
    private String id;
    private int instance;
    private String version;
    private String uniqueName;
    private String displayName;
    private String vendor;
    private RegistryInstance parent;
    private String location;
    private String uninstaller;
    private Vector required;
    private Vector dependent;
    private Vector children;
    private Vector backwardCompatable;
    private Vector appData;
    private String size;
    private int componentType;
    protected static final int PRODUCT = 0;
    protected static final int FEATURE = 1;
    protected static final int ELEMENT = 2;
    private static final int ALL = 3;

    public RegistryComponent(String string) {
        this("", "", string, "", "", "", 0);
    }

    protected RegistryComponent(String string, String string2, String string3, String string4, String string5, String string6, int n) {
        this.id = string;
        this.instance = 0;
        this.version = string2;
        this.uniqueName = string3;
        this.displayName = string4;
        this.location = string5;
        this.vendor = string6;
        this.componentType = n;
        this.parent = null;
        this.uninstaller = "";
        this.required = new Vector();
        this.dependent = new Vector();
        this.backwardCompatable = new Vector();
        this.appData = new Vector();
        this.children = new Vector();
        this.size = "";
    }

    public void addBackwardCompatableVersion(String string) {
        this.backwardCompatable.add(string);
    }

    private void addDependentComponent(RegistryComponent registryComponent) {
        this.dependent.addElement(registryComponent.getRegistryInstance());
    }

    private void addRequiredComponent(RegistryComponent registryComponent) {
        this.required.add(registryComponent.getRegistryInstance());
    }

    public Vector getAppData() {
        return this.appData;
    }

    public Vector getBackwardCompatableVersions() {
        return this.backwardCompatable;
    }

    public String getBackwardCompatableVersionsString() {
        String string = "";
        Iterator iterator = ((AbstractList)this.backwardCompatable).iterator();
        while (iterator.hasNext()) {
            string = String.valueOf(string) + (String)iterator.next() + ", ";
        }
        if (string.length() > 0) {
            string = string.substring(0, string.length() - 3);
        }
        return string;
    }

    public int getComponentType() {
        return this.componentType;
    }

    public String getDataValue(String string) {
        Iterator iterator = ((AbstractList)this.appData).iterator();
        while (iterator.hasNext()) {
            KeyValuePair keyValuePair = (KeyValuePair)iterator.next();
            if (!keyValuePair.getKey().equalsIgnoreCase(string)) continue;
            return keyValuePair.getValue();
        }
        return null;
    }

    private Vector getDependentComponents() {
        return this.dependent;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getID() {
        return this.id;
    }

    public int getInstanceNumber() {
        return this.instance;
    }

    public String getInstanceString() {
        return String.valueOf(this.instance);
    }

    public String getLocation() {
        return this.location;
    }

    protected RegistryInstance getParent() {
        return this.parent;
    }

    protected RegistryInstance getRegistryInstance() {
        RegistryInstance registryInstance = new RegistryInstance(this.id, this.instance, this.version);
        return registryInstance;
    }

    protected RegistryQuery getRegistryQuery() {
        RegistryQuery registryQuery = new RegistryQuery(this.id, this.instance, this.version, this.uniqueName, this.location);
        return registryQuery;
    }

    private Vector getRequiredComponents() {
        return this.required;
    }

    public String getSize() {
        return this.size;
    }

    public String getUninstaller() {
        return this.uninstaller;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean hasChildren() {
        return this.children.isEmpty() ^ true;
    }

    public boolean hasDependentComponents() {
        return this.dependent.isEmpty() ^ true;
    }

    public void setAppData(Vector vector) {
        if (vector != null) {
            this.appData = vector;
        }
    }

    public void setBackwardCompatableVersions(Vector vector) {
        this.backwardCompatable = vector;
    }

    protected void setChildren(Vector vector) {
        this.children = vector;
    }

    protected void setComponentType(int n) {
        this.componentType = n;
    }

    public void setDataValue(String string, String string2) {
        KeyValuePair keyValuePair;
        Iterator iterator = ((AbstractList)this.appData).iterator();
        while (iterator.hasNext()) {
            keyValuePair = (KeyValuePair)iterator.next();
            if (!keyValuePair.getKey().equalsIgnoreCase(string)) continue;
            keyValuePair.setValue(string2);
            return;
        }
        keyValuePair = new KeyValuePair(string, string2);
        this.appData.add(keyValuePair);
    }

    private void setDependentComponents(Vector vector) {
        this.dependent = vector;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public void setID(String string) {
        this.id = string;
    }

    public void setInstanceNumber(int n) {
        this.instance = n;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    protected void setParent(RegistryComponent registryComponent) {
        this.parent = registryComponent.getRegistryInstance();
    }

    protected void setParent(RegistryInstance registryInstance) {
        this.parent = registryInstance;
    }

    private void setRequiredComponents(Vector vector) {
        this.required = vector;
    }

    public String setSize() {
        return "";
    }

    protected void setUninstaller(String string) {
        this.uninstaller = string;
    }

    public void setUniqueName(String string) {
        this.uniqueName = string;
    }

    public void setVendor(String string) {
        this.vendor = string;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public String toString() {
        return this.displayName;
    }
}

