/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.servlet;

import com.sun.management.viperimpl.ViperImplVersion;
import com.sun.management.viperimpl.server.Registry;
import com.sun.management.viperimpl.server.RegistryProgress;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class InfoServlet
extends HttpServlet {
    protected Properties serverInfo;

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getPathInfo();
        if (string == null || string.length() <= 1) {
            this.sendInternalError(httpServletResponse, string);
            return;
        }
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        if ((string = string.substring(1).trim()).equals("startupProgress")) {
            this.sendStartupProgress(servletOutputStream);
        } else if (string.equals("serverInfo")) {
            this.sendServerInfo(servletOutputStream);
        } else {
            this.sendInternalError(httpServletResponse, string);
        }
        servletOutputStream.close();
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        Properties properties = System.getProperties();
        this.serverInfo = new Properties();
        this.serverInfo.setProperty("viper.api.version", "1.0");
        this.serverInfo.setProperty("viper.impl.version", ViperImplVersion.getVersion());
        this.serverInfo.setProperty("viper.impl.fullversion", ViperImplVersion.getFullVersion());
        this.serverInfo.setProperty("os.name", properties.getProperty("os.name"));
        this.serverInfo.setProperty("os.arch", properties.getProperty("os.arch"));
        this.serverInfo.setProperty("os.version", properties.getProperty("os.version"));
        this.serverInfo.setProperty("rolesupport", "true");
    }

    public void log(String string) {
    }

    public void log(String string, Throwable throwable) {
    }

    private void sendInternalError(HttpServletResponse httpServletResponse, String string) throws IOException {
        httpServletResponse.sendError(404, "File not found.");
    }

    protected void sendServerInfo(ServletOutputStream servletOutputStream) throws IOException {
        this.serverInfo.store((OutputStream)servletOutputStream, null);
    }

    protected void sendStartupProgress(ServletOutputStream servletOutputStream) throws IOException {
        RegistryProgress registryProgress = Registry.getProgress();
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)servletOutputStream));
        bufferedWriter.write("completed: " + registryProgress.completed);
        bufferedWriter.newLine();
        bufferedWriter.write("total: " + registryProgress.total);
        bufferedWriter.newLine();
        bufferedWriter.write("task: " + registryProgress.task);
        bufferedWriter.newLine();
        bufferedWriter.flush();
        bufferedWriter.close();
    }
}

