
import java.rmi.*;
import com.sun.wbem.client.CIMClient;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMNameSpace;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.security.UserPrincipal;
import com.sun.wbem.security.PasswordCredential;
import java.util.Enumeration;

/**
 * This example program takes command-line arguments and creates the specified 
 * name space on the specified host. The user must specify the username and 
 * password of the administrative account for the CIM Object Manager repository.
 * 
 */
public class CreateNameSpace {
    public static void main(String args[]) throws CIMException {
    
        // Initialize an instance of the CIM Client class
	CIMClient cc = null;
	
	// Requires 5 command-line arguments.
	// If not all entered, prints command string.
	
	if (args.length != 5) {
	    System.out.println
        ("Usage: CreateNameSpace host parentNS childNS username password"); 
	    System.exit(1);
	}
	
	try {
	
	    /**
	     * Creates a name space object (cns), which stores the host 
	     * name and parent name space.
	     * 
	     */ 
	     
	    CIMNameSpace cns = new CIMNameSpace(args[0], args[1]);
    
	    /**
	     * Creates the user principal and password credential used
	     * to authenticate the user to the CIMOM.
	     */
	    UserPrincipal up = new UserPrincipal(args[3]);
	    PasswordCredential pc = new PasswordCredential(args[4]);

	    /** 
	     * Connects to the CIM Object Manager, and passes it the
	     * name space object (cns) and the user principal and
	     * password credential.
	     */
	     
	    cc = new CIMClient(cns, up, pc);
	    
	    /**
	     * Creates another name space object (cop), which stores the
	     * a null string for the host name and a string for the
	     * child name space (from the command-line arguments).
	     */
	     
	    CIMNameSpace cop = new CIMNameSpace("", args[2]);
	    
	    /**
	     * Creates the child name space under the parent name space.
	     */
	     
	    cc.createNameSpace(cop);
	}
	catch (Exception e) {
	    System.out.println("Exception: "+e);
	}

	// Close the session.
	if (cc != null) {
	    cc.close();
	}
    }
}
