/*
 * Copyright (c) 1999-2000 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef	_SYS_EXACCT_CATALOG_H
#define	_SYS_EXACCT_CATALOG_H

#pragma ident	"@(#)exacct_catalog.h	1.2	00/03/18 SMI"

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * exacct_catalog.h contains the default catalog for SunOS resource values
 * reported via the extended accounting facility.  Each recorded value written
 * to an exacct file is identified via its catalog tag, which is the first four
 * bytes of each object.  The exacct catalog tag is a 32-bit integer partitioned
 * into three fields, as illustrated by the following diagram.
 *
 * 31	   27	   23						  0
 * +-------+-------+----------------------------------------------+
 * |type   |catalog|id						  |
 * +-------+-------+----------------------------------------------+
 *
 * Each of the fields is described in more detail below.
 */

/*
 * Data type field.  These should correspond to the values of an ea_item_type_t,
 * shifted left 28 bits, plus the special value for a record group.  All
 * unspecified values of this field are reserved for future use.
 */
#define	EXT_TYPE_MASK		((uint_t)0xf << 28)

#define	EXT_NONE		((uint_t)0x0 << 28)
#define	EXT_UINT8		((uint_t)0x1 << 28)
#define	EXT_UINT16		((uint_t)0x2 << 28)
#define	EXT_UINT32		((uint_t)0x3 << 28)
#define	EXT_UINT64		((uint_t)0x4 << 28)
#define	EXT_DOUBLE		((uint_t)0x5 << 28)
#define	EXT_STRING		((uint_t)0x6 << 28)
#define	EXT_EXACCT_OBJECT	((uint_t)0x7 << 28)
#define	EXT_RAW			((uint_t)0x8 << 28)
#define	EXT_GROUP		((uint_t)0xf << 28)

/*
 * The catalog type field is the second four bits of the catalog tag.  All
 * unspecified values of this field are reserved for future use.
 */
#define	EXC_CATALOG_MASK	((uint_t)0xf << 24)

#define	EXC_NONE		(0x0 << 24)
#define	EXC_LOCAL		(0x1 << 24)
#define	EXC_DEFAULT		EXC_NONE

/*
 * The data id field comprises the final 24 bits of an ea_catalog_t.  The
 * current Solaris data ids defined in this version of the exacct format follow.
 * All values of this field are reserved if the catalog type is EXC_DEFAULT.  If
 * the catalog type is EXC_LOCAL, this field is application defined.
 */
#define	EXD_DATA_MASK		0xffffff

#define	EXD_NONE		0x000000

#define	EXD_VERSION		0x000001
#define	EXD_FILETYPE		0x000002
#define	EXD_CREATOR		0x000003
#define	EXD_HOSTNAME		0x000004

#define	EXD_GROUP_HEADER	0x0000ff
#define	EXD_GROUP_PROC		0x000100
#define	EXD_GROUP_TASK		0x000101
#define	EXD_GROUP_LWP		0x000102
#define	EXD_GROUP_PROC_TAG	0x000103
#define	EXD_GROUP_TASK_TAG	0x000104
#define	EXD_GROUP_LWP_TAG	0x000105
#define	EXD_GROUP_PROC_PARTIAL	0x000106
#define	EXD_GROUP_TASK_PARTIAL	0x000107
#define	EXD_GROUP_TASK_INTERVAL	0x000108

#define	EXD_PROC_PID		0x001000
#define	EXD_PROC_UID		0x001001
#define	EXD_PROC_GID		0x001002
#define	EXD_PROC_TASKID		0x001003
#define	EXD_PROC_PROJID		0x001004
#define	EXD_PROC_HOSTNAME	0x001005
#define	EXD_PROC_COMMAND	0x001006
#define	EXD_PROC_START_SEC	0x001007
#define	EXD_PROC_START_NSEC	0x001008
#define	EXD_PROC_FINISH_SEC	0x001009
#define	EXD_PROC_FINISH_NSEC	0x00100a
#define	EXD_PROC_CPU_USER_SEC	0x00100b
#define	EXD_PROC_CPU_USER_NSEC	0x00100c
#define	EXD_PROC_CPU_SYS_SEC	0x00100d
#define	EXD_PROC_CPU_SYS_NSEC	0x00100e
#define	EXD_PROC_TTY_MAJOR	0x00100f
#define	EXD_PROC_TTY_MINOR	0x001010
#define	EXD_PROC_FAULTS_MAJOR	0x001011
#define	EXD_PROC_FAULTS_MINOR	0x001012
#define	EXD_PROC_MESSAGES_RCV	0x001013
#define	EXD_PROC_MESSAGES_SND	0x001014
#define	EXD_PROC_BLOCKS_IN	0x001015
#define	EXD_PROC_BLOCKS_OUT	0x001016
#define	EXD_PROC_CHARS_RDWR	0x001017
#define	EXD_PROC_CONTEXT_VOL	0x001018
#define	EXD_PROC_CONTEXT_INV	0x001019
#define	EXD_PROC_SIGNALS	0x00101a
#define	EXD_PROC_SWAPS		0x00101b
#define	EXD_PROC_SYSCALLS	0x00101c
#define	EXD_PROC_ACCT_FLAGS	0x00101d
#define	EXD_PROC_TAG		0x00101e

#define	EXD_TASK_TASKID		0x002000
#define	EXD_TASK_PROJID		0x002001
#define	EXD_TASK_HOSTNAME	0x002002
#define	EXD_TASK_START_SEC	0x002003
#define	EXD_TASK_START_NSEC	0x002004
#define	EXD_TASK_FINISH_SEC	0x002005
#define	EXD_TASK_FINISH_NSEC	0x002006
#define	EXD_TASK_CPU_USER_SEC	0x002007
#define	EXD_TASK_CPU_USER_NSEC	0x002008
#define	EXD_TASK_CPU_SYS_SEC	0x002009
#define	EXD_TASK_CPU_SYS_NSEC	0x00200a
#define	EXD_TASK_FAULTS_MAJOR	0x00200b
#define	EXD_TASK_FAULTS_MINOR	0x00200c
#define	EXD_TASK_MESSAGES_RCV	0x00200d
#define	EXD_TASK_MESSAGES_SND	0x00200e
#define	EXD_TASK_BLOCKS_IN	0x00200f
#define	EXD_TASK_BLOCKS_OUT	0x002010
#define	EXD_TASK_CHARS_RDWR	0x002011
#define	EXD_TASK_CONTEXT_VOL	0x002012
#define	EXD_TASK_CONTEXT_INV	0x002013
#define	EXD_TASK_SIGNALS	0x002014
#define	EXD_TASK_SWAPS		0x002015
#define	EXD_TASK_SYSCALLS	0x002016
#define	EXD_TASK_TAG		0x002017

#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_EXACCT_CATALOG_H */
