/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.Transport;

import com.sun.pdasync.SyncUtils.BufferedBytes;
import com.sun.pdasync.Transport.CTransportPAD;

public final class TransportTester {
    public static void main(String[] args) {
        CTransportPAD transport;
        long err;
        String port = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-port") && i + 1 < args.length) {
                port = new String(args[i + 1]);
            }
            ++i;
        }
        if (port == null) {
            port = new String("/dev/term/a");
        }
        if ((err = (transport = new CTransportPAD(false)).MakePlatformSerialPort(port)) != 0L) {
            System.out.println("Error Making Platform Serial Port: " + err);
        }
        transport.m_padState = (short)16384;
        err = 99L;
        System.out.println("Establishing Connection ...");
        while ((err = transport.PollConnection()) != 0L) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                System.out.println(e);
            }
        }
        err = transport.EstablishConnection();
        if (err == 0L) {
            System.out.println("Connection Established");
        } else {
            System.out.println("Connection NOT! Established");
        }
        TransportTester tester = new TransportTester();
        BufferedBytes pBuff = new BufferedBytes(new byte[10]);
        pBuff.bytes[0] = 47;
        pBuff.bytes[1] = 1;
        pBuff.bytes[2] = 32;
        pBuff.bytes[3] = 2;
        pBuff.bytes[4] = 0;
        pBuff.bytes[5] = 0;
        pBuff.bytes[6] = 0;
        pBuff.bytes[7] = 0;
        pBuff.bytes[8] = 0;
        pBuff.bytes[9] = 0;
        transport.SendTransaction((byte)3, pBuff.bytes, (short)6, transport.UtilNewTransId());
        byte[] lpResp = new byte[1300];
        int[] dwSize = new int[1];
        byte[] bTID = new byte[1];
        transport.ReceiveTransactionResp(new BufferedBytes(lpResp), dwSize, bTID);
    }

    public void sendAbort(CTransportPAD t) {
        byte[] frame = new byte[1300];
        frame[0] = -66;
        frame[1] = -17;
        frame[2] = -19;
        frame[3] = 3;
        frame[4] = 3;
        frame[5] = 2;
        frame[6] = 0;
        frame[7] = 14;
        frame[8] = -1;
        frame[9] = -81;
        frame[10] = 1;
        frame[11] = -64;
        frame[12] = 0;
        frame[13] = 10;
        frame[14] = 2;
        frame[15] = -128;
        frame[16] = 0;
        frame[17] = 0;
        frame[18] = 0;
        frame[19] = 0;
        frame[20] = 0;
        frame[21] = 0;
        frame[22] = 0;
        frame[23] = 0;
        BufferedBytes pBuff = new BufferedBytes(frame);
        short crc = t.calcCrc16(pBuff, 24, 0);
        pBuff.setIndex(24);
        pBuff.copyShortBytes(crc);
        long[] actual = new long[1];
        long err = CTransportPAD.m_pSerialPort.WriteBytes(frame, 26L, actual);
        System.out.println("In sendAbort actual bytes written");
    }
}

