/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.groups;

import com.sun.wbem.solarisprovider.common.ProviderDirectoryFilter;
import com.sun.wbem.solarisprovider.usermgr.common.SolServerException;
import com.sun.wbem.solarisprovider.usermgr.groups.GroupObj;
import com.sun.wbem.solarisprovider.usermgr.users.FlatUserObj;
import com.sun.wbem.utility.directorytable.DirectoryFilter;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableAccessException;
import com.sun.wbem.utility.directorytable.DirectoryTableConnectionException;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.DirectoryTableInvalidParameterException;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;

public class SolarisGroupTable {
    private String table = new String("group");
    private String emptyString = new String("");
    private String fileType = new String("File");
    private String nameCol = "name";
    private String passwdCol = "passwd";
    private String gidCol = "gid";
    private String memberCol = "members";
    private String scope;

    public SolarisGroupTable(String string) {
        this.scope = string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addGroupRow(GroupObj groupObj) throws DirectoryTableException, SolServerException {
        DirectoryTable directoryTable = null;
        directoryTable = this.openGroupTable();
        try {
            try {
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                if (groupObj.getGroupID() != null) {
                    directoryRow.putColumn(tableDefinitions.getColumnNumber(this.gidCol), groupObj.getGroupID());
                    directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                }
                if (directoryRow != null) {
                    throw new SolServerException("EXM_SUS16", groupObj.getGroupID());
                }
                directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                if (groupObj.getGroupName() != null) {
                    directoryRow.putColumn(tableDefinitions.getColumnNumber(this.nameCol), groupObj.getGroupName());
                    directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                }
                if (directoryRow != null) {
                    throw new SolServerException("EXM_SUS18", groupObj.getGroupName());
                }
                directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                if (groupObj.getGroupName() != null) {
                    directoryRow.putColumn(tableDefinitions.getColumnNumber(this.nameCol), groupObj.getGroupName());
                }
                if (groupObj.getGroupID() != null) {
                    directoryRow.putColumn(tableDefinitions.getColumnNumber(this.gidCol), groupObj.getGroupID());
                }
                if (groupObj.getGroupPassword() != null) {
                    directoryRow.putColumn(tableDefinitions.getColumnNumber(this.passwdCol), groupObj.getGroupPassword());
                }
                if (groupObj.getGroupUsers() != null) {
                    directoryRow.putColumn(tableDefinitions.getColumnNumber(this.memberCol), SolarisGroupTable.formatMembersIntoString(groupObj.getGroupUsers()));
                }
                directoryTable.addRow(directoryRow);
            }
            catch (SolServerException solServerException) {
                throw solServerException;
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw directoryTableInvalidParameterException;
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw directoryTableConnectionException;
            }
            catch (DirectoryTableException directoryTableException) {
                throw directoryTableException;
            }
            catch (Exception exception) {
            }
            Object var4_12 = null;
            if (directoryTable == null) return;
        }
        catch (Throwable throwable) {
            Object var4_13 = null;
            if (directoryTable == null) throw throwable;
            directoryTable.close();
            throw throwable;
        }
        directoryTable.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteGroupRow(GroupObj groupObj) throws DirectoryTableException, Exception {
        DirectoryTable directoryTable;
        block12: {
            block11: {
                directoryTable = null;
                directoryTable = this.openGroupTable();
                try {
                    try {
                        TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                        DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                        directoryRow.putColumn(tableDefinitions.getColumnNumber(this.nameCol), groupObj.getGroupName());
                        directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                        if (directoryRow == null) {
                            Object var4_12 = null;
                            if (directoryTable == null) return;
                            break block11;
                        }
                        directoryTable.deleteRow(directoryRow);
                        break block12;
                    }
                    catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                        throw directoryTableInvalidParameterException;
                    }
                    catch (DirectoryTableAccessException directoryTableAccessException) {
                        throw directoryTableAccessException;
                    }
                    catch (DirectoryTableConnectionException directoryTableConnectionException) {
                        throw directoryTableConnectionException;
                    }
                    catch (DirectoryTableException directoryTableException) {
                        throw directoryTableException;
                    }
                    catch (Exception exception) {
                        throw exception;
                    }
                }
                catch (Throwable throwable) {
                    Object var4_14 = null;
                    if (directoryTable == null) throw throwable;
                    directoryTable.close();
                    throw throwable;
                }
            }
            directoryTable.close();
            return;
        }
        Object var4_13 = null;
        if (directoryTable == null) return;
        directoryTable.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean doesGroupExist(GroupObj groupObj) throws Exception {
        DirectoryTable directoryTable;
        block10: {
            boolean bl;
            directoryTable = null;
            directoryTable = this.openGroupTable();
            try {
                try {
                    TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                    DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                    directoryRow.putColumn(tableDefinitions.getColumnNumber(this.nameCol), groupObj.getGroupName());
                    directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                    if (directoryRow != null) break block10;
                    bl = false;
                    Object var5_12 = null;
                    if (directoryTable == null) return bl;
                }
                catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                    throw directoryTableInvalidParameterException;
                }
                catch (DirectoryTableAccessException directoryTableAccessException) {
                    throw directoryTableAccessException;
                }
                catch (DirectoryTableConnectionException directoryTableConnectionException) {
                    throw directoryTableConnectionException;
                }
                catch (DirectoryTableException directoryTableException) {
                    throw directoryTableException;
                }
                catch (Exception exception) {
                    throw exception;
                }
            }
            catch (Throwable throwable) {
                Object var5_14 = null;
                if (directoryTable == null) throw throwable;
                directoryTable.close();
                throw throwable;
            }
            directoryTable.close();
            return bl;
        }
        Object var5_13 = null;
        if (directoryTable == null) return true;
        directoryTable.close();
        return true;
    }

    public static String formatMembersIntoString(String[] stringArray) {
        if (stringArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        int n = 1;
        while (n < stringArray.length) {
            stringBuffer.append(",");
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector getAllGroupRows() throws DirectoryTableException {
        DirectoryTable directoryTable;
        Vector<GroupObj> vector;
        block12: {
            Vector<GroupObj> vector2;
            block11: {
                vector = new Vector<GroupObj>();
                directoryTable = null;
                directoryTable = this.openGroupTable();
                try {
                    try {
                        TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                        DirectoryRow directoryRow = directoryTable.getAll();
                        if (directoryRow == null) {
                            vector2 = vector;
                            Object var6_11 = null;
                            if (directoryTable == null) return vector2;
                            break block11;
                        }
                        int n = 1;
                        while (n <= directoryRow.getNumberOfRows()) {
                            GroupObj groupObj = new GroupObj(directoryRow.getColumn(tableDefinitions.getColumnNumber(this.nameCol), n));
                            groupObj.setGroupType("Solaris");
                            groupObj.setGroupID(directoryRow.getColumn(tableDefinitions.getColumnNumber(this.gidCol), n));
                            vector.addElement(groupObj);
                            ++n;
                        }
                        break block12;
                    }
                    catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                        throw directoryTableInvalidParameterException;
                    }
                    catch (DirectoryTableAccessException directoryTableAccessException) {
                        throw directoryTableAccessException;
                    }
                    catch (DirectoryTableConnectionException directoryTableConnectionException) {
                        throw directoryTableConnectionException;
                    }
                    catch (DirectoryTableException directoryTableException) {
                        throw directoryTableException;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_13 = null;
                    if (directoryTable == null) throw throwable;
                    directoryTable.close();
                    throw throwable;
                }
            }
            directoryTable.close();
            return vector2;
        }
        Object var6_12 = null;
        if (directoryTable == null) return vector;
        directoryTable.close();
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList getAllGroupRows(ProviderDirectoryFilter providerDirectoryFilter) throws DirectoryTableException {
        DirectoryTable directoryTable;
        ArrayList<GroupObj> arrayList;
        block18: {
            ArrayList<GroupObj> arrayList2;
            block17: {
                arrayList = new ArrayList<GroupObj>();
                directoryTable = null;
                DirectoryFilter directoryFilter = null;
                directoryTable = this.openGroupTable();
                if (providerDirectoryFilter != null) {
                    try {
                        directoryFilter = providerDirectoryFilter.getDirectoryFilter(directoryTable);
                    }
                    catch (Exception exception) {
                        throw new DirectoryTableInvalidParameterException("EXM_INVALID");
                    }
                }
                try {
                    try {
                        TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                        Object var10_12 = null;
                        DirectoryRow directoryRow = null;
                        DirectoryRow directoryRow2 = null;
                        if (directoryFilter != null) {
                            directoryRow = directoryTable.getAll((SearchTemplate)directoryFilter);
                            directoryRow2 = directoryTable.getAll((SearchTemplate)directoryFilter);
                        } else {
                            directoryRow = directoryTable.getAll();
                            directoryRow2 = directoryTable.getAll();
                        }
                        if (directoryRow2 == null) {
                            arrayList2 = arrayList;
                            Object var8_15 = null;
                            if (directoryTable == null) return arrayList2;
                            break block17;
                        }
                        int n = 1;
                        while (n <= directoryRow2.getNumberOfRows()) {
                            GroupObj groupObj = new GroupObj(directoryRow2.getColumn(tableDefinitions.getColumnNumber(this.nameCol), n));
                            groupObj.setGroupType("Solaris");
                            groupObj.setGroupID(directoryRow2.getColumn(tableDefinitions.getColumnNumber(this.gidCol), n));
                            arrayList.add(groupObj);
                            ++n;
                        }
                        break block18;
                    }
                    catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                        throw directoryTableInvalidParameterException;
                    }
                    catch (DirectoryTableAccessException directoryTableAccessException) {
                        throw directoryTableAccessException;
                    }
                    catch (DirectoryTableConnectionException directoryTableConnectionException) {
                        throw directoryTableConnectionException;
                    }
                    catch (DirectoryTableException directoryTableException) {
                        throw directoryTableException;
                    }
                    catch (Exception exception) {
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_17 = null;
                    if (directoryTable == null) throw throwable;
                    directoryTable.close();
                    throw throwable;
                }
            }
            directoryTable.close();
            return arrayList2;
        }
        Object var8_16 = null;
        if (directoryTable == null) return arrayList;
        directoryTable.close();
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector getAllSecondaryGroups(FlatUserObj flatUserObj) throws DirectoryTableException {
        Vector<String> vector = new Vector<String>();
        DirectoryTable directoryTable = null;
        directoryTable = this.openGroupTable();
        try {
            try {
                DirectoryRow directoryRow = directoryTable.getAll();
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                boolean bl = false;
                String string = "";
                if (flatUserObj.getPrimaryGroup() != null) {
                    string = flatUserObj.getPrimaryGroup();
                }
                String string2 = "";
                int n = 1;
                while (n <= directoryRow.getNumberOfRows()) {
                    String string3 = directoryRow.getColumn(tableDefinitions.getColumnNumber(this.memberCol), n);
                    if (this.isGroupMember(flatUserObj.getUserName(), string3) && (string2 = directoryRow.getColumn(tableDefinitions.getColumnNumber(this.nameCol), n)) != null && !string2.equals(string)) {
                        vector.addElement(string2);
                    }
                    ++n;
                }
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw directoryTableInvalidParameterException;
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw directoryTableConnectionException;
            }
            catch (DirectoryTableException directoryTableException) {
                throw directoryTableException;
            }
            Object var5_17 = null;
            if (directoryTable == null) return vector;
        }
        catch (Throwable throwable) {
            Object var5_18 = null;
            if (directoryTable == null) throw throwable;
            directoryTable.close();
            throw throwable;
        }
        directoryTable.close();
        return vector;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GroupObj getGroupRow(GroupObj groupObj) throws DirectoryTableException, SolServerException {
        DirectoryTable directoryTable = null;
        directoryTable = this.openGroupTable();
        try {
            try {
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.nameCol), groupObj.getGroupName());
                directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                if (directoryRow == null) {
                    throw new SolServerException("EXM_SUS22", groupObj.getGroupName());
                }
                groupObj.setGroupUsers(SolarisGroupTable.parseMembersIntoArray(directoryRow.getColumn(tableDefinitions.getColumnNumber(this.memberCol))));
                groupObj.setGroupID(directoryRow.getColumn(tableDefinitions.getColumnNumber(this.gidCol)));
                groupObj.setGroupPassword(directoryRow.getColumn(tableDefinitions.getColumnNumber(this.passwdCol)));
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
            }
            catch (DirectoryTableException directoryTableException) {
                throw directoryTableException;
            }
            catch (SolServerException solServerException) {
                throw solServerException;
            }
            catch (Exception exception) {
            }
            Object var4_10 = null;
            if (directoryTable == null) return groupObj;
        }
        catch (Throwable throwable) {
            Object var4_11 = null;
            if (directoryTable == null) throw throwable;
            directoryTable.close();
            throw throwable;
        }
        directoryTable.close();
        return groupObj;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getNextAvailableGID() throws DirectoryTableException {
        int n = 100;
        DirectoryTable directoryTable = null;
        directoryTable = this.openGroupTable();
        TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
        int n2 = 0;
        boolean bl = false;
        try {
            try {
                DirectoryRow directoryRow = directoryTable.getAll();
                directoryRow.sortByColumn(tableDefinitions.getColumnNumber(this.gidCol), tableDefinitions);
                int n3 = 1;
                while (n3 <= directoryRow.getNumberOfRows()) {
                    String string = directoryRow.getColumn(tableDefinitions.getColumnNumber(this.gidCol), n3);
                    if (string != null && string.trim().length() > 0 && (n2 = Integer.parseInt(string)) != 60001 && n2 != 60002 && n2 != 65534) {
                        if (n == n2) {
                            ++n;
                        } else if (n < n2) {
                            bl = true;
                        }
                    }
                    ++n3;
                }
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw directoryTableInvalidParameterException;
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw directoryTableConnectionException;
            }
            catch (DirectoryTableException directoryTableException) {
                throw directoryTableException;
            }
            Object var8_14 = null;
            if (directoryTable == null) return String.valueOf(n);
        }
        catch (Throwable throwable) {
            Object var8_15 = null;
            if (directoryTable == null) throw throwable;
            directoryTable.close();
            throw throwable;
        }
        directoryTable.close();
        return String.valueOf(n);
    }

    private boolean isGroupMember(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        if (string2 == "") {
            return false;
        }
        String[] stringArray = SolarisGroupTable.parseMembersIntoArray(string2);
        int n = 0;
        while (n < stringArray.length) {
            if (string.compareTo(stringArray[n]) == 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void modifyGroupRow(GroupObj groupObj) throws DirectoryTableException, SolServerException {
        DirectoryTable directoryTable;
        block22: {
            block21: {
                directoryTable = null;
                directoryTable = this.openGroupTable();
                try {
                    try {
                        TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                        DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                        if (groupObj.getGroupID() != null) {
                            directoryRow.putColumn(tableDefinitions.getColumnNumber(this.gidCol), groupObj.getGroupID());
                            directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                            if (directoryRow == null) {
                                this.addGroupRow(groupObj);
                                Object var4_12 = null;
                                if (directoryTable == null) return;
                                break block21;
                            }
                        }
                        DirectoryRow directoryRow2 = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                        String string = directoryRow.getColumn(tableDefinitions.getColumnNumber(this.nameCol));
                        if (!string.equals(groupObj.getGroupName()) && groupObj.getGroupName() != null) {
                            directoryRow2.putColumn(tableDefinitions.getColumnNumber(this.nameCol), groupObj.getGroupName());
                            directoryRow2 = directoryTable.getFirstRow((SearchTemplate)directoryRow2);
                            if (directoryRow2 != null) {
                                throw new SolServerException("EXM_SUS18", groupObj.getGroupName());
                            }
                            directoryRow2 = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                        }
                        if (groupObj.getGroupUsers() != null) {
                            directoryRow2.putColumn(tableDefinitions.getColumnNumber(this.memberCol), SolarisGroupTable.formatMembersIntoString(groupObj.getGroupUsers()));
                        }
                        if (groupObj.getGroupName() != null) {
                            directoryRow2.putColumn(tableDefinitions.getColumnNumber(this.nameCol), groupObj.getGroupName());
                        }
                        if (groupObj.getGroupPassword() != null) {
                            directoryRow2.putColumn(tableDefinitions.getColumnNumber(this.passwdCol), groupObj.getGroupPassword());
                        }
                        if (groupObj.getGroupID() != null) {
                            directoryRow2.putColumn(tableDefinitions.getColumnNumber(this.gidCol), groupObj.getGroupID());
                        }
                        directoryTable.modifyRow(directoryRow, directoryRow2);
                        break block22;
                    }
                    catch (SolServerException solServerException) {
                        throw solServerException;
                    }
                    catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                        throw directoryTableInvalidParameterException;
                    }
                    catch (DirectoryTableAccessException directoryTableAccessException) {
                        throw directoryTableAccessException;
                    }
                    catch (DirectoryTableConnectionException directoryTableConnectionException) {
                        throw directoryTableConnectionException;
                    }
                    catch (DirectoryTableException directoryTableException) {
                        throw directoryTableException;
                    }
                    catch (Exception exception) {
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    Object var4_14 = null;
                    if (directoryTable == null) throw throwable;
                    directoryTable.close();
                    throw throwable;
                }
            }
            directoryTable.close();
            return;
        }
        Object var4_13 = null;
        if (directoryTable == null) return;
        directoryTable.close();
    }

    private DirectoryTable openGroupTable() throws DirectoryTableException {
        try {
            DirectoryTable directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
            directoryTable.open(this.table);
            return directoryTable;
        }
        catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
            throw directoryTableInvalidParameterException;
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            throw directoryTableDoesNotExistException;
        }
        catch (DirectoryTableConnectionException directoryTableConnectionException) {
            throw directoryTableConnectionException;
        }
        catch (DirectoryTableException directoryTableException) {
            throw directoryTableException;
        }
    }

    public static String[] parseMembersIntoArray(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public String translateGIDtoName(String string) throws SolServerException {
        try {
            DirectoryTable directoryTable = this.openGroupTable();
            TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
            DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
            directoryRow.putColumn(tableDefinitions.getColumnNumber(this.gidCol), string);
            DirectoryRow directoryRow2 = directoryTable.getFirstRow((SearchTemplate)directoryRow);
            if (directoryRow2 == null) {
                throw new SolServerException("EXM_NOGRPID", string);
            }
            String string2 = directoryRow2.getColumn(tableDefinitions.getColumnNumber(this.nameCol));
            directoryTable.close();
            return string2;
        }
        catch (SolServerException solServerException) {
            throw solServerException;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String translateNametoGID(String string) throws SolServerException {
        try {
            DirectoryTable directoryTable = this.openGroupTable();
            TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
            DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
            directoryRow.putColumn(tableDefinitions.getColumnNumber(this.nameCol), string);
            DirectoryRow directoryRow2 = directoryTable.getFirstRow((SearchTemplate)directoryRow);
            if (directoryRow2 == null) {
                throw new SolServerException("EXM_NOGRPNAME", string);
            }
            String string2 = directoryRow2.getColumn(tableDefinitions.getColumnNumber(this.gidCol));
            directoryTable.close();
            return string2;
        }
        catch (SolServerException solServerException) {
            throw solServerException;
        }
        catch (Exception exception) {
            return "";
        }
    }
}

