/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.printer;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.UnsignedInt16;
import com.sun.wbem.client.CIMOMHandle;
import com.sun.wbem.provider20.Authorizable;
import com.sun.wbem.provider20.InstanceProvider;
import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.printer.PrtBuff;
import com.sun.wbem.solarisprovider.printer.Solaris_PrtNative;
import com.sun.wbem.utility.log.LogUtil;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;

public class Solaris_Printer
implements InstanceProvider,
Authorizable {
    private CIMOMHandle cimomhandle = null;
    private String prtList = null;
    private String dummy = null;
    LogUtil logUtil = null;
    private ProviderUtility prov_util = null;
    private String PROVIDER_NAME = "Solaris_Printer";
    PrtBuff prtbuff = new PrtBuff();
    public static final String PRINTER_MODIFY_RIGHT = "solaris.admin.printer.modify";
    public static final String PRINTER_DELETE_RIGHT = "solaris.admin.printer.delete";
    public static final String PRINTER_READ_RIGHT = "solaris.admin.printer.read";

    public void cleanup() throws CIMException {
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        this.prov_util.checkRights(PRINTER_MODIFY_RIGHT, cIMObjectPath);
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        try {
            string = (String)cIMInstance.getProperty("DeviceID").getValue().getValue();
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{string};
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9406", "LM_9407", stringArray, null, false, 0, 2);
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)string);
        }
        try {
            string2 = (String)cIMInstance.getProperty("Description").getValue().getValue();
        }
        catch (Exception exception) {
            string2 = "Added_via_WBEM";
        }
        try {
            string3 = (String)cIMInstance.getProperty("PrintServer").getValue().getValue();
        }
        catch (Exception exception) {
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                string3 = inetAddress.getHostName();
            }
            catch (Exception exception2) {
                throw new CIMException("CIM_ERR_FAILED", (Object)exception2);
            }
            try {
                bl = (Boolean)cIMInstance.getProperty("DefaultPrinter").getValue().getValue();
            }
            catch (Exception exception3) {
                bl = false;
            }
            try {
                boolean bl2 = this.prtbuff.addQ(string, string3, string2, bl);
                if (!bl2) {
                    String[] stringArray = new String[]{string};
                    this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9406", "LM_9407", stringArray, "Error", false, 0, 0);
                    throw new CIMException("CIM_ERR_FAILED", (Object)"Create Printer Failed");
                }
                String[] stringArray = new String[]{string};
                this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9404", "LM_9405", stringArray, "Success", false, 0, 0);
            }
            catch (Exception exception4) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)exception);
            }
        }
        return cIMObjectPath;
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        block4: {
            String[] stringArray;
            String string = null;
            this.prov_util.checkRights(PRINTER_DELETE_RIGHT, cIMObjectPath);
            Enumeration enumeration = cIMObjectPath.getKeys().elements();
            while (enumeration.hasMoreElements()) {
                stringArray = (String[])enumeration.nextElement();
                if (!stringArray.getName().equalsIgnoreCase("DeviceID")) continue;
                string = (String)stringArray.getValue().getValue();
            }
            try {
                if (this.prtbuff.delPrinter(string)) {
                    stringArray = new String[]{string};
                    this.logUtil.writeLog("Solaris_Printer", "LM_9400", "LM_9401", stringArray, "Success", false, 0, 0);
                    break block4;
                }
                stringArray = new String[]{string};
                this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9402", "LM_9402", stringArray, "Error", false, 0, 0);
                throw new CIMException("CIM_ERR_FAILED", (Object)"Delete Failed");
            }
            catch (Exception exception) {
                throw new CIMException("CIM_ERR_FAILED", (Object)exception);
            }
        }
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass) throws CIMException {
        String[] stringArray = new String[]{"Enumerating Printers for Solaris_Printer"};
        try {
            Vector<CIMObjectPath> vector = new Vector<CIMObjectPath>();
            this.prtbuff.createPrtFile();
            int n = this.prtbuff.getNumPrinters();
            int n2 = 0;
            while (n2 < n) {
                CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
                try {
                    this.prtList = this.prtbuff.getPrinter(n2);
                    cIMObjectPath2.addKey("DeviceID", new CIMValue((Object)this.prtList));
                }
                catch (Exception exception) {
                    throw new CIMException("CIM_ERR_FAILED", (Object)exception);
                }
                cIMObjectPath2.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                try {
                    cIMObjectPath2.addKey("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                }
                catch (Exception exception) {}
                cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"Solaris_Printer"));
                cIMObjectPath2.addKey("Description", new CIMValue((Object)"Add Description"));
                vector.addElement(cIMObjectPath2);
                ++n2;
            }
            return vector;
        }
        catch (Exception exception) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9421", "LM_9422", stringArray, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_FAILED", (Object)"Enumerate Instances Failed");
        }
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass, boolean bl2) throws CIMException {
        String[] stringArray = new String[]{"Enumerating Printers for Solaris_Printer"};
        String string = null;
        boolean bl3 = false;
        boolean bl4 = false;
        try {
            Vector<CIMInstance> vector = new Vector<CIMInstance>();
            this.prtbuff.createPrtFile();
            int n = this.prtbuff.getNumPrinters();
            int n2 = 0;
            while (n2 < n) {
                CIMInstance cIMInstance = cIMClass.newInstance();
                this.prtList = this.prtbuff.getPrinter(n2);
                cIMInstance.setProperty("DeviceID", new CIMValue((Object)this.prtList));
                cIMInstance.setProperty("Name", new CIMValue((Object)this.prtList));
                String string2 = Solaris_PrtNative.getPrtStat(this.prtList, "Description");
                cIMInstance.setProperty("PrinterStatus", new CIMValue((Object)new UnsignedInt16(string2)));
                cIMInstance.setProperty("Description", new CIMValue((Object)Solaris_PrtNative.getInfo(this.prtList, "Description")));
                cIMInstance.setProperty("Status", new CIMValue((Object)Solaris_PrtNative.getInfo(this.prtList, "Status")));
                cIMInstance.setProperty("Caption", new CIMValue((Object)Solaris_PrtNative.getInfo(this.prtList, "Caption")));
                cIMInstance.setProperty("DetectedErrorState", new CIMValue((Object)new UnsignedInt16(2)));
                cIMInstance.setProperty("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                cIMInstance.setProperty("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"Solaris_Printer"));
                string = this.prtbuff.getPrintServer(this.prtList);
                cIMInstance.setProperty("PrintServer", new CIMValue((Object)string));
                if (string.equalsIgnoreCase(InetAddress.getLocalHost().getHostName())) {
                    bl3 = true;
                }
                cIMInstance.setProperty("LocalPrinter", new CIMValue((Object)new Boolean(bl3)));
                bl4 = this.prtbuff.getDefaultPrt(this.prtList);
                cIMInstance.setProperty("DefaultPrinter", new CIMValue((Object)new Boolean(bl4)));
                vector.addElement(cIMInstance);
                ++n2;
            }
            return vector;
        }
        catch (Exception exception) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9421", "LM_9422", stringArray, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_FAILED", (Object)"Enumerate Instances Failed");
        }
    }

    public Vector execQuery(CIMObjectPath cIMObjectPath, String string, int n, CIMClass cIMClass) {
        return null;
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, CIMClass cIMClass, boolean bl) throws CIMException {
        String[] stringArray = new String[]{"getInstance for Solaris_Printer"};
        String string = null;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            CIMInstance cIMInstance;
            Enumeration enumeration = cIMObjectPath.getKeys().elements();
            while (enumeration.hasMoreElements()) {
                cIMInstance = (CIMProperty)enumeration.nextElement();
                if (!cIMInstance.getName().equalsIgnoreCase("DeviceID")) continue;
                this.prtList = (String)cIMInstance.getValue().getValue();
            }
            cIMInstance = cIMClass.newInstance();
            cIMInstance.setProperty("DeviceID", new CIMValue((Object)this.prtList));
            cIMInstance.setProperty("Name", new CIMValue((Object)this.prtList));
            String string2 = Solaris_PrtNative.getPrtStat(this.prtList, "Description");
            cIMInstance.setProperty("PrinterStatus", new CIMValue((Object)new UnsignedInt16(string2)));
            cIMInstance.setProperty("Description", new CIMValue((Object)Solaris_PrtNative.getInfo(this.prtList, "Description")));
            cIMInstance.setProperty("Status", new CIMValue((Object)Solaris_PrtNative.getInfo(this.prtList, "Status")));
            cIMInstance.setProperty("Caption", new CIMValue((Object)Solaris_PrtNative.getInfo(this.prtList, "Caption")));
            cIMInstance.setProperty("DetectedErrorState", new CIMValue((Object)new UnsignedInt16(2)));
            string = this.prtbuff.getPrintServer(this.prtList);
            cIMInstance.setProperty("PrintServer", new CIMValue((Object)string));
            if (string.equalsIgnoreCase(InetAddress.getLocalHost().getHostName())) {
                bl2 = true;
            }
            cIMInstance.setProperty("LocalPrinter", new CIMValue((Object)new Boolean(bl2)));
            bl3 = this.prtbuff.getDefaultPrt(this.prtList);
            cIMInstance.setProperty("DefaultPrinter", new CIMValue((Object)new Boolean(bl3)));
            cIMInstance.setProperty("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
            try {
                cIMInstance.setProperty("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
            }
            catch (Exception exception) {
                throw new CIMException("CIM_ERR_FAILED");
            }
            cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"Solaris_Printer"));
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9421", "LM_9422", stringArray, "Success", false, 0, 0);
            return cIMInstance;
        }
        catch (Exception exception) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9420", "LM_9420", stringArray, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_FAILED", (Object)"getInstance Failed");
        }
    }

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = cIMOMHandle;
        this.logUtil = LogUtil.getInstance((CIMOMHandle)cIMOMHandle);
        this.prov_util = new ProviderUtility(cIMOMHandle, this.PROVIDER_NAME);
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        try {
            this.prov_util.checkRights(PRINTER_MODIFY_RIGHT, cIMObjectPath);
            String[] stringArray = new String[]{"set Instance"};
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9420", "LM_9420", stringArray, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_FAILED", (Object)"Set Instance Failed");
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
    }
}

