/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.perfmon;

import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMProviderException;
import com.sun.wbem.client.CIMOMHandle;
import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.perfmon.CPUSysinfo;
import com.sun.wbem.solarisprovider.perfmon.CPUVminfo;
import com.sun.wbem.solarisprovider.perfmon.CpuUtilization;
import com.sun.wbem.solarisprovider.perfmon.DiskIOInformation;
import com.sun.wbem.solarisprovider.perfmon.PerfmonProviderException;
import com.sun.wbem.solarisprovider.perfmon.RunPerfMonitorCmd;
import com.sun.wbem.utility.log.LogUtil;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class PerformanceMonitor {
    private static ProviderUtility provUtil = null;
    private LogUtil logUtil = null;
    private static CIMOMHandle cimomhandle = null;
    protected static final String PROVIDERNAME = "Solaris System Performance Monitor";
    private static final String[] ENV_ARGS = new String[]{"LC_ALL=C", "LC_MESSAGES=C", "LANG=C"};
    private static final String NFSSTATS = "/usr/bin/nfsstat";
    private static final String[] PERFMON_GET_DISK_INFO = new String[]{"/usr/ucb/df", "-F ufs"};

    static {
        System.loadLibrary("solprov");
    }

    public PerformanceMonitor(CIMOMHandle cIMOMHandle, LogUtil logUtil, ProviderUtility providerUtility) throws CIMException {
        cimomhandle = cIMOMHandle;
        provUtil = providerUtility;
        this.logUtil = logUtil;
    }

    public synchronized Vector getAllCpuSysinfoObjs() throws CIMException {
        Vector vector = null;
        Vector<CPUSysinfo> vector2 = new Vector<CPUSysinfo>();
        try {
            vector = this.getCpuIdList();
            int n = 0;
            while (n < vector.size()) {
                String string = (String)vector.elementAt(n);
                vector2.addElement(this.getCpuSysinfoObj(Integer.parseInt(string)));
                ++n;
            }
        }
        catch (Exception exception) {
            String string = this.writeLog(2, "LM_9631", null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
        return vector2;
    }

    public synchronized Vector getAllCpuUtilObjects() throws CIMException {
        Vector vector = null;
        Vector<CpuUtilization> vector2 = new Vector<CpuUtilization>();
        try {
            vector = this.getCpuIdList();
            int n = 0;
            while (n < vector.size()) {
                String string = (String)vector.elementAt(n);
                vector2.addElement(this.getCpuUtilObject(Integer.parseInt(string)));
                ++n;
            }
        }
        catch (Exception exception) {
            String string = this.writeLog(2, "LM_9607", null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
        return vector2;
    }

    public synchronized Vector getAllCpuVMObjs() throws CIMException {
        Vector vector = null;
        Vector<CPUVminfo> vector2 = new Vector<CPUVminfo>();
        try {
            vector = this.getCpuIdList();
            int n = 0;
            while (n < vector.size()) {
                String string = (String)vector.elementAt(n);
                vector2.addElement(this.getCpuVMObj(Integer.parseInt(string)));
                ++n;
            }
        }
        catch (Exception exception) {
            String string = this.writeLog(2, "LM_9632", null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
        return vector2;
    }

    public synchronized Vector getAllDiskIOInfoObjs() throws CIMException {
        Vector vector = null;
        Vector<DiskIOInformation> vector2 = new Vector<DiskIOInformation>();
        try {
            vector = this.getDeviceNamesList();
            int n = 0;
            while (n < vector.size()) {
                String string = (String)vector.elementAt(n);
                DiskIOInformation diskIOInformation = new DiskIOInformation(string);
                if (diskIOInformation != null) {
                    vector2.addElement(diskIOInformation);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            String string = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
        return vector2;
    }

    public synchronized String getBulkCpuSysInfo() throws CIMException {
        String string = null;
        int n = 0;
        try {
            string = this.get_bulk_cpustats(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string2 = this.writeLog(2, "LM_9631", null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        return string;
    }

    public synchronized String getBulkCpuVmInfo() throws CIMException {
        String string = null;
        int n = 1;
        try {
            string = this.get_bulk_cpustats(n);
        }
        catch (Exception exception) {
            String string2 = this.writeLog(2, "LM_9632", null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        return string;
    }

    public synchronized String getBulkDiskIOData() throws CIMException {
        String string = null;
        try {
            string = this.get_bulkdiskIO_data();
        }
        catch (Exception exception) {
            String string2 = this.writeLog(2, "LM_9611", null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        return string;
    }

    private Vector getCpuIdList() throws PerfmonProviderException {
        Vector<String> vector = new Vector<String>();
        String string = null;
        try {
            string = this.get_cpu_list();
            string = string.trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
            while (stringTokenizer.hasMoreTokens()) {
                vector.addElement(stringTokenizer.nextToken());
            }
        }
        catch (Exception exception) {
            this.writeLog(2, null, null, exception);
            throw new PerfmonProviderException("LM_9622", exception);
        }
        return vector;
    }

    public synchronized CPUSysinfo getCpuSysinfoObj(int n) throws CIMException {
        CPUSysinfo cPUSysinfo = null;
        try {
            cPUSysinfo = new CPUSysinfo(n);
            int n2 = cPUSysinfo.getStatus();
            if (n2 == -4 || n2 == -1) {
                throw new PerfmonProviderException("LM_9631");
            }
        }
        catch (Exception exception) {
            String string = this.writeLog(2, "LM_9631", null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
        return cPUSysinfo;
    }

    public synchronized CpuUtilization getCpuUtilObject(int n) throws CIMException {
        CpuUtilization cpuUtilization = null;
        try {
            cpuUtilization = new CpuUtilization(n);
            int n2 = cpuUtilization.getStatus();
            if (n2 == -4 || n2 == -1) {
                throw new PerfmonProviderException("LM_9607");
            }
        }
        catch (Exception exception) {
            String string = this.writeLog(2, "LM_9607", null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
        return cpuUtilization;
    }

    private Vector getCpuUtilization() throws PerfmonProviderException {
        Vector vector = null;
        Vector vector2 = null;
        String string = "1";
        String string2 = "2";
        String[] stringArray = new String[]{"/usr/bin/mpstat", string, string2};
        try {
            RunPerfMonitorCmd runPerfMonitorCmd = new RunPerfMonitorCmd(stringArray, ENV_ARGS);
            if (runPerfMonitorCmd.getResult() != 0) {
                vector2 = runPerfMonitorCmd.getErrors();
                if (vector2 != null) {
                    this.writeLog(1, vector2.toString());
                }
                runPerfMonitorCmd.dispose();
                throw new PerfmonProviderException("LM_9607");
            }
            vector = this.parseCpuUtilData(runPerfMonitorCmd.getOutput());
            runPerfMonitorCmd.dispose();
        }
        catch (Exception exception) {
            this.writeLog(2, "LM_9607", null, exception);
            throw new PerfmonProviderException("LM_9607", exception);
        }
        return vector;
    }

    public synchronized CPUVminfo getCpuVMObj(int n) throws CIMException {
        CPUVminfo cPUVminfo = null;
        try {
            cPUVminfo = new CPUVminfo(n);
            int n2 = cPUVminfo.getStatus();
            if (n2 == -4 || n2 == -1) {
                throw new PerfmonProviderException("LM_9632");
            }
        }
        catch (Exception exception) {
            String string = this.writeLog(2, "LM_9632", null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
        return cPUVminfo;
    }

    public synchronized String getDaysSinceLastReboot() throws CIMException {
        Vector vector = null;
        String string = null;
        Vector vector2 = null;
        String[] stringArray = new String[]{"/usr/bin/uptime"};
        try {
            RunPerfMonitorCmd runPerfMonitorCmd = new RunPerfMonitorCmd(stringArray, ENV_ARGS);
            if (runPerfMonitorCmd.getResult() != 0) {
                vector2 = runPerfMonitorCmd.getErrors();
                if (vector2 != null) {
                    this.writeLog(1, vector2.toString());
                }
                runPerfMonitorCmd.dispose();
                throw new PerfmonProviderException("LM_9620");
            }
            vector = runPerfMonitorCmd.getOutput();
            runPerfMonitorCmd.dispose();
            String string2 = (String)vector.elementAt(0);
            string = this.parseDataString(string2);
        }
        catch (Exception exception) {
            String string3 = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string3);
        }
        return string;
    }

    private Vector getDeviceNamesList() throws PerfmonProviderException {
        Vector<String> vector = new Vector<String>();
        String string = null;
        try {
            string = this.get_disk_list();
            string = string.trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                vector.addElement(stringTokenizer.nextToken());
            }
        }
        catch (Exception exception) {
            this.writeLog(2, null, null, exception);
            throw new PerfmonProviderException("LM_9611", exception);
        }
        return vector;
    }

    public synchronized DiskIOInformation getDiskIOInfoObj(String string) throws CIMException {
        DiskIOInformation diskIOInformation = null;
        try {
            diskIOInformation = new DiskIOInformation(string);
        }
        catch (Exception exception) {
            String string2 = this.writeLog(2, "LM_9611", null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        return diskIOInformation;
    }

    public synchronized String getMemorySize() throws CIMException {
        Vector vector = null;
        String string = null;
        Vector vector2 = null;
        String[] stringArray = new String[]{"/usr/sbin/prtconf"};
        try {
            RunPerfMonitorCmd runPerfMonitorCmd = new RunPerfMonitorCmd(stringArray, ENV_ARGS);
            if (runPerfMonitorCmd.getResult() != 0) {
                vector2 = runPerfMonitorCmd.getErrors();
                if (vector2 != null) {
                    this.writeLog(1, vector2.toString());
                }
                runPerfMonitorCmd.dispose();
                throw new PerfmonProviderException("LM_9619");
            }
            vector = runPerfMonitorCmd.getOutput();
            runPerfMonitorCmd.dispose();
            String string2 = (String)vector.elementAt(1);
            string = this.parseDataString(string2);
        }
        catch (Exception exception) {
            String string3 = this.writeLog(2, "LM_9619", null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string3);
        }
        return string;
    }

    private Vector getNetworkInterfaces() throws PerfmonProviderException {
        Vector<String> vector = new Vector<String>();
        Vector vector2 = null;
        try {
            vector2 = this.getNetworkThroughputSummary();
        }
        catch (Exception exception) {
            this.writeLog(2, "LM_9614", null, exception);
            throw new PerfmonProviderException("LM_9614", exception);
        }
        if (vector2 == null || vector2.size() < 3) {
            return null;
        }
        vector2.removeElementAt(0);
        vector2.removeElementAt(0);
        int n = 0;
        while (n < vector2.size()) {
            String string = null;
            string = (String)vector2.elementAt(n);
            if (string.startsWith("Name")) {
                vector2.setSize(n);
                break;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < vector2.size()) {
            String string = null;
            String string2 = (String)vector2.elementAt(n2);
            string2 = string2.trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t\n\r\f");
            try {
                string = stringTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                this.writeLog(2, "LM_9614", null, noSuchElementException);
                throw new PerfmonProviderException("LM_9614", noSuchElementException);
            }
            vector.addElement(string);
            ++n2;
        }
        return vector;
    }

    private Vector getNetworkThroughputSummary() throws PerfmonProviderException {
        Vector vector = null;
        String[] stringArray = new String[]{"/usr/bin/netstat", "-i"};
        try {
            RunPerfMonitorCmd runPerfMonitorCmd = new RunPerfMonitorCmd(stringArray, ENV_ARGS);
            if (runPerfMonitorCmd.getResult() != 0) {
                runPerfMonitorCmd.dispose();
            } else {
                vector = runPerfMonitorCmd.getOutput();
                runPerfMonitorCmd.dispose();
            }
        }
        catch (Exception exception) {
            this.writeLog(2, "LM_9616", null, exception);
            throw new PerfmonProviderException("LM_9616", exception);
        }
        return vector;
    }

    public synchronized int getNumberOfCpus() throws CIMException {
        Vector vector = null;
        int n = 0;
        Vector vector2 = null;
        String[] stringArray = new String[]{"/usr/sbin/psrinfo"};
        try {
            RunPerfMonitorCmd runPerfMonitorCmd = new RunPerfMonitorCmd(stringArray, ENV_ARGS);
            if (runPerfMonitorCmd.getResult() != 0) {
                vector2 = runPerfMonitorCmd.getErrors();
                if (vector2 != null) {
                    this.writeLog(1, vector2.toString());
                }
                runPerfMonitorCmd.dispose();
                throw new PerfmonProviderException("LM_9618");
            }
            vector = runPerfMonitorCmd.getOutput();
            n = vector.size();
            runPerfMonitorCmd.dispose();
        }
        catch (Exception exception) {
            String string = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
        return n;
    }

    public synchronized int getNumberOfDiskPartitions() throws CIMException {
        Vector vector = null;
        Vector vector2 = null;
        int n = 0;
        String[] stringArray = new String[]{"/usr/ucb/df", "-F ufs"};
        try {
            RunPerfMonitorCmd runPerfMonitorCmd = new RunPerfMonitorCmd(stringArray, ENV_ARGS);
            if (runPerfMonitorCmd.getResult() != 0) {
                vector2 = runPerfMonitorCmd.getErrors();
                if (vector2 != null) {
                    this.writeLog(1, vector2.toString());
                }
                runPerfMonitorCmd.dispose();
                throw new PerfmonProviderException("LM_9617");
            }
            vector = runPerfMonitorCmd.getOutput();
            n = vector.size() - 1;
            runPerfMonitorCmd.dispose();
        }
        catch (Exception exception) {
            String string = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
        return n;
    }

    public synchronized int getNumberOfNetworkInterfaces() throws CIMException {
        int n = 0;
        try {
            Vector vector = this.getNetworkInterfaces();
            n = vector.size();
        }
        catch (Exception exception) {
            String string = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
        return n;
    }

    private native String get_bulk_cpustats(int var1);

    private native String get_bulkdiskIO_data();

    private native int get_cpu_count();

    private native String get_cpu_list();

    private native String get_disk_list();

    private Vector parseCpuUtilData(Vector vector) throws PerfmonProviderException {
        int n;
        Vector<String> vector2 = new Vector<String>();
        int n2 = 0;
        if (vector.size() == 3) {
            vector.removeElementAt(0);
            vector.removeElementAt(0);
        } else if (vector.size() > 3) {
            n2 = vector.size() / 2 + 1;
            n = 1;
            while (n <= n2) {
                vector.removeElementAt(0);
                ++n;
            }
        } else {
            return null;
        }
        n = 0;
        while (n < vector.size()) {
            String string = null;
            String string2 = (String)vector.elementAt(n);
            string2 = string2.trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t\n\r\f");
            int n3 = 0;
            String string3 = "";
            try {
                while (stringTokenizer.hasMoreTokens()) {
                    if (n3 == 0) {
                        string3 = stringTokenizer.nextToken();
                    }
                    if (++n3 != 12) continue;
                    string = String.valueOf(string3) + " " + stringTokenizer.nextToken();
                    string = String.valueOf(string) + " " + stringTokenizer.nextToken();
                    string = String.valueOf(string) + " " + stringTokenizer.nextToken();
                    string = String.valueOf(string) + " " + stringTokenizer.nextToken() + "\n";
                    break;
                }
            }
            catch (Exception exception) {
                this.writeLog(2, "LM_9608", null, exception);
                throw new PerfmonProviderException("LM_9608", exception);
            }
            vector2.addElement(string);
            ++n;
        }
        return vector2;
    }

    private String parseDataString(String string) throws NoSuchElementException {
        String string2 = null;
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f");
        int n = stringTokenizer.countTokens();
        try {
            if (n >= 4) {
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NoSuchElementException(noSuchElementException.getMessage());
        }
        return string2;
    }

    protected void writeLog(int n, String string) {
        try {
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", null, null, string, false, 0, n);
        }
        catch (Exception exception) {}
    }

    protected String writeLog(int n, String string, String[] stringArray, Exception exception) {
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        try {
            string3 = exception.getLocalizedMessage();
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", string, stringArray, string3, bl, 0, n);
        }
        catch (Exception exception2) {}
        if (string != null) {
            string2 = this.logUtil.getLocalizedMessage(string, stringArray);
            string2 = String.valueOf(string2) + " " + string3;
        } else {
            string2 = string3;
        }
        return string2;
    }
}

