/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.diskdrive;

import java.io.Serializable;

public class SliceData
implements Serializable,
Cloneable {
    private static final int MIN_SLICE_NUM = 0;
    private static final int MAX_SLICE_NUM = 7;
    public static final int BACKUP_TAG = 5;
    private short partition;
    private short tag;
    private short flag;
    private int startCylinder;
    private int endCylinder;
    private int totalCylinder;
    private int numSectors;

    public SliceData(short s) {
        this.partition = s;
        this.startCylinder = 0;
        this.numSectors = 0;
    }

    public SliceData(short s, short s2, short s3, int n, int n2, int n3, int n4) {
        this.partition = s;
        this.tag = s2;
        this.flag = s3;
        this.startCylinder = n;
        this.endCylinder = n2;
        this.totalCylinder = n3;
        this.numSectors = n4;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(SliceData sliceData) {
        if (sliceData == null) {
            return false;
        }
        return this.getPartition() == sliceData.getPartition() && this.getTag() == sliceData.getTag() && this.getFlag() == sliceData.getFlag() && this.getStartCylinder() == sliceData.getStartCylinder() && this.getNumSectors() == sliceData.getNumSectors();
    }

    public int getEndCylinder() {
        return this.endCylinder;
    }

    public short getFlag() {
        return this.flag;
    }

    public int getNumSectors() {
        return this.numSectors;
    }

    public short getPartition() {
        return this.partition;
    }

    public int getStartCylinder() {
        return this.startCylinder;
    }

    public short getTag() {
        return this.tag;
    }

    public int getTotalCylinder() {
        return this.totalCylinder;
    }

    public void print() {
        System.out.println("*************************************");
        System.out.println("Slice Number:\t" + this.partition);
        System.out.println("Tag:\t\t\t" + this.tag);
        System.out.println("Flag:\t\t\t" + this.flag);
        System.out.println("Start Cylinder:\t" + this.startCylinder);
        System.out.println("Num Sectors:\t" + this.numSectors);
        System.out.println("*************************************");
    }

    public void setFlag(short s) {
        this.flag = s;
    }

    public void setNumSectors(int n) {
        this.numSectors = n;
    }

    public void setPartition(short s) {
        this.partition = s;
    }

    public void setStartCylinder(int n) {
        this.startCylinder = n;
    }

    public void setTag(short s) {
        this.tag = s;
    }
}

