/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.Conduits.AddressSync;

import com.sun.pdasync.Conduits.AddressSync.AddressSyncConstants;
import com.sun.pdasync.Conduits.AddressSync.AddressSyncException;
import com.sun.pdasync.Conduits.AddressSync.AddressSyncUtils;
import com.sun.pdasync.Conduits.AddressSync.SunCardWriter;
import com.sun.pdasync.SyncUtils.SyncConstants;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import palm.conduit.AbstractRecord;

public final class AddressSyncRecord
extends AbstractRecord
implements Serializable {
    public static final int MAX_NOTE_SIZE = 4096;
    public static final int MAX_VCARDFILE_SIZE = 8192;
    public static final String WORK_LABEL = "Work";
    public static final int WORK_LABEL_ID = 0;
    public static final String HOME_LABEL = "Home";
    public static final int HOME_LABEL_ID = 1;
    public static final String FAX_LABEL = "Fax";
    public static final int FAX_LABEL_ID = 2;
    public static final String OTHER_LABEL = "Other";
    public static final int OTHER_LABEL_ID = 3;
    public static final String EMAIL_LABEL = "E-mail";
    public static final int EMAIL_LABEL_ID = 4;
    public static final String MAIN_LABEL = "Main";
    public static final int MAIN_LABEL_ID = 5;
    public static final String PAGER_LABEL = "Pager";
    public static final int PAGER_LABEL_ID = 6;
    public static final String MOBILE_LABEL = "Mobile";
    public static final int MOBILE_LABEL_ID = 7;
    public static final int MAX_PHONES = 8;
    public static final int MAX_HH_PHONES = 5;
    public static final String BEGIN_VCARD = "BEGIN:VCARD";
    public static final String END_VCARD = "END:VCARD";
    private int[] phoneLabelId;
    private int displayPhone;
    private String name;
    private String firstName;
    private String company;
    private String[] phones;
    private String address;
    private String city;
    private String state;
    private String zipCode;
    private String country;
    private String[] customs;
    private String note;
    private StringBuffer valueBuffer;
    private static String[] phoneLabelText = new String[]{"Work", "Home", "Fax", "Other", "E-mail", "Main", "Pager", "Mobile"};
    private String[] phoneValues;
    long modTime;
    public String cardFilename;
    static int count = 0;

    public AddressSyncRecord() {
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        this.phoneLabelId = nArray;
        this.displayPhone = 0;
        this.name = null;
        this.firstName = null;
        this.company = null;
        this.phones = new String[]{null, null, null, null, null};
        this.address = null;
        this.city = null;
        this.state = null;
        this.zipCode = null;
        this.country = null;
        this.customs = new String[]{null, null, null, null, null};
        this.note = null;
        this.valueBuffer = null;
        this.phoneValues = new String[phoneLabelText.length];
    }

    private void appendValueBuffer(String value, boolean hasLinebreak) throws AddressSyncException {
        if (this.valueBuffer != null && this.valueBuffer.length() + value.length() + 1 >= 4096) {
            this.valueBuffer = null;
            throw new AddressSyncException(8);
        }
        if (hasLinebreak) {
            value = this.removeNewLine(value);
        }
        if (value == null) {
            if (this.valueBuffer == null) {
                this.valueBuffer = new StringBuffer(10);
            } else {
                this.valueBuffer.append('\n');
            }
        } else {
            if (this.valueBuffer == null) {
                this.valueBuffer = new StringBuffer(value);
            } else {
                this.valueBuffer.append(value);
            }
            if (hasLinebreak) {
                this.valueBuffer.append('\n');
            }
        }
    }

    public String[] categoryInfoFromCardName() {
        String cardName = this.getCardFilename();
        if (cardName == null || cardName.length() == 0) {
            return null;
        }
        String[] catInfo = new String[2];
        try {
            int lastIndex = cardName.lastIndexOf(SyncConstants.SEPARATOR);
            String dirPath = cardName.substring(0, lastIndex + 1);
            if (dirPath.equals(AddressSyncConstants.USER_OWN_VCARDS_DIR)) {
                return null;
            }
            dirPath = cardName.substring(0, lastIndex);
            int firstIndex = dirPath.lastIndexOf(SyncConstants.SEPARATOR);
            catInfo[0] = dirPath;
            catInfo[1] = cardName.substring(firstIndex + 1, lastIndex);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return null;
        }
        return catInfo;
    }

    public String categoryNameFromCardName() {
        String cardName = this.getCardFilename();
        if (cardName == null || cardName.length() == 0) {
            return null;
        }
        String cat = null;
        try {
            int lastIndex = cardName.lastIndexOf(SyncConstants.SEPARATOR);
            String dirPath = cardName.substring(0, lastIndex + 1);
            if (dirPath.equals(AddressSyncConstants.USER_OWN_VCARDS_DIR)) {
                return null;
            }
            dirPath = cardName.substring(0, lastIndex);
            int firstIndex = dirPath.lastIndexOf(SyncConstants.SEPARATOR);
            cat = cardName.substring(firstIndex + 1, lastIndex);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return null;
        }
        return cat;
    }

    public File createAddrCardFile(Vector categories, SunCardWriter scw) throws IOException {
        String cardName = AddressSyncUtils.makeUniqueCardName(this, categories);
        if (cardName == null || cardName.length() == 0) {
            throw new IOException();
        }
        this.setCardFilename(cardName);
        File file = scw.writeHardCoded(this);
        this.setModTime(file.lastModified());
        return file;
    }

    public void deleteAddrCardFile() {
        String cardName = this.getCardFilename();
        if (cardName == null || cardName.length() == 0) {
            return;
        }
        File file = new File(cardName);
        file.delete();
    }

    private boolean diffString(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return false;
        }
        if (str1 != null && str2 != null) {
            return !str1.equals(str2);
        }
        return true;
    }

    public String getAddress() {
        return this.address;
    }

    public String getCardFilename() {
        return this.cardFilename;
    }

    public String getCity() {
        return this.city;
    }

    public String getCompany() {
        return this.company;
    }

    public String getCountry() {
        return this.country;
    }

    public String getCustom(int index) {
        return this.customs[index];
    }

    public int getDisplayPhone() {
        return this.displayPhone;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public long getModTime() {
        return this.modTime;
    }

    public String getName() {
        return this.name;
    }

    public String getNote() {
        return this.note;
    }

    public String getPhone(int i) {
        return this.phones[i];
    }

    public int getPhoneLabelId(int index) {
        return this.phoneLabelId[index];
    }

    public static String getPhoneLabelText(int i) {
        if (i < 0 || i > 7) {
            i = 0;
        }
        return phoneLabelText[i];
    }

    public String getPhoneLabelValue(String label) {
        String value = null;
        if (label == null || label.length() == 0) {
            return value;
        }
        int i = 0;
        while (i < 5) {
            if (label.equals(AddressSyncRecord.getPhoneLabelText(this.getPhoneLabelId(i)))) {
                value = this.getPhone(i);
                break;
            }
            ++i;
        }
        return value;
    }

    public String getState() {
        return this.state;
    }

    public String getTitle() {
        return this.customs[0];
    }

    public String getZipCode() {
        return this.zipCode;
    }

    private boolean hasEncodedNewLine(String value) {
        return value.indexOf("=0A=") != -1;
    }

    public boolean isDifferentFrom(AddressSyncRecord rec) {
        String recValue;
        if (rec == null) {
            return true;
        }
        if (this.isNameDifferent(rec)) {
            return true;
        }
        String thisValue = this.getTitle();
        if (this.diffString(thisValue, recValue = rec.getTitle())) {
            return true;
        }
        thisValue = this.getCompany();
        if (this.diffString(thisValue, recValue = rec.getCompany())) {
            return true;
        }
        int i = 0;
        while (i < 5) {
            thisValue = this.getPhone(i);
            if (this.getPhoneLabelId(i) == rec.getPhoneLabelId(i)) {
                recValue = rec.getPhone(i);
            } else {
                int label = rec.matchPhoneLabelId(this.getPhoneLabelId(i));
                if (label != -1) {
                    recValue = rec.getPhone(label);
                } else {
                    return true;
                }
            }
            if (this.diffString(thisValue, recValue)) {
                return true;
            }
            ++i;
        }
        thisValue = this.getAddress();
        if (this.diffString(thisValue, recValue = rec.getAddress())) {
            return true;
        }
        thisValue = this.getCity();
        if (this.diffString(thisValue, recValue = rec.getCity())) {
            return true;
        }
        thisValue = this.getState();
        if (this.diffString(thisValue, recValue = rec.getState())) {
            return true;
        }
        thisValue = this.getZipCode();
        if (this.diffString(thisValue, recValue = rec.getZipCode())) {
            return true;
        }
        thisValue = this.getCountry();
        if (this.diffString(thisValue, recValue = rec.getCountry())) {
            return true;
        }
        thisValue = this.getNote();
        if (this.diffString(thisValue, recValue = rec.getNote())) {
            return true;
        }
        int i2 = 1;
        while (i2 < 5) {
            thisValue = this.getCustom(i2);
            if (this.diffString(thisValue, recValue = rec.getCustom(i2))) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    private boolean isNameDifferent(AddressSyncRecord rec) {
        String recName;
        if (rec == null) {
            return true;
        }
        String thisName = this.getName();
        if (this.diffString(thisName, recName = rec.getName())) {
            return true;
        }
        thisName = this.getFirstName();
        return this.diffString(thisName, recName = rec.getFirstName());
    }

    private boolean isNote(String field) {
        return field.startsWith("NOTE") || field.startsWith("note");
    }

    public int matchPhoneLabelId(int labelId) {
        int i = 0;
        while (i < this.phoneLabelId.length) {
            if (this.phoneLabelId[i] == labelId) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean parseLine(String line, String[] parms) {
        String field = null;
        String value = null;
        StringTokenizer fieldTokenizer = new StringTokenizer(line, ":", false);
        if (fieldTokenizer.countTokens() == 0) {
            return false;
        }
        field = fieldTokenizer.nextToken();
        StringTokenizer fieldNameTokenizer = new StringTokenizer(field, ";", false);
        if (fieldNameTokenizer.countTokens() == 0) {
            return false;
        }
        String fieldName = fieldNameTokenizer.nextToken();
        if (AddressSyncUtils.isValidField(fieldName)) {
            int index = line.indexOf(58);
            if (index == -1) {
                return false;
            }
            value = line.substring(index + 1);
            index = 0;
            while (index < value.length()) {
                if (value.charAt(index) != ' ' && value.charAt(index) != '\t') break;
                ++index;
            }
            if (index != 0) {
                value = value.substring(index);
            }
        } else {
            return false;
        }
        parms[0] = field;
        parms[1] = value;
        return true;
    }

    public void populateFromAddrCard() throws Exception {
        LineNumberReader lnr;
        FileReader fr;
        if (this.cardFilename == null || this.cardFilename.length() == 0) {
            throw new IOException();
        }
        File file = new File(this.cardFilename);
        if (!file.exists()) {
            throw new IOException();
        }
        if (file.length() > 8192L) {
            throw new AddressSyncException(7);
        }
        try {
            fr = new FileReader(file);
            lnr = new LineNumberReader(fr);
        }
        catch (FileNotFoundException fne) {
            throw fne;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        String line = lnr.readLine();
        if (line == null || !line.startsWith(BEGIN_VCARD) && !line.startsWith(BEGIN_VCARD.toLowerCase())) {
            throw new AddressSyncException(6);
        }
        this.valueBuffer = null;
        String[] parms = new String[2];
        String prevField = null;
        boolean newlineFlag = false;
        while ((line = lnr.readLine()) != null) {
            if (line.startsWith(END_VCARD) || line.startsWith(END_VCARD.toLowerCase())) break;
            boolean validMapping = this.parseLine(line, parms);
            if (validMapping) {
                newlineFlag = this.hasEncodedNewLine(parms[1]);
                if (!newlineFlag) {
                    this.setCorrespondingField(parms[0], parms[1]);
                    continue;
                }
                prevField = parms[0];
                this.valueBuffer = null;
                this.appendValueBuffer(parms[1], true);
                continue;
            }
            if (!newlineFlag || prevField == null) continue;
            newlineFlag = this.hasEncodedNewLine(line);
            this.appendValueBuffer(line, newlineFlag);
            if (newlineFlag) continue;
            if (this.isNote(prevField)) {
                this.setNote(this.valueBuffer);
            } else {
                this.setCorrespondingField(prevField, this.valueBuffer.toString());
            }
            prevField = null;
        }
        lnr.close();
        fr.close();
        this.setHHphoneFields();
        this.setDefaultDisplayPhone();
    }

    public void populateFromAddrCard(String cardName) throws Exception {
        this.setCardFilename(cardName);
        this.populateFromAddrCard();
    }

    public void readData(DataInputStream dins) throws IOException {
        int options = dins.readInt();
        int i = 0;
        while (i < 5) {
            this.phoneLabelId[i] = options & 0xF;
            options >>>= 4;
            ++i;
        }
        this.displayPhone = (options & 0xF) + 1;
        int flags = dins.readInt();
        dins.read();
        this.name = (flags & 1) == 1 ? AbstractRecord.readCString((DataInputStream)dins) : null;
        this.firstName = ((flags >>>= 1) & 1) == 1 ? AbstractRecord.readCString((DataInputStream)dins) : null;
        this.company = ((flags >>>= 1) & 1) == 1 ? AbstractRecord.readCString((DataInputStream)dins) : null;
        flags >>>= 1;
        i = 0;
        while (i < 5) {
            this.phones[i] = (flags & 1) == 1 ? AbstractRecord.readCString((DataInputStream)dins) : null;
            flags >>>= 1;
            ++i;
        }
        this.address = (flags & 1) == 1 ? AbstractRecord.readCString((DataInputStream)dins) : null;
        this.city = ((flags >>>= 1) & 1) == 1 ? AbstractRecord.readCString((DataInputStream)dins) : null;
        this.state = ((flags >>>= 1) & 1) == 1 ? AbstractRecord.readCString((DataInputStream)dins) : null;
        this.zipCode = ((flags >>>= 1) & 1) == 1 ? AbstractRecord.readCString((DataInputStream)dins) : null;
        this.country = ((flags >>>= 1) & 1) == 1 ? AbstractRecord.readCString((DataInputStream)dins) : null;
        flags >>>= 1;
        i = 0;
        while (i < 5) {
            this.customs[i] = (flags & 1) == 1 ? AbstractRecord.readCString((DataInputStream)dins) : null;
            flags >>>= 1;
            ++i;
        }
        this.note = (flags & 1) == 1 ? AbstractRecord.readCString((DataInputStream)dins) : null;
        flags >>>= 1;
    }

    private String removeNewLine(String line) {
        int index = line.indexOf("=0A=");
        if (index != -1) {
            if (line.equals("=0A=")) {
                return null;
            }
            return line.substring(0, index);
        }
        return line;
    }

    public void setAddress(String address) {
        this.address = this.sunwNullIfEmpty(address);
    }

    public void setCardFilename(String fileName) {
        this.cardFilename = null;
        this.cardFilename = fileName;
    }

    public void setCity(String city) {
        this.city = this.sunwNullIfEmpty(city);
    }

    public void setCompany(String company) {
        this.company = this.sunwNullIfEmpty(company);
    }

    private void setCorrespondingAddressValue(String value) {
        String token = "";
        StringTokenizer trueTokenizer = new StringTokenizer(value, ";", true);
        try {
            token = trueTokenizer.nextToken();
            String token2 = trueTokenizer.nextToken();
            if (!token2.equals(";")) {
                token = trueTokenizer.nextToken();
            }
            if ((token = trueTokenizer.nextToken()).equals(";")) {
                token = trueTokenizer.nextToken();
            }
            this.setAddress(AddressSyncUtils.nullIfSemicolon(token));
            token = trueTokenizer.nextToken();
            if (token.equals(";")) {
                token = trueTokenizer.nextToken();
            }
            this.setCity(AddressSyncUtils.nullIfSemicolon(token));
            token = trueTokenizer.nextToken();
            if (token.equals(";")) {
                token = trueTokenizer.nextToken();
            }
            this.setState(AddressSyncUtils.nullIfSemicolon(token));
            token = trueTokenizer.nextToken();
            if (token.equals(";")) {
                token = trueTokenizer.nextToken();
            }
            this.setZipCode(AddressSyncUtils.nullIfSemicolon(token));
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    private void setCorrespondingField(String addrMgrField, String value) {
        if (addrMgrField == null || addrMgrField.length() == 0 || value == null || value.length() == 0 || value.equals(";")) {
            return;
        }
        if (addrMgrField.equals("N") || addrMgrField.equals("N".toLowerCase())) {
            this.setCorrespondingFirstAndlastName(value);
        } else if (addrMgrField.startsWith("TITLE") || addrMgrField.startsWith("TITLE".toLowerCase())) {
            this.setTitle(value);
        } else if (addrMgrField.startsWith("ORG") || addrMgrField.startsWith("ORG".toLowerCase())) {
            this.setCompany(value);
        } else if (addrMgrField.startsWith("EMAIL;INTERNET") || addrMgrField.startsWith("EMAIL;INTERNET".toLowerCase())) {
            this.setEmailValue(value);
        } else if (addrMgrField.startsWith("TEL") || addrMgrField.startsWith("TEL".toLowerCase())) {
            this.setCorrespondingPhoneValue(addrMgrField, value);
        } else if (addrMgrField.startsWith("ADR;WORK") || addrMgrField.startsWith("ADR;WORK".toLowerCase())) {
            this.setCorrespondingAddressValue(value);
        } else if (addrMgrField.startsWith("NOTE") || addrMgrField.startsWith("NOTE".toLowerCase())) {
            this.setNote(value);
        } else if (addrMgrField.startsWith("X-PalmPilot-Custom1")) {
            this.setCustom(1, value);
        } else if (addrMgrField.startsWith("X-PalmPilot-Custom2")) {
            this.setCustom(2, value);
        } else if (addrMgrField.startsWith("X-PalmPilot-Custom3")) {
            this.setCustom(3, value);
        } else if (addrMgrField.startsWith("X-PalmPilot-Custom4")) {
            this.setCustom(4, value);
        } else if (addrMgrField.startsWith("X-PalmPilot-Country")) {
            this.setCountry(value);
        } else if (addrMgrField.startsWith("X-PalmPilot-Other")) {
            this.setOtherPhoneValue(value);
        } else if (addrMgrField.startsWith("X-PalmPilot-MainPhone")) {
            this.setMainPhoneValue(value);
        }
    }

    private void setCorrespondingFirstAndlastName(String value) {
        String token = "";
        StringTokenizer trueTokenizer = new StringTokenizer(value, ";", true);
        try {
            token = trueTokenizer.nextToken();
            if (token.equals(";")) {
                token = trueTokenizer.nextToken();
            }
            this.setName(AddressSyncUtils.nullIfSemicolon(token));
            token = trueTokenizer.nextToken();
            if (token.equals(";")) {
                token = trueTokenizer.nextToken();
            }
            this.setFirstName(AddressSyncUtils.nullIfSemicolon(token));
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    private void setCorrespondingPhoneValue(String field, String value) {
        String validValue = AddressSyncUtils.nullIfSemicolon(value);
        StringTokenizer falseTokenizer = new StringTokenizer(field, ";", false);
        try {
            String token = falseTokenizer.nextToken();
            token = falseTokenizer.nextToken();
            if (token.indexOf("WORK") != -1) {
                this.setPhoneValue(0, validValue);
            } else if (token.indexOf("HOME") != -1) {
                this.setPhoneValue(1, validValue);
            } else if (token.indexOf("FAX") != -1) {
                this.setPhoneValue(2, validValue);
            } else if (token.indexOf("PAGER") != -1) {
                this.setPhoneValue(6, validValue);
            } else if (token.indexOf("CELL") != -1) {
                this.setPhoneValue(7, validValue);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    public void setCountry(String country) {
        this.country = this.sunwNullIfEmpty(country);
    }

    public void setCustom(int index, String custom) {
        this.customs[index] = this.sunwNullIfEmpty(custom);
    }

    private void setDefaultDisplayPhone() {
        int i = 0;
        while (i < 5) {
            if (this.getPhoneLabelValue(phoneLabelText[i]) != null) {
                this.displayPhone = i + 1;
                break;
            }
            ++i;
        }
    }

    public void setDisplayPhone(int displayPhone) {
        this.displayPhone = displayPhone;
    }

    private void setEmailValue(String value) {
        String validValue = AddressSyncUtils.nullIfSemicolon(value);
        this.setPhoneValue(4, validValue);
    }

    public void setFirstName(String firstName) {
        this.firstName = this.sunwNullIfEmpty(firstName);
    }

    private void setHHphoneFields() {
        int i = 0;
        while (i < 5) {
            this.phoneLabelId[i] = i;
            this.phones[i] = this.phoneValues[i];
            ++i;
        }
        i = 5;
        while (i < 8) {
            if (this.phoneValues[i] != null) {
                int j = 0;
                while (j < 5) {
                    if (this.phones[j] == null) {
                        this.phoneLabelId[j] = i;
                        this.phones[j] = this.phoneValues[i];
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void setMainPhoneValue(String value) {
        String validValue = AddressSyncUtils.nullIfSemicolon(value);
        this.setPhoneValue(5, validValue);
    }

    public void setModTime(long modtime) {
        this.modTime = modtime;
    }

    public void setName(String name) {
        this.name = this.sunwNullIfEmpty(name);
    }

    public void setNote(String note) {
        this.note = this.sunwNullIfEmpty(note);
    }

    public void setNote(StringBuffer buffer) {
        this.note = buffer.length() == 0 ? null : buffer.toString();
    }

    private void setOtherPhoneValue(String value) {
        String validValue = AddressSyncUtils.nullIfSemicolon(value);
        this.setPhoneValue(3, validValue);
    }

    public void setPhone(int index, String phone) {
        this.phones[index] = this.sunwNullIfEmpty(phone);
    }

    public void setPhoneLabelId(int index, int phone) {
        this.phoneLabelId[index] = phone;
    }

    public void setPhoneValue(int labelId, String value) {
        if (labelId >= 0 && labelId < 8) {
            this.phoneValues[labelId] = value;
        }
    }

    public void setState(String state) {
        this.state = this.sunwNullIfEmpty(state);
    }

    public void setTitle(String title) {
        this.setCustom(0, title);
    }

    public void setZipCode(String zipCode) {
        this.zipCode = this.sunwNullIfEmpty(zipCode);
    }

    public String toFormattedString() {
        int id = this.getDisplayPhone();
        id = id == 0 ? id : id - 1;
        return "AddressSync record: \n {\n   name:      " + this.getName() + "\n" + "   firstName: " + this.getFirstName() + "\n" + "   title:     " + this.getTitle() + "\n" + "   company:   " + this.getCompany() + "\n" + "   " + AddressSyncRecord.getPhoneLabelText(this.getPhoneLabelId(0)) + ":      " + this.getPhone(0) + "\n" + "   " + AddressSyncRecord.getPhoneLabelText(this.getPhoneLabelId(1)) + ":      " + this.getPhone(1) + "\n" + "   " + AddressSyncRecord.getPhoneLabelText(this.getPhoneLabelId(2)) + ":       " + this.getPhone(2) + "\n" + "   " + AddressSyncRecord.getPhoneLabelText(this.getPhoneLabelId(3)) + ":     " + this.getPhone(3) + "\n" + "   " + AddressSyncRecord.getPhoneLabelText(this.getPhoneLabelId(4)) + ":    " + this.getPhone(4) + "\n" + "   dispPhone: " + AddressSyncRecord.getPhoneLabelText(id) + "\n" + "   address:   " + this.getAddress() + "\n" + "   city:      " + this.getCity() + "\n" + "   state:     " + this.getState() + "\n" + "   zipCode:   " + this.getZipCode() + "\n" + "   country:   " + this.getCountry() + "\n" + "   custom1:   " + this.getCustom(1) + "\n" + "   custom2:   " + this.getCustom(2) + "\n" + "   custom3:   " + this.getCustom(3) + "\n" + "   custom4:   " + this.getCustom(4) + "\n" + "   note:      " + this.getNote() + "\n" + "   card:      " + this.getCardFilename() + "\n" + "   modTime:   " + this.getModTime() + "\n" + " }\n" + super.toFormattedString();
    }

    public String toShortFormatted() {
        int id = this.getDisplayPhone();
        id = id == 0 ? id : id - 1;
        return "AddressSync record: \n {\n   name:      " + this.getName() + "\n" + "   firstName: " + this.getFirstName() + "\n" + "   dispPhone: " + AddressSyncRecord.getPhoneLabelText(id) + "\n" + "   card:      " + this.getCardFilename() + "\n" + "   modTime:   " + this.getModTime() + "\n" + " }\n" + super.toFormattedString();
    }

    public String toString() {
        if (this.getFirstName() != null || this.getName() != null) {
            return "Address record: " + this.getFirstName() + " " + this.getName() + " " + super.toString();
        }
        if (this.getCompany() != null) {
            return "Address record: " + this.getCompany() + " " + super.toString();
        }
        if (this.getTitle() != null) {
            return "Address record: " + this.getTitle() + " " + super.toString();
        }
        return "Address record: " + super.toString();
    }

    public void writeData(DataOutputStream out) throws IOException {
        int offset;
        int options = (this.displayPhone & 0xF) - 1;
        int i = 5;
        i = 0;
        while (i < 5) {
            options <<= 4;
            options |= this.phoneLabelId[4 - i] & 0xF;
            ++i;
        }
        out.writeInt(options);
        int flags = 0;
        if (this.note != null) {
            flags |= 1;
        }
        flags <<= 1;
        i = 5;
        while (i-- > 0) {
            if (this.customs[i] != null) {
                flags |= 1;
            }
            flags <<= 1;
        }
        if (this.country != null) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.zipCode != null) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.state != null) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.city != null) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.address != null) {
            flags |= 1;
        }
        flags <<= 1;
        i = 5;
        while (i-- > 0) {
            if (this.phones[i] != null) {
                flags |= 1;
            }
            flags <<= 1;
        }
        if (this.company != null) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.firstName != null) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.name != null) {
            flags |= 1;
        }
        out.writeInt(flags);
        if (this.company != null) {
            int len = 1;
            if (this.name != null) {
                len += this.name.length() + 1;
            }
            if (this.firstName != null) {
                len += this.firstName.length() + 1;
            }
            offset = (byte)(len & 0xFF);
        } else {
            offset = 0;
        }
        out.write(offset);
        if (this.name != null) {
            out.write(this.name.getBytes());
            out.write(0);
        }
        if (this.firstName != null) {
            out.write(this.firstName.getBytes());
            out.write(0);
        }
        if (this.company != null) {
            out.write(this.company.getBytes());
            out.write(0);
        }
        i = 0;
        while (i < 5) {
            if (this.phones[i] != null) {
                out.write(this.phones[i].getBytes());
                out.write(0);
            }
            ++i;
        }
        if (this.address != null) {
            out.write(this.address.getBytes());
            out.write(0);
        }
        if (this.city != null) {
            out.write(this.city.getBytes());
            out.write(0);
        }
        if (this.state != null) {
            out.write(this.state.getBytes());
            out.write(0);
        }
        if (this.zipCode != null) {
            out.write(this.zipCode.getBytes());
            out.write(0);
        }
        if (this.country != null) {
            out.write(this.country.getBytes());
            out.write(0);
        }
        i = 0;
        while (i < 5) {
            if (this.customs[i] != null) {
                out.write(this.customs[i].getBytes());
                out.write(0);
            }
            ++i;
        }
        if (this.note != null) {
            AbstractRecord.writeCString((DataOutputStream)out, (String)AbstractRecord.sunwStringWithoutCarriageReturns((String)this.note));
        }
    }
}

