/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.Conduits.AddressSync;

import com.sun.pdasync.Conduits.AddressSync.AddressSyncConstants;
import com.sun.pdasync.Conduits.AddressSync.AddressSyncException;
import com.sun.pdasync.Conduits.AddressSync.AddressSyncProperties;
import com.sun.pdasync.Conduits.AddressSync.AddressSyncPropsUI;
import com.sun.pdasync.Conduits.AddressSync.AddressSyncRecMgr;
import com.sun.pdasync.Conduits.AddressSync.AddressSyncUtils;
import com.sun.pdasync.Conduits.AddressSync.AddressSyncWriter;
import com.sun.pdasync.Conduits.Utils.DesktopManager;
import com.sun.pdasync.Conduits.Utils.SUNWCatManager;
import com.sun.pdasync.SyncUtils.SyncUtils;
import java.awt.Dialog;
import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import palm.conduit.Conduit;
import palm.conduit.ConfigureConduitInfo;
import palm.conduit.Record;
import palm.conduit.SyncException;
import palm.conduit.SyncManager;
import palm.conduit.SyncProperties;

public final class AddressSyncConduit
implements Conduit,
Serializable {
    private static Locale theLocale;
    private static ResourceBundle addrRes;
    Class recordClass;
    AddressSyncWriter writer;
    AddressSyncRecMgr recordMgr;
    SUNWCatManager categoryMgr;
    Vector dtRecords;
    Vector cardRecords;
    Vector hhRecords;
    Vector archiveRecords;
    Vector dtCategories;
    Vector cardCategories;
    Vector hhCategories;
    int pilotDB;
    SyncProperties syncProps;
    private AddressSyncProperties addrSyncProps = new AddressSyncProperties();
    private AddressSyncPropsUI addrPropsUI;

    static {
        try {
            theLocale = Locale.getDefault();
            String resName = "com.sun.pdasync.ListResourceBundle.AddressSyncConduitMessages";
            AddressSyncWriter.addrRes = addrRes = ResourceBundle.getBundle(resName, theLocale);
        }
        catch (MissingResourceException e) {
            System.err.println("PDASync: can't find properties");
            System.err.println("PDASync:" + e.getMessage());
        }
    }

    private void closePilotDB() {
        block2: {
            if (this.pilotDB == -1) break block2;
            try {
                SyncManager.closeDB((int)this.pilotDB);
                this.pilotDB = -1;
            }
            catch (Exception exception) {}
        }
    }

    public int configure(ConfigureConduitInfo info) {
        if (this.addrPropsUI == null) {
            this.addrPropsUI = new AddressSyncPropsUI(SyncUtils.getParentOfAllConduits(), this.addrSyncProps);
        }
        ((Dialog)((Object)this.addrPropsUI)).show();
        info.syncPermanent = this.addrSyncProps.addressModifies ? 3 : (this.addrSyncProps.pilotModifies ? 2 : 0);
        info.syncTemporary = info.syncPermanent;
        return 0;
    }

    private void doNothing() {
        AddressSyncUtils.doLog(addrRes.getString("do nothing"));
        this.closePilotDB();
    }

    public String name() {
        try {
            return addrRes.getString("Address");
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public void open(SyncProperties props) {
        block37: {
            this.pilotDB = -1;
            this.syncProps = props;
            try {
                this.syncProps.syncType = this.syncDirection(this.syncProps);
            }
            catch (AddressSyncException ase) {
                AddressSyncUtils.doDebug(String.valueOf(ase.getMessage()) + " " + this.syncProps.syncType);
                return;
            }
            if (this.syncProps.syncType == 6) {
                this.doNothing();
                return;
            }
            this.archiveRecords = new Vector();
            this.writer = new AddressSyncWriter(this.syncProps.localName);
            try {
                AddressSyncWriter.createLocalVCardSchema();
            }
            catch (Exception e) {
                AddressSyncUtils.doDebug("Error in creating VCard Schema -- " + e.getMessage());
            }
            try {
                this.writer.addPalmPilotFieldsToSchema();
            }
            catch (Exception e) {
                AddressSyncUtils.doDebug("Error in adding palm fields to VCard Schema -- " + e.getMessage());
            }
            try {
                this.pilotDB = SyncManager.openDB((String)this.syncProps.remoteNames[0], (int)0, (int)224);
            }
            catch (SyncException e) {
                if (e.errorCode != 16387 || this.syncProps.syncType == 2) break block37;
                try {
                    this.pilotDB = SyncManager.createDB((int)this.syncProps.creator, (int)0, (int)this.syncProps.cardNo, (String)this.syncProps.remoteNames[0], (int)this.syncProps.dbType);
                }
                catch (SyncException se) {
                    AddressSyncUtils.doDebug(se.getMessage());
                    return;
                }
            }
        }
        try {
            int recCount;
            this.recordClass = Class.forName("com.sun.pdasync.Conduits.AddressSync.AddressSyncRecord");
            this.categoryMgr = new SUNWCatManager(this.syncProps, this.pilotDB, (DesktopManager)this.writer);
            this.recordMgr = new AddressSyncRecMgr(this.syncProps, this.pilotDB, this.recordClass, this.writer);
            if (this.syncProps.syncType == 2 && (recCount = SyncManager.getDBRecordCount((int)this.pilotDB)) == 0) {
                this.syncProps.syncType = 3;
            }
            if (this.syncProps.syncType == 2) {
                this.dtRecords = this.recordMgr.copyHHRecords();
                if (this.dtRecords != null && this.dtRecords.size() > 0) {
                    this.writer.removeAllDtVCards();
                    this.hhCategories = this.categoryMgr.getHHCategories();
                    this.categoryMgr.copyHHCategoryToPC(this.hhCategories);
                    this.writer.setLocalCategories(this.hhCategories);
                    AddressSyncUtils.nameFreshRecords(this.dtRecords, this.hhCategories);
                    this.writer.createDtVCards(this.dtRecords);
                    AddressSyncUtils.doLog(addrRes.getString("copied handheld records to desktop"));
                } else {
                    AddressSyncUtils.doLog(addrRes.getString("SYNC_HH_TO_PC: empty HH, do nothing"));
                }
            } else {
                if (this.syncProps.syncType == 3) {
                    this.writer.removeLocalDBFile();
                } else {
                    this.writer.openLocalDB();
                }
                this.dtCategories = this.writer.getLocalCategories();
                this.dtRecords = this.writer.getLocalRecords();
                if ((this.dtRecords == null || this.dtRecords.size() == 0) && this.syncProps.syncType == 0) {
                    this.syncProps.syncType = 1;
                }
                this.cardRecords = new Vector();
                Vector emptyCategories = new Vector();
                this.writer.makeRecordsOutOfCardFiles(this.cardRecords, emptyCategories, AddressSyncConstants.USER_OWN_VCARDS_DIR);
                AddressSyncUtils.doDebug("cardRecords.size = " + this.cardRecords.size());
                AddressSyncUtils.doDebug("emptyCategories.size = " + emptyCategories.size());
                this.cardCategories = this.writer.makeCategoriesOutOfCardRecords(this.cardRecords);
                if (this.cardCategories == null) {
                    this.cardCategories = new Vector();
                }
                int i = 0;
                while (i < emptyCategories.size()) {
                    this.cardCategories.addElement(emptyCategories.elementAt(i));
                    ++i;
                }
                AddressSyncUtils.doDebug("cardCategories.size = " + (this.cardCategories == null ? 0 : this.cardCategories.size()));
                this.dtCategories = this.categoryMgr.synchronize(this.cardCategories, this.dtCategories);
                this.writer.setLocalCategories(this.dtCategories);
                this.writer.setDtVCardRecsCategory(this.cardRecords);
                this.writer.mergeDtVCardRecords(this.cardRecords);
                AddressSyncUtils.doDebug("After merge records, dtRecords.size = " + (this.dtRecords == null ? 0 : this.dtRecords.size()));
                switch (this.syncProps.syncType) {
                    case 0: {
                        AddressSyncUtils.doLog(addrRes.getString("performing fast synchronization"));
                        this.recordMgr.fastSyncData(this.dtRecords, this.archiveRecords);
                        break;
                    }
                    case 1: {
                        Vector buRecs = this.writer.getBackupRecords();
                        AddressSyncUtils.doLog(addrRes.getString("performing slow synchronization"));
                        this.dtRecords = this.recordMgr.slowSyncData(this.dtRecords, this.archiveRecords, buRecs);
                        break;
                    }
                    case 3: {
                        if (this.cardRecords.size() == 0) {
                            this.dtRecords = this.recordMgr.copyHHRecords();
                            if (this.dtRecords != null && this.dtRecords.size() > 0) {
                                AddressSyncUtils.nameFreshRecords(this.dtRecords, this.dtCategories);
                                this.writer.createDtVCards(this.dtRecords);
                                AddressSyncUtils.doLog(addrRes.getString("copied handheld records to desktop"));
                                break;
                            }
                            AddressSyncUtils.doLog(addrRes.getString("SYNC_HH_TO_PC: empty HH, do nothing"));
                            break;
                        }
                        try {
                            SyncManager.purgeAllRecs((int)this.pilotDB);
                        }
                        catch (SyncException se) {
                            se.printStackTrace();
                        }
                        int i2 = 0;
                        while (i2 < this.dtRecords.size()) {
                            Record tmpRec = (Record)this.dtRecords.elementAt(i2);
                            if (tmpRec.isDeleted()) {
                                this.dtRecords.removeElementAt(i2);
                                continue;
                            }
                            ++i2;
                        }
                        try {
                            this.dtRecords = this.recordMgr.copyPCRecords(this.dtRecords);
                            AddressSyncUtils.doLog(addrRes.getString("copied desktop records to handheld"));
                        }
                        catch (SyncException se) {
                            if (se.errorCode == 16404) {
                                AddressSyncUtils.doLog(String.valueOf(addrRes.getString("Handheld is out of memory: error writing record")) + addrRes.getString(" - some desktop records have not been copied to handheld."));
                                break;
                            }
                            AddressSyncUtils.doLog(String.valueOf(se.getMessage()) + addrRes.getString(" - some desktop records have not been copied to handheld."));
                        }
                        break;
                    }
                }
            }
            this.writer.setLocalCategories(this.dtCategories);
            this.writer.setLocalRecords(this.dtRecords);
            this.writer.updateRenamedCategories();
            this.closePilotDB();
            this.writer.writeLocalDB();
        }
        catch (Throwable t) {
            this.closePilotDB();
            t.printStackTrace();
        }
    }

    private int syncDirection(SyncProperties syncProps) throws AddressSyncException {
        int errorType = 0;
        int syncType = syncProps.syncType;
        if (syncProps.syncType == 5) {
            syncType = 2;
        } else if (syncProps.syncType == 7) {
            syncType = 3;
        } else if (syncProps.syncType < -1 || syncProps.syncType > 8) {
            errorType = 5;
        }
        if (errorType != 0) {
            throw new AddressSyncException(errorType);
        }
        return syncType;
    }
}

