/*
 * Decompiled with CFR 0.152.
 */
package com.scmmicro.smartos.util;

public class Buffer {
    private int m_nLength;
    private int m_nCapacity;
    private byte[] m_rData;

    public Buffer(int n) {
        this.m_rData = new byte[n];
        this.m_nCapacity = n;
        this.m_nLength = 0;
    }

    public Buffer(byte[] byArray) {
        this.m_nCapacity = this.m_nLength = byArray.length;
        this.m_rData = new byte[this.m_nLength];
        this.copy_(0, this.m_nLength, byArray);
    }

    public Buffer(byte[] byArray, int n) {
        this.m_nLength = byArray.length <= n ? byArray.length : n;
        this.m_nCapacity = n;
        this.m_rData = new byte[this.m_nCapacity];
        this.copy_(0, this.m_nLength, byArray);
    }

    public void appendBytes(int n, byte[] byArray) throws ArrayIndexOutOfBoundsException {
        if (this.m_nLength + n > this.m_nCapacity) {
            this.setCapacity(this.m_nLength + n);
        }
        this.copy_(this.m_nLength, n, byArray);
        this.m_nLength += n;
    }

    private void copy_(int n, int n2, byte[] byArray) {
        int n3 = 0;
        int n4 = n;
        while (n3 < n2) {
            this.m_rData[n4] = byArray[n3];
            ++n3;
            ++n4;
        }
    }

    public void flushBytes(int n) throws ArrayIndexOutOfBoundsException {
        if (n > this.m_nCapacity) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n2 = 0;
        while (n2 < this.m_nLength - n) {
            this.m_rData[n2] = this.m_rData[n2 + n];
            ++n2;
        }
        this.m_nLength -= n;
    }

    public byte getByte(int n) throws ArrayIndexOutOfBoundsException {
        if (n > this.m_nCapacity - 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.m_rData[n];
    }

    public int getCapacity() {
        return this.m_nCapacity;
    }

    public byte[] getData() {
        return this.m_rData;
    }

    public int getLength() {
        return this.m_nLength;
    }

    public void setByte(int n, byte by) throws ArrayIndexOutOfBoundsException {
        if (n > this.m_nCapacity - 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.m_rData[n] = by;
    }

    public void setCapacity(int n) throws ArrayIndexOutOfBoundsException {
        if (n < this.m_nLength) {
            throw new ArrayIndexOutOfBoundsException();
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < this.m_nLength) {
            byArray[n2] = this.m_rData[n2];
            ++n2;
        }
        this.m_rData = byArray;
        this.m_nCapacity = n;
    }

    public void setData(byte[] byArray) {
        this.m_nCapacity = this.m_nLength = byArray.length;
        this.m_rData = new byte[this.m_nLength];
        this.copy_(0, this.m_nLength, byArray);
    }

    public void setData(byte[] byArray, int n) {
        this.m_nCapacity = this.m_nLength = n;
        this.m_rData = new byte[this.m_nLength];
        this.copy_(0, this.m_nLength, byArray);
    }

    public void setLength(int n) throws ArrayIndexOutOfBoundsException {
        if (n > this.m_nCapacity) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.m_nLength = n;
    }
}

