/*
 * Decompiled with CFR 0.152.
 */
package com.scmmicro.smartos.core;

import com.scmmicro.smartos.core.Parameters;
import com.scmmicro.smartos.core.Session;
import com.scmmicro.smartos.exceptions.BadParameterException;
import com.scmmicro.smartos.exceptions.BadParameterValueException;
import com.scmmicro.smartos.exceptions.CardException;
import com.scmmicro.smartos.exceptions.CommunicationException;
import com.scmmicro.smartos.exceptions.TimeOutException;
import com.scmmicro.smartos.physical.Drive;
import com.scmmicro.smartos.util.Buffer;

public abstract class ATR {
    protected Session m_rSession;
    static final byte FREQ_DIV = 1;
    static final int FREQ = 3580;
    static final boolean NEGOCIABLE = false;
    static final boolean SPECIFIC = true;
    static final byte DEFAULT_Dl = 1;
    static final byte DEFAULT_Fl = 1;
    static final byte DEFAULT_Xl = 0;
    static final byte DEFAULT_Cl = 1;
    static final byte DEFAULT_I1 = 0;
    static final byte DEFAULT_P11 = 5;
    static final byte DEFAULT_P12 = 50;
    static final byte DEFAULT_N = 0;
    static final byte DEFAULT_WI = 10;
    static final byte DEFAULT_CWI = 13;
    static final short DEFAULT_CGT = 13;
    static final short DEFAULT_BWI = 4;
    static final short DEFAULT_ETULength = 372;
    static final long DEFAULT_CWT = 3571200L;
    static final long DEFAULT_BWT = 62853120L;
    static final long DEFAULT_IWT = 3571200L;
    static final byte ATR_OFF = 1;
    static final byte ATR_ON = 2;
    static final boolean LRC = false;
    static final boolean CRC = true;
    static final byte PTS_SIZE = 4;
    static final byte TAx = 1;
    static final byte TBx = 2;
    static final byte TCx = 4;
    static final byte TDx = 8;
    static final byte MAX_ATR_BYTES = 32;
    static final byte CARD_ACT = 2;
    static final byte CL_NOCARD = 0;
    static final byte CL_T0PROTOCOL = 1;
    static final byte CL_T1PROTOCOL = 2;
    static final byte CL_T14PROTOCOL = 3;
    static final byte CL_SYNCPROTOCOL = 4;
    static final byte CL_OK = 0;
    static final byte CL_ERR_ATR = -30;
    static final byte T0 = 0;
    static final byte T1 = 1;
    static final byte T14 = 14;
    static final byte T15 = 15;
    static final short[] COMToETU = new short[]{372, 186, 186, 93, 62, 31};
    static final byte[] DlToDi;
    static final short[] FlToCycles;
    protected byte Protocol;
    protected byte SpecProt;
    protected byte TD1Protocol;
    protected byte Dl;
    protected byte Fl;
    protected byte Xl;
    protected byte Cl;
    protected byte Il;
    protected byte Pl1;
    protected byte Pl2;
    protected byte EGT;
    protected byte WI;
    protected byte CWI;
    protected short BWI;
    protected short IFSC;
    protected short ETULength;
    protected short CGT;
    protected long IWT;
    protected boolean Mode;
    protected boolean ModifMode;
    protected boolean DefPar;
    protected boolean ATR_Edc;
    protected boolean Conv;
    protected boolean PTS_Enable;
    protected long CWT;
    protected long BWT;

    static {
        byte[] byArray = new byte[10];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 4;
        byArray[4] = 8;
        byArray[5] = 16;
        byArray[6] = 32;
        byArray[8] = 12;
        byArray[9] = 20;
        DlToDi = byArray;
        short[] sArray = new short[16];
        sArray[0] = 372;
        sArray[1] = 372;
        sArray[2] = 558;
        sArray[3] = 744;
        sArray[4] = 1116;
        sArray[5] = 1488;
        sArray[6] = 1860;
        sArray[9] = 512;
        sArray[10] = 768;
        sArray[11] = 1024;
        sArray[12] = 1536;
        sArray[13] = 2048;
        FlToCycles = sArray;
    }

    public ATR() {
        this.initAtr();
    }

    protected void initAtr() {
        this.Dl = 1;
        this.Fl = 1;
        this.Xl = 0;
        this.Cl = 1;
        this.Il = 0;
        this.Pl1 = (byte)5;
        this.Pl2 = (byte)50;
        this.EGT = 0;
        this.WI = (byte)10;
        this.CWI = (byte)13;
        this.BWI = (short)4;
        this.CWT = 3571200L;
        this.BWT = 62853120L;
        this.IWT = 3571200L;
        this.Mode = false;
        this.ModifMode = false;
        this.DefPar = false;
        this.Protocol = 0;
        this.SpecProt = 0;
        this.TD1Protocol = 0;
        this.ATR_Edc = false;
        this.ETULength = (short)372;
        this.CGT = (short)13;
        this.Conv = false;
        this.IFSC = (short)254;
    }

    protected abstract byte postPTS();

    void pts(Drive drive) throws CommunicationException, CardException, TimeOutException {
        byte by = 0;
        int n = 0;
        int n2 = 4;
        Buffer buffer = new Buffer(4);
        Buffer buffer2 = new Buffer(4);
        this.Dl = this.m_rSession.getParameters().CLP_Dl;
        this.Fl = this.m_rSession.getParameters().CLP_Fl;
        this.Protocol = this.m_rSession.getParameters().CLP_Protocol;
        try {
            drive.setParameter((byte)2, this.CGT);
            drive.setParameter((byte)17, this.ETULength);
        }
        catch (BadParameterException badParameterException) {
            System.out.println(badParameterException.toString());
            throw new CommunicationException();
        }
        catch (BadParameterValueException badParameterValueException) {
            System.out.println(badParameterValueException.toString());
            throw new CommunicationException();
        }
        buffer2.setByte(0, (byte)-1);
        by = (byte)(by ^ buffer2.getByte(0));
        buffer2.setByte(1, (byte)16);
        buffer2.setByte(1, (byte)(buffer2.getByte(1) | 0xF & this.Protocol));
        by = (byte)(by ^ buffer2.getByte(1));
        buffer2.setByte(2, (byte)((this.Fl << 4) + (this.Dl & 0xF)));
        by = (byte)(by ^ buffer2.getByte(2));
        buffer2.setByte(3, by);
        buffer2.setLength(4);
        drive.sendBlock(buffer2);
        drive.receiveBlock(buffer);
        n = 0;
        while (n < n2) {
            if (buffer2.getByte(n) != buffer.getByte(n)) {
                throw new CardException();
            }
            ++n;
        }
        this.updatePar(drive);
    }

    abstract void reset(boolean var1, Buffer var2, Buffer var3, Drive var4) throws CommunicationException, CardException, BadParameterValueException, TimeOutException;

    void setSession(Session session) {
        this.m_rSession = session;
    }

    protected void updatePar(Drive drive) throws CommunicationException, CardException, TimeOutException {
        this.postPTS();
        Parameters parameters = this.m_rSession.getParameters();
        parameters.CLP_CardState = (byte)2;
        parameters.CLP_Conv = this.Conv;
        parameters.CLP_Dl = this.Dl;
        parameters.CLP_Fl = this.Fl;
        parameters.CLP_ETULength = this.ETULength;
        parameters.CLP_Cgt = this.CGT;
        parameters.CLP_Cwt = this.CWT;
        try {
            if (parameters.CLP_Autolearn && this.ETULength == 372) {
                parameters.CLP_ETULength = (short)drive.getParameter((byte)17);
            }
            switch (this.Protocol) {
                case 0: {
                    parameters.CLP_Protocol = 1;
                    break;
                }
                case 1: {
                    parameters.CLP_Bwt = this.BWT;
                    parameters.CLP_Edc = this.ATR_Edc;
                    parameters.CLP_Ifsc = this.IFSC;
                    parameters.CLP_Protocol = (byte)2;
                    break;
                }
                case 14: {
                    parameters.CLP_Protocol = (byte)3;
                    break;
                }
                default: {
                    parameters.CLP_Protocol = (byte)4;
                    break;
                }
            }
        }
        catch (BadParameterException badParameterException) {
            System.out.println(badParameterException.toString());
            throw new CommunicationException("SpecificATR.updatePar : setParameterFailed " + badParameterException.toString());
        }
    }
}

