/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.core;

import com.sun.prodreg.awt.AWTUIProvider;
import com.sun.prodreg.core.ComponentDescription;
import com.sun.prodreg.core.ComponentDescriptionLookup;
import com.sun.prodreg.core.ComponentReference;
import com.sun.prodreg.core.InstallManager;
import com.sun.prodreg.core.InteractiveUninstaller;
import com.sun.prodreg.core.ProdRegTreeNode;
import com.sun.prodreg.core.ProdRegViewManager;
import com.sun.prodreg.core.Registry;
import com.sun.prodreg.core.RegistryNotAvailableException;
import com.sun.prodreg.core.UIProvider;
import com.sun.prodreg.core.WebstartRegistry;
import com.sun.prodreg.event.ExpansionEvent;
import com.sun.prodreg.event.ExpansionListener;
import com.sun.prodreg.event.NoExpansionException;
import com.sun.prodreg.event.ProgressListener;
import com.sun.prodreg.event.Subprocess;
import com.sun.prodreg.event.SubprocessDoneEvent;
import com.sun.prodreg.event.SubprocessDoneListener;
import com.sun.prodreg.util.Localizer;
import com.sun.prodreg.util.Log;
import com.sun.prodreg.util.TypedSystemSubprocess;
import com.sun.prodreg.util.Utils;
import com.sun.prodreg.view.ComponentSelectableView;
import com.sun.prodreg.view.ComponentSelectableViewListener;
import com.sun.prodreg.view.ComponentView;
import com.sun.prodreg.view.TreeView;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class ProdReg
implements InstallManager,
ComponentSelectableViewListener,
SubprocessDoneListener,
ProgressListener,
ExpansionListener,
Runnable {
    public static final String ROOT_PROPERTY = "prodreg.pkgroot";
    public static final String SYSTEM_NODE_ID = "a01ee8dd-1dd1-11b2-a3f2-0800209a5b6b";
    public static final String UNCLASSIFIED_NODE_ID = "8f64eabf-1dd2-11b2-a3f1-0800209a5b6b";
    private static final String SYSTEM_TMP_NODE_ID = "ProdRegSystemSoftware";
    private static final String UNCLASSIFIED_TMP_NODE_ID = "ProdRegUnclassifiedSoftware";
    public static final int MAX_NAME_LENGTH = 50;
    public static boolean debug = false;
    private int activeUninstallerCount = 0;
    private Registry reg = null;
    private ProdRegViewManager vm = null;
    private UIProvider provider = null;
    private Log log = null;
    private ComponentDescription desc = null;
    private boolean sysLoaded = false;
    private TreeView tv = null;
    private ComponentDescription rootDesc = null;
    private ComponentDescription systemDesc = null;
    private ComponentDescription unclassifiedDesc = null;

    public ProdReg(UIProvider uIProvider) {
        this.provider = uIProvider;
        new Thread(this).start();
    }

    static /* synthetic */ boolean access$6(ProdReg prodReg) {
        return prodReg.sysLoaded;
    }

    private void cleanup() {
        try {
            this.log.close();
            this.reg.cleanup();
        }
        catch (Exception exception) {
            this.logError("Error cleaning up: " + exception);
        }
    }

    public void close(int n) {
        this.cleanup();
        System.exit(n);
    }

    public void componentSelected(ComponentSelectableView componentSelectableView, ComponentDescription componentDescription) {
        if (!this.sysLoaded && (componentDescription.getID().equals(SYSTEM_TMP_NODE_ID) || componentDescription.getID().equals(UNCLASSIFIED_TMP_NODE_ID))) {
            this.expandSystemFolders(componentDescription, false);
        }
        this.showComponent(componentDescription);
    }

    private boolean currentComponentUninstallable() {
        if (this.desc == null) {
            return false;
        }
        boolean bl = Utils.listPackages(this.desc) != null;
        boolean bl2 = this.desc.getDependentComponents() != null && this.desc.getDependentComponents().size() > 0;
        boolean bl3 = this.desc.getUninstaller() != null;
        String string = this.desc.getData("noUninstall");
        if (string != null && string.equalsIgnoreCase("true")) {
            return false;
        }
        if (this.desc == this.rootDesc || this.desc == this.systemDesc) {
            return false;
        }
        return bl || !bl2 || bl3;
    }

    private synchronized void decrementActiveUninstallerCount() {
        if (this.activeUninstallerCount > 0) {
            --this.activeUninstallerCount;
        }
        int n = this.vm.getOptions();
        if (this.activeUninstallerCount <= 0 && this.currentComponentUninstallable()) {
            n |= 1;
        }
        this.vm.setOptions(n);
    }

    private void expandSystemFolders(ComponentDescription componentDescription, boolean bl) {
        if (componentDescription.getID().equals(SYSTEM_TMP_NODE_ID) || componentDescription.getID().equals(UNCLASSIFIED_TMP_NODE_ID)) {
            this.tv.setEnabled(false);
            Vector<String> vector = new Vector<String>();
            vector.addElement(componentDescription.getID());
            SystemLoader systemLoader = new SystemLoader(this, vector, bl);
            Thread thread = new Thread((Runnable)systemLoader, "SystemResolver");
            thread.start();
        }
    }

    public void expanding(ExpansionEvent expansionEvent) throws NoExpansionException {
        ComponentDescription componentDescription = (ComponentDescription)expansionEvent.getSource();
        boolean bl = expansionEvent.isExpanding();
        if (bl && !this.sysLoaded && (componentDescription.getID().equals(SYSTEM_TMP_NODE_ID) || componentDescription.getID().equals(UNCLASSIFIED_TMP_NODE_ID))) {
            this.expandSystemFolders(componentDescription, true);
            throw new NoExpansionException();
        }
    }

    private ProdRegTreeNode getRegistryData() throws RegistryNotAvailableException {
        Object object;
        ComponentReference componentReference;
        Object object2;
        if (debug) {
            System.out.println("Java diving into JNI at " + new Date().getTime());
        }
        long l = new Date().getTime();
        Vector vector = this.reg.getAllComponents(1, this);
        long l2 = new Date().getTime();
        double d = (double)(l2 - l) / 1000.0;
        if (debug) {
            System.out.println("Java emerging from JNI.  Total time: " + d + " seconds");
        }
        Vector<Object> vector2 = new Vector<Object>();
        ComponentDescriptionLookup.removeAll();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            ComponentDescription componentDescription = (ComponentDescription)vector.elementAt(n2);
            ComponentDescriptionLookup.add(componentDescription.getID(), componentDescription);
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            object2 = (ComponentDescription)vector.elementAt(n3);
            if (((ComponentDescription)object2).getParent() == null) {
                vector2.addElement(object2);
            } else if (((ComponentDescription)object2).isDamaged()) {
                componentReference = ((ComponentDescription)object2).getParent();
                while (componentReference != null) {
                    object = ComponentDescriptionLookup.get(componentReference.getID());
                    if (object != null) {
                        ((ComponentDescription)object).setData("isDamaged", "true");
                        componentReference = ((ComponentDescription)object).getParent();
                        continue;
                    }
                    componentReference = null;
                }
            }
            ++n3;
        }
        this.systemDesc = new ComponentDescription(SYSTEM_TMP_NODE_ID);
        object2 = Localizer.resolve("<L ProdRegResources.SystemSoftware>");
        this.systemDesc.setDisplayName((String)object2);
        componentReference = new ComponentDescription("ProdRegSystemSoftware child");
        ((ComponentDescription)componentReference).setDisplayName("Never Seen");
        this.unclassifiedDesc = new ComponentDescription(UNCLASSIFIED_TMP_NODE_ID);
        object = Localizer.resolve("<L ProdRegResources.UnclassifiedSoftware>");
        this.unclassifiedDesc.setDisplayName((String)object);
        ComponentDescription componentDescription = new ComponentDescription("ProdRegUnclassifiedSoftware child");
        componentDescription.setDisplayName("Never Seen");
        ComponentDescriptionLookup.add(this.systemDesc.getID(), this.systemDesc);
        ComponentDescriptionLookup.add(this.unclassifiedDesc.getID(), this.unclassifiedDesc);
        ComponentDescriptionLookup.add(componentReference.getID(), (ComponentDescription)componentReference);
        ComponentDescriptionLookup.add(componentDescription.getID(), componentDescription);
        this.rootDesc = new ComponentDescription("root");
        ProdRegTreeNode prodRegTreeNode = new ProdRegTreeNode(this.rootDesc);
        String string = Localizer.resolve("<L ProdRegResources.SystemRegistry>");
        prodRegTreeNode.getComponentDescription().setDisplayName(string);
        this.systemDesc.addChild(componentReference);
        this.unclassifiedDesc.addChild(componentDescription);
        prodRegTreeNode.getComponentDescription().addChild(this.systemDesc);
        prodRegTreeNode.getComponentDescription().addChild(this.unclassifiedDesc);
        int n4 = 0;
        while (n4 < vector2.size()) {
            ComponentDescription componentDescription2 = (ComponentDescription)vector2.elementAt(n4);
            prodRegTreeNode.getComponentDescription().addChild(componentDescription2);
            ++n4;
        }
        this.setProgress(100);
        this.vm.hideProgress();
        return prodRegTreeNode;
    }

    private static UIProvider getSwingProvider() {
        try {
            Class<?> clazz = Class.forName("com.sun.prodreg.swing.SwingUIProvider");
            Class.forName("javax.swing.JPanel");
            return (UIProvider)clazz.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private TreeView getTreeView() {
        TreeView treeView = null;
        try {
            ProdRegTreeNode prodRegTreeNode = this.getRegistryData();
            treeView = this.provider.getTreeView(prodRegTreeNode);
            treeView.addComponentSelectableViewListener(this);
            treeView.addExpansionListener(this);
        }
        catch (RegistryNotAvailableException registryNotAvailableException) {
            if (debug) {
                System.out.println("ProdReg: reg not available: " + registryNotAvailableException.toString());
            }
            String string = Localizer.resolve("<L ProdRegResources.NotAvail>");
            this.logError(string);
        }
        return treeView;
    }

    private synchronized void incrementActiveUninstallerCount() {
        ++this.activeUninstallerCount;
        int n = this.vm.getOptions();
        this.vm.setOptions(n &= 0xFFFFFFFE);
    }

    private void initializeReg() {
        this.reg = new WebstartRegistry();
        this.log = new Log();
        if (debug) {
            System.out.println("Java initializing libprodreg...");
        }
        try {
            String string = System.getProperty(ROOT_PROPERTY);
            if (string != null && string.trim().equals("")) {
                Properties properties = System.getProperties();
                ((Hashtable)properties).remove(ROOT_PROPERTY);
                System.setProperties(properties);
                string = null;
            }
            if (string != null && debug) {
                System.out.println("ProdReg using root: " + string);
            }
            this.reg.initialize(this.vm, this.provider, this, string);
            if (debug) {
                System.out.println("Java done initializing libprodreg...");
            }
        }
        catch (Exception exception) {
            if (debug) {
                System.out.println("Error during registry initializatin:" + exception.toString());
                exception.printStackTrace();
            }
            String string = Localizer.resolve("<L ProdRegResources.InitError>");
            this.logError(string);
        }
    }

    private void initializeUI() {
        String string = Localizer.resolve("<L ProdRegResources.PleaseWait>");
        ComponentView componentView = this.provider.getMoreView();
        ComponentView componentView2 = this.provider.getSummaryView();
        this.vm = new ProdRegViewManager(this.provider, this, componentView2, componentView, null);
        int n = this.vm.getOptions();
        n &= 0xFFFFFFFD;
        this.vm.setOptions(n &= 0xFFFFFFFE);
        this.vm.showProgress();
        this.vm.setProgress(0);
        this.vm.setProgressMessage(string);
    }

    private void installDone(int n, String string) {
        if (n == 0) {
            String string2 = Localizer.resolve("<L ProdRegResources.InstallSuccessTitle>");
            String string3 = Localizer.resolve("<L ProdRegResources.OK>");
            String string4 = Localizer.resolve("<L ProdRegResources.InstallSuccess>");
            this.vm.query(string2, string4, string, new String[]{string3});
            this.resetRegistry();
        } else {
            String string5 = Localizer.resolve("<L ProdRegResources.InstallFailedTitle>");
            String string6 = Localizer.resolve("<L ProdRegResources.OK>");
            String string7 = Localizer.resolve("<L ProdRegResources.Cancel>");
            String string8 = Localizer.resolve("<L ProdRegResources.InstallFailed>");
            int n2 = this.vm.query(string5, string8, string, new String[]{string6});
        }
    }

    private void logError(String string) {
        this.log.logMessage(string, 2);
        this.vm.logError(string);
    }

    public static void main(String[] stringArray) {
        UIProvider uIProvider = null;
        boolean bl = false;
        boolean bl2 = false;
        String string = System.getProperty("java.version");
        if (string.compareTo("1.1.3") < 0) {
            System.err.println(Localizer.resolve("Sorry, Java 1.1.3 or greater is required"));
            System.exit(1);
        }
        Localizer.addResourcePackage("com.sun.prodreg");
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-swing")) {
                if (bl2) {
                    ProdReg.usage();
                }
                bl = true;
                bl2 = false;
            } else if (stringArray[n].equals("-awt")) {
                if (bl) {
                    ProdReg.usage();
                }
                bl = false;
                bl2 = true;
            } else if (stringArray[n].equals("-debug")) {
                debug = true;
                TypedSystemSubprocess.debug = true;
            } else if (stringArray[n].equals("-R")) {
                if (n + 1 < stringArray.length) {
                    System.setProperty(ROOT_PROPERTY, stringArray[n + 1]);
                    ++n;
                } else {
                    ProdReg.usage();
                }
            } else {
                System.err.println(String.valueOf(Localizer.resolve("<L ProdRegResources.UnrecognizedArg>:")) + stringArray[n]);
                ProdReg.usage();
            }
            ++n;
        }
        try {
            if (!bl2) {
                uIProvider = ProdReg.getSwingProvider();
                if (uIProvider == null) {
                    if (bl) {
                        String string2 = Localizer.resolve("<L ProdRegResources.WarnNoSwing>");
                        System.err.println(string2);
                    }
                    uIProvider = new AWTUIProvider();
                }
            } else {
                uIProvider = new AWTUIProvider();
            }
        }
        catch (InternalError internalError) {
            System.err.println(Localizer.resolve("<L ProdRegResources.NoDisplay>"));
            System.exit(1);
        }
        new ProdReg(uIProvider);
    }

    public void newInstall(String string, String string2) {
        TypedSystemSubprocess typedSystemSubprocess = new TypedSystemSubprocess(string, string2);
        typedSystemSubprocess.addSubprocessDoneListener(this, "NewInstall");
        new Thread((Runnable)typedSystemSubprocess, "new installer").start();
    }

    public void newUninstall(boolean bl) {
        String string;
        Object object;
        Object[] objectArray;
        Object object2;
        Object object3;
        boolean bl2;
        if (this.desc == null) {
            return;
        }
        boolean bl3 = Utils.listPackages(this.desc) != null;
        boolean bl4 = this.desc.getDependentComponents() != null && this.desc.getDependentComponents().size() > 0;
        boolean bl5 = bl2 = this.desc.getUninstaller() != null;
        if (!bl && bl4) {
            object3 = "";
            object2 = this.desc.getDependentComponents();
            int n = 0;
            while (n < object2.size()) {
                objectArray = (ComponentReference)object2.elementAt(n);
                object = ComponentDescriptionLookup.get(objectArray.getID());
                object3 = String.valueOf(object3) + "\"" + ((ComponentDescription)object).getDisplayName() + "\", ";
                ++n;
            }
            object3 = ((String)object3).substring(0, ((String)object3).length() - 2);
            objectArray = new String[]{"<bold>\"" + Utils.getDisplayName(this.desc) + "</bold>\"", object3};
            object = Localizer.resolve("<L ProdRegResources.Warning>");
            string = Localizer.resolve("<L ProdRegResources.OK>");
            String string2 = Localizer.resolve("<L ProdRegResources.Cancel>");
            String string3 = Localizer.resolve("<L ProdRegResources.UninstallDependency>", objectArray);
            int n2 = this.vm.query((String)object, string3, null, new String[]{string2, string});
            if (n2 == 0) {
                return;
            }
        }
        if (bl) {
            object3 = new InteractiveUninstaller(this.desc, this.vm, this.reg);
            ((Subprocess)object3).addSubprocessDoneListener(this);
            this.incrementActiveUninstallerCount();
            new Thread((Runnable)object3).start();
            return;
        }
        object3 = this.desc.getUninstaller();
        if (object3 == null || ((String)object3).trim().equals("")) {
            object2 = new String[]{"\"" + Utils.getDisplayName(this.desc) + "\""};
            String string4 = Localizer.resolve("<L ProdRegResources.UninstallFailedTitle>");
            objectArray = Localizer.resolve("<L ProdRegResources.OK>");
            object = Localizer.resolve("<L ProdRegResources.Cancel>");
            string = Localizer.resolve("<L ProdRegResources.NoUninstaller>", object2);
            int n = this.vm.query(string4, string, null, new String[]{object, objectArray});
            if (n == 1) {
                this.newUninstall(true);
            }
            return;
        }
        object2 = "bin/rootrun " + TypedSystemSubprocess.escape(' ', this.desc.getUninstaller());
        String string5 = Localizer.resolve("<L ProdRegResources.EnterRootPassword>");
        object2 = String.valueOf(object2) + " " + TypedSystemSubprocess.escape(' ', string5);
        objectArray = System.getProperty("prodreg.home");
        if (debug) {
            System.out.println("ProdReg: running -->" + (String)object2 + "<--");
        }
        object = new TypedSystemSubprocess((String)objectArray, (String)object2, 2);
        ((Subprocess)object).addSubprocessDoneListener(this, this.desc);
        this.incrementActiveUninstallerCount();
        new Thread((Runnable)object, "NewUnInstall for file " + this.desc.getUninstaller()).start();
    }

    private void resetRegistry() {
        String string = Localizer.resolve("<L ProdRegResources.PleaseWait>");
        int n = this.vm.getOptions();
        n &= 0xFFFFFFFD;
        this.vm.setOptions(n &= 0xFFFFFFFE);
        TreeView treeView = (TreeView)this.vm.getTreeView();
        if (treeView != null) {
            treeView.removeComponentSelectableViewListener(this);
            treeView.removeExpansionListener(this);
        }
        this.vm.setTreeView(null);
        this.showComponent(null);
        this.sysLoaded = false;
        this.tv = null;
        this.tv = this.getTreeView();
        this.vm.setTreeView(this.tv);
        n = this.vm.getOptions();
        n |= 2;
        if (this.currentComponentUninstallable()) {
            n |= 1;
        }
        this.vm.setOptions(n);
    }

    public void run() {
        try {
            this.initializeUI();
            this.initializeReg();
            this.showUI();
        }
        catch (InternalError internalError) {
            System.err.println(Localizer.resolve("<L ProdRegResources.NoDisplay>"));
            this.close(1);
        }
    }

    public void setProgress(int n) {
        this.vm.setProgress(n);
    }

    public synchronized void showComponent(ComponentDescription componentDescription) {
        this.desc = componentDescription;
        int n = this.vm.getOptions();
        if (this.activeUninstallerCount <= 0) {
            n |= 1;
        }
        if (!this.currentComponentUninstallable()) {
            n &= 0xFFFFFFFE;
        }
        this.vm.setOptions(n);
        this.vm.showComponent(componentDescription);
    }

    private void showUI() {
        this.tv = this.getTreeView();
        this.vm.setTreeView(this.tv);
        int n = this.vm.getOptions();
        n |= 2;
        if (this.currentComponentUninstallable()) {
            n |= 1;
        }
        this.vm.setOptions(n);
    }

    public void subprocessDone(SubprocessDoneEvent subprocessDoneEvent) {
        if (subprocessDoneEvent.getSource() instanceof InteractiveUninstaller) {
            if (subprocessDoneEvent.getReturnValue() == 0) {
                this.resetRegistry();
            }
            this.decrementActiveUninstallerCount();
        } else {
            Object object = subprocessDoneEvent.getData();
            if (object != null && object instanceof ComponentDescription) {
                ComponentDescription componentDescription = (ComponentDescription)object;
                this.uninstallDone(componentDescription, subprocessDoneEvent.getReturnValue(), subprocessDoneEvent.getMessage());
            } else if (object != null && object instanceof String) {
                String string = (String)object;
                if (string.equals("NewInstall")) {
                    this.installDone(subprocessDoneEvent.getReturnValue(), subprocessDoneEvent.getMessage());
                }
            } else {
                this.logError("Internal Error: unknown process completed");
            }
        }
    }

    private void uninstallDone(ComponentDescription componentDescription, int n, String string) {
        if (n != 0) {
            int n2;
            boolean bl = Utils.listPackages(componentDescription) != null;
            boolean bl2 = componentDescription.getDependentComponents() != null && componentDescription.getDependentComponents().size() > 0;
            boolean bl3 = componentDescription.getUninstaller() != null;
            Object[] objectArray = new String[]{"\"<italics>" + Utils.getDisplayName(componentDescription) + "\"" + "</italics>", "<bold> " + n + " </bold>"};
            String string2 = Localizer.resolve("<L ProdRegResources.UninstallFailedTitle>");
            String string3 = Localizer.resolve("<L ProdRegResources.OK>");
            String string4 = Localizer.resolve("<L ProdRegResources.Cancel>");
            if (bl2 && !bl) {
                String string5 = Localizer.resolve("<L ProdRegResources.UninstallFailedNoInt>", objectArray);
                n2 = this.vm.query(string2, string5, string, new String[]{string3});
            } else {
                String string6 = Localizer.resolve("<L ProdRegResources.UninstallFailed>", objectArray);
                n2 = this.vm.query(string2, string6, string, new String[]{string4, string3});
            }
            if (n2 == 1) {
                this.newUninstall(true);
            }
        } else {
            Object[] objectArray = new String[]{"\"<italics>" + Utils.getDisplayName(componentDescription) + "\"" + "</italics>", "<bold> " + n + " </bold>"};
            String string7 = Localizer.resolve("<L ProdRegResources.UninstallSuccessTitle>");
            String string8 = Localizer.resolve("<L ProdRegResources.OK>");
            String string9 = Localizer.resolve("<L ProdRegResources.UninstallSuccess>", objectArray);
            int n3 = this.vm.query(string7, string9, string, new String[]{string8});
            this.resetRegistry();
        }
        this.decrementActiveUninstallerCount();
    }

    private static void usage() {
        System.err.print(Localizer.resolve("<L ProdRegResources.Usage>:"));
        System.err.println("prodreg [-awt] [-swing] [-R <root>]");
        System.exit(1);
    }

    class SystemLoader
    implements Runnable {
        private ProgressListener pl = null;
        private boolean failed = false;
        private Vector idsToExpand = null;
        private boolean expand = false;

        public SystemLoader(ProgressListener progressListener, Vector vector, boolean bl) {
            this.pl = progressListener;
            this.idsToExpand = vector;
            this.expand = bl;
        }

        public boolean hasFailed() {
            return this.failed;
        }

        private void resolveSystemComponents() throws RegistryNotAvailableException {
            Object object;
            Cloneable cloneable;
            String string = Localizer.resolve("<L ProdRegResources.SystemPleaseWait>");
            ProdReg.this.vm.showProgress();
            ProdReg.this.vm.setProgress(0);
            ProdReg.this.vm.setProgressMessage(string);
            Vector vector = ProdReg.this.reg.getAllComponents(0, this.pl);
            ProdReg.this.vm.hideProgress();
            Vector<Cloneable> vector2 = new Vector<Cloneable>();
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                cloneable = (ComponentDescription)vector.elementAt(n2);
                ComponentDescriptionLookup.add(((ComponentReference)cloneable).getID(), (ComponentDescription)cloneable);
                if (((ComponentDescription)cloneable).getParent() == null) {
                    vector2.addElement(cloneable);
                }
                ++n2;
            }
            this.setLocalizedFolderNames();
            cloneable = new Vector();
            boolean bl = false;
            int n3 = 0;
            while (n3 < vector2.size()) {
                object = (ComponentDescription)vector2.elementAt(n3);
                ProdReg.this.rootDesc.addChild((ComponentReference)object);
                if (((ComponentReference)object).getID().equals(ProdReg.SYSTEM_NODE_ID)) {
                    if (this.idsToExpand.contains(ProdReg.SYSTEM_TMP_NODE_ID)) {
                        ((Vector)cloneable).addElement(((ComponentReference)object).getID());
                    }
                } else if (((ComponentReference)object).getID().equals(ProdReg.UNCLASSIFIED_NODE_ID)) {
                    bl = true;
                    if (this.idsToExpand.contains(ProdReg.UNCLASSIFIED_TMP_NODE_ID)) {
                        ((Vector)cloneable).addElement(((ComponentReference)object).getID());
                    }
                }
                ++n3;
            }
            ProdReg.this.rootDesc.removeChild(ProdReg.this.systemDesc);
            if (bl) {
                ProdReg.this.rootDesc.removeChild(ProdReg.this.unclassifiedDesc);
            } else {
                object = Localizer.resolve("<L ProdRegResources.NoUnclassifiedSoftware>");
                ProdReg.this.unclassifiedDesc.setDisplayName(Utils.getLocaleName(), (String)object);
                ProdReg.this.unclassifiedDesc.setData("isSelectable", "false");
            }
            ProdReg.this.tv.refresh((Vector)cloneable, this.expand);
            ProdReg.this.sysLoaded = true;
            ProdReg.this.tv.setEnabled(true);
        }

        public void run() {
            this.failed = false;
            try {
                this.resolveSystemComponents();
            }
            catch (RegistryNotAvailableException registryNotAvailableException) {
                this.failed = true;
            }
        }

        private void setLocalizedFolderNames() {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            ComponentDescription componentDescription = ComponentDescriptionLookup.get(ProdReg.SYSTEM_NODE_ID);
            if (componentDescription != null) {
                object4 = componentDescription.getVersion();
                object3 = Localizer.resolve("<L ProdRegResources.SystemSoftwareReload>", new Object[]{object4});
                componentDescription.setDisplayName((String)object3);
            }
            if ((object4 = ComponentDescriptionLookup.get("a8dcab4f-1dd1-11b2-a3f2-0800209a5b6b")) != null) {
                object3 = Localizer.resolve("<L ProdRegResources.L10NSoftwareExpand>");
                ((ComponentDescription)object4).setDisplayName((String)object3);
            }
            if ((object3 = ComponentDescriptionLookup.get("b1c43601-1dd1-11b2-a3f2-0800209a5b6b")) != null) {
                object2 = Localizer.resolve("<L ProdRegResources.AdditinalSoftwareExpand>");
                ((ComponentDescription)object3).setDisplayName((String)object2);
            }
            if ((object2 = ComponentDescriptionLookup.get("b96ae9a9-1dd1-11b2-a3f2-0800209a5b6b")) != null) {
                object = Localizer.resolve("<L ProdRegResources.SystemL10NSoftwareExpand>");
                ((ComponentDescription)object2).setDisplayName((String)object);
            }
            if ((object = ComponentDescriptionLookup.get(ProdReg.UNCLASSIFIED_NODE_ID)) != null) {
                String string = Localizer.resolve("<L ProdRegResources.UnclassifiedSoftware>");
                ((ComponentDescription)object).setDisplayName(string);
            }
        }
    }
}

