/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg;

import com.sun.prodreg.OutlineNode;
import com.sun.prodreg.OutlineView;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

public class OutlineItem {
    OutlineItem[] children;
    OutlineNode node;
    boolean header;
    int xdrawn;
    int topdrawn;
    int bottomdrawn;
    static Font normalFont = new Font("Dialog", 1, 12);
    static Font damageFont = new Font("Dialog", 2, 12);
    static int[] xlist = new int[4];
    static int[] ylist = new int[4];
    static Color damageColor = new Color(6307968);

    OutlineItem(OutlineNode outlineNode) {
        this.node = outlineNode;
        this.header = false;
        this.children = new OutlineItem[outlineNode.getChildCount()];
        int n = 0;
        while (n < this.children.length) {
            this.children[n] = new OutlineItem(outlineNode.getChild(n));
            ++n;
        }
    }

    OutlineItem(OutlineNode[] outlineNodeArray) {
        this.node = null;
        this.header = true;
        this.children = new OutlineItem[outlineNodeArray.length];
        int n = 0;
        while (n < outlineNodeArray.length) {
            this.children[n] = new OutlineItem(outlineNodeArray[n]);
            ++n;
        }
    }

    OutlineItem getClickedItem(int n, int n2) {
        if (n2 < this.topdrawn || n2 > this.bottomdrawn) {
            return null;
        }
        if (this.node != null && this.node.isCollapsed() || this.children.length <= 0 || n2 < this.children[0].topdrawn) {
            return this;
        }
        if (this.node == null || !this.node.isCollapsed()) {
            int n3 = 0;
            while (n3 < this.children.length) {
                OutlineItem outlineItem = this.children[n3];
                if (n2 < outlineItem.bottomdrawn) {
                    return outlineItem.getClickedItem(n, n2);
                }
                ++n3;
            }
        }
        return this;
    }

    void hilite(Graphics graphics, OutlineView outlineView) {
        graphics.setXORMode(outlineView.getBackground());
        graphics.fillRect(this.xdrawn + outlineView.itemheight, this.topdrawn, outlineView.size().width, outlineView.itemheight);
        graphics.setPaintMode();
    }

    void paintItem(Graphics graphics, int n, int n2, int n3) {
        this.xdrawn = n;
        int n4 = n3;
        int n5 = n3 / 2;
        if (this.node.isDamaged()) {
            graphics.setFont(damageFont);
            graphics.drawString(this.node.toString(), n + n4 + n5, n2 + n3);
        } else {
            graphics.setFont(normalFont);
            graphics.drawString(this.node.toString(), n + n4 + n5, n2 + n3);
        }
        int n6 = n5 / 2;
        n2 += n6;
        if (this.children.length > 0) {
            if (this.node.isCollapsed()) {
                OutlineItem.xlist[0] = n += n6;
                OutlineItem.ylist[0] = n2;
                OutlineItem.xlist[1] = n;
                OutlineItem.ylist[1] = n2 + n4;
                OutlineItem.xlist[2] = n + n5;
                OutlineItem.ylist[2] = n2 + n5;
            } else {
                OutlineItem.xlist[0] = n;
                OutlineItem.ylist[0] = n2;
                OutlineItem.xlist[1] = n + n5;
                OutlineItem.ylist[1] = n2 + n5;
                OutlineItem.xlist[2] = n + n4;
                OutlineItem.ylist[2] = n2;
            }
            OutlineItem.xlist[3] = xlist[0];
            OutlineItem.ylist[3] = ylist[0];
        } else {
            OutlineItem.xlist[0] = n += n6;
            OutlineItem.ylist[0] = n2 += n6;
            OutlineItem.xlist[1] = n;
            OutlineItem.ylist[1] = n2 + n5;
            OutlineItem.xlist[2] = n + n5;
            OutlineItem.ylist[2] = n2 + n5;
            OutlineItem.xlist[3] = n + n5;
            OutlineItem.ylist[3] = n2;
        }
        graphics.fillPolygon(xlist, ylist, 4);
    }
}

