/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg;

import com.sun.prodreg.CannotRegister;
import com.sun.prodreg.ExtProgram;
import com.sun.prodreg.FileCount;
import com.sun.prodreg.LabelBlock;
import com.sun.prodreg.OutlineNode;
import com.sun.prodreg.PKGArticle;
import com.sun.prodreg.ProdReg;
import com.sun.prodreg.RegException;
import com.sun.prodreg.Registry;
import com.sun.prodreg.Revision;
import com.sun.prodreg.SwingTreeNode;
import com.sun.prodreg.UninstallThread;
import com.sun.prodreg.ViewableNode;
import com.sun.prodreg._;
import java.awt.Button;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.swing.JButton;

public class Article
implements ViewableNode {
    String mnemonic;
    String id;
    Properties props;
    Revision[] revisions;
    int health = 1;
    static final int UNKNOWN = 1;
    static final int DAMAGED = 2;
    static final int INTACT = 3;
    String damageReason = null;
    boolean collapsed = true;
    SwingTreeNode equivalent;
    private Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    private static Random idgen = new Random(System.currentTimeMillis());
    static Hashtable index = new Hashtable();
    Article nextSame;
    private static DateFormat builddateformat = DateFormat.getDateInstance(1);
    private static DateFormat installdateformat = DateFormat.getDateTimeInstance(1, 3);

    public Article(String string) throws RegException {
        this.cal.setLenient(false);
        builddateformat.setTimeZone(TimeZone.getTimeZone("GMT"));
        installdateformat.setTimeZone(TimeZone.getDefault());
        string = string.toLowerCase();
        if (string.indexOf(32) >= 0) {
            throw new RegException(_.__("noSpacesEr", string));
        }
        this.mnemonic = string;
        this.props = new Properties();
        ((Hashtable)this.props).put("mnemonic", string);
        this.revisions = null;
    }

    public Article(Properties properties) throws RegException {
        Object object;
        this.cal.setLenient(false);
        builddateformat.setTimeZone(TimeZone.getTimeZone("GMT"));
        installdateformat.setTimeZone(TimeZone.getDefault());
        this.props = properties;
        this.mnemonic = properties.getProperty("mnemonic");
        if (this.mnemonic == null) {
            throw new CannotRegister(_.__("noMnAttrEr"));
        }
        this.mnemonic = this.mnemonic.toLowerCase();
        if (this.mnemonic.indexOf(32) >= 0) {
            throw new CannotRegister(_.__("noSpacesEr", this.mnemonic));
        }
        ((Hashtable)properties).put("mnemonic", this.mnemonic);
        this.revisions = null;
        String string = properties.getProperty("installlocation");
        String string2 = properties.getProperty("locationflags");
        if (string2 == null) {
            string2 = "";
        }
        if (string != null && string2.indexOf(115) < 0) {
            try {
                object = new FileCount(string);
                ((Hashtable)properties).put("installdiskspace", ((FileCount)object).summary());
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new CannotRegister(fileNotFoundException.toString());
            }
            catch (IOException iOException) {
                throw new CannotRegister(iOException.toString());
            }
        }
        object = "";
        StringTokenizer stringTokenizer = new StringTokenizer(properties.getProperty("pkgs", ""));
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            PKGArticle pKGArticle = new PKGArticle(string3);
            pKGArticle.assessDamage();
            if (pKGArticle.health != 3) continue;
            object = String.valueOf(object) + string3 + ' ';
        }
        ((Hashtable)properties).put("pkgs", object);
        this.revise(properties);
    }

    void assessDamage() {
        File file;
        if (this.health != 1) {
            return;
        }
        this.health = 3;
        String string = this.getAttribute("keyfile,file");
        if (string == null) {
            string = this.getAttribute("installlocation");
        }
        if (string != null && !(file = new File(string)).exists()) {
            this.health = 2;
            this.damageReason = _.__("missingKeyFileEr", string);
            return;
        }
        int n = this.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            Article article = (Article)this.getChild(n2);
            article.assessDamage();
            if (article.health == 2) {
                this.health = 2;
                this.damageReason = _.__("missingInCompEr");
            }
            ++n2;
        }
    }

    void chooseID() throws RegException {
        String string = this.props.getProperty("chosenid");
        if (string != null) {
            if (string.length() != 9) {
                throw new RegException(_.__("badChosenIDEr", string));
            }
            if (string.charAt(0) == '0') {
                throw new RegException(_.__("badChosenIDEr", string));
            }
            int n = 0;
            while (n < 9) {
                if (string.charAt(n) < '0' || string.charAt(n) > '9') {
                    throw new RegException(_.__("badChosenIDEr", string));
                }
                ++n;
            }
            this.id = string;
            ((Hashtable)this.props).remove("chosenid");
        } else {
            int n = idgen.nextInt();
            n = Math.abs(n % 900000000) + 100000000;
            this.id = Integer.toString(n);
        }
        ((Hashtable)this.props).put("id", this.id);
    }

    void deChild(Article article) throws RegException {
        String string = this.getAttribute("articles");
        if (string == null) {
            throw new RegException(_.__("noArticlesEr", this.getTitle()));
        }
        String string2 = this.getAttribute("articleids");
        if (string2 == null) {
            throw new RegException(_.__("noArticleIDsEr", this.getTitle()));
        }
        int n = 0;
        int n2 = 0;
        while (n < string.length() && n2 < string2.length()) {
            int n3;
            int n4;
            int n5 = string.indexOf(" ", n);
            if (n5 < 0) {
                n5 = string.length();
                string = String.valueOf(string) + ' ';
            }
            if ((n4 = string2.indexOf(" ", n2)) < 0) {
                n4 = string2.length();
                string2 = String.valueOf(string2) + ' ';
            }
            if ((n3 = n5 - n) == article.mnemonic.length() && string.regionMatches(n, article.mnemonic, 0, n3)) {
                string = String.valueOf(string.substring(0, n)) + string.substring(n5 + 1);
                string2 = String.valueOf(string2.substring(0, n2)) + string2.substring(n4 + 1);
                this.setAttribute("articles", string);
                this.setAttribute("articleids", string2);
                return;
            }
            n = n5 + 1;
            n2 = n4 + 1;
        }
    }

    void deParent() throws RegException {
        Article article = this.getParent();
        if (article != null) {
            article.deChild(this);
        }
    }

    private void deleteFileRecursive(File file) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            int n = 0;
            while (n < stringArray.length) {
                this.deleteFileRecursive(new File(file, stringArray[n]));
                ++n;
            }
        }
        file.delete();
    }

    public Enumeration getAllChildren() {
        return new ArticleEnumeration(this);
    }

    public String getAttribute(String string) {
        int n = (string = string.toLowerCase()).indexOf(44);
        if (n < 0) {
            return this.props.getProperty(string);
        }
        String string2 = string.substring(n + 1);
        string = string.substring(0, n);
        if (string2.equals("file")) {
            Object object;
            String string3 = this.props.getProperty(string);
            if (string3 == null) {
                return null;
            }
            File file = new File(string3);
            if (file.isAbsolute()) {
                return string3;
            }
            String string4 = null;
            try {
                object = this;
                while (object != null) {
                    string4 = ((Article)object).getAttribute("installlocation");
                    if (string4 == null) {
                        object = ((Article)object).getParent();
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                string4 = null;
            }
            if (string4 == null) {
                return string3;
            }
            object = new File(string4, string3);
            return ((File)object).toString();
        }
        throw new Error(_.__("unknownConversionEr", string2));
    }

    public String getAttribute(String string, String string2) {
        String string3 = this.getAttribute(string.toLowerCase());
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public Properties getAttrs() {
        return this.props;
    }

    public OutlineNode getChild(int n) {
        Article article;
        String string = null;
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(this.getAttribute("pkgs", ""));
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (--n < 0) break;
        }
        if (n < 0 && string2 != null) {
            PKGArticle pKGArticle = PKGArticle.lookupPKG(string2);
            if (pKGArticle == null) {
                try {
                    pKGArticle = new PKGArticle(string2);
                    ProdReg.systemRegistry.add(pKGArticle);
                    pKGArticle.setAttribute("parent", string2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.exit(1);
                }
            }
            return pKGArticle;
        }
        StringTokenizer stringTokenizer2 = new StringTokenizer(this.getAttribute("articleids", ""));
        stringTokenizer = new StringTokenizer(this.getAttribute("articles", ""));
        while (stringTokenizer2.hasMoreTokens() && stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer2.nextToken();
            string2 = stringTokenizer.nextToken();
            if (--n < 0) break;
        }
        if (n < 0 && string2 != null && (article = Article.lookup(string2, string)) != null) {
            return article;
        }
        try {
            article = new Article("m");
        }
        catch (Exception exception) {
            throw new Error();
        }
        article.id = string;
        article.setAttribute("title", _.__("missingArticleEr"));
        article.setAttribute("uninstall", "r");
        return article;
    }

    public int getChildCount() {
        StringTokenizer stringTokenizer = new StringTokenizer(String.valueOf(this.getAttribute("articleids", "")) + ' ' + this.getAttribute("pkgs", ""));
        return stringTokenizer.countTokens();
    }

    public Article getNextSame() {
        return this.nextSame;
    }

    public Article getParent() throws RegException {
        String string = this.getAttribute("parent");
        if (string == null) {
            return null;
        }
        String string2 = this.getAttribute("parentid");
        if (string2 == null) {
            throw new RegException(_.__("noParentIDEr", this.getTitle()));
        }
        Article article = Article.lookup(string, string2);
        if (article == null) {
            throw new RegException(_.__("parentUnregEr", this.getTitle()));
        }
        return article;
    }

    public String getSummaryParagraph() throws RegException {
        String string = "  " + this.getTitle();
        if (this.revisions != null && this.revisions.length >= 1) {
            string = String.valueOf(string) + " " + this.revisions[this.revisions.length - 1].version;
        }
        string = String.valueOf(string) + "\nID=" + this.id + "   mnemonic=" + this.mnemonic;
        String string2 = this.getAttribute("installlocation");
        if (string2 != null) {
            string = String.valueOf(string) + "\ninstallLocation=" + string2;
        }
        if (this.revisions != null) {
            string = String.valueOf(string) + "\nversionVector=" + this.revisions[this.revisions.length - 1].formatVVector();
        }
        return string;
    }

    public String getTitle() {
        String string = this.getAttribute("title");
        if (string != null) {
            return string;
        }
        string = this.mnemonic;
        if (this.id != null) {
            string = String.valueOf(string) + ' ' + this.id;
        }
        return string;
    }

    void includeInIndex() {
        this.nextSame = index.put(this.mnemonic.toLowerCase(), this);
    }

    public void interactiveUninstall(Component component, LabelBlock labelBlock, boolean bl) throws Throwable {
        this.assessDamage();
        if (this.isDamaged()) {
            bl = true;
        }
        new UninstallThread(labelBlock, this, labelBlock.infopanel, bl);
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public boolean isDamaged() {
        return this.health == 2;
    }

    public void load() {
    }

    public static Article lookup(String string) {
        return (Article)index.get(string.toLowerCase());
    }

    /*
     * Unable to fully structure code
     */
    public static Article lookup(String var0, String var1_1) {
        var2_2 = (Article)Article.index.get(var0.toLowerCase());
        if (var1_1 != null) ** GOTO lbl7
        return var2_2;
lbl-1000:
        // 1 sources

        {
            if (var2_2.id.endsWith(var1_1)) {
                return var2_2;
            }
            var2_2 = var2_2.nextSame;
lbl7:
            // 2 sources

            ** while (var2_2 != null)
        }
lbl8:
        // 1 sources

        return null;
    }

    public static Article lookupByLoc(String string, String string2) throws RegException {
        Article article = (Article)index.get(string.toLowerCase());
        while (article != null) {
            String string3 = article.getAttribute("installlocation");
            if (string2.equals(string3)) {
                return article;
            }
            article = article.nextSame;
        }
        return null;
    }

    public static Article lookupByUnLoc(String string, String string2) throws RegException {
        Article article = (Article)index.get(string.toLowerCase());
        while (article != null) {
            Article article2 = article;
            while (article2 != null) {
                String string3 = article2.getAttribute("uninstallprogram,file");
                if (string3 != null && string3.startsWith(string2)) {
                    return article;
                }
                article2 = article2.getParent();
            }
            if (article.id.endsWith(string2)) {
                return article;
            }
            article = article.nextSame;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    void removeFromIndex() {
        block3: {
            var1_1 = (Article)Article.index.get(this.mnemonic.toLowerCase());
            if (var1_1 != this) ** GOTO lbl11
            if (this.nextSame != null) {
                Article.index.put(this.mnemonic.toLowerCase(), this.nextSame);
            } else {
                Article.index.remove(this.mnemonic.toLowerCase());
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                var1_1 = var1_1.nextSame;
lbl11:
                // 2 sources

                ** while (var1_1.nextSame != null && var1_1.nextSame != this)
            }
lbl12:
            // 1 sources

            var1_1.nextSame = this.nextSame;
        }
    }

    public static void resetIndex() {
        index.clear();
    }

    public void revise(Revision revision) {
        if (this.revisions == null) {
            this.revisions = new Revision[1];
            this.revisions[0] = revision;
        } else {
            Revision[] revisionArray = new Revision[this.revisions.length + 1];
            System.arraycopy(this.revisions, 0, revisionArray, 0, this.revisions.length);
            revisionArray[this.revisions.length] = revision;
            this.revisions = revisionArray;
        }
    }

    public void revise(String string, String string2) throws RegException {
        if (string2 == null) {
            this.revise(new Revision(string, null, null, new Date()));
        } else {
            Date date;
            try {
                int n = string2.indexOf(47);
                int n2 = string2.lastIndexOf(47);
                if (n < 1 || n2 < 1 || n == n2) {
                    throw new Exception(_.__("versiondateEr", string2));
                }
                int n3 = Integer.parseInt(string2.substring(0, n));
                int n4 = Integer.parseInt(string2.substring(n + 1, n2));
                int n5 = Integer.parseInt(string2.substring(n2 + 1));
                this.cal.set(n3, n4 - 1, n5);
                date = this.cal.getTime();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RegException(_.__("versiondateValEr", string2));
            }
            catch (Exception exception) {
                throw new RegException(_.__("versionDateParseEr", exception.toString()));
            }
            this.revise(string, date);
        }
    }

    public void revise(String string, Date date) {
        Revision revision = new Revision(string, null, date, new Date());
        this.revise(revision);
    }

    public void revise(Properties properties) throws RegException {
        String string = properties.getProperty("version");
        ((Hashtable)properties).remove("version");
        String string2 = properties.getProperty("versiondate");
        ((Hashtable)properties).remove("versiondate");
        String string3 = properties.getProperty("versionvector");
        ((Hashtable)properties).remove("versionvector");
        if (string != null) {
            this.revise(string, string2);
            if (string3 != null) {
                this.revisions[this.revisions.length - 1].parseVVector(string3);
            }
        }
    }

    public void setAttribute(String string, String string2) {
        ((Hashtable)this.props).put(string.toLowerCase(), string2);
    }

    public void setCollapsed(boolean bl) {
        this.collapsed = bl;
    }

    public void setView(LabelBlock labelBlock) {
        String string;
        String string2;
        Object object;
        this.load();
        labelBlock.title.setText(this.getTitle());
        Article article = this;
        String string3 = article.getAttribute("version");
        try {
            while (article != null && string3 == null && (article.revisions == null || article.revisions.length <= 0)) {
                article = article.getParent();
                string3 = article.getAttribute("version");
            }
        }
        catch (Exception exception) {
            article = null;
        }
        if (article != null) {
            if (article.revisions == null) {
                labelBlock.version.setText(this.getAttribute("version", ""));
            } else {
                object = article.revisions[article.revisions.length - 1];
                string2 = article == this ? ((Revision)object).version : _.__("partOfVersion", article.getTitle(), ((Revision)object).version);
                if (((Revision)object).buildDate != 0L) {
                    string2 = String.valueOf(string2) + ", " + builddateformat.format(new Date(((Revision)object).buildDate));
                }
                labelBlock.version.setText(string2);
                if (((Revision)object).installDate != 0L) {
                    labelBlock.installationDate.setText(installdateformat.format(new Date(((Revision)object).installDate)));
                }
            }
        }
        if ((object = this.getAttribute("source")) != null) {
            labelBlock.source.setText((String)object);
        }
        if ((string2 = this.getAttribute("installlocation")) != null) {
            labelBlock.installlocation.setText(string2);
        }
        labelBlock.installMegs.setText(this.getAttribute("installdiskspace", this.getAttribute("diskspace", "")));
        String string4 = this.getAttribute("locationflags", "");
        if (string2 != null && string4.indexOf(115) < 0) {
            try {
                labelBlock.selectedFileCount = new FileCount();
                labelBlock.selectedThread = labelBlock.selectedFileCount.startFileCount(string2, labelBlock.currentMegs);
            }
            catch (SecurityException securityException) {}
        }
        if (this.damageReason != null) {
            labelBlock.damageReport.setText(this.damageReason);
            labelBlock.damageIcon.setImage(LabelBlock.damageImage);
        }
        if ((string = _.__("uninstallThis", this.getTitle())).length() > 50) {
            string = String.valueOf(string.substring(0, 47)) + "...";
        }
        if (ProdReg.Swing) {
            ((JButton)labelBlock.uninstallButton).setText(string);
        } else {
            ((Button)labelBlock.uninstallButton).setLabel(string);
        }
        if (this.getAttribute("uninstall", "wr").indexOf("x") >= 0 && !UninstallThread.clinic) {
            labelBlock.uninstallpanel.remove(labelBlock.uninstallButton);
        } else {
            labelBlock.uninstallpanel.add(labelBlock.uninstallButton);
        }
        labelBlock.uninstallButton.invalidate();
        labelBlock.uninstallpanel.doLayout();
    }

    public String toString() {
        String string = this.getTitle();
        if (this.revisions != null && this.revisions.length >= 1) {
            string = String.valueOf(string) + "  " + this.revisions[this.revisions.length - 1].version;
        }
        return string;
    }

    public void uninstall() throws Exception {
        String string = this.getAttribute("uninstall", "wr");
        if (string.indexOf("x") >= 0) {
            throw new RegException(_.__("cantBeUninstalledEr", this.getTitle()));
        }
        String string2 = this.getAttribute("installlocation");
        if (string.indexOf("p") >= 0) {
            boolean bl = ProdReg.systemRegistry.articles.contains(this);
            ExtProgram.runUninstaller(this, string2, bl);
        }
        if (string.indexOf("d") >= 0) {
            if (string2 == null) {
                throw new RegException(_.__("cantDeleteNoLocEr", this.getTitle()));
            }
            File file = new File(string2);
            if (!file.exists()) {
                throw new RegException(_.__("cantDeleteNoExistEr", this.getTitle()));
            }
            this.deleteFileRecursive(new File(string2));
        }
        if (string.indexOf("r") >= 0) {
            this.unregister();
        }
    }

    public void unregister() throws Exception {
        Registry registry = Registry.openContainingRegistry(this);
        Article article = Article.lookup(this.mnemonic, this.id);
        if (article != null) {
            article.deParent();
            registry.remove(article);
        }
        try {
            registry.save();
        }
        catch (IOException iOException) {
            registry.revert();
            throw iOException;
        }
    }

    void validate(Article[] articleArray) throws RegException {
        this.validateArticles(articleArray);
        String string = this.getAttribute("parent");
        if (articleArray[0] == this || string == null) {
            if (string != null) {
                throw new CannotRegister(_.__("cantHaveParentEr", this.mnemonic));
            }
        } else {
            if (string == null) {
                throw new CannotRegister(_.__("mustHaveParentEr", this.mnemonic));
            }
            string = string.toLowerCase();
            this.setAttribute("parent", string);
            int n = 0;
            while (n < articleArray.length) {
                if (articleArray[n].mnemonic.equals(string)) break;
                ++n;
            }
            if (n >= articleArray.length) {
                throw new CannotRegister(_.__("parentNotRegEr", this.mnemonic));
            }
            Article article = articleArray[n];
            String string2 = article.getAttribute("articles");
            if (string2 == null) {
                throw new CannotRegister(_.__("noArticleAttrEr", this.mnemonic, string));
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
            do {
                if (stringTokenizer.hasMoreTokens()) continue;
                throw new CannotRegister(_.__("unlistedArticleEr", this.mnemonic, string));
            } while (!stringTokenizer.nextToken().equals(this.mnemonic));
            this.setAttribute("parentid", article.id);
        }
    }

    private void validateArticles(Article[] articleArray) throws RegException {
        String string = this.getAttribute("articles");
        if (string == null) {
            return;
        }
        string = string.toLowerCase();
        this.setAttribute("articles", string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            int n = 0;
            while (n < articleArray.length) {
                if (articleArray[n].mnemonic.equals(string3)) break;
                ++n;
            }
            if (n >= articleArray.length) {
                throw new CannotRegister(_.__("articleNotRegEr", this.mnemonic, string3));
            }
            Article article = articleArray[n];
            String string4 = article.getAttribute("parent", this.mnemonic);
            if (!string4.equalsIgnoreCase(this.mnemonic)) {
                throw new CannotRegister(_.__("unlistedParentEr", this.mnemonic, string3));
            }
            string2 = String.valueOf(string2) + article.getAttribute("id") + ' ';
        }
        this.setAttribute("articleids", string2);
    }

    class ArticleEnumeration
    implements Enumeration {
        StringTokenizer mnemonics;
        StringTokenizer ids;

        ArticleEnumeration(Article article2) {
            this.ids = new StringTokenizer(article2.getAttribute("articleids", ""));
            this.mnemonics = new StringTokenizer(article2.getAttribute("articles", ""));
        }

        public boolean hasMoreElements() {
            return this.ids.hasMoreTokens() && this.mnemonics.hasMoreTokens();
        }

        public Object nextElement() {
            String string = this.ids.nextToken();
            String string2 = this.mnemonics.nextToken();
            return Article.lookup(string2, string);
        }
    }
}

