/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client.users;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.FilterItem;
import com.sun.admin.cis.common.FilterPanel;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ListFetchAdapter;
import com.sun.admin.cis.common.ListFetchEvent;
import com.sun.admin.cis.common.ListFetchListener;
import com.sun.admin.cis.common.ListProperties;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.usermgr.client.AppData;
import com.sun.admin.usermgr.client.Content;
import com.sun.admin.usermgr.client.ServiceWrapper;
import com.sun.admin.usermgr.client.VUserMgr;
import com.sun.admin.usermgr.client.rbac.AssignRightDlg;
import com.sun.admin.usermgr.client.users.AddMultiUsersWithTemplDlg;
import com.sun.admin.usermgr.client.users.AddUserWithTemplDlg;
import com.sun.admin.usermgr.client.users.AdminMultiUserWiz;
import com.sun.admin.usermgr.client.users.AdminUserWizard;
import com.sun.admin.usermgr.client.users.ConfDelUserPanel;
import com.sun.admin.usermgr.client.users.PropertyDialog;
import com.sun.admin.usermgr.client.users.UMgrUserMenuBar;
import com.sun.admin.usermgr.client.users.UMgrUserTBar;
import com.sun.admin.usermgr.client.users.UserPoliciesDlg;
import com.sun.admin.usermgr.common.PartialSuccessObject;
import com.sun.admin.usermgr.common.SolServerPartialSuccessException;
import com.sun.admin.usermgr.common.UserObj;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VFilter;
import com.sun.management.viper.console.gui.VFrame;
import com.sun.management.viper.console.gui.VOptionPane;
import com.sun.management.viper.services.PersistenceAgent;
import com.sun.management.viper.services.PersistenceException;
import com.sun.management.viper.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.tree.MutableTreeNode;

public class UserContent
extends Content {
    private static String[][] columnHeaders = null;
    private ResourceBundle bundle;
    VUserMgr theApp;
    private ListProperties listProperties;
    private ImageIcon smallUsersIcon;
    private ImageIcon largeUsersIcon;
    private UMgrUserMenuBar userMenuBar;
    private UMgrUserTBar userToolBar;
    private VFilter filterControl = null;
    UserContent userContent;

    public UserContent(VUserMgr vUserMgr) {
        super(vUserMgr);
        this.theApp = vUserMgr;
        this.userContent = this;
        this.bundle = vUserMgr.getResourceBundle();
        this.sortPreferencesKey = String.valueOf(this.getClass().getName()) + ".sortPreferences";
        this.userMenuBar = new UMgrUserMenuBar(vUserMgr, this);
        this.userToolBar = new UMgrUserTBar(vUserMgr, this);
        this.rootNode = new VScopeNode();
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        this.rootNode.setMenuBar((JMenuBar)this.userMenuBar);
        this.rootNode.setToolBar((JToolBar)this.userToolBar);
        this.smallUsersIcon = vUserMgr.loadImageIcon("user_16.gif", "");
        this.largeUsersIcon = vUserMgr.loadImageIcon("user_32.gif", "");
        try {
            this.listProperties = new ListProperties();
            this.listProperties.setFilters(new Vector());
        }
        catch (AdminException adminException) {
            vUserMgr.reportErrorException((Exception)((Object)adminException));
        }
    }

    public void addMultiUsers() {
        Thread thread = new Thread(){

            public void run() {
                UserContent.this.theApp.waitOn();
                AdminMultiUserWiz adminMultiUserWiz = new AdminMultiUserWiz(UserContent.this.theApp, ResourceStrings.getString((ResourceBundle)UserContent.this.bundle, (String)"mu_wiz_dialog_name"), true, false);
                adminMultiUserWiz.init();
                VFrame vFrame = new VFrame();
                adminMultiUserWiz.setContainer((Component)vFrame);
                vFrame.showCenter((Component)UserContent.this.theApp.getProperties().getPropertyObject("vconsole.frame"));
                adminMultiUserWiz.setVisible(true);
                adminMultiUserWiz.start();
                UserContent.this.theApp.waitOff();
            }
        };
        thread.start();
    }

    public void addMultiUsersWithTempl() {
        Thread thread = new Thread(){

            public void run() {
                UserContent.this.theApp.waitOn();
                AddMultiUsersWithTemplDlg addMultiUsersWithTemplDlg = new AddMultiUsersWithTemplDlg(UserContent.this.theApp);
                ((Component)((Object)addMultiUsersWithTemplDlg)).setVisible(true);
                UserContent.this.theApp.waitOff();
            }
        };
        thread.start();
    }

    public void addUserWithTempl() {
        Thread thread = new Thread(){

            public void run() {
                UserContent.this.theApp.waitOn();
                AddUserWithTemplDlg addUserWithTemplDlg = new AddUserWithTemplDlg(UserContent.this.theApp, UserContent.this.userContent);
                ((Component)((Object)addUserWithTemplDlg)).setVisible(true);
                UserContent.this.theApp.waitOff();
            }
        };
        thread.start();
    }

    public void appendToResultsPane(Vector vector) {
        UserObj userObj;
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        String string = ResourceManager.getLocalizedTextFile((String)"html/users.html", this.theApp.getClass());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            userObj = (UserObj)enumeration.nextElement();
            VScopeNode vScopeNode = new VScopeNode(null, null, null, null, null, this.userMenuBar.getPopupMenu(), this.smallUsersIcon, this.largeUsersIcon, userObj.getUserName(), null, null, -1, (Object)userObj);
            vScopeNode.setHTMLText(string);
            vScopeNode.setColumnValues(UserContent.getColumnValues(this.bundle, userObj));
            this.rootNode.add((MutableTreeNode)vScopeNode);
            this.vDataCache.addElement(userObj);
        }
        userObj = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.getTreeNode());
        this.theApp.fireConsoleAction((VConsoleEvent)userObj);
    }

    public void assignRight() {
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        Thread thread = new Thread(){

            public void run() {
                UserContent.this.theApp.waitOn();
                Vector vector = UserContent.this.getSelected();
                VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
                UserObj userObj = (UserObj)vScopeNode.getPayload();
                try {
                    userObj = UserContent.this.theApp.getUserMgr().getFullAttributes(userObj);
                }
                catch (Exception exception) {
                    UserContent.this.theApp.reportErrorException(exception);
                    return;
                }
                AssignRightDlg assignRightDlg = new AssignRightDlg(UserContent.this.theApp, UserContent.this.theApp.getFrame(), userObj, false);
                ((Dialog)((Object)assignRightDlg)).setTitle(ResourceStrings.getString((ResourceBundle)UserContent.this.bundle, (String)"assign_right_user_title"));
                ((Component)((Object)assignRightDlg)).setVisible(true);
                UserContent.this.theApp.waitOff();
            }
        };
        thread.start();
    }

    public void clear(boolean bl) {
        this.clearSelection();
        this.getDataCache().removeAllElements();
        System.gc();
        this.rootNode = new VScopeNode();
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        this.rootNode.setMenuBar((JMenuBar)this.userMenuBar);
        this.rootNode.setToolBar((JToolBar)this.userToolBar);
        this.getTreeNode().setInternalRoot(this.rootNode);
        if (bl) {
            VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.treeNode);
            this.theApp.fireConsoleAction(vConsoleEvent);
        }
        this.bRefresh = true;
    }

    public void copyUsers() {
        StringSelection stringSelection;
        String string = new String();
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        int n = 0;
        while (n < vector.size()) {
            try {
                stringSelection = (VScopeNode)vector.elementAt(n);
                UserObj userObj = (UserObj)stringSelection.getPayload();
                String string2 = userObj.getUserName();
                string = string.concat(String.valueOf(string2) + ";");
            }
            catch (Exception exception) {
                this.theApp.reportErrorException(exception);
            }
            ++n;
        }
        stringSelection = new StringSelection(string);
        this.theApp.getClipBoard().setContents(stringSelection, stringSelection);
    }

    public void createProperties() {
        Thread thread = new Thread(){

            public void run() {
                UserContent.this.theApp.waitOn();
                AdminUserWizard adminUserWizard = new AdminUserWizard(UserContent.this.theApp, UserContent.this.userContent, ResourceStrings.getString((ResourceBundle)UserContent.this.bundle, (String)"au_wiz_dialog_name"), true, false);
                ((Window)((Object)adminUserWizard)).pack();
                Dimension dimension = ((Container)((Object)adminUserWizard)).getPreferredSize();
                Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
                ((Component)((Object)adminUserWizard)).setLocation(dimension2.width / 2 - dimension.width / 2, dimension2.height / 2 - dimension.height / 2);
                adminUserWizard.setVisible(true);
                UserContent.this.theApp.waitOff();
            }
        };
        thread.start();
    }

    public void deleteSelected() {
        final ConfDelUserPanel confDelUserPanel = new ConfDelUserPanel(this.theApp);
        String string = new String(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"warning_user"));
        final Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    try {
                        String string;
                        UserObj userObj;
                        block10: {
                            VScopeNode vScopeNode = (VScopeNode)enumeration.nextElement();
                            userObj = (UserObj)vScopeNode.getPayload();
                            if (confDelUserPanel.delHomeDir()) {
                                userObj.setDelHomeDir(true);
                            }
                            if (confDelUserPanel.delMailBox()) {
                                userObj.setDelMBox(true);
                            }
                            String string2 = new String(userObj.getUserName());
                            string = String.valueOf(UserPoliciesDlg.USER_POLICIES) + string2;
                            try {
                                theApp.getUserMgr().deleteUser(userObj);
                            }
                            catch (SolServerPartialSuccessException solServerPartialSuccessException) {
                                String string3;
                                PartialSuccessObject partialSuccessObject = solServerPartialSuccessException.getPartialSuccessObject();
                                if (partialSuccessObject == null || (string3 = solServerPartialSuccessException.getLocalizedMessage()) == null || string3.equals("")) break block10;
                                new ErrorDialog(theApp.getFrame(), ResourceStrings.getString((ResourceBundle)bundle, (String)"er_information"), string3, true);
                            }
                        }
                        PersistenceAgent persistenceAgent = null;
                        try {
                            persistenceAgent = new PersistenceAgent(theApp.getToolInfrastructure());
                            if (persistenceAgent != null) {
                                persistenceAgent.delete(string);
                            }
                        }
                        catch (PersistenceException persistenceException) {}
                        theApp.setAllUsersCache(null);
                        userContent.removeFromResultsPane(userObj);
                    }
                    catch (AdminException adminException) {
                        theApp.reportErrorException((Exception)((Object)adminException));
                    }
                }
            }
        };
        WarningDialog warningDialog = new WarningDialog(this.theApp.getFrame(), string, (JPanel)confDelUserPanel, actionListener, ResourceStrings.getString((ResourceBundle)this.bundle, (String)"warning_delete"));
    }

    public String[][] getColumnHeaders() {
        Object[][] objectArray = new Object[][]{{ResourceStrings.getString((ResourceBundle)this.bundle, (String)"table_user_type"), new Integer(16)}, {ResourceStrings.getString((ResourceBundle)this.bundle, (String)"table_user_desc"), new Integer(32)}, {ResourceStrings.getString((ResourceBundle)this.bundle, (String)"table_user_id"), new Integer(20016)}};
        if (columnHeaders == null) {
            columnHeaders = this.constructColumnHeaders(objectArray);
        }
        return columnHeaders;
    }

    public static Hashtable getColumnValues(ResourceBundle resourceBundle, UserObj userObj) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        int n = 0;
        String string = columnHeaders[n++][0];
        String string2 = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"Solaris");
        hashtable.put(string, string2);
        string = columnHeaders[n++][0];
        hashtable.put(string, userObj.getUserDescription());
        string = columnHeaders[n++][0];
        try {
            Integer n2 = new Integer(userObj.getUserID());
            hashtable.put(string, n2);
        }
        catch (Exception exception) {
            hashtable.put(string, userObj.getUserID());
        }
        return hashtable;
    }

    private int getDisplayChunkSize() {
        return 0;
    }

    public String[] getFilterAttributes() {
        String[] stringArray = new String[]{"filter_user_name", "filter_user_desc", "filter_user_id"};
        return stringArray;
    }

    public VFilter getFilterControl() {
        if (this.isFilteringSupported() && this.filterControl == null) {
            this.filterControl = new FilterControl();
        }
        return this.filterControl;
    }

    public Vector getFilters() {
        if (this.listProperties != null) {
            return this.listProperties.getFilters();
        }
        return null;
    }

    public ListProperties getListProperties() {
        return this.listProperties;
    }

    public UMgrUserMenuBar getMenuBar() {
        return this.userMenuBar;
    }

    private int getServerChunkSize() {
        return 0;
    }

    public UMgrUserTBar getToolBar() {
        return this.userToolBar;
    }

    public boolean isFilteringSupported() {
        return true;
    }

    public void refresh() {
        this.theApp.setAdminRoleCache(null);
        this.vDataCache.removeAllElements();
        System.gc();
        this.clear(false);
        this.theApp.setStatusBar("");
        MyListFetch myListFetch = new MyListFetch(this.getServerChunkSize(), this.getDisplayChunkSize());
        myListFetch.addListFetchListener(new ListFetchListener(){

            public synchronized void batchReady(ListFetchEvent listFetchEvent) {
                Vector vector = listFetchEvent.getBatch();
                if (vector == null) {
                    UserContent.this.updateStatusBar();
                    UserContent.this.showFilteredStatus();
                    UserContent.this.theApp.waitOff();
                    return;
                }
                UserContent.this.appendToResultsPane(vector);
            }

            public synchronized void errorException(Exception exception) {
                UserContent.this.theApp.reportErrorException(exception);
            }
        });
        this.theApp.waitOn();
        ((Thread)((Object)myListFetch)).start();
        this.bRefresh = true;
    }

    private void removeFromResultsPane(UserObj userObj) {
        int n = 0;
        while (n < this.rootNode.getChildCount()) {
            VScopeNode vScopeNode = (VScopeNode)this.rootNode.getChildAt(n);
            UserObj userObj2 = (UserObj)vScopeNode.getPayload();
            if (userObj2 == userObj) {
                this.rootNode.remove((MutableTreeNode)vScopeNode);
                VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.treeNode);
                this.theApp.fireConsoleAction(vConsoleEvent);
                break;
            }
            ++n;
        }
    }

    public void renameSelected() {
    }

    public void setFilters(Vector vector) {
        try {
            if (this.listProperties != null) {
                this.listProperties.setFilters(vector);
            } else {
                this.listProperties = new ListProperties();
                this.listProperties.setFilters(vector);
            }
        }
        catch (AdminException adminException) {}
    }

    public void setListProperties(ListProperties listProperties) {
        this.listProperties = listProperties;
    }

    public void updateStatusBar() {
        ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        String string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"UserListContents");
        Object[] objectArray = new Object[]{new Integer(this.getDataCache().size())};
        String string2 = MessageFormat.format(string, objectArray);
        this.theApp.setStatusBar(string2);
    }

    public void viewProperties() {
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        Thread thread = new Thread(){

            public void run() {
                UserContent.this.theApp.waitOn();
                Vector vector = UserContent.this.getSelected();
                VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
                UserObj userObj = (UserObj)vScopeNode.getPayload();
                try {
                    userObj = UserContent.this.theApp.getUserMgr().getFullAttributes(userObj);
                }
                catch (AdminException adminException) {
                    UserContent.this.theApp.reportErrorException((Exception)((Object)adminException));
                    return;
                }
                PropertyDialog propertyDialog = new PropertyDialog(UserContent.this.theApp, UserContent.this.theApp.getFrame(), userObj);
                ((Component)((Object)propertyDialog)).setVisible(true);
                UserContent.this.theApp.waitOff();
            }
        };
        thread.start();
    }

    public String whatAmI() {
        return ResourceStrings.getString((ResourceBundle)this.bundle, (String)"users");
    }

    private class FilterControl
    implements VFilter {
        private Vector helpCache = new Vector(12);
        private FilterPanel filterPanel = null;
        private Action filterAction = null;
        private VConsoleProperties properties = null;

        static /* synthetic */ Action access$0(FilterControl filterControl) {
            return filterControl.filterAction;
        }

        public Vector applyFilter(VScopeNode vScopeNode) {
            return null;
        }

        public void clearFilter() {
            this.filterPanel.setDefaultState();
            this.filterAction.setEnabled(false);
        }

        public boolean getFilterEnabled() {
            if (this.filterPanel != null) {
                this.filterPanel.setFilterItems(UserContent.this.getFilters());
            }
            if (this.filterAction != null) {
                Vector vector = UserContent.this.getFilters();
                int n = 0;
                int n2 = 0;
                while (vector != null && n2 < vector.size()) {
                    FilterItem filterItem = (FilterItem)vector.elementAt(n2);
                    n += filterItem.getValue().length();
                    ++n2;
                }
                this.filterAction.setEnabled(n > 0);
            }
            return false;
        }

        public boolean getFindMode() {
            return false;
        }

        public void setFilterAction(Action action) {
            this.filterAction = action;
        }

        public void setFilterEnabled(boolean bl) {
            UserContent.this.setFilters(bl ? this.filterPanel.getFilterItems() : new Vector());
            UserContent.this.refresh();
        }

        public void setFindMode(boolean bl) {
        }

        public void setOptionPane(VOptionPane vOptionPane) {
            if (vOptionPane == null) {
                return;
            }
            ActionListener actionListener = new ActionListener(this){
                private final /* synthetic */ FilterControl this$1;
                {
                    this.this$1 = filterControl;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    FilterControl.access$0(this.this$1).setEnabled(actionEvent.getID() > 0);
                }
            };
            GenInfoPanel genInfoPanel = new GenInfoPanel(vOptionPane);
            this.filterPanel = new FilterPanel(UserContent.this.getFilterAttributes(), "com.sun.admin.usermgr.client.resources.Resources", this.helpCache, genInfoPanel, actionListener);
            this.filterPanel.setFilterItems(UserContent.this.getFilters());
            vOptionPane.getContentPane().setLayout(new BorderLayout());
            vOptionPane.getContentPane().add((Component)this.filterPanel, "Center");
            vOptionPane.repaint();
        }

        public void setProperties(VConsoleProperties vConsoleProperties) {
            this.properties = vConsoleProperties;
        }
    }

    private class MyListFetch
    extends ListFetchAdapter {
        ServiceWrapper userMgr;
        AppData appData = null;
        ListProperties listProps;

        public MyListFetch(int n, int n2) {
            super(n, n2);
        }

        public String getTracePrefix() {
            return ResourceStrings.getString((ResourceBundle)UserContent.this.bundle, (String)"users");
        }

        public Vector listAll() throws AdminException {
            if (UserContent.this.getListProperties() == null) {
                return new Vector();
            }
            Vector vector = new Vector();
            ListProperties listProperties = UserContent.this.getListProperties();
            Vector vector2 = listProperties.getFilters();
            if (!vector2.isEmpty()) {
                vector = UserContent.this.theApp.getUserMgr().getAllUsers(UserContent.this.getListProperties());
            } else {
                vector = UserContent.this.theApp.getUserMgr().getAllUsers();
                UserContent.this.theApp.setAllUsersCache(vector);
            }
            return vector;
        }
    }
}

