/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client.rbac;

import com.sun.admin.cis.common.Arranger;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ContextHelpListener;
import com.sun.admin.cis.common.DblTreeNode;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.sort.Compare;
import com.sun.admin.cis.common.sort.Sort;
import com.sun.admin.usermgr.client.UMgrContextHelpListener;
import com.sun.admin.usermgr.client.UMgrPropsPanel;
import com.sun.admin.usermgr.client.VUserMgr;
import com.sun.admin.usermgr.client.rbac.NodeCompare;
import com.sun.admin.usermgr.client.rbac.ProfTreeNode;
import com.sun.admin.usermgr.client.rbac.ProfileRenderer;
import com.sun.admin.usermgr.common.ProfAttrObj;
import com.sun.admin.usermgr.common.RightObj;
import com.sun.admin.usermgr.common.UserAttrObj;
import com.sun.admin.usermgr.common.UserObj;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class RightsPanel
extends UMgrPropsPanel {
    private GenInfoPanel infoPanel;
    private VUserMgr theApp;
    private ResourceBundle bundle;
    public static Arranger profPanel;
    private static DblTreeNode srcRoot;
    private static DblTreeNode dstRoot;
    private DefaultTreeModel srcModel;
    private DefaultTreeModel dstModel;
    private DblTreeNode[] profNodes;
    private ProfTreeNode[] profTreeNodes;
    private ProfTreeNode currProfTreeNode;
    private DblTreeNode currDblTreeNode;
    private String targetRightName;
    private RightObj targetRight;
    private UserObj userObj = null;
    private Vector vAllRightObjs = null;
    private boolean isNew;
    private boolean isUserProps = false;
    private boolean isRightProps = false;
    private boolean isProfListOK = true;

    public RightsPanel(VUserMgr vUserMgr, GenInfoPanel genInfoPanel, boolean bl, UserObj userObj) {
        this(vUserMgr, null, genInfoPanel, false, userObj);
    }

    public RightsPanel(VUserMgr vUserMgr, RightObj rightObj, GenInfoPanel genInfoPanel, boolean bl) {
        this(vUserMgr, rightObj, genInfoPanel, bl, null);
    }

    public RightsPanel(VUserMgr vUserMgr, RightObj rightObj, GenInfoPanel genInfoPanel, boolean bl, UserObj userObj) {
        this.infoPanel = genInfoPanel;
        this.theApp = vUserMgr;
        this.userObj = userObj;
        this.bundle = vUserMgr.getResourceBundle();
        this.isNew = bl;
        if (userObj != null) {
            this.isUserProps = true;
        } else {
            this.isRightProps = true;
        }
        this.targetRight = rightObj;
        if (this.isRightProps && !this.isNew) {
            this.targetRightName = rightObj.getRightName();
        }
        this.createGui();
        this.loadProfTrees();
    }

    private void createGui() {
        Vector vector = new Vector(2);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        profPanel = this.isUserProps ? new Arranger(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"role_avail_rights"), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"role_granted_rights")) : new Arranger(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"right_subright_excluded"), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"right_subright_included"));
        RightsPanel.profPanel.srcTree.setCellRenderer(new ProfileRenderer(this, this.theApp));
        RightsPanel.profPanel.dstTree.setCellRenderer(new ProfileRenderer(this, this.theApp));
        Constraints.constrain((Container)this, (Component)profPanel, (int)0, (int)0, (int)1, (int)1, (int)1, (int)10, (double)1.0, (double)1.0, (int)10, (int)10, (int)10, (int)10);
    }

    private void disableProfileChoices(TreeModelEvent treeModelEvent) {
        if (treeModelEvent.getPath().length > 1) {
            return;
        }
        Object[] objectArray = treeModelEvent.getChildren();
        DblTreeNode dblTreeNode = (DblTreeNode)objectArray[0];
        Enumeration<TreeNode> enumeration = dblTreeNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            this.disableRecursively((DblTreeNode)enumeration.nextElement());
        }
    }

    private void disableRecursively(DblTreeNode dblTreeNode) {
        String string = dblTreeNode.toString();
        Enumeration<TreeNode> enumeration = srcRoot.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            TreeNode[] treeNodeArray;
            DblTreeNode dblTreeNode2;
            DblTreeNode dblTreeNode3 = (DblTreeNode)enumeration.nextElement();
            if (!string.equals(dblTreeNode3.toString()) || (dblTreeNode2 = (DblTreeNode)(treeNodeArray = dblTreeNode3.getPath())[1]).isConflict()) continue;
            dblTreeNode2.setConflict(true);
            dblTreeNode3.setConflict(true);
        }
    }

    private void enableProfileChoices(TreeModelEvent treeModelEvent) {
        if (treeModelEvent.getPath().length > 1) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        if (this.isRightProps) {
            vector.addElement(this.currDblTreeNode.toString());
        }
        Enumeration<TreeNode> enumeration = dstRoot.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement().toString());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        Enumeration<TreeNode> enumeration2 = srcRoot.children();
        while (enumeration2.hasMoreElements()) {
            String string;
            DblTreeNode dblTreeNode = (DblTreeNode)enumeration2.nextElement();
            boolean bl = false;
            Enumeration<TreeNode> enumeration3 = dblTreeNode.depthFirstEnumeration();
            while (enumeration3.hasMoreElements()) {
                string = enumeration3.nextElement().toString();
                int n = 0;
                while (n < objectArray.length) {
                    if (string.equals(objectArray[n])) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
                if (bl) break;
            }
            if (bl) continue;
            enumeration3 = dblTreeNode.depthFirstEnumeration();
            while (enumeration3.hasMoreElements()) {
                string = (DblTreeNode)enumeration3.nextElement();
                string.setConflict(false);
            }
            dblTreeNode.setConflict(false);
        }
    }

    public Vector getAssignedProfs() {
        Vector<String> vector = new Vector<String>();
        if (!this.isProfListOK) {
            return vector;
        }
        DblTreeNode dblTreeNode = (DblTreeNode)this.dstModel.getRoot();
        Enumeration<TreeNode> enumeration = dblTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DblTreeNode dblTreeNode2 = (DblTreeNode)enumeration.nextElement();
            vector.addElement(dblTreeNode2.toString());
        }
        return vector;
    }

    private void loadProfTrees() {
        int n;
        int n2;
        Object object;
        String[] stringArray;
        Object object2;
        Object object3;
        this.vAllRightObjs = this.theApp.getRightListCache();
        if (this.vAllRightObjs == null) {
            try {
                this.vAllRightObjs = this.theApp.getUserMgr().getRightProfs();
            }
            catch (Exception exception) {
                this.isProfListOK = false;
                this.theApp.reportErrorException(exception);
                return;
            }
            this.theApp.setRightListCache(this.vAllRightObjs);
        }
        this.srcModel = (DefaultTreeModel)RightsPanel.profPanel.srcTree.getModel();
        srcRoot = (DblTreeNode)this.srcModel.getRoot();
        this.dstModel = (DefaultTreeModel)RightsPanel.profPanel.dstTree.getModel();
        dstRoot = (DblTreeNode)this.dstModel.getRoot();
        if (this.isNew || this.isUserProps) {
            this.profNodes = new DblTreeNode[this.vAllRightObjs.size()];
            this.profTreeNodes = new ProfTreeNode[this.vAllRightObjs.size()];
        } else {
            this.profNodes = new DblTreeNode[this.vAllRightObjs.size() - 1];
            this.profTreeNodes = new ProfTreeNode[this.vAllRightObjs.size() - 1];
        }
        int n3 = 0;
        ProfAttrObj profAttrObj = null;
        Enumeration enumeration = this.vAllRightObjs.elements();
        Vector vector = new Vector(60);
        String string = this.theApp.getApplicationContext().getMgmtServer();
        while (enumeration.hasMoreElements()) {
            object3 = (RightObj)enumeration.nextElement();
            object2 = ((RightObj)object3).getRightName();
            if (this.isRightProps && !this.isNew && ((String)object2).equals(this.targetRightName)) {
                this.currProfTreeNode = new ProfTreeNode((RightObj)object3);
                this.currDblTreeNode = new DblTreeNode((Object)this.currProfTreeNode);
                continue;
            }
            this.profTreeNodes[n3] = new ProfTreeNode((RightObj)object3);
            stringArray = null;
            object = this.profTreeNodes[n3].getHelpFile();
            if (object != null) {
                n2 = ((String)object).lastIndexOf(".");
                if (n2 > -1) {
                    stringArray = ((String)object).substring(0, n2);
                }
                this.profTreeNodes[n3].setContextHelp(new UMgrContextHelpListener(this.theApp, vector, this.infoPanel, string, "profiles", (String)stringArray));
            }
            ++n3;
        }
        ContextHelpListener.loadHelp(vector);
        if (this.profTreeNodes.length > 1) {
            object3 = new NodeCompare();
            Sort.sort((Object[])this.profTreeNodes, (Compare)object3);
        }
        int n4 = 0;
        while (n4 < this.profTreeNodes.length) {
            this.profNodes[n4] = new DblTreeNode((Object)this.profTreeNodes[n4]);
            this.srcModel.insertNodeInto((MutableTreeNode)this.profNodes[n4], (MutableTreeNode)srcRoot, n4);
            object2 = new TreePath(this.profNodes[n4].getPath());
            RightsPanel.profPanel.srcTree.scrollPathToVisible((TreePath)object2);
            ++n4;
        }
        if (!this.theApp.getUserMgr().hasProfMgrAssignAuth()) {
            if (this.theApp.getUserMgr().hasProfMgrDelegateAuth()) {
                object2 = this.theApp.getAuthenticatedUser();
                stringArray = this.theApp.getAdminProfCache();
                if (stringArray == null) {
                    try {
                        stringArray = this.theApp.getUserMgr().getUserProfs((String)object2);
                    }
                    catch (Exception exception) {
                        this.theApp.reportErrorException(exception);
                    }
                    this.theApp.setAdminProfCache(stringArray);
                }
                int n5 = 0;
                while (n5 < this.profNodes.length) {
                    n2 = 0;
                    String string2 = this.profNodes[n5].toString();
                    n = 0;
                    while (n < stringArray.length) {
                        if (string2.equals(stringArray[n])) {
                            n2 = 1;
                            break;
                        }
                        ++n;
                    }
                    if (n2 != 0) {
                        this.profNodes[n5].setEnabled(true);
                    } else {
                        this.profNodes[n5].setEnabled(false);
                    }
                    ++n5;
                }
            } else {
                int n6 = 0;
                while (n6 < this.profNodes.length) {
                    this.profNodes[n6].setEnabled(false);
                    ++n6;
                }
            }
        }
        this.srcModel.addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            }

            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                RightsPanel.this.enableProfileChoices(treeModelEvent);
            }

            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                RightsPanel.this.disableProfileChoices(treeModelEvent);
            }

            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            }
        });
        this.dstModel.addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            }

            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                RightsPanel.this.updateDstTree(treeModelEvent);
            }

            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                RightsPanel.this.updateDstTree(treeModelEvent);
            }

            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            }
        });
        int n7 = 0;
        while (n7 < this.profNodes.length) {
            this.rebuildSubProfiles(this.profNodes[n7], this.profNodes[n7]);
            ++n7;
        }
        if (this.isNew) {
            this.currProfTreeNode = new ProfTreeNode(this.targetRight);
            this.currDblTreeNode = new DblTreeNode((Object)this.currProfTreeNode);
            profPanel.setInitSelection();
            return;
        }
        if (this.isUserProps) {
            object = this.userObj.getSolAuthAttrs();
            if (object == null) {
                profPanel.setInitSelection();
                return;
            }
            stringArray = ((UserAttrObj)object).getProfNames();
            if (stringArray == null) {
                profPanel.setInitSelection();
                return;
            }
        } else {
            profAttrObj = this.targetRight.getProfAttr();
            if (profAttrObj == null) {
                profPanel.setInitSelection();
                return;
            }
            stringArray = profAttrObj.getProfNames();
            if (stringArray == null) {
                profPanel.setInitSelection();
                return;
            }
        }
        int n8 = 0;
        while (n8 < stringArray.length) {
            n2 = 0;
            int n9 = 0;
            n = 0;
            while (n < this.profNodes.length) {
                String string3 = this.profNodes[n].toString();
                if (string3.equals(stringArray[n8])) {
                    n2 = 1;
                    n9 = n;
                    break;
                }
                ++n;
            }
            if (n2 != 0) {
                profPanel.initLeaf(RightsPanel.profPanel.srcTree, RightsPanel.profPanel.dstTree, this.profNodes[n9]);
            }
            ++n8;
        }
        profPanel.setInitSelection();
    }

    private void rebuildSubProfiles(DblTreeNode dblTreeNode, DblTreeNode dblTreeNode2) {
        DblTreeNode dblTreeNode3;
        int n = dblTreeNode.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            dblTreeNode3 = (DblTreeNode)this.srcModel.getChild(dblTreeNode, 0);
            this.srcModel.removeNodeFromParent((MutableTreeNode)dblTreeNode3);
            ++n2;
        }
        int n3 = 0;
        Enumeration<TreeNode> enumeration = dblTreeNode2.breadthFirstEnumeration();
        ProfTreeNode profTreeNode = (ProfTreeNode)dblTreeNode.getUserObject();
        RightObj rightObj = profTreeNode.getRightObj();
        ProfAttrObj profAttrObj = rightObj.getProfAttr();
        String[] stringArray = profAttrObj.getProfNames();
        if (stringArray == null) {
            return;
        }
        int n4 = 0;
        while (n4 < stringArray.length) {
            String string = stringArray[n4];
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                if (!string.equals(enumeration.nextElement().toString())) continue;
                bl = true;
                dblTreeNode2.setCyclic(true);
                Enumeration<TreeNode> enumeration2 = dblTreeNode2.breadthFirstEnumeration();
                while (enumeration2.hasMoreElements()) {
                    dblTreeNode3 = (DblTreeNode)enumeration2.nextElement();
                    if (!string.equals(dblTreeNode3.toString())) continue;
                    dblTreeNode3.setCyclic(true);
                }
                break block2;
            }
            int n5 = 0;
            while (n5 < this.profTreeNodes.length) {
                if (string.equals(this.profTreeNodes[n5].toString())) {
                    dblTreeNode3 = new DblTreeNode((Object)this.profTreeNodes[n5]);
                    this.srcModel.insertNodeInto((MutableTreeNode)dblTreeNode3, (MutableTreeNode)dblTreeNode, n3++);
                    dblTreeNode3.setEnabled(false);
                    if (bl) {
                        dblTreeNode3.setCyclic(true);
                    } else {
                        this.rebuildSubProfiles(dblTreeNode3, dblTreeNode2);
                    }
                }
                ++n5;
            }
            ++n4;
        }
    }

    private void updateDstTree(TreeModelEvent treeModelEvent) {
        DblTreeNode dblTreeNode;
        Vector<DblTreeNode> vector = new Vector<DblTreeNode>();
        if (this.isRightProps) {
            vector.addElement(this.currDblTreeNode);
        }
        Enumeration<TreeNode> enumeration = dstRoot.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            dblTreeNode = (DblTreeNode)enumeration.nextElement();
            vector.addElement(dblTreeNode);
            dblTreeNode.setConflict(false);
        }
        dblTreeNode = new DblTreeNode[vector.size()];
        vector.copyInto((Object[])dblTreeNode);
        if (((DblTreeNode)dblTreeNode).length < 2) {
            return;
        }
        int n = 0;
        while (n < ((DblTreeNode)dblTreeNode).length) {
            String string = dblTreeNode[n].toString();
            int n2 = n + 1;
            while (n2 < ((DblTreeNode)dblTreeNode).length) {
                if (string.equals(dblTreeNode[n2].toString())) {
                    dblTreeNode[n2].setConflict(true);
                    dblTreeNode[n].setConflict(true);
                    TreeNode[] treeNodeArray = dblTreeNode[n2].getPath();
                    DblTreeNode dblTreeNode2 = (DblTreeNode)treeNodeArray[1];
                    dblTreeNode2.setConflict(true);
                }
                ++n2;
            }
            ++n;
        }
    }

    public UserAttrObj updateRightProps(UserAttrObj userAttrObj) {
        if (this.isProfListOK) {
            userAttrObj.setProfNamesVector(this.getAssignedProfs());
        }
        return userAttrObj;
    }

    public RightObj updateRightSubProps(RightObj rightObj) {
        if (this.isProfListOK) {
            ProfAttrObj profAttrObj;
            Vector<String> vector = new Vector<String>();
            DblTreeNode dblTreeNode = (DblTreeNode)this.dstModel.getRoot();
            Enumeration<TreeNode> enumeration = dblTreeNode.children();
            while (enumeration.hasMoreElements()) {
                profAttrObj = (DblTreeNode)enumeration.nextElement();
                vector.addElement(((DefaultMutableTreeNode)((Object)profAttrObj)).toString());
            }
            profAttrObj = rightObj.getProfAttr();
            profAttrObj.setProfNamesVector(vector);
        }
        return rightObj;
    }
}

