/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.terminal.scm.SCMI2c;

import com.sun.opencard.terminal.scm.SCMI2c.I2CDeviceAccessException;
import com.sun.opencard.terminal.scm.SCMI2c.I2CErrorException;
import com.sun.opencard.terminal.scm.SCMI2c.I2CIllegalRegisterException;
import com.sun.opencard.terminal.scm.SCMI2c.I2CNoCardException;
import com.sun.opencard.terminal.scm.SCMI2c.I2CShortCircuitException;
import com.sun.opencard.terminal.scm.SCMI2c.I2CTimeoutException;
import opencard.core.util.Tracer;

public class SCMI2CNative {
    private String nativeLibrary;
    private String nativeLibrary_def = "SCMI2CNative";
    private String devName;
    private Tracer itracer = new Tracer((Object)this, class$com$sun$opencard$terminal$scm$SCMI2c$SCMI2CNative != null ? class$com$sun$opencard$terminal$scm$SCMI2c$SCMI2CNative : (class$com$sun$opencard$terminal$scm$SCMI2c$SCMI2CNative = SCMI2CNative.class$("com.sun.opencard.terminal.scm.SCMI2c.SCMI2CNative")));
    static /* synthetic */ Class class$com$sun$opencard$terminal$scm$SCMI2c$SCMI2CNative;

    public SCMI2CNative() throws I2CDeviceAccessException {
        this.nativeLibrary = this.nativeLibrary_def;
        this.init();
    }

    public SCMI2CNative(String string) throws I2CDeviceAccessException {
        this.nativeLibrary = string;
        this.init();
    }

    public void cardpowermanagement(int n, int n2) throws I2CDeviceAccessException, I2CErrorException {
        SCMI2CNative.nativeCardPowerManagement(n, n2);
    }

    public void cardpresent(int n) throws I2CDeviceAccessException, I2CErrorException, I2CNoCardException {
        SCMI2CNative.nativeCardpresent(n);
    }

    public void checkshortcircuit(int n) throws I2CDeviceAccessException, I2CErrorException, I2CShortCircuitException {
        SCMI2CNative.nativeCheckShortCircuit(n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public int close(int n) throws I2CDeviceAccessException {
        if (n < 0) {
            throw new I2CDeviceAccessException("close error: device not open");
        }
        return SCMI2CNative.nativeClose(n);
    }

    public void disablerxtxpolling(int n) throws I2CDeviceAccessException, I2CErrorException {
        SCMI2CNative.nativeDisablerxtxpolling(n);
    }

    public void enablerxtxpolling(int n) throws I2CDeviceAccessException, I2CErrorException {
        SCMI2CNative.nativeEnablerxtxpolling(n);
    }

    public int getnumreceived(int n) throws I2CDeviceAccessException, I2CErrorException {
        return SCMI2CNative.nativeGetnumreceived(n);
    }

    private void init() throws I2CDeviceAccessException {
        this.itracer.debug("SCMI2CNative", "instantiated, nativeLibrary = [" + this.nativeLibrary + "]");
        try {
            System.loadLibrary(this.nativeLibrary);
        }
        catch (Exception exception) {
            this.itracer.debug("SCMI2CNative", "can't load native library\n    nativeLibrary = [" + this.nativeLibrary + "]\n" + "      (exception) = " + exception.toString());
            throw new I2CDeviceAccessException("can't load native library [" + this.nativeLibrary + "]");
        }
        this.itracer.debug("SCMI2CNative", "loaded native library\n    nativeLibrary = [" + this.nativeLibrary + "]");
    }

    public static native void nativeCardPowerManagement(int var0, int var1) throws I2CDeviceAccessException, I2CErrorException;

    public static native void nativeCardpresent(int var0) throws I2CDeviceAccessException, I2CErrorException, I2CNoCardException;

    public static native void nativeCheckShortCircuit(int var0) throws I2CDeviceAccessException, I2CErrorException, I2CShortCircuitException;

    public static native int nativeClose(int var0) throws I2CDeviceAccessException;

    public static native void nativeDisablerxtxpolling(int var0) throws I2CDeviceAccessException, I2CErrorException;

    public static native void nativeEnablerxtxpolling(int var0) throws I2CDeviceAccessException, I2CErrorException;

    public static native int nativeGetnumreceived(int var0) throws I2CDeviceAccessException, I2CErrorException;

    public static native int nativeOpen(String var0) throws I2CDeviceAccessException;

    public static native byte nativeReadregister(int var0, int var1) throws I2CDeviceAccessException, I2CErrorException, I2CIllegalRegisterException;

    public static native int nativeReceiveblock(int var0, byte[] var1, int var2) throws I2CTimeoutException, I2CErrorException, I2CNoCardException, I2CDeviceAccessException;

    public static native int nativeSendblock(int var0, byte[] var1, int var2) throws I2CTimeoutException, I2CErrorException, I2CNoCardException, I2CDeviceAccessException;

    public static native void nativeSetReceiveTimeout(int var0, int var1) throws I2CDeviceAccessException, I2CErrorException;

    public static native void nativeSetSendTimeout(int var0, int var1) throws I2CDeviceAccessException, I2CErrorException;

    public static native void nativeWriteregister(int var0, int var1, byte var2) throws I2CDeviceAccessException, I2CErrorException, I2CIllegalRegisterException;

    public int open(String string) throws I2CDeviceAccessException {
        this.devName = string;
        this.itracer.debug("SCMI2CNative", "open: devName = [" + this.devName + "]");
        return SCMI2CNative.nativeOpen(this.devName);
    }

    public byte readregister(int n, int n2) throws I2CDeviceAccessException, I2CErrorException, I2CIllegalRegisterException {
        this.itracer.debug("SCMI2CNative", "readregister: register = 0x" + Integer.toHexString(n2));
        return SCMI2CNative.nativeReadregister(n, n2);
    }

    public int receiveblock(int n, byte[] byArray, int n2) throws I2CDeviceAccessException, I2CErrorException, I2CNoCardException, I2CTimeoutException {
        this.itracer.debug("SCMI2CNative", "receiveblock: num = " + n2);
        return SCMI2CNative.nativeReceiveblock(n, byArray, n2);
    }

    public int sendblock(int n, byte[] byArray, int n2) throws I2CTimeoutException, I2CErrorException, I2CNoCardException, I2CDeviceAccessException {
        this.itracer.debug("SCMI2CNative", "sendblock: length = " + n2);
        return SCMI2CNative.nativeSendblock(n, byArray, n2);
    }

    public void setreceivetimeout(int n, int n2) throws I2CDeviceAccessException, I2CErrorException {
        SCMI2CNative.nativeSetReceiveTimeout(n, n2);
    }

    public void setsendtimeout(int n, int n2) throws I2CDeviceAccessException, I2CErrorException {
        SCMI2CNative.nativeSetSendTimeout(n, n2);
    }

    public void writeregister(int n, int n2, byte by) throws I2CDeviceAccessException, I2CErrorException, I2CIllegalRegisterException {
        this.itracer.debug("SCMI2CNative", "writeregister: register = 0x" + Integer.toHexString(n2) + " value = 0x" + Integer.toHexString(by));
        SCMI2CNative.nativeWriteregister(n, n2, by);
    }
}

