/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.cli.pntadm;

import com.sun.dhcpmgr.bridge.BridgeException;
import com.sun.dhcpmgr.bridge.NoEntryException;
import com.sun.dhcpmgr.cli.common.DhcpCliFunction;
import com.sun.dhcpmgr.cli.common.Util;
import com.sun.dhcpmgr.cli.pntadm.PntAdmFunction;
import com.sun.dhcpmgr.data.DhcpClientRecord;
import com.sun.dhcpmgr.data.Network;

public class ModifyClientEntry
extends PntAdmFunction {
    static final int[] supportedOptions = new int[]{110, 99, 101, 102, 104, 105, 97, 109, 121, 115, 114, 117, 112};
    String clientIP;

    public ModifyClientEntry(String string) {
        this.clientIP = string;
        this.validOptions = supportedOptions;
    }

    public int execute() throws IllegalArgumentException {
        int n = 0;
        try {
            Object object;
            String string;
            String string2;
            String string3;
            DhcpClientRecord dhcpClientRecord = new DhcpClientRecord();
            dhcpClientRecord.setClientIP(this.clientIP);
            Network network = DhcpCliFunction.getNetMgr().getNetwork(this.networkName);
            if (network == null) {
                this.printErrMessage(this.getString("network_name_error"));
                return 3;
            }
            dhcpClientRecord = DhcpCliFunction.getNetMgr().getClient(dhcpClientRecord, network.toString(), this.getDhcpDatastore());
            DhcpClientRecord dhcpClientRecord2 = (DhcpClientRecord)dhcpClientRecord.clone();
            String string4 = this.options.valueOf(110);
            if (string4 != null) {
                dhcpClientRecord2.setClientIP(string4);
            } else {
                dhcpClientRecord2.setClientIP(this.clientIP);
            }
            String string5 = this.options.valueOf(105);
            boolean bl = this.options.isSet(97);
            if (bl) {
                if (string5 == null) {
                    String string6 = this.getString("no_clientid_specified");
                    throw new IllegalArgumentException(string6);
                }
                string5 = Util.asciiToHex(string5);
            }
            if (string5 != null) {
                dhcpClientRecord2.setClientId(string5);
            }
            if ((string3 = this.options.valueOf(102)) != null) {
                dhcpClientRecord2.setFlags(string3);
            }
            if ((string2 = this.options.valueOf(104)) != null) {
                if (this.isHostsManaged()) {
                    dhcpClientRecord2.setClientName(string2);
                } else {
                    n = 3;
                }
            }
            if ((string = this.options.valueOf(115)) == null) {
                string = DhcpCliFunction.getSvcMgr().getServerName();
            }
            dhcpClientRecord2.setServerIP(string);
            String string7 = this.options.valueOf(101);
            if (string7 != null) {
                String string8 = this.getString("expiration_format");
                dhcpClientRecord2.setExpiration(string8, string7);
            }
            boolean bl2 = this.options.isSet(121);
            String string9 = this.options.valueOf(109);
            if (bl2) {
                if (string9 == null) {
                    String string10 = this.getString("no_macro_specified");
                    throw new IllegalArgumentException(string10);
                }
                try {
                    object = DhcpCliFunction.getDhcptabMgr().getMacro(string9);
                }
                catch (BridgeException bridgeException) {
                    this.printErrMessage(this.getString("macro_not_found"));
                    return 3;
                }
            }
            if (string9 != null) {
                dhcpClientRecord2.setMacro(string9);
            }
            if ((object = this.options.valueOf(99)) != null) {
                dhcpClientRecord2.setComment((String)object);
            }
            DhcpCliFunction.getNetMgr().modifyClient(dhcpClientRecord, dhcpClientRecord2, network.toString(), this.getDhcpDatastore());
        }
        catch (NoEntryException noEntryException) {
            this.printErrMessage(DhcpCliFunction.getMessage(noEntryException));
            n = 2;
        }
        catch (Throwable throwable) {
            this.printErrMessage(DhcpCliFunction.getMessage(throwable));
            n = 3;
        }
        return n;
    }
}

