/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.iso.fs;

import java.io.EOFException;
import java.io.IOException;
import opencard.core.terminal.CardTerminalException;
import opencard.opt.iso.fs.CardFile;
import opencard.opt.iso.fs.CardIOException;
import opencard.opt.iso.fs.CardRandomAccess;
import opencard.opt.iso.fs.CardRecord;

public class CardRandomRecordAccess
extends CardRandomAccess {
    public CardRandomRecordAccess(CardFile cardFile) throws CardTerminalException, IOException {
        this(cardFile, "rw");
    }

    public CardRandomRecordAccess(CardFile cardFile, String string) throws CardTerminalException, IOException {
        super(cardFile, string);
        if (this.file.isDirectory() || this.file.isTransparent()) {
            throw new CardIOException("not a structured file " + this.file.getPath());
        }
        if (this.file.isCyclic()) {
            throw new CardIOException("cyclic file: " + this.file.getPath());
        }
    }

    public long getFilePointer() throws IOException, CardTerminalException {
        return this.filePointer;
    }

    public int read(CardRecord[] cardRecordArray) throws IOException, CardTerminalException {
        return this.read(cardRecordArray, 0, cardRecordArray.length);
    }

    public int read(CardRecord[] cardRecordArray, int n, int n2) throws IOException, CardTerminalException {
        int n3 = 0;
        while (n2 > 0) {
            cardRecordArray[n] = this.readRecord();
            if (cardRecordArray[n] == null) break;
            --n2;
            ++n3;
            ++n;
        }
        if (n3 == 0) {
            return -1;
        }
        return n3;
    }

    public CardRecord readRecord() throws IOException, CardTerminalException {
        CardRecord cardRecord = null;
        byte[] byArray = this.fileSystem.readRecord(this.file.getPath(), this.filePointer);
        if (byArray != null) {
            cardRecord = new CardRecord(byArray);
            ++this.filePointer;
        }
        return cardRecord;
    }

    public void seek(long l) throws EOFException, CardTerminalException {
        int n;
        int n2;
        int n3;
        if (!this.file.isVariable() && l >= (long)(n3 = (n2 = this.file.getLength()) / (n = this.file.getRecordSize()))) {
            throw new EOFException("seek past end of file");
        }
        this.filePointer = (int)l;
    }

    public int skip(int n) throws EOFException, CardTerminalException {
        this.seek(this.filePointer + n);
        return n;
    }

    public void write(CardRecord cardRecord) throws IOException, CardTerminalException {
        this.fileSystem.writeRecord(this.file.getPath(), this.filePointer, cardRecord.bytes());
        ++this.filePointer;
    }

    public void write(CardRecord[] cardRecordArray) throws IOException, CardTerminalException {
        this.write(cardRecordArray, 0, cardRecordArray.length);
    }

    public void write(CardRecord[] cardRecordArray, int n, int n2) throws IOException, CardTerminalException {
        while (n2 > 0) {
            this.write(cardRecordArray[n]);
            ++n;
            --n2;
        }
    }
}

