/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.terminal.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommunicationErrorException;

public class T0Protocol {
    private InputStream in;
    private OutputStream out;
    private static final int BAD_APDU = 0;
    private static final int CASE_1 = 1;
    private static final int CASE_2S = 2;
    private static final int CASE_3S = 3;
    private static final int CASE_4S = 4;
    private static final int CASE_2E = 5;
    private static final int CASE_3E = 6;
    private static final int CASE_4E = 7;

    public T0Protocol(InputStream inputStream, OutputStream outputStream) {
        this.in = inputStream;
        this.out = outputStream;
    }

    public static final int apduType(byte[] byArray, int n) {
        try {
            if (n == 4) {
                return 1;
            }
            if (n == 5) {
                return 2;
            }
            int n2 = byArray[4] & 0xFF;
            if (n2 != 0) {
                if (n == 5 + n2) {
                    return 3;
                }
                if (n == 6 + n2) {
                    return 4;
                }
                return 0;
            }
            if (n == 7) {
                return 5;
            }
            n2 = (byArray[5] & 0xFF) << 8 | byArray[6] & 0xFF;
            if (n2 != 0) {
                if (n == 7 + n2) {
                    return 6;
                }
                if (n == 9 + n2) {
                    return 7;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return 0;
    }

    public byte[] exchangeData(byte[] byArray, int n) throws CardTerminalException {
        switch (T0Protocol.apduType(byArray, n)) {
            case 1: {
                return this.sendTPDU(byArray, 0, 0, 0, 0);
            }
            case 2: {
                int n2 = T0Protocol.get1(byArray, 4);
                byte[] byArray2 = this.sendTPDU(byArray, n2, 0, 0, n2);
                if (T0Protocol.sw1(byArray2) == 108) {
                    int n3 = T0Protocol.sw2(byArray2);
                    byArray2 = T0Protocol.truncate(this.sendTPDU(byArray, n3, 0, 0, n3), n2);
                }
                return byArray2;
            }
            case 3: {
                int n4 = T0Protocol.get1(byArray, 4);
                byte[] byArray3 = this.sendTPDU(byArray, n4, n4, 5, 0);
                if (T0Protocol.sw1(byArray3) == 97) {
                    byArray3 = this.getResponse(T0Protocol.sw2(byArray3));
                }
                return byArray3;
            }
            case 4: {
                int n5 = T0Protocol.get1(byArray, 4);
                int n6 = T0Protocol.get1(byArray, n - 1);
                byte[] byArray4 = this.sendTPDU(byArray, n5, n5, 5, 0);
                switch (T0Protocol.sw1(byArray4)) {
                    case 144: {
                        return this.getResponse(n6);
                    }
                    case 97: {
                        return this.getResponse(Math.min(T0Protocol.sw2(byArray4), n6));
                    }
                }
                return byArray4;
            }
            case 5: {
                int n7 = T0Protocol.get2(byArray, 5);
                if (n7 <= 256) {
                    return this.sendTPDU(byArray, n7, 0, 0, n7);
                }
                byte[] byArray5 = this.sendTPDU(byArray, 0, 0, 0, 256);
                if (T0Protocol.sw1(byArray5) == 97) {
                    byte[] byArray6 = byArray5;
                    byArray5 = new byte[n7 + 2];
                    int n8 = 0;
                    int n9 = n7;
                    while (true) {
                        int n10 = Math.min(n9, byArray6.length - 2);
                        System.arraycopy(byArray6, 0, byArray5, n8, n10 + 2);
                        n8 += n10;
                        if ((n9 -= n10) == 0) {
                            return byArray5;
                        }
                        if (T0Protocol.sw1(byArray6) != 97) {
                            return T0Protocol.truncate(byArray5, n7);
                        }
                        byArray6 = this.getResponse(Math.min(n9, T0Protocol.sw2(byArray6)));
                    }
                }
                return byArray5;
            }
            case 6: {
                byte[] byArray7;
                int n11;
                int n12 = T0Protocol.get2(byArray, 5);
                int n13 = 7;
                if (n12 < 256) {
                    return this.sendTPDU(byArray, n12, n12, n13, 0);
                }
                int n14 = 255;
                byte[] byArray8 = new byte[260];
                byArray8[1] = -62;
                do {
                    n11 = Math.min(n12, 255);
                    System.arraycopy(byArray, n13, byArray8, 5, n11);
                    byArray7 = this.sendTPDU(byArray, n11, n11, 5, 0);
                    if (T0Protocol.sw1(byArray7) != 144) break;
                    n13 += n11;
                } while ((n12 -= n11) > 0);
                return byArray7;
            }
            case 7: {
                byte[] byArray9 = this.exchangeData(byArray, n - 2);
                int n15 = T0Protocol.get2(byArray, n - 2);
                switch (T0Protocol.sw1(byArray9)) {
                    case 97: 
                    case 144: {
                        byArray9 = this.getResponse(n15);
                    }
                }
                return byArray9;
            }
        }
        throw new CardTerminalException("malformed APDU");
    }

    private static final int get1(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        if (n2 == 0) {
            n2 = 256;
        }
        return n2;
    }

    private static final int get2(byte[] byArray, int n) {
        int n2 = (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
        if (n2 == 0) {
            n2 = 65536;
        }
        return n2;
    }

    private final byte[] getResponse(int n) throws CardTerminalException {
        byte[] byArray;
        if (n <= 256) {
            byte[] byArray2 = new byte[5];
            byArray2[1] = -64;
            byArray2[4] = (byte)n;
            byArray = byArray2;
        } else {
            byte[] byArray3 = new byte[7];
            byArray3[1] = -64;
            byArray3[5] = (byte)(n >> 8);
            byArray3[6] = (byte)n;
            byArray = byArray3;
        }
        return this.exchangeData(byArray, byArray.length);
    }

    private byte[] sendTPDU(byte[] byArray, int n, int n2, int n3, int n4) throws CardTerminalException {
        try {
            int n5;
            byte[] byArray2;
            block10: {
                this.out.write(byArray, 0, 4);
                this.out.write(n);
                byArray2 = null;
                int n6 = 0;
                while (true) {
                    if ((n5 = this.in.read()) < 0) {
                        throw new CommunicationErrorException("timeout");
                    }
                    if (n5 == 96) continue;
                    int n7 = n5 & 0xF0;
                    if (n7 == 96 || n7 == 144) break block10;
                    int n8 = (n5 ^ byArray[1]) & 0xFE;
                    if (n8 == 254) {
                        if (n2 > 0) {
                            this.out.write(byArray[n3]);
                            ++n3;
                            --n2;
                            continue;
                        }
                        n8 = 0;
                    }
                    if (n8 != 0) break;
                    if (n2 > 0) {
                        this.out.write(byArray, n3, n2);
                        n3 += n2;
                        n2 = 0;
                    }
                    if (n4 <= 0) continue;
                    byArray2 = new byte[n4 + 2];
                    if (this.in.read(byArray2, 0, n4) < n4) {
                        throw new CommunicationErrorException("timeout");
                    }
                    n6 = n4;
                }
                throw new CardTerminalException("malformed response");
            }
            if (byArray2 == null) {
                byArray2 = new byte[2];
            }
            byArray2[n6++] = (byte)n5;
            byArray2[n6++] = (byte)this.in.read();
            return byArray2;
        }
        catch (CardTerminalException cardTerminalException) {
            throw cardTerminalException;
        }
        catch (IOException iOException) {
            throw new CommunicationErrorException(iOException.getMessage());
        }
    }

    private static final int sw1(byte[] byArray) {
        return byArray[byArray.length - 2] & 0xFF;
    }

    private static final int sw2(byte[] byArray) {
        return T0Protocol.get1(byArray, byArray.length - 1);
    }

    private static final byte[] truncate(byte[] byArray, int n) {
        if (byArray.length - 2 > n) {
            byte[] byArray2 = new byte[n + 2];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            byArray2[n] = byArray[byArray.length - 2];
            byArray2[n + 1] = byArray[byArray.length - 1];
            byArray = byArray2;
        }
        return byArray;
    }
}

