/*
 * Decompiled with CFR 0.152.
 */
package palm.conduit;

import com.sun.pdasync.SyncMgr.CCardInfo;
import com.sun.pdasync.SyncMgr.CCommunicator;
import com.sun.pdasync.SyncMgr.CDbCreateDB;
import com.sun.pdasync.SyncMgr.CDbGenInfo;
import com.sun.pdasync.SyncMgr.CDbList;
import com.sun.pdasync.SyncMgr.CPositionInfo;
import com.sun.pdasync.SyncMgr.CRawPreferenceInfo;
import com.sun.pdasync.SyncMgr.CRawRecordInfo;
import com.sun.pdasync.SyncMgr.CSyncFindDbByNameParams;
import com.sun.pdasync.SyncMgr.CSyncFindDbByTypeCreatorParams;
import com.sun.pdasync.SyncMgr.CSyncReadOpenDbInfoParams;
import com.sun.pdasync.SyncMgr.CSystemInfo;
import com.sun.pdasync.SyncMgr.CUserIDInfo;
import com.sun.pdasync.SyncMgr.SyncDatabaseInfoType;
import com.sun.pdasync.SyncMgr.SyncProdCompInfoType;
import com.sun.pdasync.Transport.CTransportBase;
import com.sun.pdasync.Transport.CTransportPAD;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import palm.conduit.AppPreferenceInfo;
import palm.conduit.Card;
import palm.conduit.Conduit;
import palm.conduit.ConfigureConduitInfo;
import palm.conduit.DbGenInfo;
import palm.conduit.DbList;
import palm.conduit.FatalSyncException;
import palm.conduit.PositionInfo;
import palm.conduit.RawRecordInfo;
import palm.conduit.Record;
import palm.conduit.SyncDatabaseInfo;
import palm.conduit.SyncException;
import palm.conduit.SyncFindDbByNameParams;
import palm.conduit.SyncFindDbByTypeCreatorParams;
import palm.conduit.SyncProdCompInfo;
import palm.conduit.SyncProperties;
import palm.conduit.SyncReadOpenDbInfoParams;
import palm.conduit.SyncVersionException;
import palm.conduit.SystemInfo;
import palm.conduit.UserInfo;
import palm.conduit.dbCreateDB;

public class SyncManager {
    public static final int DB_RECORD = 0;
    public static final int DB_RESOURCE = 1;
    public static final int DB_READ_ONLY = 2;
    public static final int DB_INFO_DIRTY = 4;
    public static final int DB_BACKUP_DB = 8;
    public static final int DB_OK_TO_INSTALL_NEW = 16;
    public static final int DB_RESET_AFTER_INSTALL = 32;
    public static final int DB_OPEN_DB = 32768;
    public static final int OPEN_SECRET = 16;
    public static final int OPEN_EXCLUSIVE = 32;
    public static final int OPEN_WRITE = 64;
    public static final int OPEN_READ = 128;
    public static final byte DB_INFO_OPT_GET_ATTRIBUTES = -128;
    public static final byte DB_INFO_OPT_GET_SIZE = 64;
    public static final byte DB_INFO_OPT_GET_MAX_REC_SIZE = 32;
    public static final byte DB_SRCH_OPT_NEW_SEARCH = -128;
    public static final byte DB_SRCH_OPT_ONLY_LATEST = 64;
    public static final byte CLOSE_DB_OPT_UPDATE_BACKUP_DATE = -128;
    public static final byte CLOSE_DB_OPT_UPDATE_MOD_DATE = 64;
    public static final int SYNCAPI_VER_MAJOR_2 = 2;
    public static final int SYNCAPI_VER_MINOR_0 = 0;
    public static final int SYNCAPI_VER_MINOR_1 = 1;
    public static final int SYNCAPI_VER_MINOR_2 = 2;
    private static final int READ_SIZE = 1024;
    private static final boolean haveCheckedVM = false;
    static int majorVersion;
    static int minorVersion;
    static CCommunicator ccomm;

    private static int SyncAddLogEntry(String text) {
        long retVal = ccomm.AddLogEntry(text.getBytes(), (short)text.length());
        return (int)retVal;
    }

    private static int SyncChangeCategory(int fHandle, int from, int to) {
        long retVal = 0L;
        retVal = ccomm.ChangeCategory((byte)fHandle, (byte)from, (byte)to);
        return (int)retVal;
    }

    private static int SyncCloseDB(int handle) {
        long retVal = ccomm.CloseDBEx((byte)handle, (byte)0);
        return (int)retVal;
    }

    private static int SyncCloseDBEx(byte dbHandle, byte optFlags) {
        long retVal = 0L;
        retVal = ccomm.CloseDBEx(dbHandle, optFlags);
        return (int)retVal;
    }

    private static int SyncCreateDB(dbCreateDB rDbStats) {
        long retVal = 0L;
        CDbCreateDB CrDbStats = new CDbCreateDB();
        rDbStats.copyToCDbCreateDB(CrDbStats);
        retVal = ccomm.CreateDB(CrDbStats);
        rDbStats.copyFromCDbCreateDB(CrDbStats);
        return (int)retVal;
    }

    private static int SyncDeleteAllResourceRec(int handle) {
        long retVal = 0L;
        retVal = ccomm.DeleteAllResourceRec((byte)handle);
        return (int)retVal;
    }

    private static int SyncDeleteDB(String pName, int ncardNo) {
        long retVal = ccomm.DeleteDB(pName.getBytes(), ncardNo);
        return (int)retVal;
    }

    private static int SyncDeleteRecord(RawRecordInfo record, int opt) {
        long retVal = 0L;
        CRawRecordInfo recInfo = new CRawRecordInfo();
        record.copyToCRawRecordInfo(recInfo);
        retVal = ccomm.DeleteRecord(recInfo, opt);
        record.copyFromCRawRecordInfo(recInfo);
        return (int)retVal;
    }

    private static int SyncDeleteResourceRec(RawRecordInfo record) {
        long retVal = 0L;
        CRawRecordInfo recInfo = new CRawRecordInfo();
        record.copyToCRawRecordInfo(recInfo);
        retVal = ccomm.DeleteResourceRec(recInfo);
        record.copyFromCRawRecordInfo(recInfo);
        return (int)retVal;
    }

    private static int SyncEndOfSync(int Status) {
        long retval = 16394L;
        if (ccomm != null) {
            retval = ccomm.EndSyncSessionWithHH(Status);
        }
        return (int)retval;
    }

    private static int SyncFindDbByName(SyncFindDbByNameParams params, SyncDatabaseInfo info) {
        long retVal = 0L;
        CSyncFindDbByNameParams cfindDbInfo = new CSyncFindDbByNameParams();
        params.copyToCSyncFindDbByNameParams(cfindDbInfo);
        SyncDatabaseInfoType cinfoType = new SyncDatabaseInfoType();
        info.copyToSyncDatabaseInfoType(cinfoType);
        retVal = SyncManager.sunwSyncFindDbByName(cfindDbInfo, cinfoType);
        params.copyFromCSyncFindDbByNameParams(cfindDbInfo);
        info.copyFromSyncDatabaseInfoType(cinfoType);
        return (int)retVal;
    }

    private static int SyncFindDbByTypeCreator(SyncFindDbByTypeCreatorParams params, SyncDatabaseInfo info) {
        long retVal = 0L;
        CSyncFindDbByTypeCreatorParams cfdb = new CSyncFindDbByTypeCreatorParams();
        params.copyToCSyncFindDbByTypeCreatorParams(cfdb);
        SyncDatabaseInfoType cinfoType = new SyncDatabaseInfoType();
        info.copyToSyncDatabaseInfoType(cinfoType);
        retVal = SyncManager.sunwSyncFindDbByTypeCreator(cfdb, cinfoType);
        params.copyFromCSyncFindDbByTypeCreatorParams(cfdb);
        info.copyFromSyncDatabaseInfoType(cinfoType);
        return (int)retVal;
    }

    private static int SyncGetAPIVersion(int[] pdwMajor, int[] pdwMinor) {
        if (pdwMajor != null) {
            pdwMajor[0] = 2;
        }
        if (pdwMinor != null) {
            pdwMinor[0] = 2;
        }
        return 0;
    }

    private static int SyncGetDBRecordCount(int handle, int[] intRef) {
        long retVal = 0L;
        retVal = ccomm.GetDBRecordCount((byte)handle, intRef);
        return (int)retVal;
    }

    private static short SyncGetHHOSVersion(short[] pwRomVMinor) {
        int[] major = new int[1];
        int[] minor = new int[1];
        long retVal = ccomm.GetHHOSVersion(major, minor);
        if (pwRomVMinor != null) {
            pwRomVMinor[0] = (short)minor[0];
        }
        return (short)major[0];
    }

    private static int SyncInit(CTransportPAD transport) {
        ccomm = new CCommunicator((CTransportBase)transport);
        SyncManager.init();
        if (ccomm == null) {
            return 16394;
        }
        return 0;
    }

    private static int SyncMaxRemoteRecSize(int[] maxRecSize) {
        long retVal = 0L;
        retVal = ccomm.MaxRemoteRecSize(maxRecSize);
        return (int)retVal;
    }

    private static int SyncOpenDB(String pName, int ncardNo, int[] intRef, int openMode) {
        long retVal = 0L;
        byte[] ref = new byte[intRef.length];
        int i = 0;
        while (i < intRef.length) {
            ref[i] = (byte)intRef[i];
            ++i;
        }
        retVal = ccomm.OpenDB(pName.getBytes(), (byte)ncardNo, ref, (byte)openMode);
        int i2 = 0;
        while (i2 < intRef.length) {
            intRef[i2] = ref[i2];
            ++i2;
        }
        return (int)retVal;
    }

    private static int SyncPurgeAllRecs(int handle) {
        long retVal = 0L;
        retVal = ccomm.PurgeAllRecs((byte)handle, false, (short)1);
        return (int)retVal;
    }

    private static int SyncPurgeAllRecsInCategory(int handle, int category) {
        long retVal = 0L;
        retVal = ccomm.PurgeAllRecs((byte)handle, true, (short)category);
        return (int)retVal;
    }

    private static int SyncPurgeDeletedRecs(int handle) {
        long retVal = 0L;
        retVal = ccomm.PurgeDeletedRecs((byte)handle);
        return (int)retVal;
    }

    private static int SyncReadAppPreference(AppPreferenceInfo preferenceInfo) {
        long retVal = 0L;
        CRawPreferenceInfo cprefInfo = new CRawPreferenceInfo();
        preferenceInfo.copyToCRawPreferenceInfo(cprefInfo);
        retVal = ccomm.ReadAppPreference(cprefInfo);
        preferenceInfo.copyFromCRawPreferenceInfo(cprefInfo);
        return (int)retVal;
    }

    private static int SyncReadCRecordByIndex(CRawRecordInfo recInfo) {
        long retVal = 0L;
        retVal = ccomm.ReadRecordByIndex(recInfo);
        return (int)retVal;
    }

    private static int SyncReadCResRecordByIndex(CRawRecordInfo recInfo, boolean bBody) {
        long retVal = 0L;
        retVal = ccomm.ReadResRecordByIndex(recInfo, bBody);
        return (int)retVal;
    }

    private static int SyncReadDBAppInfoBlock(int handle, DbGenInfo rDbInfo) {
        long retVal = 0L;
        CDbGenInfo cdbInfo = new CDbGenInfo();
        rDbInfo.copyToCDbGenInfo(cdbInfo);
        retVal = ccomm.ReadDBAppInfoBlock((byte)handle, cdbInfo);
        rDbInfo.copyFromCDbGenInfo(cdbInfo);
        return (int)retVal;
    }

    private static int SyncReadDBList(int cardNo, int startIX, boolean bRam, DbList[] Dblist, int[] intRef) {
        long retVal = 0L;
        CDbList[] cdbList = CDbList.makeCDbListArray((int)Dblist.length);
        int i = 0;
        while (i < Dblist.length) {
            Dblist[i].copyToCDbList(cdbList[i]);
            ++i;
        }
        retVal = SyncManager.sunwSyncReadDBList(cardNo, startIX, bRam, cdbList, intRef);
        int i2 = 0;
        while (i2 < Dblist.length) {
            Dblist[i2].copyFromCDbList(cdbList[i2]);
            ++i2;
        }
        return (int)retVal;
    }

    private static int SyncReadDBSortInfoBlock(int handle, DbGenInfo rDbInfo) {
        long retVal = 0L;
        CDbGenInfo cdbInfo = new CDbGenInfo();
        rDbInfo.copyToCDbGenInfo(cdbInfo);
        retVal = ccomm.ReadDBSortInfoBlock((byte)handle, cdbInfo);
        rDbInfo.copyFromCDbGenInfo(cdbInfo);
        return (int)retVal;
    }

    private static int SyncReadFeature(int ftrCreator, short ftrNum, int[] ftrValue) {
        long retVal = 0L;
        retVal = ccomm.ReadFeature(ftrCreator, ftrNum, ftrValue);
        return (int)retVal;
    }

    private static int SyncReadNextModifiedRec(RawRecordInfo record) {
        long retVal = 0L;
        CRawRecordInfo recInfo = new CRawRecordInfo();
        record.copyToCRawRecordInfo(recInfo);
        retVal = ccomm.ReadNextModRecord(recInfo);
        record.copyFromCRawRecordInfo(recInfo);
        return (int)retVal;
    }

    private static int SyncReadNextModifiedRecInCategory(RawRecordInfo record) {
        long retVal = 0L;
        CRawRecordInfo recInfo = new CRawRecordInfo();
        record.copyToCRawRecordInfo(recInfo);
        retVal = ccomm.ReadNextRecInCategory(recInfo, true);
        record.copyFromCRawRecordInfo(recInfo);
        return (int)retVal;
    }

    private static int SyncReadNextRecInCategory(RawRecordInfo record, boolean modified) {
        long retVal = 0L;
        CRawRecordInfo recInfo = new CRawRecordInfo();
        record.copyToCRawRecordInfo(recInfo);
        retVal = ccomm.ReadNextRecInCategory(recInfo, modified);
        record.copyFromCRawRecordInfo(recInfo);
        return (int)retVal;
    }

    private static int SyncReadOpenDbInfo(SyncReadOpenDbInfoParams params, SyncDatabaseInfo info) {
        long retVal = 0L;
        CSyncReadOpenDbInfoParams cfdb = new CSyncReadOpenDbInfoParams();
        params.copyToCSyncReadOpenDbInfoParams(cfdb);
        SyncDatabaseInfoType cinfoType = new SyncDatabaseInfoType();
        info.copyToSyncDatabaseInfoType(cinfoType);
        ccomm.ReadOpenDbInfo(cfdb, cinfoType);
        params.copyFromCSyncReadOpenDbInfoParams(cfdb);
        info.copyFromSyncDatabaseInfoType(cinfoType);
        return (int)retVal;
    }

    private static int SyncReadPositionXMap(PositionInfo rInfo) {
        long retVal = 0L;
        CPositionInfo cposInfo = new CPositionInfo();
        rInfo.copyToCPositionInfo(cposInfo);
        retVal = ccomm.ReadPositionXMap(cposInfo);
        rInfo.copyFromCPositionInfo(cposInfo);
        return (int)retVal;
    }

    private static int SyncReadProdCompInfo(SyncProdCompInfo info) {
        long retVal = 0L;
        SyncProdCompInfoType cprodInfo = new SyncProdCompInfoType();
        info.copyToSyncProdCompInfoType(cprodInfo);
        retVal = SyncManager.sunwSyncReadProdCompInfo(cprodInfo);
        info.copyFromSyncProdCompInfoType(cprodInfo);
        return (int)retVal;
    }

    private static int SyncReadRecordById(RawRecordInfo record) {
        long retVal = 0L;
        CRawRecordInfo recInfo = new CRawRecordInfo();
        record.copyToCRawRecordInfo(recInfo);
        retVal = ccomm.ReadRecordById(recInfo);
        record.copyFromCRawRecordInfo(recInfo);
        return (int)retVal;
    }

    private static int SyncReadRecordByIndex(RawRecordInfo record) {
        long retVal = 0L;
        CRawRecordInfo recInfo = new CRawRecordInfo();
        record.copyToCRawRecordInfo(recInfo);
        retVal = ccomm.ReadRecordByIndex(recInfo);
        record.copyFromCRawRecordInfo(recInfo);
        return (int)retVal;
    }

    private static int SyncReadResRecordByIndex(RawRecordInfo record, boolean bBody) {
        long retVal = 0L;
        CRawRecordInfo recInfo = new CRawRecordInfo();
        record.copyToCRawRecordInfo(recInfo);
        retVal = ccomm.ReadResRecordByIndex(recInfo, bBody);
        record.copyFromCRawRecordInfo(recInfo);
        return (int)retVal;
    }

    private static int SyncReadSingleCardInfo(Card rInfo) {
        long retVal = 0L;
        CCardInfo cardInfo = new CCardInfo();
        rInfo.copyToCCardInfo(cardInfo);
        retVal = ccomm.ReadSingleCardInfo(cardInfo);
        rInfo.copyFromCCardInfo(cardInfo);
        return (int)retVal;
    }

    private static int SyncReadSysDateTime(int[] rDate) {
        long retVal = 0L;
        long[] lDate = new long[rDate.length];
        int i = 0;
        while (i < rDate.length) {
            lDate[i] = rDate[i];
            ++i;
        }
        retVal = ccomm.ReadSysDateTime(lDate);
        int i2 = 0;
        while (i2 < rDate.length) {
            rDate[i2] = (int)lDate[i2];
            ++i2;
        }
        return (int)retVal;
    }

    private static int SyncReadSystemInfo(SystemInfo rInfo) {
        long retVal = 0L;
        CSystemInfo csysInfo = new CSystemInfo();
        rInfo.copyToCSystemInfo(csysInfo);
        retVal = SyncManager.sunwSyncReadSystemInfo(csysInfo);
        rInfo.copyFromCSystemInfo(csysInfo);
        return (int)retVal;
    }

    private static int SyncReadUserID(UserInfo userInfo) {
        long retVal = 0L;
        CUserIDInfo cuInfo = new CUserIDInfo();
        userInfo.copyToCUserIDInfo(cuInfo);
        retVal = ccomm.ReadUserID(cuInfo);
        userInfo.copyFromCUserIDInfo(cuInfo);
        return (int)retVal;
    }

    private static int SyncRebootSystem() {
        long retVal = 0L;
        retVal = ccomm.ResetSystem();
        return (int)retVal;
    }

    private static int SyncResetRecordIndex(int handle) {
        long retVal = 0L;
        retVal = ccomm.ResetRecordIndex((byte)handle);
        return (int)retVal;
    }

    private static int SyncResetSyncFlags(int handle) {
        long retVal = ccomm.ResetSyncFlags((byte)handle);
        return (int)retVal;
    }

    private static int SyncWriteAppPreference(AppPreferenceInfo preferenceInfo) {
        long retVal = 0L;
        CRawPreferenceInfo cprefInfo = new CRawPreferenceInfo();
        preferenceInfo.copyToCRawPreferenceInfo(cprefInfo);
        retVal = ccomm.WriteAppPreference(cprefInfo);
        preferenceInfo.copyFromCRawPreferenceInfo(cprefInfo);
        return (int)retVal;
    }

    private static int SyncWriteCRec(CRawRecordInfo recInfo) {
        long retVal = 0L;
        retVal = ccomm.WriteRecord(recInfo);
        return (int)retVal;
    }

    private static int SyncWriteCResourceRec(CRawRecordInfo recInfo) {
        long retVal = 0L;
        retVal = ccomm.WriteResourceRecord(recInfo);
        return (int)retVal;
    }

    private static int SyncWriteDBAppInfoBlock(int handle, DbGenInfo rDbInfo) {
        long retVal = 0L;
        CDbGenInfo cdbInfo = new CDbGenInfo();
        rDbInfo.copyToCDbGenInfo(cdbInfo);
        retVal = ccomm.WriteDBAppInfoBlock((byte)handle, cdbInfo);
        rDbInfo.copyFromCDbGenInfo(cdbInfo);
        return (int)retVal;
    }

    private static int SyncWriteDBSortInfoBlock(int handle, DbGenInfo rDbInfo) {
        long retVal = 0L;
        CDbGenInfo cdbInfo = new CDbGenInfo();
        rDbInfo.copyToCDbGenInfo(cdbInfo);
        retVal = ccomm.WriteDBSortInfoBlock((byte)handle, cdbInfo);
        rDbInfo.copyFromCDbGenInfo(cdbInfo);
        return (int)retVal;
    }

    private static int SyncWriteRec(RawRecordInfo record) {
        long retVal = 0L;
        CRawRecordInfo recInfo = new CRawRecordInfo();
        record.copyToCRawRecordInfo(recInfo);
        retVal = ccomm.WriteRecord(recInfo);
        record.copyFromCRawRecordInfo(recInfo);
        return (int)retVal;
    }

    private static int SyncWriteResourceRec(RawRecordInfo record) {
        long retVal = 0L;
        CRawRecordInfo recInfo = new CRawRecordInfo();
        record.copyToCRawRecordInfo(recInfo);
        retVal = ccomm.WriteResourceRecord(recInfo);
        record.copyFromCRawRecordInfo(recInfo);
        return (int)retVal;
    }

    private static int SyncWriteSysDateTime(int lDate) {
        long retVal = 0L;
        retVal = ccomm.WriteSysDateTime((long)lDate);
        return (int)retVal;
    }

    private static int SyncWriteUserID(UserInfo userInfo) {
        long retVal = 0L;
        CUserIDInfo cuInfo = new CUserIDInfo();
        userInfo.copyToCUserIDInfo(cuInfo);
        retVal = ccomm.WriteUserID(cuInfo);
        userInfo.copyFromCUserIDInfo(cuInfo);
        return (int)retVal;
    }

    private static int SyncYieldCycles(int wMaxMiliSecs) {
        long retVal = 0L;
        retVal = ccomm.YieldCycles((short)wMaxMiliSecs);
        return (int)retVal;
    }

    public static void addLogEntry(String text) throws SyncException {
        SyncManager.verifyResult(SyncManager.SyncAddLogEntry(text), "Error Adding Log Entry");
    }

    public static void changeCategory(int handle, int from, int to) throws SyncException {
        SyncManager.verifyResult(SyncManager.SyncChangeCategory(handle, from, to), "Error Changing Category");
    }

    public static void closeDB(int handle) throws SyncException {
        SyncManager.verifyResult(SyncManager.SyncCloseDB(handle), "Error During Close of Database");
    }

    public static void closeDBEx(byte dbHandle, byte optFlags) throws SyncException {
        SyncManager.verifyVersion(2, 2, "closeDBEx");
        SyncManager.verifyResult(SyncManager.SyncCloseDBEx(dbHandle, optFlags), "Error in closeDBEx");
    }

    private static int configure(int infoPtr, String conduitName) {
        return 0;
    }

    private static int configure(ConfigureConduitInfo info, String conduitName) {
        int retval = -1;
        SyncManager.init();
        try {
            Conduit conduit = (Conduit)Class.forName(conduitName).newInstance();
            retval = conduit.configure(info);
        }
        catch (Throwable t) {
            System.out.println("Uncaught exception: " + t);
            t.printStackTrace();
        }
        return retval;
    }

    public static int createDB(int creator, int flags, int cardNo, String name, int type) throws SyncException {
        dbCreateDB data = new dbCreateDB(creator, flags, cardNo, name, type);
        SyncManager.verifyResult(SyncManager.SyncCreateDB(data), "Error Creating Database");
        return data.fileHandle;
    }

    private static void dataFromRec(RawRecordInfo data, Record record) throws IOException {
        data.recId = record.getId();
        data.recIndex = (short)record.getIndex();
        data.catId = (byte)record.getCategoryIndex();
        if (record.isArchived()) {
            data.attribs = (byte)(data.attribs | 8);
        }
        if (record.isPrivate()) {
            data.attribs = (byte)(data.attribs | 0x10);
        }
        if (record.isDeleted()) {
            data.attribs = (byte)(data.attribs | 0x80);
        }
        if (record.isModified() || record.isNew()) {
            data.attribs = (byte)(data.attribs | 0x40);
        }
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(byteOut);
        record.writeData(dataOut);
        dataOut.flush();
        dataOut.close();
        data.setBytes(byteOut.toByteArray());
    }

    private static void dataToRec(Record record, RawRecordInfo data) throws IOException {
        record.setId(data.recId);
        record.setIndex(data.recIndex);
        record.setCategoryIndex(data.catId);
        record.setIsArchived((data.attribs & 8) != 0);
        record.setIsPrivate((data.attribs & 0x10) != 0);
        record.setIsDeleted((data.attribs & 0x80) != 0);
        record.setIsModified((data.attribs & 0x40) != 0);
        if (!record.isDeleted()) {
            byte[] bytes = data.getBytes();
            ByteArrayInputStream byteIn = new ByteArrayInputStream(bytes, 0, data.recSize);
            DataInputStream dataIn = new DataInputStream(byteIn);
            record.readData(dataIn);
            dataIn.close();
        }
    }

    public static void deleteAllResourceRec(int handle) throws SyncException {
        SyncManager.verifyResult(SyncManager.SyncDeleteAllResourceRec(handle), "Error Deleting Resource Recs");
    }

    public static void deleteDB(String name, int cardNo) throws SyncException {
        SyncManager.verifyResult(SyncManager.SyncDeleteDB(name, cardNo), "Error Deleting Database");
    }

    public static void deleteRecord(int handle, Record record) throws SyncException {
        byte[] bytes = new byte[]{};
        RawRecordInfo data = new RawRecordInfo(handle, record.getId(), 0, bytes);
        SyncManager.verifyResult(SyncManager.SyncDeleteRecord(data, 0), "Error Deleting Record");
    }

    public static void deleteResourceRec(int handle, Record record) throws SyncException {
        byte[] bytes = new byte[]{};
        RawRecordInfo data = new RawRecordInfo(handle, record.getId(), 0, bytes);
        SyncManager.verifyResult(SyncManager.SyncDeleteResourceRec(data), "Error Deleting Resource Rec");
    }

    public static SyncDatabaseInfo findDbByName(byte optFlags, int cardNum, String databaseName) throws SyncException {
        SyncDatabaseInfo info = new SyncDatabaseInfo();
        SyncFindDbByNameParams params = new SyncFindDbByNameParams();
        params.optFlags = optFlags;
        params.cardNum = cardNum;
        params.databaseName = databaseName;
        SyncManager.verifyVersion(2, 2, "findDbByName");
        SyncManager.verifyResult(SyncManager.SyncFindDbByName(params, info), "Error in findDbByName");
        return info;
    }

    public static SyncDatabaseInfo findDbByTypeCreator(byte optFlags, byte srchFlags, int type, int creator) throws SyncException {
        SyncFindDbByTypeCreatorParams params = new SyncFindDbByTypeCreatorParams();
        SyncDatabaseInfo info = new SyncDatabaseInfo();
        params.optFlags = optFlags;
        params.srchFlags = srchFlags;
        params.type = type;
        params.creator = creator;
        SyncManager.verifyVersion(2, 2, "findDbByTypeCreator");
        SyncManager.verifyResult(SyncManager.SyncFindDbByTypeCreator(params, info), "Error findDbByTypeCreator");
        return info;
    }

    public static int[] getAPIVersion() throws SyncException {
        int[] pdwMajorIntRef = new int[1];
        int[] pdwMinorIntRef = new int[1];
        int[] versions = new int[2];
        SyncManager.verifyResult(SyncManager.SyncGetAPIVersion(pdwMajorIntRef, pdwMinorIntRef), "Error Getting API Version");
        versions[0] = pdwMajorIntRef[0];
        versions[1] = pdwMinorIntRef[0];
        return versions;
    }

    public static int getDBRecordCount(int handle) throws SyncException {
        int[] ir = new int[1];
        SyncManager.verifyResult(SyncManager.SyncGetDBRecordCount(handle, ir), "Error Getting Record Count");
        return ir[0];
    }

    public static short[] getHHOSVersion() throws SyncException {
        short[] version = new short[2];
        SyncManager.verifyVersion(2, 1, "getHHOSVersion");
        short major = SyncManager.SyncGetHHOSVersion(version);
        version[1] = version[0];
        version[0] = major;
        return version;
    }

    private static void init() {
        try {
            int[] version = SyncManager.getAPIVersion();
            majorVersion = version[0];
            minorVersion = version[1];
        }
        catch (SyncException syncException) {}
    }

    public static int maxRemoteRecordSize() throws SyncException {
        int[] maxRecSize = new int[1];
        SyncManager.verifyVersion(2, 2, "maxRemoteRecordSize");
        SyncManager.verifyResult(SyncManager.SyncMaxRemoteRecSize(maxRecSize), "Error in maxRemoteRecordSize");
        return maxRecSize[0];
    }

    public static int openDB(String name, int cardNo, int openMode) throws SyncException {
        int[] ir = new int[1];
        int res = SyncManager.SyncOpenDB(name, cardNo, ir, openMode);
        SyncManager.verifyResult(res, "Error Opening Database");
        return ir[0];
    }

    public static void purgeAllRecs(int handle) throws SyncException {
        SyncManager.verifyResult(SyncManager.SyncPurgeAllRecs(handle), "Error Purging All Recs");
    }

    public static void purgeAllRecsInCategory(int handle, int category) throws SyncException {
        SyncManager.verifyResult(SyncManager.SyncPurgeAllRecsInCategory(handle, category), "Error Purging All Records In Category");
    }

    public static void purgeDeletedRecs(int handle) throws SyncException {
        SyncManager.verifyResult(SyncManager.SyncPurgeDeletedRecs(handle), "Error Purging Deleted Recs");
    }

    public static AppPreferenceInfo readAppPreference(int creator, short prefId, short reqBytesv, short retBytes, boolean backedUp, byte[] bytes) throws SyncException {
        AppPreferenceInfo preferenceInfo = new AppPreferenceInfo(creator, prefId, reqBytesv, retBytes, backedUp, bytes);
        SyncManager.verifyResult(SyncManager.SyncReadAppPreference(preferenceInfo), "Error Reading Preference Info");
        return preferenceInfo;
    }

    public static byte[] readDBAppInfoBlock(int handle, String databaseName) throws SyncException {
        DbGenInfo data = new DbGenInfo(databaseName, new byte[1024]);
        boolean allBytesRead = false;
        while (!allBytesRead) {
            SyncManager.verifyResult(SyncManager.SyncReadDBAppInfoBlock(handle, data), "Error Reading AppInfoBlock");
            if (data.bytesRead <= data.totalBytes) {
                allBytesRead = true;
                continue;
            }
            data.setBytes(new byte[data.totalBytes * 2]);
        }
        return data.getBytes();
    }

    public static DbList[] readDBList(int cardNo, int startIX, boolean bRam) throws SyncException {
        int[] ir = new int[1];
        Card cInfo = new Card();
        cInfo.cardNo = (byte)cardNo;
        SyncManager.SyncReadSingleCardInfo(cInfo);
        int dbCount = (bRam ? cInfo.ramDbCount : cInfo.romDbCount) - startIX;
        DbList[] list = new DbList[dbCount];
        int i = 0;
        while (i < list.length) {
            list[i] = new DbList();
            ++i;
        }
        ir[0] = dbCount;
        SyncManager.SyncReadDBList(cardNo, startIX, true, list, ir);
        return list;
    }

    public static byte[] readDBSortInfoBlock(int handle, String databaseName) throws SyncException {
        DbGenInfo data = new DbGenInfo(databaseName, new byte[1024]);
        boolean allBytesRead = false;
        while (!allBytesRead) {
            SyncManager.verifyResult(SyncManager.SyncReadDBSortInfoBlock(handle, data), "Error Reading SortInfoBlock");
            if (data.bytesRead <= data.totalBytes) {
                allBytesRead = true;
                continue;
            }
            data.setBytes(new byte[data.totalBytes * 2]);
        }
        return data.getBytes();
    }

    public static int readFeature(int featureCreator, short featureNum) throws SyncException {
        int[] featureValue = new int[1];
        SyncManager.verifyVersion(2, 1, "readFeature");
        SyncManager.verifyResult(SyncManager.SyncReadFeature(featureCreator, featureNum, featureValue), "Error readFeature");
        return featureValue[0];
    }

    public static void readNextModifiedRec(int handle, Record record) throws IOException {
        byte[] bytes = new byte[1024];
        RawRecordInfo data = new RawRecordInfo(handle, record.getId(), 0, bytes);
        SyncManager.verifyResult(SyncManager.SyncReadNextModifiedRec(data), "Error Reading Next Record");
        if (data.recSize > data.totalBytes) {
            data.setBytes(new byte[data.recSize]);
            SyncManager.verifyResult(SyncManager.SyncReadRecordById(data), "Error Reading Record");
        }
        SyncManager.dataToRec(record, data);
        record.setId(data.recId);
    }

    public static void readNextModifiedRecInCategory(int handle, Record record) throws IOException {
        byte[] bytes = new byte[1024];
        RawRecordInfo data = new RawRecordInfo(handle, record.getId(), 0, (short)record.getCategoryIndex(), bytes);
        SyncManager.verifyResult(SyncManager.SyncReadNextModifiedRecInCategory(data), "Error Reading Record");
        if (data.recSize > data.totalBytes) {
            data.setBytes(new byte[data.recSize]);
            SyncManager.verifyResult(SyncManager.SyncReadNextModifiedRecInCategory(data), "Error Reading Record");
        }
        SyncManager.dataToRec(record, data);
    }

    public static void readNextRecInCategory(int handle, Record record) throws IOException {
        byte[] bytes = new byte[1024];
        RawRecordInfo data = new RawRecordInfo(handle, record.getId(), 0, (short)record.getCategoryIndex(), bytes);
        SyncManager.verifyResult(SyncManager.SyncReadNextRecInCategory(data, false), "Error Reading Record");
        if (data.recSize > data.totalBytes) {
            data.setBytes(new byte[data.recSize]);
            SyncManager.verifyResult(SyncManager.SyncReadNextRecInCategory(data, false), "Error Reading Record");
        }
        SyncManager.dataToRec(record, data);
    }

    public static SyncDatabaseInfo readOpenDbInfo(byte optFlags, byte dbHandle) throws SyncException {
        SyncReadOpenDbInfoParams params = new SyncReadOpenDbInfoParams();
        params.optFlags = optFlags;
        params.dbHandle = dbHandle;
        SyncDatabaseInfo info = new SyncDatabaseInfo();
        SyncManager.verifyVersion(2, 2, "readOpenDbInfo");
        SyncManager.verifyResult(SyncManager.SyncReadOpenDbInfo(params, info), "Error in readOpenDbInfo");
        return info;
    }

    public static byte[] readPositionXMap(byte fileHandle, short firstPos, short maxEntries) throws SyncException {
        PositionInfo rInfo = new PositionInfo(fileHandle, firstPos, maxEntries);
        byte[] bytes = new byte[1024];
        rInfo.setBytes(bytes);
        boolean allBytesRead = false;
        while (!allBytesRead) {
            SyncManager.verifyResult(SyncManager.SyncReadPositionXMap(rInfo), "Error Reading PositionXMap");
            if (rInfo.numReadIn <= rInfo.totalBytes) {
                allBytesRead = true;
                continue;
            }
            rInfo.setBytes(new byte[rInfo.totalBytes * 2]);
        }
        return rInfo.getBytes();
    }

    public static SyncProdCompInfo readProdCompInfo() throws SyncException {
        SyncProdCompInfo info = new SyncProdCompInfo();
        SyncManager.verifyVersion(2, 2, "readProdCompInfo");
        SyncManager.verifyResult(SyncManager.SyncReadProdCompInfo(info), "Error in readProdCompInfo");
        return info;
    }

    public static void readRecordById(int handle, Record record) throws IOException {
        byte[] bytes = new byte[1024];
        RawRecordInfo data = new RawRecordInfo(handle, record.getId(), 0, bytes);
        SyncManager.verifyResult(SyncManager.SyncReadRecordById(data), "Error Reading Record");
        if (data.recSize > data.totalBytes) {
            data.setBytes(new byte[data.recSize]);
            SyncManager.verifyResult(SyncManager.SyncReadRecordById(data), "Error Reading Record");
        }
        SyncManager.dataToRec(record, data);
    }

    public static void readRecordByIndex(int handle, Record record) throws IOException {
        byte[] bytes = new byte[1024];
        RawRecordInfo data = new RawRecordInfo(handle, 0, record.getIndex(), bytes);
        SyncManager.verifyResult(SyncManager.SyncReadRecordByIndex(data), "Error Reading Record");
        if (data.recSize > data.totalBytes) {
            data.setBytes(new byte[data.recSize]);
            SyncManager.verifyResult(SyncManager.SyncReadRecordByIndex(data), "Error Reading Record");
        }
        SyncManager.dataToRec(record, data);
        record.setId(data.recId);
    }

    public static void readResRecordByIndex(int handle, Record record, boolean bBody) throws IOException {
        byte[] bytes = new byte[1024];
        RawRecordInfo data = new RawRecordInfo(handle, 0, record.getIndex(), bytes);
        SyncManager.verifyResult(SyncManager.SyncReadResRecordByIndex(data, bBody), "Error Reading Resource Record");
        if (data.recSize > data.totalBytes) {
            data.setBytes(new byte[data.recSize]);
            SyncManager.verifyResult(SyncManager.SyncReadResRecordByIndex(data, bBody), "Error Reading Resource Record");
        }
        SyncManager.dataToRec(record, data);
        record.setId(data.recId);
    }

    public static Card readSingleCardInfo(int cardNo) throws SyncException {
        Card card = new Card();
        SyncManager.verifyResult(SyncManager.SyncReadSingleCardInfo(card), "Error Reading Card Information");
        return card;
    }

    public static int readSysDateTime() throws SyncException {
        int[] rDate = new int[1];
        SyncManager.verifyResult(SyncManager.SyncReadSysDateTime(rDate), "Error Reading System Date/Time");
        return rDate[0];
    }

    public static SystemInfo readSystemInfo() throws SyncException {
        byte[] bytes = new byte[255];
        SystemInfo system = new SystemInfo(bytes);
        SyncManager.verifyResult(SyncManager.SyncReadSystemInfo(system), "Error Reading System Info");
        return system;
    }

    public static UserInfo readUserID(int userID) throws SyncException {
        UserInfo userInfo = new UserInfo(userID);
        SyncManager.verifyResult(SyncManager.SyncReadUserID(userInfo), "Error Reading User");
        return userInfo;
    }

    public static void rebootSystem() throws SyncException {
        SyncManager.verifyResult(SyncManager.SyncRebootSystem(), "Error Rebooting System");
    }

    public static void resetRecordIndex(int handle) throws SyncException {
        SyncManager.verifyResult(SyncManager.SyncResetRecordIndex(handle), "Error Resetting record Index");
    }

    public static void resetSyncFlags(int handle) throws SyncException {
        SyncManager.verifyResult(SyncManager.SyncResetSyncFlags(handle), "Error Resetting Sync Flags");
    }

    public static long sunwOpenConduit() throws SyncException {
        long retVal = ccomm.RegisterConduit(0L);
        SyncManager.verifyResult((int)retVal, "User Canceled");
        return retVal;
    }

    public static void sunwReadRawRecordByIndex(int handle, CRawRecordInfo rawRecord) throws IOException {
        rawRecord.m_pBytes_u = new byte[1024];
        rawRecord.m_TotalBytes = 1024L;
        SyncManager.verifyResult(SyncManager.SyncReadCRecordByIndex(rawRecord), "Error Reading Record");
        if ((long)rawRecord.m_RecSize_u > rawRecord.m_TotalBytes) {
            rawRecord.m_pBytes_u = new byte[rawRecord.m_RecSize_u];
            SyncManager.verifyResult(SyncManager.SyncReadCRecordByIndex(rawRecord), "Error Reading Record");
        }
    }

    public static void sunwReadResRawRecordByIndex(int handle, CRawRecordInfo rawRecord, boolean bBody) throws IOException {
        rawRecord.m_pBytes_u = new byte[1024];
        rawRecord.m_TotalBytes = 1024L;
        short index = rawRecord.m_RecIndex_u;
        SyncManager.verifyResult(SyncManager.SyncReadCResRecordByIndex(rawRecord, bBody), "Error Reading Resource Record");
        if ((long)rawRecord.m_RecSize_u > rawRecord.m_TotalBytes) {
            rawRecord.m_RecIndex_u = index;
            rawRecord.m_pBytes_u = new byte[rawRecord.m_RecSize_u];
            rawRecord.m_TotalBytes = rawRecord.m_RecSize_u;
            SyncManager.verifyResult(SyncManager.SyncReadCResRecordByIndex(rawRecord, bBody), "Error Reading Resource Record");
        }
    }

    public static int sunwSyncCloseDB(int handle) {
        return SyncManager.SyncCloseDB(handle);
    }

    public static long sunwSyncEndOfSync(int Status) throws SyncException {
        long retVal = SyncManager.SyncEndOfSync(Status);
        SyncManager.verifyResult((int)retVal, "Error Ending Session");
        return retVal;
    }

    public static int sunwSyncFindDbByName(CSyncFindDbByNameParams cfindDbInfo, SyncDatabaseInfoType cinfoType) {
        long retVal = 0L;
        retVal = ccomm.FindDbByName(cfindDbInfo, cinfoType);
        return (int)retVal;
    }

    public static int sunwSyncFindDbByTypeCreator(CSyncFindDbByTypeCreatorParams cfdb, SyncDatabaseInfoType cinfoType) {
        long retVal = 0L;
        retVal = ccomm.FindDbByTypeCreator(cfdb, cinfoType);
        return (int)retVal;
    }

    public static short sunwSyncGetHHOSVersion(short[] pwRomVMinor) {
        return SyncManager.SyncGetHHOSVersion(pwRomVMinor);
    }

    public static long sunwSyncInit(CTransportPAD transport) throws SyncException {
        long retVal = SyncManager.SyncInit(transport);
        SyncManager.verifyResult((int)retVal, "sync error CComm not init");
        return retVal;
    }

    public static int sunwSyncOpenDB(String pName, int ncardNo, int[] intRef, int openMode) {
        return SyncManager.SyncOpenDB(pName, ncardNo, intRef, openMode);
    }

    public static int sunwSyncReadDBList(int cardNo, int startIX, boolean bRam, CDbList[] cDblist, int[] intRef) {
        long retVal = 0L;
        retVal = ccomm.ReadDBList((byte)cardNo, (short)startIX, bRam, cDblist, intRef);
        return (int)retVal;
    }

    public static int sunwSyncReadFeature(int ftrCreator, short ftrNum, int[] ftrValue) {
        return SyncManager.SyncReadFeature(ftrCreator, ftrNum, ftrValue);
    }

    public static int sunwSyncReadProdCompInfo(SyncProdCompInfoType cprodInfo) {
        long retVal = 0L;
        retVal = ccomm.ReadProdCompInfo(cprodInfo);
        return (int)retVal;
    }

    public static int sunwSyncReadSingleCardInfo(Card rInfo) {
        return SyncManager.SyncReadSingleCardInfo(rInfo);
    }

    public static int sunwSyncReadSystemInfo(CSystemInfo csysInfo) {
        long retVal = 0L;
        retVal = ccomm.ReadSystemInfo(csysInfo);
        return (int)retVal;
    }

    public static long sunwSyncReadUserID(UserInfo userInfo) throws SyncException {
        long retVal = SyncManager.SyncReadUserID(userInfo);
        SyncManager.verifyResult((int)retVal, "Error Reading User");
        return retVal;
    }

    public static void sunwWriteRawRec(CRawRecordInfo crawRecInfo) throws IOException {
        SyncManager.verifyResult(SyncManager.SyncWriteCRec(crawRecInfo), "Error Writing Record");
    }

    public static void sunwWriteRawResourceRec(CRawRecordInfo crawRecInfo) throws IOException {
        SyncManager.verifyResult(SyncManager.SyncWriteCResourceRec(crawRecInfo), "Error Writing Resource Rec");
    }

    public static void sunwdeleteRecord(int handle, Record record, int opt) throws SyncException {
        byte[] bytes = new byte[]{};
        RawRecordInfo data = new RawRecordInfo(handle, record.getId(), 0, bytes);
        SyncManager.verifyResult(SyncManager.SyncDeleteRecord(data, opt), "Error Deleting Record");
    }

    public static void sunwreadNextRecInCategory(int handle, Record record, boolean modified) throws IOException {
        byte[] bytes = new byte[1024];
        RawRecordInfo data = new RawRecordInfo(handle, record.getId(), 0, (short)record.getCategoryIndex(), bytes);
        SyncManager.verifyResult(SyncManager.SyncReadNextRecInCategory(data, modified), "Error Reading Record");
        if (data.recSize > data.totalBytes) {
            data.setBytes(new byte[data.recSize]);
            SyncManager.verifyResult(SyncManager.SyncReadNextRecInCategory(data, modified), "Error Reading Record");
        }
        SyncManager.dataToRec(record, data);
    }

    public static int swapBytes(int flop) {
        return (0xFF000000 & flop) >>> 24 | (0xFF0000 & flop) >>> 8 | (0xFF00 & flop) << 8 | (0xFF & flop) << 24;
    }

    public static short swapBytes(short flop) {
        return (short)(0xFFFF & ((0xFF & flop) >>> 8 | (0xFF00 & flop) << 8));
    }

    private static void sync(int propsPtr, String conduitName) {
    }

    private static void sync(SyncProperties props, String conduitName) {
        SyncManager.init();
        try {
            Conduit conduit = (Conduit)Class.forName(conduitName).newInstance();
            conduit.open(props);
        }
        catch (Throwable t) {
            System.out.println("Uncaught exception: " + t);
            t.printStackTrace();
        }
    }

    public static int uint(byte b) {
        return b & 0xFF;
    }

    public static int uint(short s) {
        return s & 0xFFFF;
    }

    private static void verifyResult(int result, String err) throws SyncException {
        if ((result & 0x10000000) != 0) {
            throw new FatalSyncException(err, result);
        }
        if ((result & 0x4000) != 0) {
            throw new SyncException(err, result);
        }
    }

    private static void verifyVersion(int major, int minor, String msg) throws SyncVersionException {
        if (majorVersion < major || minorVersion < minor) {
            throw new SyncVersionException(msg, major, minor);
        }
    }

    public static AppPreferenceInfo writeAppPreference(short version, int creator, short prefId, boolean backedUp, byte[] bytes) throws SyncException {
        AppPreferenceInfo preferenceInfo = new AppPreferenceInfo(version, creator, prefId, backedUp, bytes);
        SyncManager.verifyResult(SyncManager.SyncWriteAppPreference(preferenceInfo), "Error Writing Preference Info");
        return preferenceInfo;
    }

    public static void writeDBAppInfoBlock(int handle, String fileName, byte[] bytes) throws SyncException {
        DbGenInfo data = new DbGenInfo(fileName, bytes);
        SyncManager.verifyResult(SyncManager.SyncWriteDBAppInfoBlock(handle, data), "Error Writing Database App Info Block");
    }

    public static void writeDBSortInfoBlock(int handle, String fileName, byte[] bytes) throws SyncException {
        DbGenInfo data = new DbGenInfo(fileName, bytes);
        SyncManager.verifyResult(SyncManager.SyncWriteDBSortInfoBlock(handle, data), "Error Writing Database Sort Info Block");
    }

    public static void writeRec(int handle, Record record) throws IOException {
        RawRecordInfo data = new RawRecordInfo(handle, record.getId(), 0);
        SyncManager.dataFromRec(data, record);
        SyncManager.verifyResult(SyncManager.SyncWriteRec(data), "Error Writing Record");
        record.setId(data.recId);
    }

    public static void writeResourceRec(int handle, Record record) throws IOException {
        RawRecordInfo data = new RawRecordInfo(handle, record.getId(), record.getIndex());
        SyncManager.dataFromRec(data, record);
        SyncManager.verifyResult(SyncManager.SyncWriteResourceRec(data), "Error Writing Resource Rec");
        record.setId(data.recId);
    }

    public static void writeSysDateTime(int lDate) throws SyncException {
        SyncManager.verifyResult(SyncManager.SyncWriteSysDateTime(lDate), "Error Writing System Date/Time");
    }

    public static int writeUserID(UserInfo userInfo) throws SyncException {
        SyncManager.verifyResult(SyncManager.SyncWriteUserID(userInfo), "Error Writing User Info");
        return userInfo.id;
    }

    public static void yieldCycles(int wMaxMiliSecs) throws SyncException {
        SyncManager.verifyResult(SyncManager.SyncYieldCycles(wMaxMiliSecs), "Error in YieldCycles");
    }
}

