/*
 * Decompiled with CFR 0.152.
 */
package palm.conduit;

import java.io.IOException;
import java.util.Vector;
import palm.conduit.Record;
import palm.conduit.SyncException;
import palm.conduit.SyncManager;
import palm.conduit.SyncProperties;

public class RecordManager {
    SyncProperties props;
    Vector hhRecords;
    Vector pcRecords;
    Vector archivedRecords;
    Vector backupRecords;
    Vector slowPCRecords;
    Class recordClass;
    int db;
    int recordIndex;
    int recordCount;
    boolean slowSync;

    public RecordManager(SyncProperties props, int db, Class recordClass) {
        this.props = props;
        this.db = db;
        this.recordClass = recordClass;
        this.hhRecords = new Vector();
        this.slowSync = false;
    }

    private void addPCRecord(Record record) {
        if (this.slowSync) {
            this.slowPCRecords.addElement(record);
        } else {
            this.pcRecords.addElement(record);
        }
    }

    private void archiveRecord(Record record) throws SyncException {
        this.resetAttributes(record);
        this.archivedRecords.addElement(record);
    }

    private boolean compareRecords(Record firstRecord, Record secondRecord) throws IOException {
        if (firstRecord.getCategoryIndex() != secondRecord.getCategoryIndex() || firstRecord.isPrivate() != secondRecord.isPrivate()) {
            return false;
        }
        return firstRecord.equals(secondRecord);
    }

    public Vector copyHHRecords() throws SyncException, IOException {
        this.pcRecords = new Vector();
        int recordCount = SyncManager.getDBRecordCount(this.db);
        this.recordIndex = 0;
        while (this.recordIndex < recordCount) {
            Record hhRecord = this.getNewRecord();
            hhRecord.setIndex(this.recordIndex);
            SyncManager.readRecordByIndex(this.db, hhRecord);
            if (!hhRecord.isDeleted()) {
                this.resetAttributes(hhRecord);
                this.addPCRecord(hhRecord);
            }
            ++this.recordIndex;
        }
        SyncManager.purgeDeletedRecs(this.db);
        SyncManager.resetSyncFlags(this.db);
        return this.pcRecords;
    }

    public Vector copyPCRecords(Vector pcRecs) throws SyncException, IOException {
        Record pcRecord;
        this.hhRecords = this.pcRecords = pcRecs;
        int recordCount = this.pcRecords.size();
        SyncManager.purgeAllRecs(this.db);
        int i = 0;
        while (i < pcRecs.size()) {
            pcRecord = (Record)pcRecs.elementAt(i);
            pcRecord.setId(0);
            ++i;
        }
        this.writeHHRecords();
        this.pcRecords = this.hhRecords;
        int i2 = 0;
        while (i2 < this.pcRecords.size()) {
            pcRecord = (Record)this.hhRecords.elementAt(i2);
            this.resetAttributes(pcRecord);
            ++i2;
        }
        return this.pcRecords;
    }

    private void deleteHHRecord(Record record) throws SyncException {
        SyncManager.deleteRecord(this.db, record);
        this.hhRecords.removeElement(record);
        --this.recordCount;
        --this.recordIndex;
    }

    private void deletePCRecord(Record pcRecord) {
        this.pcRecords.removeElement(pcRecord);
    }

    public void fastSyncData(Vector pcRecords, Vector archivedRecords) throws SyncException, IOException {
        boolean allRecordsRead = false;
        this.pcRecords = pcRecords;
        this.archivedRecords = archivedRecords;
        if (this.pcRecords == null) {
            this.pcRecords = new Vector();
        }
        this.recordIndex = 0;
        while (!allRecordsRead) {
            try {
                Record hhRecord = this.getNewRecord();
                SyncManager.readNextModifiedRec(this.db, hhRecord);
                this.hhRecords.addElement(hhRecord);
                this.synchronizeHHRecord(hhRecord);
            }
            catch (SyncException syncException) {
                allRecordsRead = true;
            }
        }
        allRecordsRead = false;
        this.recordIndex = 0;
        while (!allRecordsRead) {
            Record pcRecord = this.getNextModifiedRecord();
            if (pcRecord != null) {
                this.synchronizePCRecord(pcRecord);
                this.resetAttributes(pcRecord);
                continue;
            }
            allRecordsRead = true;
        }
        this.writeHHRecords();
    }

    private Record getNewRecord() {
        Record hhRecord = null;
        try {
            hhRecord = (Record)this.recordClass.newInstance();
        }
        catch (Throwable t) {
            System.out.println("Uncaught exception: " + t);
            t.printStackTrace();
        }
        return hhRecord;
    }

    private Record getNextModifiedRecord() {
        if (this.pcRecords != null) {
            int i = this.recordIndex;
            while (i < this.pcRecords.size()) {
                Record record = (Record)this.pcRecords.elementAt(i);
                ++this.recordIndex;
                if (this.props.firstDevice == 2 || record.isModified() || record.isNew() || record.isDeleted() || record.isArchived()) {
                    return record;
                }
                ++i;
            }
        }
        return null;
    }

    private Record getRecordById(int id, Vector records) {
        if (records != null) {
            int i = 0;
            while (i < records.size()) {
                Record tempRecord = (Record)records.elementAt(i);
                if (tempRecord.getId() == id) {
                    return tempRecord;
                }
                ++i;
            }
        }
        return null;
    }

    public void handleArchived(Record hhRecord, Record pcRecord) throws IOException {
        Record backupRecord;
        if (!pcRecord.isModified()) {
            this.archiveRecord(hhRecord);
            this.deleteHHRecord(hhRecord);
            this.deletePCRecord(pcRecord);
            return;
        }
        if (!(hhRecord.isModified() || hhRecord.isNew() || hhRecord.isDeleted() || this.props.syncType != 1 || (backupRecord = this.getRecordById(hhRecord.getId(), this.backupRecords)) != null && this.compareRecords(hhRecord, backupRecord))) {
            hhRecord.setIsModified(true);
        }
        if (hhRecord.isModified()) {
            if (this.compareRecords(hhRecord, pcRecord)) {
                this.archiveRecord(hhRecord);
                this.deleteHHRecord(hhRecord);
                this.deletePCRecord(pcRecord);
            } else {
                pcRecord.setId(0);
                pcRecord.setIsNew(true);
                this.resetAttributes(hhRecord);
                this.addPCRecord(hhRecord);
            }
        } else if (pcRecord.isArchived() || pcRecord.isDeleted()) {
            this.archiveRecord(hhRecord);
            this.deletePCRecord(pcRecord);
            this.deleteHHRecord(hhRecord);
        } else {
            this.resetAttributes(pcRecord);
            this.deleteHHRecord(hhRecord);
            this.hhRecords.addElement(pcRecord);
        }
    }

    public void handleDeleted(Record hhRecord, Record pcRecord) throws IOException {
        if (pcRecord.isArchived()) {
            this.archiveRecord(pcRecord);
            this.deleteHHRecord(hhRecord);
            this.deletePCRecord(pcRecord);
        } else if (pcRecord.isModified()) {
            this.resetAttributes(pcRecord);
            this.hhRecords.addElement(pcRecord);
        } else {
            this.deleteHHRecord(hhRecord);
            this.deletePCRecord(pcRecord);
        }
    }

    public void handleModified(Record hhRecord, Record pcRecord) throws IOException {
        Record backupRecord;
        if (!(hhRecord.isModified() || (backupRecord = this.getRecordById(hhRecord.getId(), this.backupRecords)) != null && this.compareRecords(hhRecord, backupRecord))) {
            hhRecord.setIsModified(true);
        }
        if (hhRecord.isModified()) {
            if (pcRecord.isDeleted()) {
                this.deletePCRecord(pcRecord);
                this.addPCRecord(hhRecord);
            } else if (!pcRecord.isModified()) {
                this.resetAttributes(hhRecord);
                this.deletePCRecord(pcRecord);
                this.addPCRecord(hhRecord);
            } else if (this.compareRecords(hhRecord, pcRecord)) {
                if (pcRecord.isArchived()) {
                    this.archiveRecord(pcRecord);
                    this.deletePCRecord(pcRecord);
                    this.deleteHHRecord(hhRecord);
                } else if (pcRecord.isDeleted()) {
                    this.deletePCRecord(pcRecord);
                    this.deleteHHRecord(hhRecord);
                } else {
                    this.resetAttributes(pcRecord);
                    if (this.slowSync) {
                        this.slowPCRecords.addElement(pcRecord);
                    }
                }
            } else {
                this.resetAttributes(pcRecord);
                pcRecord.setIsNew(true);
                pcRecord.setId(0);
                this.resetAttributes(hhRecord);
                this.addPCRecord(hhRecord);
            }
        } else {
            if (pcRecord.isArchived()) {
                this.archiveRecord(pcRecord);
                this.deleteHHRecord(pcRecord);
            } else if (pcRecord.isDeleted()) {
                this.deleteHHRecord(hhRecord);
            } else if (pcRecord.isModified() && !this.compareRecords(hhRecord, pcRecord)) {
                this.hhRecords.addElement(pcRecord);
                this.slowPCRecords.addElement(pcRecord);
            } else {
                this.slowPCRecords.addElement(pcRecord);
            }
            this.pcRecords.removeElement(pcRecord);
        }
    }

    private void resetAttributes(Record record) {
        record.setIsModified(false);
        record.setIsArchived(false);
        record.setIsDeleted(false);
        record.setIsNew(false);
    }

    private Record retrieveHHRecord(Record pcRecord) throws IOException {
        Record hhRecord = this.getNewRecord();
        hhRecord.setId(pcRecord.getId());
        try {
            SyncManager.readRecordById(this.db, hhRecord);
        }
        catch (SyncException syncException) {
            return null;
        }
        return hhRecord;
    }

    public Vector slowSyncData(Vector pcRecords, Vector archivedRecords, Vector backupRecords) throws SyncException, IOException {
        this.backupRecords = backupRecords;
        boolean allRecordsRead = false;
        this.pcRecords = pcRecords;
        this.archivedRecords = archivedRecords;
        if (this.pcRecords == null) {
            this.pcRecords = new Vector();
        }
        this.recordIndex = 0;
        this.slowPCRecords = new Vector();
        this.slowSync = true;
        this.recordCount = SyncManager.getDBRecordCount(this.db);
        this.recordIndex = 0;
        while (this.recordIndex < this.recordCount) {
            Record hhRecord = this.getNewRecord();
            hhRecord.setIndex(this.recordIndex);
            SyncManager.readRecordByIndex(this.db, hhRecord);
            this.synchronizeHHRecord(hhRecord);
            ++this.recordIndex;
        }
        int i = 0;
        while (i < pcRecords.size()) {
            Record newRecord = (Record)pcRecords.elementAt(i);
            if (newRecord.isNew()) {
                this.resetAttributes(newRecord);
                this.addPCRecord(newRecord);
                this.hhRecords.addElement(newRecord);
            }
            ++i;
        }
        this.writeHHRecords();
        return this.slowPCRecords;
    }

    public void synchronizeHHRecord(Record hhRecord) throws SyncException, IOException {
        Record pcRecord = this.getRecordById(hhRecord.getId(), this.pcRecords);
        if (pcRecord == null) {
            if (hhRecord.isArchived()) {
                this.archiveRecord(hhRecord);
                this.deleteHHRecord(hhRecord);
            } else if (hhRecord.isDeleted()) {
                this.deletePCRecord(hhRecord);
                this.deleteHHRecord(hhRecord);
            } else {
                this.resetAttributes(hhRecord);
                this.addPCRecord(hhRecord);
                this.hhRecords.removeElement(hhRecord);
            }
        } else if (hhRecord.isArchived()) {
            this.handleArchived(hhRecord, pcRecord);
        } else if (hhRecord.isDeleted()) {
            this.handleDeleted(hhRecord, pcRecord);
        } else {
            this.handleModified(hhRecord, pcRecord);
        }
    }

    public void synchronizePCRecord(Record pcRecord) throws IOException, SyncException {
        if (!pcRecord.isNew()) {
            Record hhRecord = this.retrieveHHRecord(pcRecord);
            if (hhRecord == null) {
                if (this.props.firstDevice == 2) {
                    this.hhRecords.addElement(pcRecord);
                }
                SyncManager.writeRec(this.db, pcRecord);
            } else if (pcRecord.isArchived()) {
                this.archiveRecord(pcRecord);
                this.deletePCRecord(pcRecord);
                this.deleteHHRecord(pcRecord);
            } else if (pcRecord.isDeleted()) {
                this.deletePCRecord(pcRecord);
                this.deleteHHRecord(hhRecord);
            } else if (!this.compareRecords(hhRecord, pcRecord)) {
                this.hhRecords.addElement(pcRecord);
            }
        } else if (pcRecord.isArchived()) {
            this.archiveRecord(pcRecord);
            this.deletePCRecord(pcRecord);
        } else if (pcRecord.isDeleted()) {
            this.deletePCRecord(pcRecord);
        } else {
            this.resetAttributes(pcRecord);
            this.hhRecords.addElement(pcRecord);
        }
    }

    private void writeHHRecords() throws IOException {
        if (this.hhRecords != null) {
            int i = 0;
            while (i < this.hhRecords.size()) {
                Record hhRecord = (Record)this.hhRecords.elementAt(i);
                SyncManager.writeRec(this.db, hhRecord);
                ++i;
            }
            SyncManager.purgeDeletedRecs(this.db);
            SyncManager.resetSyncFlags(this.db);
        }
    }
}

