/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.ui;

import com.sun.dhcpmgr.data.IPAddress;
import com.sun.dhcpmgr.data.ValidationException;
import com.sun.dhcpmgr.ui.DownButton;
import com.sun.dhcpmgr.ui.IPAddressField;
import com.sun.dhcpmgr.ui.ResourceStrings;
import com.sun.dhcpmgr.ui.UpButton;
import com.sun.dhcpmgr.ui.VerticalButtonLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class IPAddressList
extends JPanel {
    IPAddressField address;
    JList serverList;
    IPAddressListModel serverListModel;
    JButton add;
    JButton delete;
    UpButton moveUp;
    DownButton moveDown;

    public IPAddressList() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        this.address = new IPAddressField();
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.address, gridBagConstraints);
        this.add(this.address);
        this.add = new JButton(ResourceStrings.getString("add"));
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.5;
        gridBagLayout.setConstraints(this.add, gridBagConstraints);
        this.add(this.add);
        this.serverListModel = new IPAddressListModel();
        this.serverList = new JList(this.serverListModel);
        this.serverList.setPrototypeCellValue("222.222.222.222");
        this.serverList.setSelectionMode(2);
        JScrollPane jScrollPane = new JScrollPane(this.serverList);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        this.add(jScrollPane);
        JPanel jPanel = new JPanel(new VerticalButtonLayout());
        this.moveUp = new UpButton();
        jPanel.add(this.moveUp);
        this.moveDown = new DownButton();
        jPanel.add(this.moveDown);
        this.delete = new JButton(ResourceStrings.getString("delete"));
        jPanel.add(this.delete);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.5;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        this.add.setEnabled(false);
        this.delete.setEnabled(false);
        this.moveUp.setEnabled(false);
        this.moveDown.setEnabled(false);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == IPAddressList.this.add || actionEvent.getSource() == IPAddressList.this.address) {
                    IPAddress iPAddress = IPAddressList.this.address.getValue();
                    if (iPAddress != null) {
                        IPAddressList.this.serverListModel.addElement(iPAddress);
                    }
                } else if (actionEvent.getSource() == IPAddressList.this.delete) {
                    int n;
                    int[] nArray = IPAddressList.this.serverList.getSelectedIndices();
                    if (nArray.length > 1) {
                        n = 0;
                        while (n < nArray.length) {
                            int n2 = n;
                            while (n2 < nArray.length) {
                                if (nArray[n] > nArray[n2]) {
                                    int n3 = nArray[n];
                                    nArray[n] = nArray[n2];
                                    nArray[n2] = n3;
                                }
                                ++n2;
                            }
                            ++n;
                        }
                    }
                    n = nArray.length - 1;
                    while (n >= 0) {
                        IPAddressList.this.serverListModel.removeElementAt(nArray[n]);
                        --n;
                    }
                    if (nArray.length > 1) {
                        IPAddressList.this.serverList.clearSelection();
                        IPAddressList.this.delete.setEnabled(false);
                    } else if (IPAddressList.this.serverListModel.getSize() == 0) {
                        IPAddressList.this.delete.setEnabled(false);
                    } else if (nArray[0] >= IPAddressList.this.serverListModel.getSize()) {
                        IPAddressList.this.serverList.setSelectedIndex(IPAddressList.this.serverListModel.getSize() - 1);
                    } else {
                        IPAddressList.this.serverList.setSelectedIndex(nArray[0]);
                    }
                } else if (actionEvent.getSource() == IPAddressList.this.moveUp) {
                    int n = IPAddressList.this.serverList.getSelectedIndex();
                    IPAddressList.this.serverListModel.moveUp(n);
                    IPAddressList.this.serverList.setSelectedIndex(n - 1);
                } else if (actionEvent.getSource() == IPAddressList.this.moveDown) {
                    int n = IPAddressList.this.serverList.getSelectedIndex();
                    IPAddressList.this.serverListModel.moveDown(n);
                    IPAddressList.this.serverList.setSelectedIndex(n + 1);
                }
            }
        };
        this.address.addActionListener(actionListener);
        this.add.addActionListener(actionListener);
        this.delete.addActionListener(actionListener);
        this.moveUp.addActionListener(actionListener);
        this.moveDown.addActionListener(actionListener);
        this.serverList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int[] nArray = IPAddressList.this.serverList.getSelectedIndices();
                switch (nArray.length) {
                    case 0: {
                        IPAddressList.this.delete.setEnabled(false);
                        IPAddressList.this.moveUp.setEnabled(false);
                        IPAddressList.this.moveDown.setEnabled(false);
                        break;
                    }
                    case 1: {
                        IPAddressList.this.delete.setEnabled(true);
                        if (nArray[0] == 0) {
                            IPAddressList.this.moveUp.setEnabled(false);
                        } else {
                            IPAddressList.this.moveUp.setEnabled(true);
                        }
                        if (nArray[0] == IPAddressList.this.serverListModel.getSize() - 1) {
                            IPAddressList.this.moveDown.setEnabled(false);
                            break;
                        }
                        IPAddressList.this.moveDown.setEnabled(true);
                        break;
                    }
                    default: {
                        IPAddressList.this.delete.setEnabled(true);
                        IPAddressList.this.moveUp.setEnabled(false);
                        IPAddressList.this.moveDown.setEnabled(false);
                    }
                }
            }
        });
        this.address.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                IPAddressList.this.add.setEnabled(IPAddressList.this.address.getText().length() != 0);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        });
    }

    public Vector getAddressList() {
        return this.serverListModel.getDataVector();
    }

    public String getAddressListString() {
        return this.serverListModel.getDataString();
    }

    public int getListSize() {
        return this.serverListModel.getDataVector().size();
    }

    public void setAddressList(String string) {
        this.serverListModel.setData(string);
    }

    public void setAddressList(IPAddress[] iPAddressArray) {
        this.serverListModel.setData(iPAddressArray);
    }

    class IPAddressListModel
    extends AbstractListModel {
        private Vector addrs = new Vector();

        public void addElement(IPAddress iPAddress) {
            this.addrs.addElement(iPAddress);
            this.fireIntervalAdded(this, this.addrs.size() - 1, this.addrs.size() - 1);
        }

        public String getDataString() {
            StringBuffer stringBuffer = new StringBuffer();
            Enumeration enumeration = this.addrs.elements();
            while (enumeration.hasMoreElements()) {
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(((IPAddress)enumeration.nextElement()).getHostAddress());
            }
            return stringBuffer.toString();
        }

        public Vector getDataVector() {
            return (Vector)this.addrs.clone();
        }

        public Object getElementAt(int n) {
            return this.addrs.elementAt(n);
        }

        public int getSize() {
            return this.addrs.size();
        }

        public void moveDown(int n) {
            Object e = this.addrs.elementAt(n + 1);
            this.addrs.setElementAt(this.addrs.elementAt(n), n + 1);
            this.addrs.setElementAt(e, n);
            this.fireContentsChanged(this, n, n + 1);
        }

        public void moveUp(int n) {
            Object e = this.addrs.elementAt(n - 1);
            this.addrs.setElementAt(this.addrs.elementAt(n), n - 1);
            this.addrs.setElementAt(e, n);
            this.fireContentsChanged(this, n - 1, n);
        }

        public void removeElementAt(int n) {
            this.addrs.removeElementAt(n);
            this.fireIntervalRemoved(this, n, n);
        }

        public void setData(String string) {
            this.addrs.removeAllElements();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    this.addrs.addElement(new IPAddress(stringTokenizer.nextToken()));
                }
                catch (ValidationException validationException) {}
            }
            this.fireContentsChanged(this, 0, this.addrs.size() - 1);
        }

        public void setData(IPAddress[] iPAddressArray) {
            this.addrs.removeAllElements();
            int n = 0;
            while (n < iPAddressArray.length) {
                this.addrs.addElement(iPAddressArray[n]);
                ++n;
            }
            this.fireContentsChanged(this, 0, this.addrs.size() - 1);
        }
    }
}

