/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.client;

import com.sun.dhcpmgr.client.DataManager;
import com.sun.dhcpmgr.client.DhcpmgrApplet;
import com.sun.dhcpmgr.client.DhcpmgrDialog;
import com.sun.dhcpmgr.client.ResourceStrings;
import com.sun.dhcpmgr.data.DhcpdOptions;
import com.sun.dhcpmgr.data.IPInterface;
import com.sun.dhcpmgr.ui.IPAddressList;
import com.sun.dhcpmgr.ui.IntegerField;
import com.sun.dhcpmgr.ui.LeftButton;
import com.sun.dhcpmgr.ui.RightButton;
import com.sun.dhcpmgr.ui.VerticalButtonLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class ServerOptionsDialog
extends DhcpmgrDialog {
    private static int DEFAULT_RESCAN_INTERVAL = 60;
    private DhcpdOptions options;
    private DhcpdOptions originalOptions;
    private JCheckBox verboseLogging;
    private JCheckBox detectDuplicates;
    private JCheckBox restartServer;
    private JCheckBox logTransactions;
    private JCheckBox reloadEnabled;
    private JCheckBox dnsUpdateEnabled;
    private IntegerField relayHops;
    private IntegerField reloadInterval;
    private IntegerField cacheTime;
    private IntegerField dnsTimeout;
    private JRadioButton noBootp;
    private JRadioButton autoBootp;
    private JRadioButton manualBootp;
    private IPAddressList serverList;
    private JComboBox logFacility;
    private JTable monitoredTable;
    private JTable ignoredTable;
    private LeftButton leftButton;
    private RightButton rightButton;
    static /* synthetic */ Class class$java$lang$String;

    public ServerOptionsDialog(Frame frame, DhcpdOptions dhcpdOptions) {
        super(frame, true);
        this.setOptions(dhcpdOptions);
        this.resetValues();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void doOk() {
        try {
            this.options.setVerbose(this.verboseLogging.isSelected());
            if (this.relayHops.getValue() != 4) {
                this.options.setRelayHops(true, new Integer(this.relayHops.getValue()));
            } else {
                this.options.setRelayHops(false, null);
            }
            this.options.setLogging(this.logTransactions.isSelected(), (Integer)this.logFacility.getSelectedItem());
            if (!DhcpmgrApplet.modeIsRelay) {
                this.options.setBootpCompatible(this.noBootp.isSelected() ^ true, this.autoBootp.isSelected());
                this.options.setICMPVerify(this.detectDuplicates.isSelected());
                if (this.reloadEnabled.isSelected() && this.reloadInterval.getValue() != 0) {
                    this.options.setRescan(true, new Integer(this.reloadInterval.getValue()));
                } else {
                    this.options.setRescan(false, null);
                }
                if (this.dnsUpdateEnabled.isSelected()) {
                    this.options.setDnsTimeout(true, new Integer(this.dnsTimeout.getValue()));
                } else {
                    this.options.setDnsTimeout(false, null);
                }
                if (this.cacheTime.getValue() != 10) {
                    this.options.setOfferTtl(true, new Integer(this.cacheTime.getValue()));
                } else {
                    this.options.setOfferTtl(false, null);
                }
            } else {
                this.options.setRelay(true, this.serverList.getAddressListString());
            }
            if (this.monitoredTable.getRowCount() == 0) {
                return;
            }
            if (this.ignoredTable.getRowCount() != 0) {
                this.options.setInterfaces(true, ((InterfaceTableModel)this.monitoredTable.getModel()).getInterfaceList());
            } else {
                this.options.setInterfaces(false, null);
            }
            DataManager.get().getDhcpServiceMgr().writeDefaults(this.options);
            if (this.restartServer.isSelected()) {
                DataManager.get().getDhcpServiceMgr().shutdown();
                Thread.sleep(5000L);
                DataManager.get().getDhcpServiceMgr().startup();
            }
            this.fireActionPerformed();
            ((Component)this).setVisible(false);
            this.dispose();
        }
        catch (Exception exception) {
            MessageFormat messageFormat = null;
            Object[] objectArray = new Object[2];
            messageFormat = new MessageFormat(ResourceStrings.getString("service_options_error"));
            objectArray[0] = exception.getMessage();
            JOptionPane.showMessageDialog(this, messageFormat.format(objectArray), ResourceStrings.getString("server_error_title"), 0);
        }
    }

    protected void doReset() {
        this.setOptions(this.originalOptions);
        this.resetValues();
    }

    protected void fireActionPerformed() {
        this.fireActionPerformed(this, "ok");
    }

    protected String getHelpKey() {
        if (DhcpmgrApplet.modeIsRelay) {
            return "modify_relay";
        }
        return "modify_server";
    }

    protected JPanel getMainPanel() {
        Serializable serializable;
        Serializable serializable2;
        Serializable serializable3;
        JPanel jPanel = new JPanel(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel2.setLayout(gridBagLayout);
        Box box = Box.createHorizontalBox();
        JLabel jLabel = new JLabel(ResourceStrings.getString("service_options_hops"));
        jLabel.setForeground(Color.black);
        box.add(jLabel);
        box.add(Box.createHorizontalStrut(5));
        this.relayHops = new IntegerField();
        box.add(this.relayHops);
        gridBagLayout.setConstraints(box, gridBagConstraints);
        jPanel2.add(box);
        this.verboseLogging = new JCheckBox(ResourceStrings.getString("service_options_verbose"), false);
        ++gridBagConstraints.gridy;
        gridBagLayout.setConstraints(this.verboseLogging, gridBagConstraints);
        jPanel2.add(this.verboseLogging);
        box = Box.createHorizontalBox();
        this.logTransactions = new JCheckBox(ResourceStrings.getString("service_options_log_transactions"), false);
        this.logTransactions.setAlignmentY(0.5f);
        box.add(this.logTransactions);
        box.add(Box.createHorizontalStrut(5));
        this.logFacility = new JComboBox<Integer>(DhcpdOptions.getLoggingFacilities());
        this.logFacility.setAlignmentY(0.5f);
        box.add(this.logFacility);
        ++gridBagConstraints.gridy;
        gridBagLayout.setConstraints(box, gridBagConstraints);
        jPanel2.add(box);
        this.logTransactions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServerOptionsDialog.this.logFacility.setEnabled(ServerOptionsDialog.this.logTransactions.isSelected());
            }
        });
        if (!DhcpmgrApplet.modeIsRelay) {
            this.detectDuplicates = new JCheckBox(ResourceStrings.getString("service_options_detect_duplicates"), true);
            ++gridBagConstraints.gridy;
            gridBagLayout.setConstraints(this.detectDuplicates, gridBagConstraints);
            jPanel2.add(this.detectDuplicates);
            box = Box.createHorizontalBox();
            this.reloadEnabled = new JCheckBox(ResourceStrings.getString("service_options_reload_dhcptab"));
            this.reloadEnabled.setAlignmentY(0.5f);
            box.add(this.reloadEnabled);
            box.add(Box.createHorizontalStrut(5));
            this.reloadInterval = new IntegerField();
            this.reloadInterval.setAlignmentY(0.5f);
            box.add(this.reloadInterval);
            box.add(Box.createHorizontalStrut(5));
            jLabel = new JLabel(ResourceStrings.getString("service_options_reload_minutes"));
            jLabel.setForeground(Color.black);
            jLabel.setAlignmentY(0.5f);
            box.add(jLabel);
            ++gridBagConstraints.gridy;
            gridBagLayout.setConstraints(box, gridBagConstraints);
            jPanel2.add(box);
            box = Box.createHorizontalBox();
            this.dnsUpdateEnabled = new JCheckBox(ResourceStrings.getString("service_options_update_dns"));
            this.dnsUpdateEnabled.setAlignmentY(0.5f);
            box.add(this.dnsUpdateEnabled);
            box.add(Box.createHorizontalStrut(5));
            ++gridBagConstraints.gridy;
            gridBagLayout.setConstraints(box, gridBagConstraints);
            jPanel2.add(box);
            box = Box.createHorizontalBox();
            this.dnsTimeout = new IntegerField();
            this.dnsTimeout.setAlignmentY(0.1f);
            box.add(Box.createHorizontalStrut(25));
            jLabel = new JLabel(ResourceStrings.getString("service_options_timeout_dns"));
            jLabel.setForeground(Color.black);
            jLabel.setAlignmentY(0.5f);
            box.add(jLabel);
            box.add(Box.createHorizontalStrut(5));
            box.add(this.dnsTimeout);
            box.add(Box.createHorizontalStrut(5));
            jLabel = new JLabel(ResourceStrings.getString("service_options_seconds"));
            jLabel.setForeground(Color.black);
            jLabel.setAlignmentY(0.5f);
            box.add(jLabel);
            ++gridBagConstraints.gridy;
            gridBagLayout.setConstraints(box, gridBagConstraints);
            jPanel2.add(box);
            box = Box.createHorizontalBox();
            jLabel = new JLabel(ResourceStrings.getString("service_options_cache"));
            jLabel.setForeground(Color.black);
            box.add(jLabel);
            box.add(Box.createHorizontalStrut(5));
            this.cacheTime = new IntegerField();
            box.add(this.cacheTime);
            box.add(Box.createHorizontalStrut(5));
            jLabel = new JLabel(ResourceStrings.getString("service_options_seconds"));
            jLabel.setForeground(Color.black);
            box.add(jLabel);
            ++gridBagConstraints.gridy;
            gridBagLayout.setConstraints(box, gridBagConstraints);
            jPanel2.add(box);
            serializable3 = new JPanel();
            ((Container)serializable3).setLayout(new GridLayout(3, 1));
            serializable2 = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), ResourceStrings.getString("service_options_bootp_compat"));
            ((JComponent)serializable3).setBorder(BorderFactory.createCompoundBorder((Border)((Object)serializable2), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            serializable = new ButtonGroup();
            this.noBootp = new JRadioButton(ResourceStrings.getString("service_options_bootp_none"), true);
            ((ButtonGroup)serializable).add(this.noBootp);
            ((Container)serializable3).add(this.noBootp);
            this.autoBootp = new JRadioButton(ResourceStrings.getString("service_options_bootp_auto"), false);
            ((ButtonGroup)serializable).add(this.autoBootp);
            ((Container)serializable3).add(this.autoBootp);
            this.manualBootp = new JRadioButton(ResourceStrings.getString("service_options_bootp_manual"), false);
            ((ButtonGroup)serializable).add(this.manualBootp);
            ((Container)serializable3).add(this.manualBootp);
            ++gridBagConstraints.gridy;
            gridBagConstraints.fill = 2;
            gridBagLayout.setConstraints((Component)serializable3, gridBagConstraints);
            jPanel2.add((Component)serializable3);
            this.reloadEnabled.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ServerOptionsDialog.this.reloadInterval.setEnabled(ServerOptionsDialog.this.reloadEnabled.isSelected());
                }
            });
            this.dnsUpdateEnabled.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ServerOptionsDialog.this.dnsTimeout.setEnabled(ServerOptionsDialog.this.dnsUpdateEnabled.isSelected());
                }
            });
        } else {
            this.serverList = new IPAddressList();
            serializable3 = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), ResourceStrings.getString("dhcp_servers"));
            this.serverList.setBorder(BorderFactory.createCompoundBorder((Border)((Object)serializable3), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            ++gridBagConstraints.gridy;
            gridBagLayout.setConstraints(this.serverList, gridBagConstraints);
            jPanel2.add(this.serverList);
        }
        jTabbedPane.addTab(ResourceStrings.getString("service_options_options"), jPanel2);
        this.monitoredTable = new JTable(new InterfaceTableModel());
        this.ignoredTable = new JTable(new InterfaceTableModel());
        this.monitoredTable.setSelectionMode(2);
        this.ignoredTable.setSelectionMode(2);
        serializable3 = Box.createHorizontalBox();
        serializable2 = new JPanel(new BorderLayout(5, 5));
        serializable2.add(new JLabel(ResourceStrings.getString("service_options_monitored")), "North");
        serializable = new JScrollPane(this.monitoredTable);
        Dimension dimension = this.monitoredTable.getPreferredScrollableViewportSize();
        dimension.height = 100;
        dimension.width = 210;
        this.monitoredTable.setPreferredScrollableViewportSize(dimension);
        serializable2.add((Component)serializable, "Center");
        ((Container)serializable3).add((Component)serializable2);
        ((Container)serializable3).add(Box.createHorizontalStrut(10));
        serializable2 = new JPanel(new VerticalButtonLayout());
        this.leftButton = new LeftButton();
        this.rightButton = new RightButton();
        this.rightButton.setEnabled(false);
        this.leftButton.setEnabled(false);
        serializable2.add(this.rightButton);
        serializable2.add(this.leftButton);
        ((Container)serializable3).add((Component)serializable2);
        ((Container)serializable3).add(Box.createHorizontalStrut(10));
        serializable2 = new JPanel(new BorderLayout(5, 5));
        serializable2.add(new JLabel(ResourceStrings.getString("service_options_ignored")), "North");
        serializable = new JScrollPane(this.ignoredTable);
        dimension = this.ignoredTable.getPreferredScrollableViewportSize();
        dimension.height = 100;
        dimension.width = 210;
        this.ignoredTable.setPreferredScrollableViewportSize(dimension);
        serializable2.add((Component)serializable, "Center");
        ((Container)serializable3).add((Component)serializable2);
        serializable2 = new JPanel(new BorderLayout());
        serializable2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        serializable2.add((Component)serializable3, "Center");
        jTabbedPane.addTab(ResourceStrings.getString("service_options_interfaces"), (Component)serializable2);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel3.add((Component)jTabbedPane, "Center");
        jPanel.add((Component)jPanel3, "North");
        this.restartServer = new JCheckBox(ResourceStrings.getString("service_options_restart"));
        serializable2 = new JPanel(new FlowLayout(0));
        serializable2.add(this.restartServer);
        jPanel.add((Component)serializable2, "Center");
        this.buttonPanel.setOkEnabled(true);
        this.monitoredTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (ServerOptionsDialog.this.monitoredTable.getSelectedRowCount() != 0) {
                    ServerOptionsDialog.this.rightButton.setEnabled(true);
                    ServerOptionsDialog.this.ignoredTable.getSelectionModel().clearSelection();
                } else {
                    ServerOptionsDialog.this.rightButton.setEnabled(false);
                }
            }
        });
        this.ignoredTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (ServerOptionsDialog.this.ignoredTable.getSelectedRowCount() != 0) {
                    ServerOptionsDialog.this.leftButton.setEnabled(true);
                    ServerOptionsDialog.this.monitoredTable.getSelectionModel().clearSelection();
                } else {
                    ServerOptionsDialog.this.leftButton.setEnabled(false);
                }
            }
        });
        this.rightButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IPInterface iPInterface;
                int[] nArray = ServerOptionsDialog.this.monitoredTable.getSelectedRows();
                if (nArray == null) {
                    return;
                }
                InterfaceTableModel interfaceTableModel = (InterfaceTableModel)ServerOptionsDialog.this.monitoredTable.getModel();
                InterfaceTableModel interfaceTableModel2 = (InterfaceTableModel)ServerOptionsDialog.this.ignoredTable.getModel();
                Vector<IPInterface> vector = new Vector<IPInterface>();
                int n = 0;
                while (n < nArray.length) {
                    iPInterface = interfaceTableModel.getInterfaceAt(nArray[n]);
                    interfaceTableModel2.addInterface(iPInterface);
                    vector.addElement(iPInterface);
                    ++n;
                }
                iPInterface = vector.elements();
                while (iPInterface.hasMoreElements()) {
                    interfaceTableModel.deleteInterface((IPInterface)iPInterface.nextElement());
                }
                ServerOptionsDialog.this.monitoredTable.getSelectionModel().clearSelection();
            }
        });
        this.leftButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IPInterface iPInterface;
                int[] nArray = ServerOptionsDialog.this.ignoredTable.getSelectedRows();
                if (nArray == null) {
                    return;
                }
                InterfaceTableModel interfaceTableModel = (InterfaceTableModel)ServerOptionsDialog.this.monitoredTable.getModel();
                InterfaceTableModel interfaceTableModel2 = (InterfaceTableModel)ServerOptionsDialog.this.ignoredTable.getModel();
                Vector<IPInterface> vector = new Vector<IPInterface>();
                int n = 0;
                while (n < nArray.length) {
                    iPInterface = interfaceTableModel2.getInterfaceAt(nArray[n]);
                    interfaceTableModel.addInterface(iPInterface);
                    vector.addElement(iPInterface);
                    ++n;
                }
                iPInterface = vector.elements();
                while (iPInterface.hasMoreElements()) {
                    interfaceTableModel2.deleteInterface((IPInterface)iPInterface.nextElement());
                }
                ServerOptionsDialog.this.ignoredTable.getSelectionModel().clearSelection();
            }
        });
        return jPanel;
    }

    public String getTitle() {
        return ResourceStrings.getString("service_options_title");
    }

    private void resetValues() {
        this.verboseLogging.setSelected(this.options.isVerbose());
        if (this.options.isRelayHops()) {
            this.relayHops.setValue(this.options.getRelayHops());
        } else {
            this.relayHops.setValue(4);
        }
        this.logTransactions.setSelected(this.options.isLogging());
        this.logFacility.setEnabled(this.options.isLogging());
        if (this.options.isLogging()) {
            this.logFacility.setSelectedItem(this.options.getLogging());
        } else {
            this.logFacility.setSelectedIndex(0);
        }
        if (!DhcpmgrApplet.modeIsRelay) {
            this.noBootp.setSelected(this.options.isBootpCompatible() ^ true);
            if (this.options.isBootpCompatible()) {
                this.autoBootp.setSelected(this.options.isBootpAutomatic());
                this.manualBootp.setSelected(this.options.isBootpAutomatic() ^ true);
            }
            this.detectDuplicates.setSelected(this.options.isICMPVerify());
            this.reloadEnabled.setSelected(this.options.isRescan());
            this.reloadInterval.setEnabled(this.options.isRescan());
            this.dnsUpdateEnabled.setSelected(this.options.isDnsUpdated());
            this.dnsTimeout.setEnabled(this.options.isDnsUpdated());
            if (this.options.isRescan()) {
                this.reloadInterval.setValue(this.options.getRescan());
            } else {
                this.reloadInterval.setValue(DEFAULT_RESCAN_INTERVAL);
            }
            if (this.options.isDnsUpdated()) {
                this.dnsTimeout.setValue(this.options.getDnsTimeout());
            } else {
                this.dnsTimeout.setValue(15);
            }
            if (this.options.isOfferTtl()) {
                this.cacheTime.setValue(this.options.getOfferTtl());
            } else {
                this.cacheTime.setValue(10);
            }
        } else {
            this.serverList.setAddressList(this.options.getRelay());
        }
        try {
            IPInterface[] iPInterfaceArray = DataManager.get().getDhcpServiceMgr().getInterfaces();
            InterfaceTableModel interfaceTableModel = (InterfaceTableModel)this.monitoredTable.getModel();
            InterfaceTableModel interfaceTableModel2 = (InterfaceTableModel)this.ignoredTable.getModel();
            if (this.options.isInterfaces()) {
                interfaceTableModel2.setInterfaceList(iPInterfaceArray);
                interfaceTableModel.setInterfaceList(null);
                StringTokenizer stringTokenizer = new StringTokenizer(this.options.getInterfaces(), ",");
                while (stringTokenizer.hasMoreTokens()) {
                    IPInterface iPInterface = interfaceTableModel2.getInterface(stringTokenizer.nextToken());
                    if (iPInterface == null) continue;
                    interfaceTableModel.addInterface(iPInterface);
                    interfaceTableModel2.deleteInterface(iPInterface);
                }
            } else {
                interfaceTableModel.setInterfaceList(iPInterfaceArray);
                interfaceTableModel2.setInterfaceList(null);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.restartServer.setSelected(true);
    }

    private void setOptions(DhcpdOptions dhcpdOptions) {
        this.originalOptions = (DhcpdOptions)dhcpdOptions.clone();
        this.options = dhcpdOptions;
    }

    class InterfaceTableModel
    extends AbstractTableModel {
        private Vector interfaces = new Vector();

        public void addInterface(IPInterface iPInterface) {
            this.interfaces.addElement(iPInterface);
            this.fireTableDataChanged();
        }

        public void deleteInterface(IPInterface iPInterface) {
            this.interfaces.removeElement(iPInterface);
            this.fireTableDataChanged();
        }

        public Class getColumnClass(int n) {
            return class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = ServerOptionsDialog.class$("java.lang.String"));
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return ResourceStrings.getString("service_options_interface");
            }
            return ResourceStrings.getString("service_options_network");
        }

        public IPInterface getInterface(String string) {
            Enumeration enumeration = this.interfaces.elements();
            while (enumeration.hasMoreElements()) {
                IPInterface iPInterface = (IPInterface)enumeration.nextElement();
                if (!string.equals(iPInterface.getName())) continue;
                return iPInterface;
            }
            return null;
        }

        public IPInterface getInterfaceAt(int n) {
            return (IPInterface)this.interfaces.elementAt(n);
        }

        public String getInterfaceList() {
            StringBuffer stringBuffer = new StringBuffer();
            Enumeration enumeration = this.interfaces.elements();
            while (enumeration.hasMoreElements()) {
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(',');
                }
                IPInterface iPInterface = (IPInterface)enumeration.nextElement();
                stringBuffer.append(iPInterface.getName());
            }
            return stringBuffer.toString();
        }

        public int getRowCount() {
            return this.interfaces.size();
        }

        public Object getValueAt(int n, int n2) {
            IPInterface iPInterface = (IPInterface)this.interfaces.elementAt(n);
            if (n2 == 0) {
                return iPInterface.getName();
            }
            return iPInterface.getNetwork().toString();
        }

        public void setInterfaceList(IPInterface[] iPInterfaceArray) {
            this.interfaces.removeAllElements();
            if (iPInterfaceArray != null) {
                int n = 0;
                while (n < iPInterfaceArray.length) {
                    this.interfaces.addElement(iPInterfaceArray[n]);
                    ++n;
                }
            }
            this.fireTableDataChanged();
        }
    }
}

