/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.diskmgr.client;

import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.diskmgr.client.Content;
import com.sun.admin.diskmgr.client.ContentEvent;
import com.sun.admin.diskmgr.client.ContentListener;
import com.sun.admin.diskmgr.client.DiskActionsListener;
import com.sun.admin.diskmgr.client.DiskContent;
import com.sun.admin.diskmgr.client.NavigationSelectionListener;
import com.sun.admin.diskmgr.client.TreeNodeData;
import com.sun.admin.diskmgr.client.VDiskMgr;
import com.sun.admin.diskmgr.common.SliceData;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.border.Border;

public class SliceToolBar
extends JToolBar {
    private ToolBarButton tbNewFS;
    private ContentListener contentListener;
    private Content content;
    private int newButtonPosition;
    private VDiskMgr theApp;
    DiskActionsListener buttonClickListener;

    public SliceToolBar(VDiskMgr vDiskMgr) {
        this.theApp = vDiskMgr;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.buttonClickListener = new DiskActionsListener(vDiskMgr);
        ((Container)this).setLayout(new GridBagLayout());
        this.tbNewFS = new ToolBarButton("TBNewFS", "createFs", "CreateFS");
        Constraints.constrain((Container)this, (Component)this.tbNewFS, (int)-1, (int)0, (int)1, (int)1, (int)0, (int)5, (int)0, (int)0);
        Dimension dimension = new Dimension(1, 1);
        this.tbNewFS.setEnabled(false);
        Constraints.constrain((Container)this, (Component)new Box.Filler(dimension, dimension, dimension), (int)-1, (int)0, (int)0, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        this.contentListener = new ContentListener(){

            public void itemPressed(ContentEvent contentEvent) {
                Content content = contentEvent.getSource();
                SliceToolBar.this.notifySelectionChange(content.getNumSelections());
            }
        };
        vDiskMgr.addNavigationSelectionListener(new NavigationSelectionListener(){

            public void valueChanged(VScopeNode vScopeNode) {
                if (SliceToolBar.this.content != null) {
                    SliceToolBar.this.content.removeContentListener(SliceToolBar.this.contentListener);
                }
                TreeNodeData treeNodeData = (TreeNodeData)vScopeNode.getPayload();
                SliceToolBar.this.content = treeNodeData.getContent();
                SliceToolBar.this.content.addContentListener(SliceToolBar.this.contentListener);
                SliceToolBar.this.configureForContent();
                SliceToolBar.this.notifySelectionChange(SliceToolBar.this.content.getNumSelections());
            }
        });
    }

    private void configureForContent() {
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        vConsoleProperties.setProperty("vconsole.deleteenabled", "false");
        vConsoleProperties.setProperty("vconsole.findenabled", "false");
        vConsoleProperties.setProperty("vconsole.filterenabled", "false");
        vConsoleProperties.setProperty("vconsole.propertiesenabled", "true");
    }

    private void notifySelectionChange(int n) {
        Content content;
        boolean bl = this.theApp.getDiskMgr().hasWriteAuthorization();
        VScopeNode vScopeNode = this.theApp.getTree().getCurrentContent().getSelectedNode();
        if (vScopeNode != null && (content = this.theApp.getTree().getCurrentContent()) instanceof DiskContent) {
            SliceData sliceData = (SliceData)vScopeNode.getPayload();
            int n2 = sliceData.getEndCylinder() - sliceData.getStartCylinder();
            boolean bl2 = n2 > 0 && sliceData.getTag() != 5;
            boolean bl3 = bl && bl2 && !sliceData.getFS();
            this.tbNewFS.setEnabled(bl3);
        }
    }

    class ToolBarButton
    extends JButton {
        private ImageIcon enabledIcon;
        private Border defaultBorder;

        public ToolBarButton(String string) {
            this(string, "???", "undefined");
        }

        public ToolBarButton(String string, String string2, String string3) {
            ResourceBundle resourceBundle = SliceToolBar.this.theApp.getResourceBundle();
            this.enabledIcon = SliceToolBar.this.theApp.loadImageIcon(String.valueOf(string2) + ".gif");
            if (this.enabledIcon != null && this.enabledIcon.getIconHeight() != -1) {
                this.setIcon(this.enabledIcon);
            } else {
                this.setText(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)string));
            }
            this.setBorderPainted(true);
            this.defaultBorder = this.getBorder();
            this.setFocusPainted(false);
            this.setActionCommand(string3);
            this.setToolTipText(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)(String.valueOf(string) + "Tooltip")));
            this.setMargin(new Insets(0, 0, 0, 0));
            this.addActionListener(SliceToolBar.this.buttonClickListener);
        }

        public void showAsDepressed() {
            this.setBorder(BorderFactory.createBevelBorder(1));
        }

        public void showAsEnabled() {
            this.setBorder(this.defaultBorder);
            this.setEnabled(true);
        }
    }
}

