/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.diskmgr.client;

import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.diskmgr.client.Content;
import com.sun.admin.diskmgr.client.DiskMgrContextHelpListener;
import com.sun.admin.diskmgr.client.FdiskWizard;
import com.sun.admin.diskmgr.client.VDiskMgr;
import com.sun.admin.diskmgr.common.DiskData;
import com.sun.admin.diskmgr.common.FdiskData;
import com.sun.management.viper.console.gui.VOptionPane;
import com.sun.management.viper.console.gui.wizard.VWizardCard;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FdiskReviewStep
extends VWizardCard {
    public static final String NAME = "FdiskReviewStep";
    public static final int HELP_CACHE_SIZE = 1;
    private static ResourceBundle bundle;
    GenInfoPanel infoPanel;
    Vector helpCache;
    DiskMgrContextHelpListener helpListener;
    DiskData diskData;
    FdiskWizard wizard;
    VDiskMgr theApp;
    Vector partitions;

    public FdiskReviewStep(VDiskMgr vDiskMgr, FdiskWizard fdiskWizard) {
        this.theApp = vDiskMgr;
        this.wizard = fdiskWizard;
        this.diskData = fdiskWizard.getDiskData();
        bundle = vDiskMgr.getResourceBundle();
        this.infoPanel = new GenInfoPanel((VOptionPane)fdiskWizard);
        this.helpCache = new Vector(1);
        this.helpListener = new DiskMgrContextHelpListener(vDiskMgr, this.helpCache, this.infoPanel, "fdisk_wiz_review");
        this.infoPanel.setFocusListener((FocusListener)((Object)this.helpListener), true);
        this.setTitle(ResourceStrings.getString((ResourceBundle)bundle, (String)"FdiskWizReviewStep"));
        this.constructStep();
    }

    private void constructStep() {
        ((Container)((Object)this)).removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        FlowArea flowArea = new FlowArea(ResourceStrings.getString((ResourceBundle)bundle, (String)"FdiskWizReviewWarning"), 30, Constants.PROPS_RO_VALUE_FONT);
        Constraints.constrain((Container)jPanel, (Component)flowArea, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)6, (int)6, (int)6, (int)6);
        Constraints.constrain((Container)((Object)this), (Component)jPanel, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)bundle, (String)"FdiskWizReviewPart"));
        Constraints.constrain((Container)jPanel2, (Component)jLabel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)10, (double)0.0, (double)0.0, (int)6, (int)6, (int)6, (int)6);
        jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)bundle, (String)"FdiskWizReviewSize"));
        Constraints.constrain((Container)jPanel2, (Component)jLabel, (int)1, (int)0, (int)1, (int)1, (int)0, (int)10, (double)0.0, (double)0.0, (int)6, (int)6, (int)6, (int)6);
        jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)bundle, (String)"FdiskWizReviewUse"));
        Constraints.constrain((Container)jPanel2, (Component)jLabel, (int)2, (int)0, (int)1, (int)1, (int)0, (int)10, (double)0.0, (double)0.0, (int)6, (int)6, (int)6, (int)6);
        JPanel jPanel3 = new JPanel();
        Constraints.constrain((Container)jPanel2, (Component)jPanel3, (int)4, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        int n = 1;
        this.partitions = this.diskData.getVPartitions();
        FdiskData fdiskData = null;
        Enumeration enumeration = this.partitions.elements();
        while (enumeration.hasMoreElements()) {
            fdiskData = (FdiskData)enumeration.nextElement();
            JLabel jLabel2 = new JLabel(Short.toString(fdiskData.getPartition()));
            Constraints.constrain((Container)jPanel2, (Component)jLabel2, (int)0, (int)n, (int)1, (int)1, (int)0, (int)10, (double)0.0, (double)0.0, (int)3, (int)6, (int)6, (int)6);
            JLabel jLabel3 = new JLabel(Content.formatSuffix(fdiskData.getSize(), ResourceStrings.getString((ResourceBundle)bundle, (String)"Megabytes")));
            Constraints.constrain((Container)jPanel2, (Component)jLabel3, (int)1, (int)n, (int)1, (int)1, (int)0, (int)10, (double)0.0, (double)0.0, (int)3, (int)6, (int)6, (int)6);
            JLabel jLabel4 = new JLabel(fdiskData.getUsedForString());
            Constraints.constrain((Container)jPanel2, (Component)jLabel4, (int)2, (int)n, (int)1, (int)1, (int)0, (int)10, (double)0.0, (double)0.0, (int)3, (int)6, (int)6, (int)6);
            jPanel3 = new JPanel();
            Constraints.constrain((Container)jPanel2, (Component)jPanel3, (int)4, (int)n, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
            ++n;
        }
        Constraints.constrain((Container)((Object)this), (Component)jPanel2, (int)0, (int)1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        jPanel3 = new JPanel();
        Constraints.constrain((Container)((Object)this), (Component)jPanel3, (int)0, (int)3, (int)1, (int)1, (int)1, (int)17, (double)1.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
    }

    public static Dimension getMaxStepSize(ResourceBundle resourceBundle, String string) {
        int n = 0;
        int n2 = 0;
        FlowArea flowArea = new FlowArea(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"FdiskWizReviewWarning"), 30, Constants.PROPS_RO_VALUE_FONT);
        n += flowArea.getPreferredSize().width + 12;
        n2 += flowArea.getPreferredSize().height + 12;
        int n3 = 0;
        JLabel jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"FdiskWizReviewPart"));
        n2 += jLabel.getPreferredSize().height + 12;
        n3 += jLabel.getPreferredSize().width + 12;
        jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"FdiskWizReviewSize"));
        n2 += jLabel.getPreferredSize().height + 12;
        int n4 = jLabel.getPreferredSize().width + 12;
        jLabel = new JLabel(Content.formatSuffix(string, ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"Megabytes")));
        int n5 = jLabel.getPreferredSize().width + 12;
        n3 += Math.max(n4, n5);
        jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"FdiskWizReviewUse"));
        n2 += jLabel.getPreferredSize().height + 12;
        n = Math.max(n, n3 += jLabel.getPreferredSize().width + 12);
        n2 += 4 * (jLabel.getPreferredSize().height + 12);
        return new Dimension(n, n2 += 12);
    }

    public boolean isSubStep() {
        return true;
    }

    public void reset() {
    }

    public void start() {
        super.start();
        this.constructStep();
        this.getManager().setNext(NAME, "");
        this.setProperty("vwp.canmovebackward", "vwp.true");
        this.setProperty("vwp.finishstate", "vwp.true");
        this.setProperty("vwp.canmoveforward", "vwp.true");
    }

    public boolean stop(boolean bl) {
        String string = "FdiskCustomStep";
        string = string.concat(Integer.toString(this.partitions.size() - 1));
        this.getManager().setPrevious(NAME, string);
        if (bl) {
            this.wizard.doFinish();
            this.wizard.cancelWizard();
        } else {
            this.setProperty("vwp.finishstate", "vwp.false");
        }
        return true;
    }
}

