/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg;

import com.sun.prodreg.LabelBlock;
import com.sun.prodreg.OutlineItem;
import com.sun.prodreg.OutlineNode;
import com.sun.prodreg.UninstallThread;
import com.sun.prodreg.ViewableNode;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.ScrollPane;

public class OutlineView
extends Canvas {
    OutlineItem root;
    int indent = -1;
    int itemheight = -1;
    int baseline = -1;
    int ylevel;
    int ytop;
    int ybottom;
    OutlineItem selected = null;
    public LabelBlock labelblock = null;
    static FontMetrics fm = null;
    long lastTime = 0L;
    int lastx = 0;
    int lasty = 0;
    LabelBlock listener;

    public OutlineView(OutlineNode[] outlineNodeArray) {
        this.root = new OutlineItem(outlineNodeArray);
        this.setBackground(new Color(221, 221, 221));
    }

    public void addItemListener(LabelBlock labelBlock) {
        this.listener = labelBlock;
    }

    public Dimension minimumSize() {
        return this.preferredSize();
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (event.when - this.lastTime < 600L && Math.abs(n - this.lastx) < 2 && Math.abs(n2 - this.lasty) < 2) {
            event.clickCount = 2;
            this.lastTime = 0L;
        } else {
            event.clickCount = 1;
            this.lastTime = event.when;
        }
        this.lastx = n;
        this.lasty = n2;
        UninstallThread.clinic = event.shiftDown();
        try {
            OutlineItem outlineItem = this.root.getClickedItem(n, n2);
            if (outlineItem == null) {
                this.select(null);
            } else if (event.clickCount > 1) {
                outlineItem.node.setCollapsed(outlineItem.node.isCollapsed() ^ true);
                this.labelblock.scrollpane.doLayout();
                this.repaint();
                this.select(outlineItem);
            } else if (n > outlineItem.xdrawn && n < outlineItem.xdrawn + this.itemheight && outlineItem.children.length > 0) {
                outlineItem.node.setCollapsed(outlineItem.node.isCollapsed() ^ true);
                this.labelblock.scrollpane.doLayout();
                this.repaint();
                this.select(outlineItem);
            } else {
                this.select(outlineItem);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    public void paint(Graphics graphics) {
        Container container = this.getParent();
        if (container instanceof ScrollPane) {
            ScrollPane scrollPane = (ScrollPane)container;
            this.ytop = scrollPane.getScrollPosition().y;
            this.ybottom = this.ytop + scrollPane.getViewportSize().height;
        } else {
            this.ytop = 0;
            this.ybottom = 100000;
        }
        this.ylevel = 0;
        int n = (this.root.header ? -1 : 0) * this.indent;
        this.paintSubtree(graphics, this.root, n);
        graphics.clearRect(0, this.ylevel, this.size().width, 9999);
        if (this.selected != null) {
            this.selected.hilite(graphics, this);
        }
    }

    private void paintSubtree(Graphics graphics, OutlineItem outlineItem, int n) {
        int n2;
        outlineItem.topdrawn = this.ylevel;
        if (!outlineItem.header) {
            n2 = this.ylevel + this.itemheight;
            if (n2 > this.ytop && this.ylevel < this.ybottom) {
                graphics.clearRect(0, this.ylevel, this.size().width, this.itemheight);
                outlineItem.paintItem(graphics, n, this.ylevel, this.baseline);
            }
            this.ylevel = n2;
        }
        if (outlineItem.node == null || !outlineItem.node.isCollapsed()) {
            n2 = 0;
            while (n2 < outlineItem.children.length) {
                this.paintSubtree(graphics, outlineItem.children[n2], n + this.indent);
                ++n2;
            }
        }
        outlineItem.bottomdrawn = this.ylevel;
    }

    public Dimension preferredSize() {
        if (this.itemheight <= 0) {
            if (fm == null) {
                fm = this.getFontMetrics(OutlineItem.normalFont);
            }
            this.itemheight = fm.getHeight();
            int n = -1;
            n = LabelBlock.damageImage.getHeight(null);
            if (n < 0) {
                n = 16;
            }
            if (this.itemheight < n) {
                this.itemheight = n;
            }
            this.indent = this.itemheight;
            this.baseline = fm.getAscent();
        }
        this.ylevel = 0;
        this.subtreePreferredSize(this.root);
        return new Dimension(5, this.ylevel);
    }

    private void select(OutlineItem outlineItem) {
        if (this.selected == outlineItem) {
            return;
        }
        Graphics graphics = this.getGraphics();
        if (this.selected != null) {
            this.selected.hilite(graphics, this);
            if (this.listener != null) {
                this.listener.itemStateChanged(false, (ViewableNode)this.selected.node);
            }
        }
        if (outlineItem != null && outlineItem.node == null) {
            return;
        }
        this.selected = outlineItem;
        if (this.selected != null) {
            if (graphics != null) {
                this.selected.hilite(graphics, this);
            }
            if (this.listener != null) {
                this.listener.itemStateChanged(true, (ViewableNode)this.selected.node);
            }
        }
    }

    private void subtreePreferredSize(OutlineItem outlineItem) {
        if (!outlineItem.header) {
            this.ylevel += this.itemheight;
        }
        if (outlineItem.node == null || !outlineItem.node.isCollapsed()) {
            int n = 0;
            while (n < outlineItem.children.length) {
                this.subtreePreferredSize(outlineItem.children[n]);
                ++n;
            }
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

