/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg;

import com.sun.prodreg.VLabel;
import com.sun.prodreg._;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class FileCount
implements Runnable {
    public int nfiles = 0;
    public int ndirectories = 0;
    public int nspecials = 0;
    public long nbytes = 0L;
    VLabel toUpdate;
    private String rootname;

    public FileCount() {
    }

    public FileCount(String string) throws IOException {
        this();
        this.rootname = string;
        this.toUpdate = null;
        File file = new File(string);
        if (!file.exists()) {
            throw new FileNotFoundException(string);
        }
        this.countAFile(file);
    }

    private void countADir(File file) throws IOException {
        String[] stringArray = file.list();
        if (stringArray == null) {
            throw new IOException(_.__("cantAccessDirEr", file.toString()));
        }
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File(file, stringArray[n]);
            this.countAFile(file2);
            if (this.toUpdate != null && (this.nfiles & 0x3F) == 0) {
                this.toUpdate.setText(String.valueOf(_.__("pleaseWait")) + this.summary());
            }
            ++n;
        }
    }

    private void countAFile(File file) throws IOException {
        long l = file.length();
        if (l < 0L) {
            throw new Error("bad file length");
        }
        if (file.isFile()) {
            ++this.nfiles;
            this.nbytes += l;
        } else if (file.isDirectory()) {
            ++this.ndirectories;
            this.nbytes += l;
            this.countADir(file);
        } else {
            ++this.nspecials;
            this.nbytes += l;
        }
    }

    public void run() {
        try {
            File file = new File(this.rootname);
            if (!file.exists()) {
                this.toUpdate.setForeground(Color.red);
                this.toUpdate.setText(_.__("noSuchDirectoryEr", this.rootname));
                return;
            }
            this.toUpdate.setText(_.__("pleaseWait"));
            this.countAFile(file);
            if (this.toUpdate != null) {
                this.toUpdate.setText(this.summary());
            }
        }
        catch (IOException iOException) {
            if (this.toUpdate == null) {
                return;
            }
            this.toUpdate.setText("");
        }
        catch (Exception exception) {
            if (this.toUpdate == null) {
                return;
            }
            this.toUpdate.setForeground(Color.red);
            String string = exception.getMessage();
            if (string == null) {
                string = exception.toString();
            }
            this.toUpdate.setText("*** " + string);
        }
    }

    public Thread startFileCount(String string, VLabel vLabel) {
        FileCount fileCount = new FileCount();
        this.rootname = string;
        this.toUpdate = vLabel;
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.start();
        return thread;
    }

    public String summary() {
        if (this.nbytes <= 0x100000L) {
            return _.__("aboutNk", Long.toString((this.nbytes + 512L) / 1024L), Long.toString(this.nfiles + this.ndirectories + this.nspecials));
        }
        return _.__("aboutNmb", Long.toString((this.nbytes + 524288L) / 0x100000L), Long.toString(this.nfiles + this.ndirectories + this.nspecials));
    }

    private static void test() throws Exception {
        Frame frame = new Frame();
        FileDialog fileDialog = new FileDialog(frame, "budda budda", 1);
        fileDialog.show();
        FileCount fileCount = new FileCount(fileDialog.getDirectory());
        System.out.println("The total bytes was:" + fileCount.nbytes);
        System.out.println("The total files was:" + fileCount.nfiles);
        System.out.println("The total dirs was:" + fileCount.ndirectories);
        System.out.println("The total specials was:" + fileCount.nspecials);
    }
}

