/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.awt;

import com.sun.prodreg.awt.RelativeLayout;
import com.sun.prodreg.awt.Separator;
import com.sun.prodreg.util.Localizer;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ExpandableDialog
extends Dialog
implements ActionListener {
    private String moreString = String.valueOf(Localizer.resolve("<L ProdRegResources.More>")) + ">>>";
    private String lessString = "<<<" + Localizer.resolve("<L ProdRegResources.Less>");
    private Component topComponent = null;
    private Component bottomComponent = null;
    private Button[] buttons = null;
    private Button expandButton = new Button(this.moreString);
    private boolean expanded = false;
    private int buttonPressed = 0;

    public ExpandableDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        this.expandButton.addActionListener(this);
        this.setLayout(new BorderLayout());
        this.updateUI();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.expandButton) {
            this.toggle();
        } else if (this.buttons != null) {
            int n = 0;
            while (n < this.buttons.length) {
                if (object == this.buttons[n]) {
                    this.buttonPressed = n;
                    this.dispose();
                    ((Component)this).setVisible(false);
                }
                ++n;
            }
        }
    }

    public int getButtonPressed() {
        return this.buttonPressed;
    }

    public void setBottomComponent(Component component) {
        this.bottomComponent = component;
        this.updateUI();
    }

    public void setButtons(String[] stringArray) {
        this.buttons = new Button[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            this.buttons[n] = new Button(stringArray[n]);
            ++n;
        }
        this.updateUI();
    }

    public void setExpandLabels(String string, String string2) {
        if (string == null || string2 == null) {
            throw new NullPointerException("ExpandableDialog: null expand strings");
        }
        this.moreString = string;
        this.lessString = string2;
    }

    public void setMoreLabel(String string) {
        this.moreString = string;
    }

    public void setTopComponent(Component component) {
        this.topComponent = component;
        this.updateUI();
    }

    public void setlessLabel(String string) {
        this.lessString = string;
    }

    public void toggle() {
        this.expanded ^= true;
        if (this.expanded) {
            this.expandButton.setLabel(this.lessString);
        } else {
            this.expandButton.setLabel(this.moreString);
        }
        this.updateUI();
        this.pack();
    }

    private void updateUI() {
        this.removeAll();
        if (this.buttons != null) {
            int n = 0;
            while (n < this.buttons.length) {
                this.buttons[n].removeActionListener(this);
                ++n;
            }
        }
        Panel panel = new Panel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        Panel panel2 = new Panel(new BorderLayout());
        if (this.topComponent != null) {
            panel2.add(this.topComponent, "Center");
        }
        panel.add((Component)panel2, gridBagConstraints);
        panel.add((Component)new Separator(1), gridBagConstraints2);
        Panel panel3 = new Panel(new BorderLayout());
        if (this.expanded && this.bottomComponent != null) {
            panel3.add(this.bottomComponent, "Center");
        }
        panel.add((Component)panel3, gridBagConstraints);
        if (this.expanded && this.bottomComponent != null) {
            panel.add((Component)new Separator(1), gridBagConstraints2);
        }
        Panel panel4 = new Panel(new RelativeLayout(new double[]{0.5, 0.5}));
        Panel panel5 = new Panel(new FlowLayout(1));
        if (this.buttons != null) {
            int n = 0;
            while (n < this.buttons.length) {
                panel5.add(this.buttons[n]);
                this.buttons[n].addActionListener(this);
                ++n;
            }
        }
        Panel panel6 = new Panel(new FlowLayout(2));
        panel6.add(this.expandButton);
        panel4.add(panel5);
        if (this.bottomComponent != null) {
            panel4.add(panel6);
        }
        panel.add((Component)panel4, gridBagConstraints);
        this.add((Component)panel, "Center");
    }
}

