# Gate Specific Code -- BEGIN
#
# Copyright 1998-2003 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
#ident  "@(#)dns_mon_stop.ksh 1.6     03/10/17 SMI"
# Gate Specific Code -- END
#!/bin/ksh
# Sun Cluster Data Services Builder template version 1.0
#
# Monitor stop method for DNS
#
# Stops the monitor that is running. This is done via PMF.

###############################################################################
# Parse program arguments.
#
function parse_args # [args ...]
{
	typeset opt

	while getopts 'R:G:T:' opt
	do
		case "$opt" in
		R)
		# Name of the DNS resource.
		RESOURCE_NAME=$OPTARG
		;;

		G)
		# Name of the resource group in which the resource is
		# configured.
		RESOURCEGROUP_NAME=$OPTARG
		;;

		T)
		# Name of the resource type.
		RESOURCETYPE_NAME=$OPTARG
		;;

		*)
		logger -p ${SYSLOG_FACILITY}.err \
		-t [$RESOURCETYPE_NAME,$RESOURCEGROUP_NAME,$RESOURCE_NAME] \
		"ERROR: Option $OPTARG unknown"
		exit 1
		;;

		esac
	done
}

###############################################################################
# MAIN
##############################################################################

export PATH=/bin:/usr/bin:/usr/cluster/bin:/usr/sbin:/usr/proc/bin:$PATH

# Obtain the syslog facility to use. This will be used to log the messages.
SYSLOG_FACILITY=`scha_cluster_get -O SYSLOG_FACILITY`

# Parse the arguments that have been passed to this method
parse_args "$@"

PMF_TAG=$RESOURCEGROUP_NAME,$RESOURCE_NAME,0.mon
SYSLOG_TAG=$RESOURCETYPE_NAME,$RESOURCEGROUP_NAME,$RESOURCE_NAME

# User added code -- BEGIN vvvvvvvvvvvvvvv
# User added code -- END   ^^^^^^^^^^^^^^^

# See if the monitor is running, and if so, kill it. 
if pmfadm -q $PMF_TAG; then 
	# User added code -- BEGIN vvvvvvvvvvvvvvv
	# User added code -- END   ^^^^^^^^^^^^^^^

	pmfadm -s $PMF_TAG KILL
	if [ $? -ne 0 ]; then 
		logger -p ${SYSLOG_FACILITY}.err \
			-t [$SYSLOG_TAG] \
			"${ARGV0} Could not stop monitor for resource " \
			$RESOURCE_NAME
		exit 1
	else
		# could successfully stop the monitor. Log a message.
		logger -p ${SYSLOG_FACILITY}.info \
			-t [$SYSLOG_TAG] \
			"${ARGV0} Monitor for resource " $RESOURCE_NAME \
			" successfully stopped"
	fi

	# User added code -- BEGIN vvvvvvvvvvvvvvv
	# User added code -- END   ^^^^^^^^^^^^^^^

fi

exit 0
