/* Gate Specific Code -- BEGIN */
/*
 * Copyright 2003 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */
/* Gate Specific Code -- END */

#ifndef _CMDLINE_SUBST_H_
#define	_CMDLINE_SUBST_H_

#pragma ident	"@(#)xfs_cmdline_subst.h	1.2	03/10/17 SMI"

#include <rgm/libdsdev.h>

typedef void *cmdline_handle_t;

/*
 * This file is the interface with the code that does the command line
 * substitution.
 *
 * See each function for parameter descriptions.
 */

/*
 * cmdline_open allocates the resources needed to parse the command line.
 *
 * - scds_handle is an input parameter giving access to the SCDS library ;
 * - handle is an output parameter that has to be given back to the other
 *   calls in this inteface
 *
 * The call returns 0 in case of success, any other value otherwise.
 */

int cmdline_open(scds_handle_t scds_handle, cmdline_handle_t *handle);

/*
 * cmdline_close frees the resources allocated by cmdline_open.
 *
 * - handle is the parameter returned by cmdline_open
 *
 * The call returns 0 in case of success, any other value otherwise.
 */

int cmdline_close(cmdline_handle_t handle);


/*
 * cmdline_substitute_parameters does the substitution in the input string.
 *
 * - input is the string containing the command line to be substituted.
 *
 * It returns the substituted command, or NULL in case of failure.
 *
 * The memory needed to allocate the result string is allocated by the
 * cmdline code and will be freed when cmdline_close will be
 * called.
 * DON'T FREE IT YOURSELF !!
 */

char *cmdline_substitute_parameters(cmdline_handle_t handle, char *input);

#endif /* _CMDLINE_SUBST_H_ */
