/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cluster.sccheck;

import com.sun.cluster.sccheck.Globals;
import com.sun.cluster.sccheck.ProtocolException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;

public abstract class Protocol
implements Globals {
    protected int BUFFSIZE = 4096;
    protected byte[] buffer = new byte[this.BUFFSIZE];
    protected Socket socket = null;
    protected BufferedInputStream bIn = null;
    protected DataInputStream dIn = null;
    protected BufferedOutputStream bOut = null;
    protected DataOutputStream dOut = null;
    protected String id = "" + ct++;
    private static int ct = 1;

    public String getID() {
        return this.id;
    }

    protected void sendString(String string) throws IOException {
        if (string == null) {
            string = "";
        }
        this.dOut.writeUTF(string);
        this.dOut.flush();
    }

    protected String readString() throws IOException {
        return this.dIn.readUTF();
    }

    public String readMessage() throws IOException {
        return this.readString();
    }

    protected void sendCode(int n) throws IOException {
        this.dOut.writeInt(n);
        this.dOut.flush();
    }

    protected int readCode() throws IOException {
        return this.dIn.readInt();
    }

    protected void sendInt(int n) throws IOException {
        this.dOut.writeInt(n);
        this.dOut.flush();
    }

    protected int readInt() throws IOException {
        return this.dIn.readInt();
    }

    protected void sendLong(long l) throws IOException {
        this.dOut.writeLong(l);
        this.dOut.flush();
    }

    protected long readLong() throws IOException {
        return this.dIn.readLong();
    }

    protected void sendBoolean(boolean bl) throws IOException {
        this.dOut.writeBoolean(bl);
        this.dOut.flush();
    }

    protected boolean readBoolean() throws IOException {
        return this.dIn.readBoolean();
    }

    protected void setSocketStreams(Socket socket) throws ProtocolException {
        try {
            this.bIn = new BufferedInputStream(this.socket.getInputStream());
            this.dIn = new DataInputStream(this.bIn);
            this.dOut = new DataOutputStream(this.socket.getOutputStream());
        }
        catch (IOException iOException) {
            throw new ProtocolException(iOException.getMessage());
        }
    }
}

