/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cluster.sccheck;

import com.sun.cluster.sccheck.Client;
import com.sun.cluster.sccheck.Globals;
import com.sun.cluster.sccheck.I18n;
import com.sun.cluster.sccheck.Logger;
import com.sun.cluster.sccheck.ProgressListener;
import com.sun.cluster.sccheck.Protocol;
import com.sun.cluster.sccheck.ProtocolException;
import com.sun.cluster.sccheck.SCProperties;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class ClientProtocol
extends Protocol
implements Globals {
    private ProgressListener progresslistener = null;
    private Client parent = null;
    private String resultsFile = null;
    private String serverPublicName = null;
    private Logger logger = Logger.getLogger();
    private SCProperties props = SCProperties.getSCProperties();

    public ClientProtocol(ProgressListener progressListener, Client client, String string, String string2, String string3) throws ProtocolException {
        this.progresslistener = progressListener;
        this.parent = client;
        String string4 = string2;
        this.serverPublicName = string;
        Object[] objectArray = null;
        String string5 = null;
        int n = SCProperties.intFromProps("INET_PORT", 7123, this.props);
        this.logger.info("ClientProtocol() inetPort: " + n);
        int n2 = SCProperties.intFromProps("SERVER_PORT", 7124, this.props);
        this.logger.info("ClientProtocol() serverPort: " + n2);
        try {
            this.logger.trace("ClientProtocol() contacting " + string4 + " on inetd port " + n);
            this.socket = new Socket(string4, n);
            Thread.yield();
        }
        catch (UnknownHostException unknownHostException) {
            this.logger.error("ClientProtocol(): UnknownHostException " + string + ": " + unknownHostException.getMessage());
            objectArray = new Object[]{unknownHostException.getMessage()};
            string5 = I18n.getLocalized("unknownHost", objectArray);
            throw new ProtocolException(string5);
        }
        catch (IOException iOException) {
            this.logger.error("ClientProtocol(): IOException " + string + ": " + iOException.getMessage());
            throw new ProtocolException(iOException.getMessage());
        }
        boolean bl = false;
        int n3 = SCProperties.intFromProps("CLIENT_WAIT_COUNT", 15, this.props);
        int n4 = SCProperties.intFromProps("CLIENT_WAIT_INTERVAL", 1000, this.props);
        int n5 = 0;
        while (!bl && n5++ < n3) {
            this.socket = null;
            try {
                this.logger.trace("ClientProtocol() contacting " + string4 + " on server port " + n2);
                boolean bl2 = false;
                int n6 = 1023;
                InetAddress inetAddress = InetAddress.getByName(string3);
                this.logger.info("ClientProtocol() myIA: " + inetAddress);
                while (!bl2) {
                    try {
                        this.logger.trace("ClientProtocol() attempting outgoing port: " + n6);
                        this.socket = new Socket(string4, n2, inetAddress, n6);
                        bl2 = true;
                    }
                    catch (UnknownHostException unknownHostException) {
                        this.logger.error("ClientProtocol(): UnknownHostException2 " + string + ": " + unknownHostException.getMessage());
                        throw new ProtocolException(unknownHostException.getMessage());
                    }
                    catch (IOException iOException) {
                        this.logger.error("ClientProtocol() in IOException ioex1: " + iOException.getMessage());
                        if (--n6 >= 513) continue;
                        this.logger.error("ClientProtocol() reserved outgoingPort not found");
                        throw new IOException(iOException.getMessage());
                    }
                }
                bl = true;
                this.logger.trace("ClientProtocol() connected on outgoing port: " + n6 + " in retry loop " + n5);
                this.setSocketStreams(this.socket);
            }
            catch (IOException iOException) {
                this.logger.error("ClientProtocol() in IOException ioex2: " + iOException.getMessage());
                this.logger.error("ClientProtocol() incrementing wait-for-server loop");
                objectArray = new Object[]{string};
                string5 = I18n.getLocalized("waitingForServerStart", objectArray);
                try {
                    Thread.sleep(n4);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.postProgress(2, string5, false);
            }
        }
        if (!bl) {
            this.logger.trace("ClientProtocol(): giving up on " + string);
            objectArray = new Object[]{string};
            string5 = I18n.getLocalized("unableToContactServer", objectArray);
            throw new ProtocolException(string5);
        }
    }

    public int getCommonVersion(int n) throws ProtocolException {
        int n2;
        try {
            this.sendInt(n);
            n2 = this.readInt();
        }
        catch (IOException iOException) {
            this.logger.error("ClientProtocol(): getCommonVersion IOException" + iOException.getMessage());
            throw new ProtocolException(iOException.getMessage());
        }
        if (n < n2) {
            return n;
        }
        return n2;
    }

    public boolean getRemoteFile(String string) throws ProtocolException {
        boolean bl = true;
        boolean bl2 = false;
        String string2 = null;
        try {
            while (!bl2) {
                int n = this.readCode();
                switch (n) {
                    case 1: {
                        int n2 = this.readCode();
                        string2 = this.readString();
                        this.postProgress(n2, string2);
                        break;
                    }
                    case 3: {
                        string2 = this.readString();
                        this.postErrMsg(string2);
                        break;
                    }
                    case 4: {
                        bl = false;
                        bl2 = true;
                        break;
                    }
                    case 2: {
                        this.receiveFile(string);
                        bl = true;
                        bl2 = true;
                        break;
                    }
                    default: {
                        bl = false;
                        bl2 = true;
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new ProtocolException(iOException.getMessage());
        }
        return bl;
    }

    public void sendLocale() throws IOException {
        String string = this.parent.getLocaleLang();
        if (string == null) {
            string = "";
        }
        this.sendString(string);
        string = this.parent.getLocaleCountry();
        if (string == null) {
            string = "";
        }
        this.sendString(string);
        string = this.parent.getLocaleVariant();
        if (string == null) {
            string = "";
        }
        this.sendString(string);
    }

    public void sendAuth() throws IOException {
        String string = this.parent.getAuth();
        if (string == null) {
            string = "";
        }
        this.sendString(string);
    }

    public boolean getPermission() throws IOException {
        boolean bl = this.readBoolean();
        return bl;
    }

    private void postProgress(int n, String string, boolean bl) {
        if (bl) {
            string = this.serverPublicName + ": " + string;
        }
        this.progresslistener.postProgress(n, string);
    }

    private void postProgress(int n, String string) {
        this.postProgress(n, string, true);
    }

    private void postErrMsg(String string) {
        Object[] objectArray = new Object[]{this.serverPublicName, string};
        String string2 = I18n.getLocalized("postErrMsgFormat", objectArray);
        this.progresslistener.postErrMsg(string2);
    }

    private void receiveFile(String string) throws ProtocolException {
        int n = 0;
        long l = 0L;
        long l2 = 0L;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            l = this.dIn.readLong();
            while (l > 0L) {
                l2 = l;
                if (l2 > (long)this.BUFFSIZE) {
                    l2 = this.BUFFSIZE;
                }
                if ((n = this.bIn.read(this.buffer, 0, (int)l2)) <= 0) {
                    this.logger.error("ClientProtocol.receiveFile() expected " + l2 + "; got " + n + " bytes: breaking");
                    String string2 = I18n.getLocalized("UnexpectedEOF.OnFileRx");
                    throw new ProtocolException(string2);
                }
                l -= (long)n;
                bufferedOutputStream.write(this.buffer, 0, n);
            }
            bufferedOutputStream.close();
        }
        catch (UnknownHostException unknownHostException) {
            this.logger.error("ClientProtocol.receiveFile() in UnknownHostException: " + unknownHostException.getMessage());
            throw new ProtocolException(unknownHostException.getMessage());
        }
        catch (IOException iOException) {
            this.logger.error("ClientProtocol.receiveFile() in IOException: " + iOException.getMessage());
            throw new ProtocolException(iOException.getMessage());
        }
    }
}

