/* Gate Specific Code -- BEGIN */
/*
 * Copyright 1998-2003 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */
/* Gate Specific Code -- END */

#ifndef	_XFS_COMMON_H
#define	_XFS_COMMON_H

#pragma ident	"@(#)xfs.h	1.8	03/10/17 SMI"

#ifdef __cplusplus
extern "C" {
#endif

/* Debug levels for error messages */
#define	DBG_LEVEL_HIGH		9
#define	DBG_LEVEL_MED		5
#define	DBG_LEVEL_LOW		1

#define	SCDS_CMD_SIZE		(8 * 1024)

#define	SCDS_ARRAY_SIZE		1024

int svc_validate(scds_handle_t scds_handle);

int svc_start(scds_handle_t scds_handle);

int svc_stop(scds_handle_t scds_handle);

/* Network aware applications code -- BEGIN */
int svc_wait_network_aware(scds_handle_t scds_handle);
int svc_probe_network_aware(scds_handle_t scds_handle, char *hostname,
    int port, int timeout);
/* Network aware applications code -- END */

/* Stand alone applications code -- BEGIN */
int svc_wait_non_network_aware(scds_handle_t scds_handle);
int svc_probe_non_network_aware(scds_handle_t scds_handle, int timeout);
/* Stand alone applications code -- END */

int mon_start(scds_handle_t scds_handle);

int mon_stop(scds_handle_t scds_handle);

int preprocess_cmd(scds_handle_t scds_handle, char *cmd, int cmd_size);

/* User added code -- BEGIN vvvvvvvvvvvvvvv */
/* User added code -- END   ^^^^^^^^^^^^^^^ */

#ifdef __cplusplus
}
#endif

#endif /* _XFS_COMMON_H */
