/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cluster.sccheck;

import com.sun.cluster.sccheck.Globals;
import com.sun.cluster.sccheck.I18n;
import com.sun.cluster.sccheck.Logger;
import com.sun.cluster.sccheck.ProgressListener;
import com.sun.cluster.sccheck.SCException;
import com.sun.cluster.sccheck.SCSeverityCheckFilter;
import com.sun.cluster.sccheck.SCXmlToText;
import com.sun.cluster.sccheck.Utils;
import com.sun.cluster.sccheck.WrapperException;
import com.sun.eras.common.checks.CheckList;
import com.sun.eras.common.checks.filters.CheckFilter;
import com.sun.eras.common.checkstorage.CheckStorageException;
import com.sun.eras.common.exception.NestedException;
import com.sun.eras.common.kaeresult.CheckResults;
import com.sun.eras.common.kaeresult.KAEResultBean;
import com.sun.eras.common.kaeresult.KAEResultConversionException;
import com.sun.eras.common.kaeresult.RunInfoBean;
import com.sun.eras.common.kaeresult.RunResultBean;
import com.sun.eras.common.logging4.FileHandler;
import com.sun.eras.common.logging4.Handler;
import com.sun.eras.common.logging4.Level;
import com.sun.eras.common.translator.TranslationException;
import com.sun.eras.common.translator.result.ResultTranslationException;
import com.sun.eras.common.translator.result.XmlToTextTranslator;
import com.sun.eras.kae.engine.CheckFinishedEvent;
import com.sun.eras.kae.engine.CheckListDesignator;
import com.sun.eras.kae.engine.CheckListFinishedEvent;
import com.sun.eras.kae.engine.CheckListStartedEvent;
import com.sun.eras.kae.engine.CheckStartedEvent;
import com.sun.eras.kae.engine.DataCollectorDesignator;
import com.sun.eras.kae.engine.EngineControllerAPI;
import com.sun.eras.kae.engine.EngineErrorEvent;
import com.sun.eras.kae.engine.EngineException;
import com.sun.eras.kae.engine.EngineFactory;
import com.sun.eras.kae.engine.EngineListener;
import com.sun.eras.kae.engine.EngineViewAPI;
import com.sun.eras.kae.engine.FactStoreDesignator;
import com.sun.eras.kae.engine.FilenameFactStoreDesignator;
import com.sun.eras.kae.engine.XmlFilenameCheckListDesignator;
import com.sun.eras.kae.io.input.explorerDir.ExplorerDataCollectorDesignator;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;

public class KEWrapper
implements Globals,
EngineListener {
    private String reportNameBase;
    private Logger logger = Logger.getLogger();
    private com.sun.eras.common.logging4.Logger kaelogger = null;
    private String gunzipCmd = null;
    private String tarCmd = null;
    private String explorersUnpackDir;
    private String[] unpackedExplorers;
    private ProgressListener progresslistener;
    private String genXslDir;
    private Vector zippedExplorers;
    private int minSeverity = 0;
    private int maxSeverity = 0;
    private int numFilteredChecks = 0;
    private String genDate = null;
    private boolean brief = false;
    private static int checksComplete = 0;
    private static int totalChecks = 0;
    private static int currcheck = 0;
    static /* synthetic */ Class class$com$sun$cluster$sccheck$KEWrapper;

    public KEWrapper(ProgressListener progressListener, String string, Vector vector, String string2, boolean bl, int n, String string3, String string4) throws WrapperException {
        this(progressListener, string, vector, string2, null, bl, n, string3, string4);
    }

    public KEWrapper(ProgressListener progressListener, String string, String[] stringArray, boolean bl, int n, String string2, String string3) throws WrapperException {
        this(progressListener, string, null, null, stringArray, bl, n, string2, string3);
    }

    public KEWrapper(ProgressListener progressListener, String string, Vector vector, String string2, String[] stringArray, boolean bl, int n, String string3, String string4) throws WrapperException {
        this.logger.info("KEWrapper()  -- START --");
        this.minSeverity = n;
        this.brief = bl;
        this.genXslDir = string4;
        this.kaelogger = com.sun.eras.common.logging4.Logger.getLogger((String)(class$com$sun$cluster$sccheck$KEWrapper == null ? (class$com$sun$cluster$sccheck$KEWrapper = KEWrapper.class$("com.sun.cluster.sccheck.KEWrapper")) : class$com$sun$cluster$sccheck$KEWrapper).getName());
        if (string3 == null) {
            string3 = "/var/cluster/logs/sccheck/ke-default.log";
        }
        try {
            FileHandler fileHandler = new FileHandler(string3, false);
            this.kaelogger.addHandler((Handler)fileHandler);
        }
        catch (IOException iOException) {
            this.logger.info("KEWrapper(): ioex: " + iOException.getMessage());
        }
        this.gunzipCmd = System.getProperty("sccheck.gunzip");
        this.tarCmd = System.getProperty("sccheck.tar");
        this.logger.info("KEWrapper() ke log: " + string3);
        this.logger.info("KEWrapper() genXslDir: " + this.genXslDir);
        this.logger.info("KEWrapper() gunzipCmd: " + this.gunzipCmd);
        this.logger.info("KEWrapper() tarCmd: " + this.tarCmd);
        this.logger.info("KEWrapper() reportNameBase: " + string);
        this.logger.info("KEWrapper() zippedExplorers: " + vector);
        this.explorersUnpackDir = string2 == null ? System.getProperty("sccheck.explorersUnpackDir") : string2;
        this.logger.info("KEWrapper() explorersUnpackDir: " + this.explorersUnpackDir);
        this.logger.info("KEWrapper() unpackedExplorers[]: " + Utils.dumpStringArray(stringArray));
        this.logger.info("KEWrapper() minSeverity: " + n);
        this.logger.info("KEWrapper() brief: " + bl);
        this.reportNameBase = string;
        this.progresslistener = progressListener;
        this.zippedExplorers = vector;
        this.unpackedExplorers = stringArray;
        this.minSeverity = n;
    }

    public int getMaxSeverity() {
        return this.maxSeverity;
    }

    public String getGenDate() {
        return this.genDate;
    }

    public void removeUnpackedExplorers() {
        Utils utils = new Utils();
        utils.rmrfDir(this.explorersUnpackDir);
        Utils.mkdir(this.explorersUnpackDir);
    }

    public void runKE(String string) throws WrapperException {
        this.logger.trace("KEWrapper.runKE() -- ENTER: " + string);
        String[] stringArray = null;
        stringArray = this.zippedExplorers != null ? this.unpackExplorers(this.zippedExplorers) : this.unpackedExplorers;
        this.logger.info("KEWrapper.runKE(): " + Utils.dumpStringArray(stringArray));
        if (stringArray == null) {
            this.logger.error("KEWrapper.runKE(): no unzipped explorers");
            String string2 = I18n.getLocalized("noUnzippedExplorerResults");
            throw new WrapperException(string2);
        }
        this.runEngine(string, stringArray);
        this.logger.trace("KEWrapper.runKE() -- EXIT --");
    }

    private String[] unpackExplorers(Vector vector) throws WrapperException {
        this.logger.trace("KEWrapper.unpackExplorers() --ENTER--");
        Utils utils = new Utils();
        String[] stringArray = new String[vector.size()];
        int n = 0;
        String string = I18n.getLocalized("unpackingChecks");
        this.progresslistener.postProgress(2, string);
        File file = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray;
            String string2 = (String)enumeration.nextElement();
            if (utils.isDir(string2)) {
                this.logger.info("KEWrapper.unpackExplorers() skip unpacking of " + string2);
                stringArray[n++] = string2;
                continue;
            }
            this.logger.info("KEWrapper.unpackExplorers() will unpack " + string2);
            file = new File(string2);
            if (file.length() == 0L) {
                this.logger.error("KEWrapper.unpackExplorers() file empty or non-existent: " + string2);
                objectArray = new Object[]{string2};
                string = I18n.getLocalized("explorerResultsEmptyOrNonExistent", objectArray);
                throw new WrapperException(string);
            }
            try {
                objectArray = this.unpackSingleExplorer(string2, this.explorersUnpackDir);
                stringArray[n++] = objectArray;
            }
            catch (WrapperException wrapperException) {
                this.logger.error("KEWrapper.unpackExplorers() in wex: " + wrapperException.getMessage());
                throw new WrapperException(wrapperException.getMessage());
            }
        }
        this.logger.trace("KEWrapper.unpackExplorers() --EXIT--");
        return stringArray;
    }

    private String unpackSingleExplorer(String string, String string2) throws WrapperException {
        this.logger.trace("KEWrapper.unpackSingleExplorer() -- ENTER -- " + string);
        String string3 = null;
        String string4 = null;
        String string5 = null;
        try {
            String string6 = Integer.toHexString(new Long(System.currentTimeMillis()).intValue());
            String string7 = string2 + File.separator + "sccheck_" + string6;
            Utils.mkdir(string7);
            File file = new File(string7);
            string3 = this.gunzipCmd + " -t " + string;
            this.logger.trace("KEWrapper.unpackSingleExplorer(): testing zipfile");
            Utils.runScript(string3);
            this.logger.trace("KEWrapper.unpackSingleExplorer(): unpacking");
            string3 = "cd " + string7 + "; " + this.gunzipCmd + " -dc " + string + " | " + this.tarCmd + " xif - ";
            Utils.runScript(string3);
            this.logger.trace("KEWrapper.unpackSingleExplorer(): getting result name");
            String[] stringArray = file.list();
            String string8 = null;
            int n = 0;
            while (n < stringArray.length) {
                if (!stringArray[n].startsWith(".")) {
                    string8 = stringArray[n];
                    break;
                }
                ++n;
            }
            if (string8 == null) {
                this.logger.info("KEWrapper.unpackSingleExplorer(): couldn't get resultDirName");
                string5 = I18n.getLocalized("unpackedExplorerResultsNotFound");
                throw new WrapperException(string5);
            }
            this.logger.info("KEWrapper.unpackSingleExplorer(): resultDirName: " + string8);
            string4 = string2 + File.separator + string8;
            this.logger.trace("KEWrapper.unpackSingleExplorer(): pushing tmpDir to unpackDir");
            String string9 = string2 + File.separator + string8;
            new Utils().rmrfDir(string9);
            string3 = "cd " + string7 + "; " + "/usr/bin/mv " + string8 + " " + string2;
            Utils.runScript(string3);
            new Utils().rmrfDir(string7);
        }
        catch (WrapperException wrapperException) {
            this.logger.error("KEWrapper.unpackSingleExplorer() in wex: " + wrapperException.getMessage());
            Object[] objectArray = new Object[]{string};
            string5 = I18n.getLocalized("unableToUnpackEplorerResults", objectArray);
            throw new WrapperException(string5 + wrapperException.getMessage());
        }
        this.logger.trace("KEWrapper.unpackSingleExplorer() -- EXIT -- " + string4);
        return string4;
    }

    private String readGenDate(String string) {
        Object object;
        this.logger.trace("KEWrapper.readGenDate() -- ENTER -- " + string);
        byte[] byArray = null;
        try {
            object = new RandomAccessFile(string, "r");
            long l = ((RandomAccessFile)object).length();
            ((RandomAccessFile)object).seek(l - 500L);
            byArray = new byte[500];
            ((RandomAccessFile)object).readFully(byArray);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logger.info("genDate() fnfex: " + fileNotFoundException.getMessage());
        }
        catch (EOFException eOFException) {
            this.logger.info("genDate() eofex: " + eOFException.getMessage());
        }
        catch (IOException iOException) {
            this.logger.info("genDate() ioex: " + iOException.getMessage());
        }
        object = new String(byArray);
        String string2 = null;
        String string3 = "<generation_date GMT='";
        try {
            int n = ((String)object).indexOf(string3);
            if (n > -1) {
                int n2 = n + string3.length();
                int n3 = ((String)object).indexOf("'>");
                if (n3 > -1 && n2 > -1 && n3 > n2) {
                    string2 = ((String)object).substring(n2, n3);
                }
            }
        }
        catch (Exception exception) {
            string2 = "Unable to read generation date" + exception.getMessage();
        }
        this.logger.trace("KEWrapper.readGenDate() -- EXIT: " + string2);
        return string2;
    }

    private void runEngine(String string, String[] stringArray) throws WrapperException {
        this.logger.trace("KEWrapper.runEngine():-- ENTER --");
        String string2 = null;
        string2 = I18n.getLocalized("loadingChecks");
        this.progresslistener.postProgress(2, string2);
        if (stringArray == null || stringArray.length == 0) {
            this.logger.error("KEWrapper.runEngine() null or 0 explorers -- EXIT--");
            string2 = I18n.getLocalized("noExplorerResultsToRead");
            throw new WrapperException(string2);
        }
        this.genDate = this.readGenDate(string);
        SCSeverityCheckFilter sCSeverityCheckFilter = new SCSeverityCheckFilter(this.minSeverity);
        this.logger.info("KEWrapper.runEngine() expdirs[0]: " + stringArray[0]);
        EngineControllerAPI engineControllerAPI = null;
        try {
            engineControllerAPI = this.getEngine(string, stringArray);
            this.logger.info("KEWrapper.runEngine() made engine");
            engineControllerAPI.setCheckFilter((CheckFilter)sCSeverityCheckFilter);
            engineControllerAPI.addListener((EngineListener)this);
            string2 = I18n.getLocalized("runningChecks");
            this.progresslistener.postProgress(2, string2);
            Thread thread = engineControllerAPI.executeAsynchronously("ekeThread");
            while (thread.isAlive()) {
                thread.join(5000L);
                int n = checksComplete * 100 / totalChecks;
                if (!thread.isAlive()) continue;
                Object[] objectArray = new Object[]{"" + currcheck, "" + n};
                string2 = I18n.getLocalized("checkRunning", objectArray);
                this.progresslistener.postProgress(2, string2);
            }
        }
        catch (RemoteException remoteException) {
            this.logger.error("KEWrapper.runEngine(): RemoteException in runEngine(): " + remoteException.getMessage());
            throw new WrapperException(remoteException.getMessage());
        }
        catch (Exception exception) {
            this.logger.error("KEWrapper.runEngine(): Exception in runEngine(): " + exception.getMessage());
            throw new WrapperException(exception.getMessage());
        }
        this.numFilteredChecks = sCSeverityCheckFilter.getNumFilteredChecks();
        this.logger.info("KEWrapper.runEngine(): numFilteredChecks: " + this.numFilteredChecks);
        this.logger.trace("KEWrapper.runEngine(): engine.executeAsynchronously() finished ***");
        if (engineControllerAPI != null) {
            this.writeReports(engineControllerAPI);
        }
        this.logger.trace("KEWrapper.runEngine() -- EXIT -- ");
    }

    private void writeReports(EngineControllerAPI engineControllerAPI) throws WrapperException {
        this.logger.trace("KEWrapper.writeReports() -- ENTER -- ");
        StackTraceElement[] stackTraceElementArray = null;
        String string = "";
        try {
            String string2 = this.getXmlResults(engineControllerAPI);
            this.writeXmlFile(string2, this.reportNameBase + ".xml");
            this.writeTextFile(string2, this.reportNameBase + ".txt");
        }
        catch (EngineException engineException) {
            this.logger.info("KEWrapper.writeReports() EngineException: " + engineException.getMessage());
            stackTraceElementArray = engineException.getStackTrace();
            string = engineException.getMessage();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.logger.info("KEWrapper.writeReports() UnsupportedEncodingException: " + unsupportedEncodingException.getMessage());
            stackTraceElementArray = unsupportedEncodingException.getStackTrace();
            string = unsupportedEncodingException.getMessage();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logger.info("KEWrapper.writeReports() FileNotFoundException: " + fileNotFoundException.getMessage());
            stackTraceElementArray = fileNotFoundException.getStackTrace();
            string = fileNotFoundException.getMessage();
        }
        catch (IOException iOException) {
            this.logger.info("KEWrapper.writeReports() IOException: " + iOException.getMessage());
            stackTraceElementArray = iOException.getStackTrace();
            string = iOException.getMessage();
        }
        catch (ResultTranslationException resultTranslationException) {
            this.logger.info("KEWrapper.writeReports() ResultTranslationException: " + resultTranslationException.getMessage());
            stackTraceElementArray = resultTranslationException.getStackTrace();
            string = resultTranslationException.getMessage();
        }
        catch (TranslationException translationException) {
            this.logger.info("KEWrapper.writeReports() TranslationException: " + translationException.getMessage());
            stackTraceElementArray = translationException.getStackTrace();
            string = translationException.getMessage();
        }
        catch (KAEResultConversionException kAEResultConversionException) {
            this.logger.info("KEWrapper.writeReports() KAEResultConversionException: " + kAEResultConversionException.getMessage());
            stackTraceElementArray = kAEResultConversionException.getStackTrace();
            string = kAEResultConversionException.getMessage();
        }
        catch (SCException sCException) {
            this.logger.info("KEWrapper.writeReports() SCException: " + sCException.getMessage());
            stackTraceElementArray = sCException.getStackTrace();
            string = sCException.getMessage();
        }
        if (stackTraceElementArray != null) {
            int n = 0;
            while (n < stackTraceElementArray.length) {
                this.logger.info(stackTraceElementArray[n].toString());
                ++n;
            }
            throw new WrapperException(string);
        }
        this.logger.trace("KEWrapper.writeReports() -- EXIT -- ");
    }

    private String getXmlResults(EngineControllerAPI engineControllerAPI) throws EngineException, KAEResultConversionException {
        this.logger.trace("KEWrapper.getXmlResults() -- ENTER -- ");
        EngineViewAPI engineViewAPI = (EngineViewAPI)engineControllerAPI;
        RunInfoBean runInfoBean = engineViewAPI.getRunInfo();
        RunResultBean runResultBean = engineViewAPI.newInstanceOfRunResult();
        runResultBean.addRunInfo(runInfoBean);
        KAEResultBean kAEResultBean = engineViewAPI.newInstanceOfKAEResult();
        kAEResultBean.addRunResult(runResultBean);
        String string = kAEResultBean.toXML();
        this.logger.trace("KEWrapper.getXmlResults() -- EXIT -- ");
        return string;
    }

    private void writeXmlFile(String string, String string2) throws UnsupportedEncodingException, FileNotFoundException {
        this.logger.info("KEWrapper.writeXmlFile() -- ENTER: " + string2);
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string2), "UTF-8"));
        printWriter.print(string);
        printWriter.close();
        this.logger.info("KEWrapper.writeXmlFile() -- EXIT-- ");
    }

    private void writeTextFile(String string, String string2) throws IOException, FileNotFoundException, TranslationException, ResultTranslationException, SCException {
        this.logger.info("KEWrapper.writeTextFile() -- ENTER: " + string2);
        SCXmlToText sCXmlToText = new SCXmlToText(this.genXslDir, this.numFilteredChecks, this.minSeverity, this.brief);
        sCXmlToText.generateXSLFile();
        XmlToTextTranslator xmlToTextTranslator = new XmlToTextTranslator("/SCXmlToText.xsl");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
        xmlToTextTranslator.translate((InputStream)byteArrayInputStream, (OutputStream)bufferedOutputStream);
        bufferedOutputStream.close();
        this.logger.trace("KEWrapper.writeTextFile() -- EXIT-- ");
    }

    private EngineControllerAPI getEngine(String string, String[] stringArray) throws CheckStorageException, EngineException, RemoteException {
        XmlFilenameCheckListDesignator xmlFilenameCheckListDesignator = new XmlFilenameCheckListDesignator(string);
        xmlFilenameCheckListDesignator.setValidating(false);
        CheckList checkList = xmlFilenameCheckListDesignator.getCheckList();
        totalChecks = checkList.size();
        this.logger.info("KEWrapper.getEngine(): totalChecks: " + totalChecks);
        this.logger.trace("KEWrapper.getEngine(): path to facts.zip: /usr/cluster/lib/sccheck/kae/storage/facts.zip");
        FilenameFactStoreDesignator filenameFactStoreDesignator = new FilenameFactStoreDesignator("/usr/cluster/lib/sccheck/kae/storage/facts.zip", null);
        ExplorerDataCollectorDesignator explorerDataCollectorDesignator = new ExplorerDataCollectorDesignator();
        int n = 0;
        while (n < stringArray.length) {
            this.logger.trace("KEWrapper.getEngine(): adding to dataCollector: " + stringArray[n]);
            explorerDataCollectorDesignator.addToExplorerDirs(stringArray[n]);
            ++n;
        }
        EngineFactory engineFactory = EngineFactory.getInstance();
        EngineControllerAPI engineControllerAPI = engineFactory.getEngine((CheckListDesignator)xmlFilenameCheckListDesignator, (FactStoreDesignator)filenameFactStoreDesignator, (DataCollectorDesignator)explorerDataCollectorDesignator, false);
        EngineViewAPI engineViewAPI = (EngineViewAPI)engineControllerAPI;
        String string2 = engineViewAPI.getKAEVersion();
        this.logger.info("KEWrapper.getEngine() KE version: " + string2);
        return engineControllerAPI;
    }

    public void checkListStarted(CheckListStartedEvent checkListStartedEvent) {
        this.kaelogger.log(Level.INFO, "Got CheckListStartedEvent");
        this.logger.info("KEWrapper.checkListStarted()");
    }

    public void checkListFinished(CheckListFinishedEvent checkListFinishedEvent) {
        this.kaelogger.log(Level.INFO, "Got CheckListFinishedEvent");
        this.logger.info("KEWrapper.checkListFinished()");
    }

    public void checkStarted(CheckStartedEvent checkStartedEvent) {
        String string = checkStartedEvent.getCheckId();
        this.logger.info("KEWrapper.checkStarted(): " + string);
        try {
            currcheck = Integer.parseInt(string);
        }
        catch (Exception exception) {
            this.kaelogger.log(Level.WARNING, "Error parsing check id in CheckStarted()", (Throwable)exception);
        }
        this.kaelogger.log(Level.INFO, "Got CheckStartedEvent for check: " + string);
    }

    public void checkFinished(CheckFinishedEvent checkFinishedEvent) {
        String string = "xx";
        try {
            ++checksComplete;
            string = checkFinishedEvent.getCheckId();
            EngineViewAPI engineViewAPI = checkFinishedEvent.getSourceEngine();
            CheckResults checkResults = engineViewAPI.getCheckResults(string);
            StringBuffer stringBuffer = new StringBuffer();
            NestedException nestedException = null;
            if (checkResults.isErrored()) {
                stringBuffer.append("E");
                this.logger.info("KEWrapper.checkFinished(): " + string + " Errored");
                nestedException = (NestedException)checkResults.getException();
                this.logger.info("KEWrapper.checkFinished() error: " + nestedException);
                this.logger.info("KEWrapper.checkFinished() nestedException: " + nestedException.getAbbreviatedTrace());
            } else if (!checkResults.isApplicable()) {
                stringBuffer.append("NA");
                this.logger.info("KEWrapper.checkFinished(): " + string + " N/A");
            } else if (checkResults.isConditionPasses()) {
                stringBuffer.append("P");
                this.logger.info("KEWrapper.checkFinished(): " + string + " Passed");
            } else {
                stringBuffer.append("F ");
                int n = checkResults.getSeverity().intValue();
                stringBuffer.append(n);
                if (n > this.maxSeverity) {
                    this.maxSeverity = n;
                }
                stringBuffer.append("\nAnalysis: " + checkResults.getAnalysisCml().getAsString() + "\n");
                stringBuffer.append("\nReccommend: " + checkResults.getRecommendationsCml().getAsString() + "\n");
                this.logger.info("KEWrapper.checkFinished(): " + string + " Failed");
            }
            this.kaelogger.log(Level.INFO, "Finished Check: " + checkFinishedEvent.getCheckId() + " " + stringBuffer);
            if (checkResults.isErrored()) {
                this.kaelogger.log(Level.INFO, "     Check Error: " + nestedException);
                this.kaelogger.log(Level.INFO, "     Exception: " + nestedException.getAbbreviatedTrace());
            }
        }
        catch (Exception exception) {
            this.kaelogger.log(Level.INFO, "Error in checkFinished(): ", (Throwable)exception);
            this.logger.info("KEWrapper.checkFinished() exception on check: " + string);
            this.logger.info(exception.getMessage());
        }
    }

    public void engineError(EngineErrorEvent engineErrorEvent) {
        this.kaelogger.log(Level.SEVERE, "Got fatal engineError: " + engineErrorEvent);
        this.logger.info("KEWrapper.engineError(): " + engineErrorEvent.getException().getMessage());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

